// python wrapper for vtkTilesHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkVector.h"
#include "vtkTilesHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkTilesHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkTilesHelper_ClassNew(); }


static PyObject *
PyvtkTilesHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkTilesHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkTilesHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkTilesHelper *tempr = vtkTilesHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTilesHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkTilesHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkTilesHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkTilesHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_SetTileDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTileDimensions(temp0, temp1);
    }
    else
    {
      op->vtkTilesHelper::SetTileDimensions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTilesHelper_SetTileDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTileDimensions(temp0);
    }
    else
    {
      op->vtkTilesHelper::SetTileDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTilesHelper_SetTileDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkTilesHelper_SetTileDimensions_s1(self, args);
    case 1:
      return PyvtkTilesHelper_SetTileDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTileDimensions");
  return nullptr;
}


static PyObject *
PyvtkTilesHelper_GetTileDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTileDimensions() :
      op->vtkTilesHelper::GetTileDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_SetTileMullions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileMullions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTileMullions(temp0, temp1);
    }
    else
    {
      op->vtkTilesHelper::SetTileMullions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTilesHelper_SetTileMullions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileMullions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTileMullions(temp0);
    }
    else
    {
      op->vtkTilesHelper::SetTileMullions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTilesHelper_SetTileMullions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkTilesHelper_SetTileMullions_s1(self, args);
    case 1:
      return PyvtkTilesHelper_SetTileMullions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTileMullions");
  return nullptr;
}


static PyObject *
PyvtkTilesHelper_GetTileMullions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileMullions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTileMullions() :
      op->vtkTilesHelper::GetTileMullions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_SetTileWindowSize_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileWindowSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTileWindowSize(temp0, temp1);
    }
    else
    {
      op->vtkTilesHelper::SetTileWindowSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTilesHelper_SetTileWindowSize_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileWindowSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTileWindowSize(temp0);
    }
    else
    {
      op->vtkTilesHelper::SetTileWindowSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkTilesHelper_SetTileWindowSize(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkTilesHelper_SetTileWindowSize_s1(self, args);
    case 1:
      return PyvtkTilesHelper_SetTileWindowSize_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTileWindowSize");
  return nullptr;
}


static PyObject *
PyvtkTilesHelper_GetTileWindowSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileWindowSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTileWindowSize() :
      op->vtkTilesHelper::GetTileWindowSize());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_GetTiledSizeAndOrigin_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTiledSizeAndOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  int temp0;
  vtkVector2i *temp1 = nullptr;
  vtkVector2i *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, "vtkVector2i") &&
      ap.GetSpecialObject(temp2, "vtkVector2i"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTiledSizeAndOrigin(temp0, *temp1, *temp2) :
      op->vtkTilesHelper::GetTiledSizeAndOrigin(temp0, *temp1, *temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkTilesHelper_GetTiledSizeAndOrigin_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTiledSizeAndOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  int temp0;
  vtkVector2i *temp1 = nullptr;
  vtkVector2i *temp2 = nullptr;
  vtkVector4d *temp3 = nullptr;
  PyObject *pobj3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, "vtkVector2i") &&
      ap.GetSpecialObject(temp2, "vtkVector2i") &&
      ap.GetSpecialObject(temp3, pobj3, "vtkVector4d"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTiledSizeAndOrigin(temp0, *temp1, *temp2, *temp3) :
      op->vtkTilesHelper::GetTiledSizeAndOrigin(temp0, *temp1, *temp2, *temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj3);

  return result;
}

static PyObject *
PyvtkTilesHelper_GetTiledSizeAndOrigin(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkTilesHelper_GetTiledSizeAndOrigin_s1(self, args);
    case 4:
      return PyvtkTilesHelper_GetTiledSizeAndOrigin_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetTiledSizeAndOrigin");
  return nullptr;
}


static PyObject *
PyvtkTilesHelper_GetTileViewport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileViewport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  int temp0;
  vtkVector4d *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, "vtkVector4d"))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTileViewport(temp0, *temp1) :
      op->vtkTilesHelper::GetTileViewport(temp0, *temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_GetTileIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  int temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<int> store1(2*size1);
  int *temp1 = store1.Data();
  int *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<int> store2(2*size2);
  int *temp2 = store2.Data();
  int *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetArray(temp2, size2))
  {
    vtkPythonArgs::Save(temp1, save1, size1);
    vtkPythonArgs::Save(temp2, save2, size2);

    bool tempr = (ap.IsBound() ?
      op->GetTileIndex(temp0, temp1, temp2) :
      op->vtkTilesHelper::GetTileIndex(temp0, temp1, temp2));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTilesHelper_GetTileEnabled(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTileEnabled");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTilesHelper *op = static_cast<vtkTilesHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTileEnabled(temp0) :
      op->vtkTilesHelper::GetTileEnabled(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkTilesHelper_Methods[] = {
  {"IsTypeOf", PyvtkTilesHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkTilesHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkTilesHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkTilesHelper\nC++: static vtkTilesHelper *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkTilesHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkTilesHelper\nC++: vtkTilesHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkTilesHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkTilesHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetTileDimensions", PyvtkTilesHelper_SetTileDimensions, METH_VARARGS,
   "SetTileDimensions(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTileDimensions(int _arg1, int _arg2)\nSetTileDimensions(self, _arg:(int, int)) -> None\nC++: void SetTileDimensions(const int _arg[2])\n\nSet the tile dimensions. Default is (1, 1).\n"},
  {"GetTileDimensions", PyvtkTilesHelper_GetTileDimensions, METH_VARARGS,
   "GetTileDimensions(self) -> (int, int)\nC++: virtual int *GetTileDimensions()\n\n"},
  {"SetTileMullions", PyvtkTilesHelper_SetTileMullions, METH_VARARGS,
   "SetTileMullions(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTileMullions(int _arg1, int _arg2)\nSetTileMullions(self, _arg:(int, int)) -> None\nC++: void SetTileMullions(const int _arg[2])\n\nSet the tile mullions in pixels. Use negative numbers to indicate\noverlap between tiles.\n"},
  {"GetTileMullions", PyvtkTilesHelper_GetTileMullions, METH_VARARGS,
   "GetTileMullions(self) -> (int, int)\nC++: virtual int *GetTileMullions()\n\n"},
  {"SetTileWindowSize", PyvtkTilesHelper_SetTileWindowSize, METH_VARARGS,
   "SetTileWindowSize(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTileWindowSize(int _arg1, int _arg2)\nSetTileWindowSize(self, _arg:(int, int)) -> None\nC++: void SetTileWindowSize(const int _arg[2])\n\nSet the tile size i.e. the size of the render window for a single\ntile. An assumption, in ParaView is that all tiles will be of the\nsame size.\n"},
  {"GetTileWindowSize", PyvtkTilesHelper_GetTileWindowSize, METH_VARARGS,
   "GetTileWindowSize(self) -> (int, int)\nC++: virtual int *GetTileWindowSize()\n\n"},
  {"GetTiledSizeAndOrigin", PyvtkTilesHelper_GetTiledSizeAndOrigin, METH_VARARGS,
   "GetTiledSizeAndOrigin(self, rank:int, size:vtkVector2i,\n    lowerLeft:vtkVector2i) -> bool\nC++: bool GetTiledSizeAndOrigin(int rank, vtkVector2i &size,\n    vtkVector2i &lowerLeft)\nGetTiledSizeAndOrigin(self, rank:int, size:vtkVector2i,\n    lowerLeft:vtkVector2i, viewport:vtkVector4d) -> bool\nC++: bool GetTiledSizeAndOrigin(int rank, vtkVector2i &size,\n    vtkVector2i &lowerLeft, vtkVector4d viewport)\n\nFor the specified `rank`, returns the tile size and origin of the\ntile rendered by the rank in display coordinates. If the rank is\nnot expected to render an tile then returns false and `size` and\n`lowerLeft` will be left unchanged. Otherwise, returns true after\nupdating `size` and `lowerLeft` appropriately.\n"},
  {"GetTileViewport", PyvtkTilesHelper_GetTileViewport, METH_VARARGS,
   "GetTileViewport(self, rank:int, tile_viewport:vtkVector4d) -> bool\nC++: bool GetTileViewport(int rank, vtkVector4d &tile_viewport)\n\nProvides the viewport for the tile displayed on the rank, if any.\nReturns false if the rank is not expected to display a tile.\nOtherwise returns true after updating `tile_viewport` to the\nresult.\n"},
  {"GetTileIndex", PyvtkTilesHelper_GetTileIndex, METH_VARARGS,
   "GetTileIndex(self, rank:int, tileX:[int, ...], tileY:[int, ...])\n    -> bool\nC++: bool GetTileIndex(int rank, int *tileX, int *tileY)\n\nGiven the rank, returns the tile location. Returns false if the\nrank is not expected to render any tile.\n"},
  {"GetTileEnabled", PyvtkTilesHelper_GetTileEnabled, METH_VARARGS,
   "GetTileEnabled(self, rank:int) -> bool\nC++: bool GetTileEnabled(int rank)\n\nReturns true if current rank will render a tile.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkTilesHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("tile_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTilesHelper_GetTileDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTilesHelper_SetTileDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTilesHelper_SetTileDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTileDimensions/SetTileDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_mullions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTilesHelper_GetTileMullions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTilesHelper_SetTileMullions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTilesHelper_SetTileMullions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTileMullions/SetTileMullions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_window_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTilesHelper_GetTileWindowSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkTilesHelper_SetTileWindowSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkTilesHelper_SetTileWindowSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTileWindowSize/SetTileWindowSize\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkTilesHelper_Doc =
  "vtkTilesHelper - this is a helper class that handles viewport\ncomputations when rendering for tile-displays.\n\n"
  "Superclass: vtkObject\n\n"
  "This assumes that all tiles have the same pixel-size.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkTilesHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkTilesHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkTilesHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkTilesHelper_StaticNew()
{
  return vtkTilesHelper::New();
}

PyObject *PyvtkTilesHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkTilesHelper_Type, PyvtkTilesHelper_Methods,
    "vtkTilesHelper",
 &PyvtkTilesHelper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkTilesHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkTilesHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkTilesHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkTilesHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

