/* This file is part of GDB.

   Copyright 2002, 2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   --

   This file was generated by the program igen */

#ifndef ICACHE_H
#define ICACHE_H

typedef unsigned_word idecode_icache
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);


PSIM_INLINE_ICACHE\
(unsigned_word)
icache_illegal
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

PSIM_INLINE_ICACHE\
(unsigned_word)
icache_floating_point_unavailable
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_instruction_call
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Trap_Word_Immediate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_Low_Immediate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Immediate_Carrying
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Compare_Logical_Immediate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Compare_Immediate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Immediate_Carrying
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Immediate_Carrying_and_Record
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Immediate_RA0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Immediate_RA
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Immediate_Shifted_RA0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Immediate_Shifted_RA
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO2
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO3
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO4
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO5
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO6
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO7
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO8
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO9
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO10
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO11
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO12
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO13
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO14
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO15
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO16
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO17
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO18
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO19
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO20
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO21
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO22
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO23
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO24
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO25
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO26
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO27
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO28
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO29
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO30
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK0_BO31
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO2
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO3
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO4
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO5
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO6
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO7
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO8
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO9
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO10
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO11
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO12
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO13
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO14
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO15
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO16
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO17
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO18
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO19
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO20
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO21
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO22
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO23
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO24
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO25
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO26
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO27
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO28
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO29
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO30
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA0_LK1_BO31
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO2
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO3
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO4
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO5
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO6
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO7
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO8
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO9
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO10
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO11
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO12
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO13
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO14
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO15
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO16
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO17
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO18
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO19
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO20
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO21
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO22
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO23
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO24
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO25
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO26
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO27
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO28
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO29
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO30
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK0_BO31
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO2
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO3
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO4
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO5
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO6
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO7
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO8
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO9
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO10
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO11
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO12
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO13
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO14
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO15
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO16
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO17
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO18
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO19
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO20
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO21
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO22
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO23
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO24
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO25
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO26
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO27
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO28
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO29
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO30
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_AA1_LK1_BO31
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_System_Call
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_AA0_LK0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_AA0_LK1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_AA1_LK0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_AA1_LK1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_Condition_Register_Field
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_to_Link_Register_LK0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_to_Link_Register_LK1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Condition_Register_NOR
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Return_From_Interrupt
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Condition_Register_AND_with_Complement
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Instruction_Synchronize
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Condition_Register_XOR
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Condition_Register_NAND
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Condition_Register_AND
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Condition_Register_Equivalent
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Condition_Register_OR_with_Complement
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Condition_Register_OR
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_to_Count_Register_LK0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Branch_Conditional_to_Count_Register_LK1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Rotate_Left_Word_then_AND_with_Mask_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Rotate_Left_Word_then_AND_with_Mask_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_OR_Immediate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_OR_Immediate_Shifted
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_XOR_Immediate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_XOR_Immediate_Shifted
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_AND_Immediate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_AND_Immediate_Shifted
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Compare
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Trap_Word
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Carrying_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Carrying_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Carrying_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Carrying_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_High_Word_Unsigned_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_High_Word_Unsigned_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_From_Condition_Register
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Word_And_Reserve_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Word_and_Zero_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Shift_Left_Word_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Shift_Left_Word_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Count_Leading_Zeros_Word_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Count_Leading_Zeros_Word_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_AND_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_AND_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Compare_Logical
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Data_Cache_Block_Store
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Word_and_Zero_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_AND_with_Complement_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_AND_with_Complement_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_High_Word_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_High_Word_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_From_Machine_State_Register
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Data_Cache_Block_Flush
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Byte_and_Zero_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Negate_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Negate_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Byte_and_Zero_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_NOR_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_NOR_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Extended_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Extended_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Extended_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Extended_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_to_Condition_Register_Fields
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_Machine_State_Register
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Word_Conditional_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Word_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Word_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_from_Zero_Extended_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_from_Zero_Extended_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_to_Zero_Extended_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_to_Zero_Extended_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_Segment_Register
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Byte_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Minus_One_Extended_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Minus_One_Extended_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_to_Minus_One_Extended_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_to_Minus_One_Extended_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_Low_Word_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_Low_Word_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_Segment_Register_Indirect
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Data_Cache_Block_Touch_for_Store
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Byte_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Data_Cache_Block_Touch
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_and_Zero_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Equivalent_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Equivalent_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_TLB_Invalidate_Entry
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_and_Zero_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_XOR_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_XOR_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_from_Special_Purpose_Register_SPR256
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_from_Special_Purpose_Register_SPR
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_Algebraic_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_TLB_Invalidate_All
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_From_Time_Base
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_Algebraic_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Half_Word_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_OR_with_Complement_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_OR_with_Complement_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Half_Word_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_OR_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_OR_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Divide_Word_Unsigned_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Divide_Word_Unsigned_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_to_Special_Purpose_Register_SPR256
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_to_Special_Purpose_Register_SPR
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Data_Cache_Block_Invalidate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_NAND_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_NAND_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Divide_Word_OE0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Divide_Word_OE0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_to_Condition_Register_from_XER
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Carrying_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Carrying_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Carrying_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Carrying_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_String_Word_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Word_ByteReverse_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_FloatingPoint_Single_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Shift_Right_Word_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Shift_Right_Word_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_TLB_Synchronize
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_FloatingPoint_Single_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_From_Segment_Register
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_String_Word_Immediate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Synchronize
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_FloatingPoint_Double_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Negate_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Negate_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_FloatingPoint_Double_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Extended_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Extended_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Extended_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_Extended_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_From_Segment_Register_Indirect
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_String_Word_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Word_ByteReversed_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Single_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Single_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_from_Zero_Extended_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_from_Zero_Extended_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_to_Zero_Extended_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_to_Zero_Extended_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_String_Word_Immedate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Double_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Minus_One_Extended_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Subtract_From_Minus_One_Extended_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_to_Minus_One_Extended_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_to_Minus_One_Extended_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_Low_Word_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Multiply_Low_Word_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Double_with_Update_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Add_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_ByteReverse_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Shift_Right_Algebraic_Word_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Shift_Right_Algebraic_Word_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Shift_Right_Algebraic_Word_Immediate_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Shift_Right_Algebraic_Word_Immediate_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Enforce_Inorder_Execution_of_IO
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Half_Word_ByteReversed_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Extend_Sign_Half_Word_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Extend_Sign_Half_Word_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Extend_Sign_Byte_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Extend_Sign_Byte_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Divide_Word_Unsigned_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Divide_Word_Unsigned_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Instruction_Cache_Block_Invalidate
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Integer_Word_Indexed
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Divide_Word_OE1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Divide_Word_OE1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Data_Cache_Block_set_to_Zero
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Word_and_Zero
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Word_and_Zero_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Byte_and_Zero
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Byte_and_Zero_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Word
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Word_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Byte
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Byte_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_and_Zero
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_and_Zero_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_Algebraic
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Halfword_Algebraic_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Half_Word
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Half_Word_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_Multiple_Word
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_Multiple_Word
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_FloatingPoint_Single
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_FloatingPoint_Single_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_FloatingPoint_Double
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Load_FloatingPoint_Double_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Single
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Single_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Double
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Store_FloatingPoint_Double_with_Update
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Divide_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Divide_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Subtract_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Subtract_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Add_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Add_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Square_Root_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Square_Root_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Reciprocal_Estimate_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Reciprocal_Estimate_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_Single_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_Single_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Compare_Unordered
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Round_to_SinglePrecision_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Round_to_SinglePrecision_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Convert_To_Integer_Word_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Convert_To_Integer_Word_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Divide_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Divide_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Subtract_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Subtract_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Add_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Add_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Square_Root_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Square_Root_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Reciprocal_Square_Root_Estimate_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Reciprocal_Square_Root_Estimate_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Compare_Ordered
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_FPSCR_Bit_1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_FPSCR_Bit_1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negate_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negate_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC1_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC1_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_to_Condition_Register_from_FPSCR
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_FPSCR_Bit_0_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_FPSCR_Bit_0_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Move_Register_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Move_Register_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC2_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC2_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC2_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC2_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC2_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC2_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC2_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC2_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC2_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC2_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC2_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC2_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC3_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC3_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC3_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC3_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC3_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC3_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC3_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC3_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC3_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC3_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC3_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC3_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_FPSCR_Field_Immediate_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_FPSCR_Field_Immediate_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_Absolute_Value_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_Absolute_Value_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC4_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC4_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC4_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC4_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC4_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC4_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC4_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC4_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC4_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC4_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC4_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC4_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC5_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC5_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC5_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC5_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC5_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC5_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC5_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC5_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC5_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC5_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC5_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC5_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC6_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC6_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC6_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC6_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC6_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC6_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC6_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC6_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC6_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC6_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC6_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC6_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC7_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC7_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC7_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC7_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC7_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC7_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC7_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC7_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC7_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC7_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC7_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC7_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Absolute_Value_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Absolute_Value_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC8_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC8_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC8_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC8_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC8_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC8_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC8_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC8_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC8_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC8_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC8_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC8_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC9_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC9_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC9_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC9_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC9_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC9_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC9_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC9_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC9_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC9_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC9_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC9_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC10_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC10_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC10_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC10_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC10_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC10_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC10_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC10_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC10_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC10_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC10_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC10_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC11_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC11_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC11_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC11_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC11_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC11_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC11_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC11_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC11_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC11_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC11_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC11_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC12_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC12_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC12_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC12_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC12_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC12_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC12_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC12_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC12_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC12_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC12_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC12_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC13_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC13_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC13_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC13_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC13_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC13_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC13_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC13_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC13_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC13_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC13_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC13_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC14_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC14_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC14_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC14_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC14_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC14_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC14_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC14_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC14_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC14_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC14_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC14_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC15_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC15_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC15_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC15_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC15_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC15_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC15_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC15_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC15_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC15_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC15_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC15_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC16_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC16_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC16_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC16_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC16_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC16_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC16_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC16_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC16_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC16_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC16_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC16_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC17_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC17_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC17_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC17_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC17_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC17_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC17_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC17_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC17_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC17_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC17_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC17_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_From_FPSCR_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_From_FPSCR_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC18_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC18_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC18_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC18_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC18_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC18_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC18_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC18_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC18_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC18_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC18_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC18_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC19_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC19_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC19_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC19_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC19_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC19_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC19_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC19_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC19_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC19_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC19_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC19_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC20_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC20_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC20_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC20_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC20_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC20_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC20_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC20_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC20_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC20_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC20_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC20_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC21_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC21_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC21_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC21_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC21_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC21_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC21_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC21_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC21_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC21_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC21_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC21_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_FPSCR_Fields_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Move_To_FPSCR_Fields_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC22_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC22_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC22_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC22_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC22_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC22_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC22_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC22_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC22_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC22_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC22_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC22_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC23_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC23_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC23_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC23_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC23_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC23_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC23_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC23_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC23_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC23_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC23_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC23_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC24_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC24_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC24_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC24_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC24_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC24_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC24_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC24_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC24_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC24_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC24_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC24_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC25_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC25_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC25_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC25_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC25_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC25_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC25_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC25_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC25_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC25_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC25_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC25_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC26_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC26_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC26_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC26_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC26_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC26_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC26_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC26_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC26_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC26_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC26_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC26_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC27_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC27_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC27_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC27_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC27_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC27_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC27_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC27_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC27_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC27_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC27_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC27_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC28_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC28_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC28_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC28_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC28_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC28_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC28_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC28_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC28_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC28_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC28_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC28_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC29_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC29_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC29_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC29_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC29_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC29_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC29_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC29_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC29_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC29_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC29_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC29_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC30_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC30_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC30_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC30_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC30_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC30_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC30_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC30_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC30_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC30_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC30_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC30_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC31_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Select_FRC31_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC31_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Multiply_FRC31_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC31_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplySubtract_FRC31_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC31_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_MultiplyAdd_FRC31_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC31_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplySubtract_FRC31_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC31_Rc0
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

EXTERN_ICACHE\
(unsigned_word) icache_Floating_Negative_MultiplyAdd_FRC31_Rc1
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry);

#endif /* _ICACHE_H_*/
