/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


#include "qoaiservervariable.h"

#include <QtCore/qset.h>
#include <QtCore/qstring.h>

QT_BEGIN_NAMESPACE

namespace QtOpenApiCommon {

class QOAIServerVariablePrivate : public QSharedData
{
public:
    QString m_value;
    QString m_description;
    QSet<QString> m_enumValues;
};

QOAIServerVariable::QOAIServerVariable(const QString &description,
                                                   const QString &defaultValue,
                                                   const QSet<QString> &enumValues)
    : QOAIServerVariable()
{
    d_ptr->m_value = defaultValue;
    d_ptr->m_description = description;
    d_ptr->m_enumValues = enumValues;
}

QOAIServerVariable::QOAIServerVariable()
    : d_ptr(new QOAIServerVariablePrivate)
{}

QOAIServerVariable::~QOAIServerVariable()
    = default;

QOAIServerVariable::QOAIServerVariable(const QOAIServerVariable &other)
    = default;

QOAIServerVariable &QOAIServerVariable::operator=(const QOAIServerVariable &other)
{
    if (this != &other)
        d_ptr = other.d_ptr;
    return *this;
}

QOAIServerVariable::QOAIServerVariable(QOAIServerVariable &&other) noexcept
    = default;

QOAIServerVariable &QOAIServerVariable::operator=(QOAIServerVariable &&other) noexcept
{
    swap(other);
    return *this;
}

void QOAIServerVariable::swap(QOAIServerVariable &other) noexcept
{
    d_ptr.swap(other.d_ptr);
}

QOAIServerVariable::ServerError QOAIServerVariable::setValue(const QString& value)
{
    if (!d_ptr->m_enumValues.empty() && !d_ptr->m_enumValues.contains(value))
        return ServerError::EnumValueNotFound;

    d_ptr.detach();
    d_ptr->m_value = value;
    return ServerError::NoError;
}

QString QOAIServerVariable::value() const
{
    return d_ptr->m_value;
}

QSet<QString> QOAIServerVariable::enumValues() const
{
    return d_ptr->m_enumValues;
}

QString QOAIServerVariable::description() const
{
    return d_ptr->m_description;
}

bool
comparesEqual(const QOAIServerVariable &lhs, const QOAIServerVariable &rhs) noexcept
{
    return lhs.d_ptr->m_value == rhs.d_ptr->m_value
        && lhs.d_ptr->m_description == rhs.d_ptr->m_description
        && lhs.d_ptr->m_enumValues == rhs.d_ptr->m_enumValues;
}

} // namespace QtOpenApiCommon

QT_END_NAMESPACE
