/* Generated by wayland-scanner 1.24.0 */

#ifndef HYPRLAND_GLOBAL_SHORTCUTS_V1_CLIENT_PROTOCOL_H
#define HYPRLAND_GLOBAL_SHORTCUTS_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_hyprland_global_shortcuts_v1 The hyprland_global_shortcuts_v1 protocol
 * registering global shortcuts
 *
 * @section page_desc_hyprland_global_shortcuts_v1 Description
 *
 * This protocol allows a client to register triggerable actions,
 * meant to be global shortcuts.
 *
 * @section page_ifaces_hyprland_global_shortcuts_v1 Interfaces
 * - @subpage page_iface_hyprland_global_shortcuts_manager_v1 - manager to register global shortcuts
 * - @subpage page_iface_hyprland_global_shortcut_v1 - a shortcut
 * @section page_copyright_hyprland_global_shortcuts_v1 Copyright
 * <pre>
 *
 * Copyright © 2022 Vaxry
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 */
struct hyprland_global_shortcut_v1;
struct hyprland_global_shortcuts_manager_v1;

#ifndef HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_INTERFACE
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_INTERFACE
/**
 * @page page_iface_hyprland_global_shortcuts_manager_v1 hyprland_global_shortcuts_manager_v1
 * @section page_iface_hyprland_global_shortcuts_manager_v1_desc Description
 *
 * This object is a manager which offers requests to create global shortcuts.
 * @section page_iface_hyprland_global_shortcuts_manager_v1_api API
 * See @ref iface_hyprland_global_shortcuts_manager_v1.
 */
/**
 * @defgroup iface_hyprland_global_shortcuts_manager_v1 The hyprland_global_shortcuts_manager_v1 interface
 *
 * This object is a manager which offers requests to create global shortcuts.
 */
extern const struct wl_interface hyprland_global_shortcuts_manager_v1_interface;
#endif
#ifndef HYPRLAND_GLOBAL_SHORTCUT_V1_INTERFACE
#define HYPRLAND_GLOBAL_SHORTCUT_V1_INTERFACE
/**
 * @page page_iface_hyprland_global_shortcut_v1 hyprland_global_shortcut_v1
 * @section page_iface_hyprland_global_shortcut_v1_desc Description
 *
 * This object represents a single shortcut.
 * @section page_iface_hyprland_global_shortcut_v1_api API
 * See @ref iface_hyprland_global_shortcut_v1.
 */
/**
 * @defgroup iface_hyprland_global_shortcut_v1 The hyprland_global_shortcut_v1 interface
 *
 * This object represents a single shortcut.
 */
extern const struct wl_interface hyprland_global_shortcut_v1_interface;
#endif

#ifndef HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_ERROR_ENUM
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_ERROR_ENUM
enum hyprland_global_shortcuts_manager_v1_error {
	/**
	 * the app_id + id combination has already been registered.
	 */
	HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_ERROR_ALREADY_TAKEN = 0,
};
#endif /* HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_ERROR_ENUM */

#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_REGISTER_SHORTCUT 0
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_DESTROY 1


/**
 * @ingroup iface_hyprland_global_shortcuts_manager_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_REGISTER_SHORTCUT_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_global_shortcuts_manager_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_hyprland_global_shortcuts_manager_v1 */
static inline void
hyprland_global_shortcuts_manager_v1_set_user_data(struct hyprland_global_shortcuts_manager_v1 *hyprland_global_shortcuts_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_global_shortcuts_manager_v1, user_data);
}

/** @ingroup iface_hyprland_global_shortcuts_manager_v1 */
static inline void *
hyprland_global_shortcuts_manager_v1_get_user_data(struct hyprland_global_shortcuts_manager_v1 *hyprland_global_shortcuts_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_global_shortcuts_manager_v1);
}

static inline uint32_t
hyprland_global_shortcuts_manager_v1_get_version(struct hyprland_global_shortcuts_manager_v1 *hyprland_global_shortcuts_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_global_shortcuts_manager_v1);
}

/**
 * @ingroup iface_hyprland_global_shortcuts_manager_v1
 *
 * Register a new global shortcut.
 *
 * A global shortcut is anonymous, meaning the app does not know what key(s) trigger it.
 *
 * The shortcut's keybinding shall be dealt with by the compositor.
 *
 * In the case of a duplicate app_id + id combination, the already_taken protocol error is raised.
 */
static inline struct hyprland_global_shortcut_v1 *
hyprland_global_shortcuts_manager_v1_register_shortcut(struct hyprland_global_shortcuts_manager_v1 *hyprland_global_shortcuts_manager_v1, const char *id, const char *app_id, const char *description, const char *trigger_description)
{
	struct wl_proxy *shortcut;

	shortcut = wl_proxy_marshal_flags((struct wl_proxy *) hyprland_global_shortcuts_manager_v1,
			 HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_REGISTER_SHORTCUT, &hyprland_global_shortcut_v1_interface, wl_proxy_get_version((struct wl_proxy *) hyprland_global_shortcuts_manager_v1), 0, NULL, id, app_id, description, trigger_description);

	return (struct hyprland_global_shortcut_v1 *) shortcut;
}

/**
 * @ingroup iface_hyprland_global_shortcuts_manager_v1
 *
 * All objects created by the manager will still remain valid, until their
 * appropriate destroy request has been called.
 */
static inline void
hyprland_global_shortcuts_manager_v1_destroy(struct hyprland_global_shortcuts_manager_v1 *hyprland_global_shortcuts_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_global_shortcuts_manager_v1,
			 HYPRLAND_GLOBAL_SHORTCUTS_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_global_shortcuts_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 * @struct hyprland_global_shortcut_v1_listener
 */
struct hyprland_global_shortcut_v1_listener {
	/**
	 * keystroke pressed
	 *
	 * The keystroke was pressed.
	 *
	 * tv_ values hold the timestamp of the occurrence.
	 * @param tv_sec_hi high 32 bits of the seconds part of the timestamp
	 * @param tv_sec_lo low 32 bits of the seconds part of the timestamp
	 * @param tv_nsec nanoseconds part of the timestamp
	 */
	void (*pressed)(void *data,
			struct hyprland_global_shortcut_v1 *hyprland_global_shortcut_v1,
			uint32_t tv_sec_hi,
			uint32_t tv_sec_lo,
			uint32_t tv_nsec);
	/**
	 * keystroke released
	 *
	 * The keystroke was released.
	 *
	 * tv_ values hold the timestamp of the occurrence.
	 * @param tv_sec_hi high 32 bits of the seconds part of the timestamp
	 * @param tv_sec_lo low 32 bits of the seconds part of the timestamp
	 * @param tv_nsec nanoseconds part of the timestamp
	 */
	void (*released)(void *data,
			 struct hyprland_global_shortcut_v1 *hyprland_global_shortcut_v1,
			 uint32_t tv_sec_hi,
			 uint32_t tv_sec_lo,
			 uint32_t tv_nsec);
};

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 */
static inline int
hyprland_global_shortcut_v1_add_listener(struct hyprland_global_shortcut_v1 *hyprland_global_shortcut_v1,
					 const struct hyprland_global_shortcut_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) hyprland_global_shortcut_v1,
				     (void (**)(void)) listener, data);
}

#define HYPRLAND_GLOBAL_SHORTCUT_V1_DESTROY 0

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUT_V1_PRESSED_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_global_shortcut_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUT_V1_RELEASED_SINCE_VERSION 1

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 */
#define HYPRLAND_GLOBAL_SHORTCUT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_hyprland_global_shortcut_v1 */
static inline void
hyprland_global_shortcut_v1_set_user_data(struct hyprland_global_shortcut_v1 *hyprland_global_shortcut_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_global_shortcut_v1, user_data);
}

/** @ingroup iface_hyprland_global_shortcut_v1 */
static inline void *
hyprland_global_shortcut_v1_get_user_data(struct hyprland_global_shortcut_v1 *hyprland_global_shortcut_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_global_shortcut_v1);
}

static inline uint32_t
hyprland_global_shortcut_v1_get_version(struct hyprland_global_shortcut_v1 *hyprland_global_shortcut_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_global_shortcut_v1);
}

/**
 * @ingroup iface_hyprland_global_shortcut_v1
 *
 * Destroys the shortcut. Can be sent at any time by the client.
 */
static inline void
hyprland_global_shortcut_v1_destroy(struct hyprland_global_shortcut_v1 *hyprland_global_shortcut_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_global_shortcut_v1,
			 HYPRLAND_GLOBAL_SHORTCUT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_global_shortcut_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
