// SPDX-FileCopyrightText: 2017-2025 deroad <deroad@kumo.xn--q9jyb4c>
// SPDX-License-Identifier: LGPL-3.0-only

#ifndef RZ_OIDS_H
#define RZ_OIDS_H

struct rz_oid_list_t {
	const char *oid;
	const char *name;
} X509OIDList[] = {
	{ "0.2.262.1.10", "Telesec" },
	{ "0.2.262.1.10.0", "extension" },
	{ "0.2.262.1.10.1", "mechanism" },
	{ "0.2.262.1.10.1.0", "authentication" },
	{ "0.2.262.1.10.1.0.1", "passwordAuthentication" },
	{ "0.2.262.1.10.1.0.2", "protectedPasswordAuthentication" },
	{ "0.2.262.1.10.1.0.3", "oneWayX509Authentication" },
	{ "0.2.262.1.10.1.0.4", "twoWayX509Authentication" },
	{ "0.2.262.1.10.1.0.5", "threeWayX509Authentication" },
	{ "0.2.262.1.10.1.0.6", "oneWayISO9798Authentication" },
	{ "0.2.262.1.10.1.0.7", "twoWayISO9798Authentication" },
	{ "0.2.262.1.10.1.0.8", "telekomAuthentication" },
	{ "0.2.262.1.10.1.1", "signature" },
	{ "0.2.262.1.10.1.1.1", "md4WithRSAAndISO9697" },
	{ "0.2.262.1.10.1.1.2", "md4WithRSAAndTelesecSignatureStandard" },
	{ "0.2.262.1.10.1.1.3", "md5WithRSAAndISO9697" },
	{ "0.2.262.1.10.1.1.4", "md5WithRSAAndTelesecSignatureStandard" },
	{ "0.2.262.1.10.1.1.5", "ripemd160WithRSAAndTelekomSignatureStandard" },
	{ "0.2.262.1.10.1.1.9", "hbciRsaSignature" },
	{ "0.2.262.1.10.1.2", "encryption" },
	{ "0.2.262.1.10.1.2.0", "none" },
	{ "0.2.262.1.10.1.2.1", "rsaTelesec" },
	{ "0.2.262.1.10.1.2.2", "des" },
	{ "0.2.262.1.10.1.2.2.1", "desECB" },
	{ "0.2.262.1.10.1.2.2.2", "desCBC" },
	{ "0.2.262.1.10.1.2.2.3", "desOFB" },
	{ "0.2.262.1.10.1.2.2.4", "desCFB8" },
	{ "0.2.262.1.10.1.2.2.5", "desCFB64" },
	{ "0.2.262.1.10.1.2.3", "des3" },
	{ "0.2.262.1.10.1.2.3.1", "des3ECB" },
	{ "0.2.262.1.10.1.2.3.2", "des3CBC" },
	{ "0.2.262.1.10.1.2.3.3", "des3OFB" },
	{ "0.2.262.1.10.1.2.3.4", "des3CFB8" },
	{ "0.2.262.1.10.1.2.3.5", "des3CFB64" },
	{ "0.2.262.1.10.1.2.4", "magenta" },
	{ "0.2.262.1.10.1.2.5", "idea" },
	{ "0.2.262.1.10.1.2.5.1", "ideaECB" },
	{ "0.2.262.1.10.1.2.5.2", "ideaCBC" },
	{ "0.2.262.1.10.1.2.5.3", "ideaOFB" },
	{ "0.2.262.1.10.1.2.5.4", "ideaCFB8" },
	{ "0.2.262.1.10.1.2.5.5", "ideaCFB64" },
	{ "0.2.262.1.10.1.3", "oneWayFunction" },
	{ "0.2.262.1.10.1.3.1", "md4" },
	{ "0.2.262.1.10.1.3.2", "md5" },
	{ "0.2.262.1.10.1.3.3", "sqModNX509" },
	{ "0.2.262.1.10.1.3.4", "sqModNISO" },
	{ "0.2.262.1.10.1.3.5", "ripemd128" },
	{ "0.2.262.1.10.1.3.6", "hashUsingBlockCipher" },
	{ "0.2.262.1.10.1.3.7", "mac" },
	{ "0.2.262.1.10.1.3.8", "ripemd160" },
	{ "0.2.262.1.10.1.4", "fecFunction" },
	{ "0.2.262.1.10.1.4.1", "reedSolomon" },
	{ "0.2.262.1.10.10", "notification" },
	{ "0.2.262.1.10.11", "snmp-mibs" },
	{ "0.2.262.1.10.11.1", "securityApplication" },
	{ "0.2.262.1.10.12", "certAndCrlExtensionDefinitions" },
	{ "0.2.262.1.10.12.0", "liabilityLimitationFlag" },
	{ "0.2.262.1.10.12.1", "telesecCertIdExt" },
	{ "0.2.262.1.10.12.2", "Telesec.policyIdentifier" },
	{ "0.2.262.1.10.12.3", "telesecPolicyQualifierID" },
	{ "0.2.262.1.10.12.4", "telesecCRLFilteredExt" },
	{ "0.2.262.1.10.12.5", "telesecCRLFilterExt" },
	{ "0.2.262.1.10.12.6", "telesecNamingAuthorityExt" },
	{ "0.2.262.1.10.2", "module" },
	{ "0.2.262.1.10.2.0", "algorithms" },
	{ "0.2.262.1.10.2.1", "attributeTypes" },
	{ "0.2.262.1.10.2.10", "electronicOrder" },
	{ "0.2.262.1.10.2.11", "telesecTtpAsymmetricApplication" },
	{ "0.2.262.1.10.2.12", "telesecTtpBasisApplication" },
	{ "0.2.262.1.10.2.13", "telesecTtpMessages" },
	{ "0.2.262.1.10.2.14", "telesecTtpTimeStampApplication" },
	{ "0.2.262.1.10.2.2", "certificateTypes" },
	{ "0.2.262.1.10.2.3", "messageTypes" },
	{ "0.2.262.1.10.2.4", "plProtocol" },
	{ "0.2.262.1.10.2.5", "smeAndComponentsOfSme" },
	{ "0.2.262.1.10.2.6", "fec" },
	{ "0.2.262.1.10.2.7", "usefulDefinitions" },
	{ "0.2.262.1.10.2.8", "stefiles" },
	{ "0.2.262.1.10.2.9", "sadmib" },
	{ "0.2.262.1.10.3", "objectClass" },
	{ "0.2.262.1.10.3.0", "telesecOtherName" },
	{ "0.2.262.1.10.3.1", "directory" },
	{ "0.2.262.1.10.3.2", "directoryType" },
	{ "0.2.262.1.10.3.3", "directoryGroup" },
	{ "0.2.262.1.10.3.4", "directoryUser" },
	{ "0.2.262.1.10.3.5", "symmetricKeyEntry" },
	{ "0.2.262.1.10.4", "package" },
	{ "0.2.262.1.10.5", "parameter" },
	{ "0.2.262.1.10.6", "nameBinding" },
	{ "0.2.262.1.10.7", "attribute" },
	{ "0.2.262.1.10.7.0", "applicationGroupIdentifier" },
	{ "0.2.262.1.10.7.1", "certificateType" },
	{ "0.2.262.1.10.7.10", "subject" },
	{ "0.2.262.1.10.7.11", "timeOfRevocation" },
	{ "0.2.262.1.10.7.12", "userGroupReference" },
	{ "0.2.262.1.10.7.13", "validity" },
	{ "0.2.262.1.10.7.14", "zert93" },
	{ "0.2.262.1.10.7.15", "securityMessEnv" },
	{ "0.2.262.1.10.7.16", "anonymizedPublicKeyDirectory" },
	{ "0.2.262.1.10.7.17", "telesecGivenName" },
	{ "0.2.262.1.10.7.18", "nameAdditions" },
	{ "0.2.262.1.10.7.19", "telesecPostalCode" },
	{ "0.2.262.1.10.7.2", "telesecCertificate" },
	{ "0.2.262.1.10.7.20", "nameDistinguisher" },
	{ "0.2.262.1.10.7.21", "telesecCertificateList" },
	{ "0.2.262.1.10.7.22", "teletrustCertificateList" },
	{ "0.2.262.1.10.7.23", "x509CertificateList" },
	{ "0.2.262.1.10.7.24", "timeOfIssue" },
	{ "0.2.262.1.10.7.25", "physicalCardNumber" },
	{ "0.2.262.1.10.7.26", "fileType" },
	{ "0.2.262.1.10.7.27", "ctlFileIsArchive" },
	{ "0.2.262.1.10.7.28", "emailAddress" },
	{ "0.2.262.1.10.7.29", "certificateTemplateList" },
	{ "0.2.262.1.10.7.3", "certificateNumber" },
	{ "0.2.262.1.10.7.30", "directoryName" },
	{ "0.2.262.1.10.7.31", "directoryTypeName" },
	{ "0.2.262.1.10.7.32", "directoryGroupName" },
	{ "0.2.262.1.10.7.33", "directoryUserName" },
	{ "0.2.262.1.10.7.34", "revocationFlag" },
	{ "0.2.262.1.10.7.35", "symmetricKeyEntryName" },
	{ "0.2.262.1.10.7.36", "glNumber" },
	{ "0.2.262.1.10.7.37", "goNumber" },
	{ "0.2.262.1.10.7.38", "gKeyData" },
	{ "0.2.262.1.10.7.39", "zKeyData" },
	{ "0.2.262.1.10.7.4", "certificateRevocationList" },
	{ "0.2.262.1.10.7.40", "ktKeyData" },
	{ "0.2.262.1.10.7.41", "ktKeyNumber" },
	{ "0.2.262.1.10.7.5", "creationDate" },
	{ "0.2.262.1.10.7.51", "timeOfRevocationGen" },
	{ "0.2.262.1.10.7.52", "liabilityText" },
	{ "0.2.262.1.10.7.6", "issuer" },
	{ "0.2.262.1.10.7.7", "namingAuthority" },
	{ "0.2.262.1.10.7.8", "publicKeyDirectory" },
	{ "0.2.262.1.10.7.9", "securityDomain" },
	{ "0.2.262.1.10.8", "attributeGroup" },
	{ "0.2.262.1.10.9", "action" },
	{ "0.4.0.127.0.7", "bsi" },
	{ "0.4.0.127.0.7.1", "bsiEcc" },
	{ "0.4.0.127.0.7.1.1", "bsifieldType" },
	{ "0.4.0.127.0.7.1.1.1", "bsiPrimeField" },
	{ "0.4.0.127.0.7.1.1.2", "bsiCharacteristicTwoField" },
	{ "0.4.0.127.0.7.1.1.2.2", "bsiECTLVKeyFormat" },
	{ "0.4.0.127.0.7.1.1.2.2.1", "bsiECTLVPublicKey" },
	{ "0.4.0.127.0.7.1.1.2.3", "bsiCharacteristicTwoBasis" },
	{ "0.4.0.127.0.7.1.1.2.3.1", "bsiGnBasis" },
	{ "0.4.0.127.0.7.1.1.2.3.2", "bsiTpBasis" },
	{ "0.4.0.127.0.7.1.1.2.3.3", "bsiPpBasis" },
	{ "0.4.0.127.0.7.1.1.4.1", "bsiEcdsaSignatures" },
	{ "0.4.0.127.0.7.1.1.4.1.1", "bsiEcdsaWithSHA1" },
	{ "0.4.0.127.0.7.1.1.4.1.2", "bsiEcdsaWithSHA224" },
	{ "0.4.0.127.0.7.1.1.4.1.3", "bsiEcdsaWithSHA256" },
	{ "0.4.0.127.0.7.1.1.4.1.4", "bsiEcdsaWithSHA384" },
	{ "0.4.0.127.0.7.1.1.4.1.5", "bsiEcdsaWithSHA512" },
	{ "0.4.0.127.0.7.1.1.4.1.6", "bsiEcdsaWithRIPEMD160" },
	{ "0.4.0.127.0.7.1.1.5.1.1", "bsiEckaEgX963KDF" },
	{ "0.4.0.127.0.7.1.1.5.1.1.1", "bsiEckaEgX963KDFWithSHA1" },
	{ "0.4.0.127.0.7.1.1.5.1.1.2", "bsiEckaEgX963KDFWithSHA224" },
	{ "0.4.0.127.0.7.1.1.5.1.1.3", "bsiEckaEgX963KDFWithSHA256" },
	{ "0.4.0.127.0.7.1.1.5.1.1.4", "bsiEckaEgX963KDFWithSHA384" },
	{ "0.4.0.127.0.7.1.1.5.1.1.5", "bsiEckaEgX963KDFWithSHA512" },
	{ "0.4.0.127.0.7.1.1.5.1.1.6", "bsiEckaEgX963KDFWithRIPEMD160" },
	{ "0.4.0.127.0.7.1.1.5.1.2", "bsiEckaEgSessionKDF" },
	{ "0.4.0.127.0.7.1.1.5.1.2.1", "bsiEckaEgSessionKDFWith3DES" },
	{ "0.4.0.127.0.7.1.1.5.1.2.2", "bsiEckaEgSessionKDFWithAES128" },
	{ "0.4.0.127.0.7.1.1.5.1.2.3", "bsiEckaEgSessionKDFWithAES192" },
	{ "0.4.0.127.0.7.1.1.5.1.2.4", "bsiEckaEgSessionKDFWithAES256" },
	{ "0.4.0.127.0.7.1.1.5.2", "bsiEckaDH" },
	{ "0.4.0.127.0.7.1.1.5.2.1", "bsiEckaDHX963KDF" },
	{ "0.4.0.127.0.7.1.1.5.2.1.1", "bsiEckaDHX963KDFWithSHA1" },
	{ "0.4.0.127.0.7.1.1.5.2.1.2", "bsiEckaDHX963KDFWithSHA224" },
	{ "0.4.0.127.0.7.1.1.5.2.1.3", "bsiEckaDHX963KDFWithSHA256" },
	{ "0.4.0.127.0.7.1.1.5.2.1.4", "bsiEckaDHX963KDFWithSHA384" },
	{ "0.4.0.127.0.7.1.1.5.2.1.5", "bsiEckaDHX963KDFWithSHA512" },
	{ "0.4.0.127.0.7.1.1.5.2.1.6", "bsiEckaDHX963KDFWithRIPEMD160" },
	{ "0.4.0.127.0.7.1.1.5.2.2", "bsiEckaDHSessionKDF" },
	{ "0.4.0.127.0.7.1.1.5.2.2.1", "bsiEckaDHSessionKDFWith3DES" },
	{ "0.4.0.127.0.7.1.1.5.2.2.2", "bsiEckaDHSessionKDFWithAES128" },
	{ "0.4.0.127.0.7.1.1.5.2.2.3", "bsiEckaDHSessionKDFWithAES192" },
	{ "0.4.0.127.0.7.1.1.5.2.2.4", "bsiEckaDHSessionKDFWithAES256" },
	{ "0.4.0.127.0.7.1.2", "bsiEcKeyType" },
	{ "0.4.0.127.0.7.1.2.1", "bsiEcPublicKey" },
	{ "0.4.0.127.0.7.1.5.1", "bsiKaeg" },
	{ "0.4.0.127.0.7.1.5.1.1", "bsiKaegWithX963KDF" },
	{ "0.4.0.127.0.7.1.5.1.2", "bsiKaegWith3DESKDF" },
	{ "0.4.0.127.0.7.2.2.1", "bsiPK" },
	{ "0.4.0.127.0.7.2.2.1.1", "bsiPK_DH" },
	{ "0.4.0.127.0.7.2.2.1.2", "bsiPK_ECDH" },
	{ "0.4.0.127.0.7.2.2.2", "bsiTA" },
	{ "0.4.0.127.0.7.2.2.2.1", "bsiTA_RSA" },
	{ "0.4.0.127.0.7.2.2.2.1.1", "bsiTA_RSAv1_5_SHA1" },
	{ "0.4.0.127.0.7.2.2.2.1.2", "bsiTA_RSAv1_5_SHA256" },
	{ "0.4.0.127.0.7.2.2.2.1.3", "bsiTA_RSAPSS_SHA1" },
	{ "0.4.0.127.0.7.2.2.2.1.4", "bsiTA_RSAPSS_SHA256" },
	{ "0.4.0.127.0.7.2.2.2.1.5", "bsiTA_RSAv1_5_SHA512" },
	{ "0.4.0.127.0.7.2.2.2.1.6", "bsiTA_RSAPSS_SHA512" },
	{ "0.4.0.127.0.7.2.2.2.2", "bsiTA_ECDSA" },
	{ "0.4.0.127.0.7.2.2.2.2.1", "bsiTA_ECDSA_SHA1" },
	{ "0.4.0.127.0.7.2.2.2.2.2", "bsiTA_ECDSA_SHA224" },
	{ "0.4.0.127.0.7.2.2.2.2.3", "bsiTA_ECDSA_SHA256" },
	{ "0.4.0.127.0.7.2.2.2.2.4", "bsiTA_ECDSA_SHA384" },
	{ "0.4.0.127.0.7.2.2.2.2.5", "bsiTA_ECDSA_SHA512" },
	{ "0.4.0.127.0.7.2.2.3", "bsiCA" },
	{ "0.4.0.127.0.7.2.2.3.1", "bsiCA_DH" },
	{ "0.4.0.127.0.7.2.2.3.1.1", "bsiCA_DH_3DES_CBC_CBC" },
	{ "0.4.0.127.0.7.2.2.3.1.2", "bsiCA_DH_AES_CBC_CMAC_128" },
	{ "0.4.0.127.0.7.2.2.3.1.3", "bsiCA_DH_AES_CBC_CMAC_192" },
	{ "0.4.0.127.0.7.2.2.3.1.4", "bsiCA_DH_AES_CBC_CMAC_256" },
	{ "0.4.0.127.0.7.2.2.3.2", "bsiCA_ECDH" },
	{ "0.4.0.127.0.7.2.2.3.2.1", "bsiCA_ECDH_3DES_CBC_CBC" },
	{ "0.4.0.127.0.7.2.2.3.2.2", "bsiCA_ECDH_AES_CBC_CMAC_128" },
	{ "0.4.0.127.0.7.2.2.3.2.3", "bsiCA_ECDH_AES_CBC_CMAC_192" },
	{ "0.4.0.127.0.7.2.2.3.2.4", "bsiCA_ECDH_AES_CBC_CMAC_256" },
	{ "0.4.0.127.0.7.2.2.4", "bsiPACE" },
	{ "0.4.0.127.0.7.2.2.4.1", "bsiPACE_DH_GM" },
	{ "0.4.0.127.0.7.2.2.4.1.1", "bsiPACE_DH_GM_3DES_CBC_CBC" },
	{ "0.4.0.127.0.7.2.2.4.1.2", "bsiPACE_DH_GM_AES_CBC_CMAC_128" },
	{ "0.4.0.127.0.7.2.2.4.1.3", "bsiPACE_DH_GM_AES_CBC_CMAC_192" },
	{ "0.4.0.127.0.7.2.2.4.1.4", "bsiPACE_DH_GM_AES_CBC_CMAC_256" },
	{ "0.4.0.127.0.7.2.2.4.2", "bsiPACE_ECDH_GM" },
	{ "0.4.0.127.0.7.2.2.4.2.1", "bsiPACE_ECDH_GM_3DES_CBC_CBC" },
	{ "0.4.0.127.0.7.2.2.4.2.2", "bsiPACE_ECDH_GM_AES_CBC_CMAC_128" },
	{ "0.4.0.127.0.7.2.2.4.2.3", "bsiPACE_ECDH_GM_AES_CBC_CMAC_192" },
	{ "0.4.0.127.0.7.2.2.4.2.4", "bsiPACE_ECDH_GM_AES_CBC_CMAC_256" },
	{ "0.4.0.127.0.7.2.2.4.3", "bsiPACE_DH_IM" },
	{ "0.4.0.127.0.7.2.2.4.3.1", "bsiPACE_DH_IM_3DES_CBC_CBC" },
	{ "0.4.0.127.0.7.2.2.4.3.2", "bsiPACE_DH_IM_AES_CBC_CMAC_128" },
	{ "0.4.0.127.0.7.2.2.4.3.3", "bsiPACE_DH_IM_AES_CBC_CMAC_192" },
	{ "0.4.0.127.0.7.2.2.4.3.4", "bsiPACE_DH_IM_AES_CBC_CMAC_256" },
	{ "0.4.0.127.0.7.2.2.4.4", "bsiPACE_ECDH_IM" },
	{ "0.4.0.127.0.7.2.2.4.4.1", "bsiPACE_ECDH_IM_3DES_CBC_CBC" },
	{ "0.4.0.127.0.7.2.2.4.4.2", "bsiPACE_ECDH_IM_AES_CBC_CMAC_128" },
	{ "0.4.0.127.0.7.2.2.4.4.3", "bsiPACE_ECDH_IM_AES_CBC_CMAC_192" },
	{ "0.4.0.127.0.7.2.2.4.4.4", "bsiPACE_ECDH_IM_AES_CBC_CMAC_256" },
	{ "0.4.0.127.0.7.2.2.5", "bsiRI" },
	{ "0.4.0.127.0.7.2.2.5.1", "bsiRI_DH" },
	{ "0.4.0.127.0.7.2.2.5.1.1", "bsiRI_DH_SHA1" },
	{ "0.4.0.127.0.7.2.2.5.1.2", "bsiRI_DH_SHA224" },
	{ "0.4.0.127.0.7.2.2.5.1.3", "bsiRI_DH_SHA256" },
	{ "0.4.0.127.0.7.2.2.5.1.4", "bsiRI_DH_SHA384" },
	{ "0.4.0.127.0.7.2.2.5.1.5", "bsiRI_DH_SHA512" },
	{ "0.4.0.127.0.7.2.2.5.2", "bsiRI_ECDH" },
	{ "0.4.0.127.0.7.2.2.5.2.1", "bsiRI_ECDH_SHA1" },
	{ "0.4.0.127.0.7.2.2.5.2.2", "bsiRI_ECDH_SHA224" },
	{ "0.4.0.127.0.7.2.2.5.2.3", "bsiRI_ECDH_SHA256" },
	{ "0.4.0.127.0.7.2.2.5.2.4", "bsiRI_ECDH_SHA384" },
	{ "0.4.0.127.0.7.2.2.5.2.5", "bsiRI_ECDH_SHA512" },
	{ "0.4.0.127.0.7.2.2.6", "bsiCardInfo" },
	{ "0.4.0.127.0.7.2.2.7", "bsiEidSecurity" },
	{ "0.4.0.127.0.7.2.2.8", "bsiPT" },
	{ "0.4.0.127.0.7.3.1.2", "bsiEACRoles" },
	{ "0.4.0.127.0.7.3.1.2.1", "bsiEACRolesIS" },
	{ "0.4.0.127.0.7.3.1.2.2", "bsiEACRolesAT" },
	{ "0.4.0.127.0.7.3.1.2.3", "bsiEACRolesST" },
	{ "0.4.0.127.0.7.3.1.3", "bsiTAv2ce" },
	{ "0.4.0.127.0.7.3.1.3.1", "bsiTAv2ceDescription" },
	{ "0.4.0.127.0.7.3.1.3.1.1", "bsiTAv2ceDescriptionPlainText" },
	{ "0.4.0.127.0.7.3.1.3.1.2", "bsiTAv2ceDescriptionIA5String" },
	{ "0.4.0.127.0.7.3.1.3.1.3", "bsiTAv2ceDescriptionOctetString" },
	{ "0.4.0.127.0.7.3.1.3.2", "bsiTAv2ceTerminalSector" },
	{ "0.4.0.127.0.7.3.1.4", "bsiAuxData" },
	{ "0.4.0.127.0.7.3.1.4.1", "bsiAuxDataBirthday" },
	{ "0.4.0.127.0.7.3.1.4.2", "bsiAuxDataExpireDate" },
	{ "0.4.0.127.0.7.3.1.4.3", "bsiAuxDataCommunityID" },
	{ "0.4.0.127.0.7.3.1.5", "bsiDefectList" },
	{ "0.4.0.127.0.7.3.1.5.1", "bsiDefectAuthDefect" },
	{ "0.4.0.127.0.7.3.1.5.1.1", "bsiDefectCertRevoked" },
	{ "0.4.0.127.0.7.3.1.5.1.2", "bsiDefectCertReplaced" },
	{ "0.4.0.127.0.7.3.1.5.1.3", "bsiDefectChipAuthKeyRevoked" },
	{ "0.4.0.127.0.7.3.1.5.1.4", "bsiDefectActiveAuthKeyRevoked" },
	{ "0.4.0.127.0.7.3.1.5.2", "bsiDefectEPassportDefect" },
	{ "0.4.0.127.0.7.3.1.5.2.1", "bsiDefectEPassportDGMalformed" },
	{ "0.4.0.127.0.7.3.1.5.2.2", "bsiDefectSODInvalid" },
	{ "0.4.0.127.0.7.3.1.5.3", "bsiDefectEIDDefect" },
	{ "0.4.0.127.0.7.3.1.5.3.1", "bsiDefectEIDDGMalformed" },
	{ "0.4.0.127.0.7.3.1.5.3.2", "bsiDefectEIDIntegrity" },
	{ "0.4.0.127.0.7.3.1.5.4", "bsiDefectDocumentDefect" },
	{ "0.4.0.127.0.7.3.1.5.4.1", "bsiDefectCardSecurityMalformed" },
	{ "0.4.0.127.0.7.3.1.5.4.2", "bsiDefectChipSecurityMalformed" },
	{ "0.4.0.127.0.7.3.1.5.4.3", "bsiDefectPowerDownReq" },
	{ "0.4.0.127.0.7.3.1.6", "bsiListContentDescription" },
	{ "0.4.0.127.0.7.3.2.1", "bsiSecurityObject" },
	{ "0.4.0.127.0.7.3.2.2", "bsiBlackList" },
	{ "0.4.0.1862", "etsiQcsProfile" },
	{ "0.4.0.1862.1", "etsiQcs" },
	{ "0.4.0.1862.1.1", "etsiQcsCompliance" },
	{ "0.4.0.1862.1.2", "etsiQcsLimitValue" },
	{ "0.4.0.1862.1.3", "etsiQcsRetentionPeriod" },
	{ "0.4.0.1862.1.4", "etsiQcsQcSSCD" },
	{ "0.9.2342.19200300.100.1.1", "userID" },
	{ "0.9.2342.19200300.100.1.25", "domainComponent" },
	{ "0.9.2342.19200300.100.1.3", "rfc822Mailbox" },
	{ "1.0.10118.3.0.49", "ripemd160" },
	{ "1.0.10118.3.0.50", "ripemd128" },
	{ "1.0.10118.3.0.55", "whirlpool" },
	{ "1.2.3.4.9999", "timeStamp" },
	{ "1.2.36.1.3.1.1.1", "qgpki" },
	{ "1.2.36.1.3.1.1.1.1", "qgpkiPolicies" },
	{ "1.2.36.1.3.1.1.1.1.1", "qgpkiMedIntermedCA" },
	{ "1.2.36.1.3.1.1.1.1.1.1", "qgpkiMedIntermedIndividual" },
	{ "1.2.36.1.3.1.1.1.1.1.2", "qgpkiMedIntermedDeviceControl" },
	{ "1.2.36.1.3.1.1.1.1.1.3", "qgpkiMedIntermedDevice" },
	{ "1.2.36.1.3.1.1.1.1.1.4", "qgpkiMedIntermedAuthorisedParty" },
	{ "1.2.36.1.3.1.1.1.1.1.5", "qgpkiMedIntermedDeviceSystem" },
	{ "1.2.36.1.3.1.1.1.1.2", "qgpkiMedIssuingCA" },
	{ "1.2.36.1.3.1.1.1.1.2.1", "qgpkiMedIssuingIndividual" },
	{ "1.2.36.1.3.1.1.1.1.2.2", "qgpkiMedIssuingDeviceControl" },
	{ "1.2.36.1.3.1.1.1.1.2.3", "qgpkiMedIssuingDevice" },
	{ "1.2.36.1.3.1.1.1.1.2.4", "qgpkiMedIssuingAuthorisedParty" },
	{ "1.2.36.1.3.1.1.1.1.2.5", "qgpkiMedIssuingClientAuth" },
	{ "1.2.36.1.3.1.1.1.1.2.6", "qgpkiMedIssuingServerAuth" },
	{ "1.2.36.1.3.1.1.1.1.2.7", "qgpkiMedIssuingDataProt" },
	{ "1.2.36.1.3.1.1.1.1.2.8", "qgpkiMedIssuingTokenAuth" },
	{ "1.2.36.1.3.1.1.1.1.3", "qgpkiBasicIntermedCA" },
	{ "1.2.36.1.3.1.1.1.1.3.1", "qgpkiBasicIntermedDeviceSystem" },
	{ "1.2.36.1.3.1.1.1.1.4", "qgpkiBasicIssuingCA" },
	{ "1.2.36.1.3.1.1.1.1.4.1", "qgpkiBasicIssuingClientAuth" },
	{ "1.2.36.1.3.1.1.1.1.4.2", "qgpkiBasicIssuingServerAuth" },
	{ "1.2.36.1.3.1.1.1.1.4.3", "qgpkiBasicIssuingDataSigning" },
	{ "1.2.36.1.3.1.1.1.2", "qgpkiAssuranceLevel" },
	{ "1.2.36.1.3.1.1.1.2.1", "qgpkiAssuranceRudimentary" },
	{ "1.2.36.1.3.1.1.1.2.2", "qgpkiAssuranceBasic" },
	{ "1.2.36.1.3.1.1.1.2.3", "qgpkiAssuranceMedium" },
	{ "1.2.36.1.3.1.1.1.2.4", "qgpkiAssuranceHigh" },
	{ "1.2.36.1.3.1.1.1.3", "qgpkiCertFunction" },
	{ "1.2.36.1.3.1.1.1.3.1", "qgpkiFunctionIndividual" },
	{ "1.2.36.1.3.1.1.1.3.2", "qgpkiFunctionDevice" },
	{ "1.2.36.1.3.1.1.1.3.3", "qgpkiFunctionAuthorisedParty" },
	{ "1.2.36.1.3.1.1.1.3.4", "qgpkiFunctionDeviceControl" },
	{ "1.2.36.1.3.1.2", "qpspki" },
	{ "1.2.36.1.3.1.2.1", "qpspkiPolicies" },
	{ "1.2.36.1.3.1.2.1.2", "qpspkiPolicyBasic" },
	{ "1.2.36.1.3.1.2.1.3", "qpspkiPolicyMedium" },
	{ "1.2.36.1.3.1.2.1.4", "qpspkiPolicyHigh" },
	{ "1.2.36.1.3.1.3.2", "qtmrpki" },
	{ "1.2.36.1.3.1.3.2.1", "qtmrpkiPolicies" },
	{ "1.2.36.1.3.1.3.2.2", "qtmrpkiPurpose" },
	{ "1.2.36.1.3.1.3.2.2.1", "qtmrpkiIndividual" },
	{ "1.2.36.1.3.1.3.2.2.2", "qtmrpkiDeviceControl" },
	{ "1.2.36.1.3.1.3.2.2.3", "qtmrpkiDevice" },
	{ "1.2.36.1.3.1.3.2.2.4", "qtmrpkiAuthorisedParty" },
	{ "1.2.36.1.3.1.3.2.2.5", "qtmrpkiDeviceSystem" },
	{ "1.2.36.1.3.1.3.2.3", "qtmrpkiDevice" },
	{ "1.2.36.1.3.1.3.2.3.1", "qtmrpkiDriverLicense" },
	{ "1.2.36.1.3.1.3.2.3.2", "qtmrpkiIndustryAuthority" },
	{ "1.2.36.1.3.1.3.2.3.3", "qtmrpkiMarineLicense" },
	{ "1.2.36.1.3.1.3.2.3.4", "qtmrpkiAdultProofOfAge" },
	{ "1.2.36.1.3.1.3.2.3.5", "qtmrpkiSam" },
	{ "1.2.36.1.3.1.3.2.4", "qtmrpkiAuthorisedParty" },
	{ "1.2.36.1.3.1.3.2.4.1", "qtmrpkiTransportInspector" },
	{ "1.2.36.1.3.1.3.2.4.2", "qtmrpkiPoliceOfficer" },
	{ "1.2.36.1.3.1.3.2.4.3", "qtmrpkiSystem" },
	{ "1.2.36.1.3.1.3.2.4.4", "qtmrpkiLiquorLicensingInspector" },
	{ "1.2.36.1.3.1.3.2.4.5", "qtmrpkiMarineEnforcementOfficer" },
	{ "1.2.36.1.333.1", "australianBusinessNumber" },
	{ "1.2.36.68980861.1.1.10", "signetPilot" },
	{ "1.2.36.68980861.1.1.11", "signetIntraNet" },
	{ "1.2.36.68980861.1.1.2", "signetPersonal" },
	{ "1.2.36.68980861.1.1.20", "signetPolicy" },
	{ "1.2.36.68980861.1.1.3", "signetBusiness" },
	{ "1.2.36.68980861.1.1.4", "signetLegal" },
	{ "1.2.36.75878867.1.100.1.1", "certificatesAustraliaPolicy" },
	{ "1.2.392.200011.61.1.1.1", "mitsubishiSecurityAlgorithm" },
	{ "1.2.392.200011.61.1.1.1.1", "misty1-cbc" },
	{ "1.2.410.200004.1", "kisaAlgorithm" },
	{ "1.2.410.200004.1.1", "kcdsa" },
	{ "1.2.410.200004.1.10", "pbeWithHAS160AndSEED-ECB" },
	{ "1.2.410.200004.1.11", "pbeWithHAS160AndSEED-CBC" },
	{ "1.2.410.200004.1.12", "pbeWithHAS160AndSEED-CFB" },
	{ "1.2.410.200004.1.13", "pbeWithHAS160AndSEED-OFB" },
	{ "1.2.410.200004.1.14", "pbeWithSHA1AndSEED-ECB" },
	{ "1.2.410.200004.1.15", "pbeWithSHA1AndSEED-CBC" },
	{ "1.2.410.200004.1.16", "pbeWithSHA1AndSEED-CFB" },
	{ "1.2.410.200004.1.17", "pbeWithSHA1AndSEED-OFB" },
	{ "1.2.410.200004.1.2", "has160" },
	{ "1.2.410.200004.1.20", "rsaWithHAS160" },
	{ "1.2.410.200004.1.21", "kcdsa1" },
	{ "1.2.410.200004.1.3", "seedECB" },
	{ "1.2.410.200004.1.4", "seedCBC" },
	{ "1.2.410.200004.1.5", "seedOFB" },
	{ "1.2.410.200004.1.6", "seedCFB" },
	{ "1.2.410.200004.1.7", "seedMAC" },
	{ "1.2.410.200004.1.8", "kcdsaWithHAS160" },
	{ "1.2.410.200004.1.9", "kcdsaWithSHA1" },
	{ "1.2.410.200004.10", "npki" },
	{ "1.2.410.200004.10.1", "npkiAttribute" },
	{ "1.2.410.200004.10.1.1", "npkiIdentifyData" },
	{ "1.2.410.200004.10.1.1.1", "npkiVID" },
	{ "1.2.410.200004.10.1.1.2", "npkiEncryptedVID" },
	{ "1.2.410.200004.10.1.1.3", "npkiRandomNum" },
	{ "1.2.410.200004.10.1.1.4", "npkiVID" },
	{ "1.2.410.200004.2", "npkiCP" },
	{ "1.2.410.200004.2.1", "npkiSignaturePolicy" },
	{ "1.2.410.200004.3", "npkiKP" },
	{ "1.2.410.200004.4", "npkiAT" },
	{ "1.2.410.200004.5", "npkiLCA" },
	{ "1.2.410.200004.5.1", "npkiSignKorea" },
	{ "1.2.410.200004.5.2", "npkiSignGate" },
	{ "1.2.410.200004.5.3", "npkiNcaSign" },
	{ "1.2.410.200004.6", "npkiON" },
	{ "1.2.410.200004.7", "npkiAPP" },
	{ "1.2.410.200004.7.1", "npkiSMIME" },
	{ "1.2.410.200004.7.1.1", "npkiSMIMEAlgo" },
	{ "1.2.410.200004.7.1.1.1", "npkiCmsSEEDWrap" },
	{ "1.2.410.200046.1.1", "aria1AlgorithmModes" },
	{ "1.2.410.200046.1.1.1", "aria128-ecb" },
	{ "1.2.410.200046.1.1.10", "aria192-ctr" },
	{ "1.2.410.200046.1.1.11", "aria256-ecb" },
	{ "1.2.410.200046.1.1.12", "aria256-cbc" },
	{ "1.2.410.200046.1.1.13", "aria256-cfb" },
	{ "1.2.410.200046.1.1.14", "aria256-ofb" },
	{ "1.2.410.200046.1.1.15", "aria256-ctr" },
	{ "1.2.410.200046.1.1.2", "aria128-cbc" },
	{ "1.2.410.200046.1.1.21", "aria128-cmac" },
	{ "1.2.410.200046.1.1.22", "aria192-cmac" },
	{ "1.2.410.200046.1.1.23", "aria256-cmac" },
	{ "1.2.410.200046.1.1.3", "aria128-cfb" },
	{ "1.2.410.200046.1.1.31", "aria128-ocb2" },
	{ "1.2.410.200046.1.1.32", "aria192-ocb2" },
	{ "1.2.410.200046.1.1.33", "aria256-ocb2" },
	{ "1.2.410.200046.1.1.34", "aria128-gcm" },
	{ "1.2.410.200046.1.1.35", "aria192-gcm" },
	{ "1.2.410.200046.1.1.36", "aria256-gcm" },
	{ "1.2.410.200046.1.1.37", "aria128-ccm" },
	{ "1.2.410.200046.1.1.38", "aria192-ccm" },
	{ "1.2.410.200046.1.1.39", "aria256-ccm" },
	{ "1.2.410.200046.1.1.4", "aria128-ofb" },
	{ "1.2.410.200046.1.1.40", "aria128-keywrap" },
	{ "1.2.410.200046.1.1.41", "aria192-keywrap" },
	{ "1.2.410.200046.1.1.42", "aria256-keywrap" },
	{ "1.2.410.200046.1.1.43", "aria128-keywrapWithPad" },
	{ "1.2.410.200046.1.1.44", "aria192-keywrapWithPad" },
	{ "1.2.410.200046.1.1.45", "aria256-keywrapWithPad" },
	{ "1.2.410.200046.1.1.5", "aria128-ctr" },
	{ "1.2.410.200046.1.1.6", "aria192-ecb" },
	{ "1.2.410.200046.1.1.7", "aria192-cbc" },
	{ "1.2.410.200046.1.1.8", "aria192-cfb" },
	{ "1.2.410.200046.1.1.9", "aria192-ofb" },
	{ "1.2.643.2.2.10", "hmacGost" },
	{ "1.2.643.2.2.13.0", "gostWrap" },
	{ "1.2.643.2.2.13.1", "cryptoProWrap" },
	{ "1.2.643.2.2.14.0", "nullMeshing" },
	{ "1.2.643.2.2.14.1", "cryptoProMeshing" },
	{ "1.2.643.2.2.19", "gostPublicKey" },
	{ "1.2.643.2.2.20", "gost94PublicKey" },
	{ "1.2.643.2.2.21", "gostCipher" },
	{ "1.2.643.2.2.3", "gostSignature" },
	{ "1.2.643.2.2.30.0", "testDigestParams" },
	{ "1.2.643.2.2.30.1", "cryptoProDigestA" },
	{ "1.2.643.2.2.31.0", "testCipherParams" },
	{ "1.2.643.2.2.31.1", "cryptoProCipherA" },
	{ "1.2.643.2.2.31.2", "cryptoProCipherB" },
	{ "1.2.643.2.2.31.3", "cryptoProCipherC" },
	{ "1.2.643.2.2.31.4", "cryptoProCipherD" },
	{ "1.2.643.2.2.31.5", "oscar11Cipher" },
	{ "1.2.643.2.2.31.6", "oscar10Cipher" },
	{ "1.2.643.2.2.31.7", "ric1Cipher" },
	{ "1.2.643.2.2.35.0", "testSignParams" },
	{ "1.2.643.2.2.35.1", "cryptoProSignA" },
	{ "1.2.643.2.2.35.2", "cryptoProSignB" },
	{ "1.2.643.2.2.35.3", "cryptoProSignC" },
	{ "1.2.643.2.2.36.0", "cryptoProSignXA" },
	{ "1.2.643.2.2.36.1", "cryptoProSignXB" },
	{ "1.2.643.2.2.4", "gost94Signature" },
	{ "1.2.643.2.2.9", "gostDigest" },
	{ "1.2.643.2.2.96", "cryptoProECDHWrap" },
	{ "1.2.752.34.1", "seis-cp" },
	{ "1.2.752.34.1.1", "SEIS.high-assurance.policyIdentifier" },
	{ "1.2.752.34.1.2", "SEIS.GAK.policyIdentifier" },
	{ "1.2.752.34.2", "SEIS.pe" },
	{ "1.2.752.34.3", "SEIS.at" },
	{ "1.2.752.34.3.1", "SEIS.at-personalIdentifier" },
	{ "1.2.840.10040.1", "module" },
	{ "1.2.840.10040.1.1", "x9f1-cert-mgmt" },
	{ "1.2.840.10040.2", "holdinstruction" },
	{ "1.2.840.10040.2.1", "holdinstruction-none" },
	{ "1.2.840.10040.2.2", "callissuer" },
	{ "1.2.840.10040.2.3", "reject" },
	{ "1.2.840.10040.2.4", "pickupToken" },
	{ "1.2.840.10040.3", "attribute" },
	{ "1.2.840.10040.3.1", "countersignature" },
	{ "1.2.840.10040.3.2", "attribute-cert" },
	{ "1.2.840.10040.4", "algorithm" },
	{ "1.2.840.10040.4.1", "dsa" },
	{ "1.2.840.10040.4.2", "dsa-match" },
	{ "1.2.840.10040.4.3", "dsaWithSha1" },
	{ "1.2.840.10045.1", "fieldType" },
	{ "1.2.840.10045.1.1", "prime-field" },
	{ "1.2.840.10045.1.2", "characteristic-two-field" },
	{ "1.2.840.10045.1.2.3", "characteristic-two-basis" },
	{ "1.2.840.10045.1.2.3.1", "onBasis" },
	{ "1.2.840.10045.1.2.3.2", "tpBasis" },
	{ "1.2.840.10045.1.2.3.3", "ppBasis" },
	{ "1.2.840.10045.2", "publicKeyType" },
	{ "1.2.840.10045.2.1", "ecPublicKey" },
	{ "1.2.840.10045.2.2", "ecPublicKeyRestricted" },
	{ "1.2.840.10045.3.0.1", "c2pnb163v1" },
	{ "1.2.840.10045.3.0.10", "c2pnb208w1" },
	{ "1.2.840.10045.3.0.11", "c2tnb239v1" },
	{ "1.2.840.10045.3.0.12", "c2tnb239v2" },
	{ "1.2.840.10045.3.0.13", "c2tnb239v3" },
	{ "1.2.840.10045.3.0.16", "c2pnb272w1" },
	{ "1.2.840.10045.3.0.18", "c2tnb359v1" },
	{ "1.2.840.10045.3.0.19", "c2pnb368w1" },
	{ "1.2.840.10045.3.0.2", "c2pnb163v2" },
	{ "1.2.840.10045.3.0.20", "c2tnb431r1" },
	{ "1.2.840.10045.3.0.3", "c2pnb163v3" },
	{ "1.2.840.10045.3.0.5", "c2tnb191v1" },
	{ "1.2.840.10045.3.0.6", "c2tnb191v2" },
	{ "1.2.840.10045.3.0.7", "c2tnb191v3" },
	{ "1.2.840.10045.3.1.1", "prime192v1" },
	{ "1.2.840.10045.3.1.2", "prime192v2" },
	{ "1.2.840.10045.3.1.3", "prime192v3" },
	{ "1.2.840.10045.3.1.4", "prime239v1" },
	{ "1.2.840.10045.3.1.5", "prime239v2" },
	{ "1.2.840.10045.3.1.6", "prime239v3" },
	{ "1.2.840.10045.3.1.7", "prime256v1" },
	{ "1.2.840.10045.4.1", "ecdsaWithSHA1" },
	{ "1.2.840.10045.4.2", "ecdsaWithRecommended" },
	{ "1.2.840.10045.4.3", "ecdsaWithSpecified" },
	{ "1.2.840.10045.4.3.1", "ecdsaWithSHA224" },
	{ "1.2.840.10045.4.3.2", "ecdsaWithSHA256" },
	{ "1.2.840.10045.4.3.3", "ecdsaWithSHA384" },
	{ "1.2.840.10045.4.3.4", "ecdsaWithSHA512" },
	{ "1.2.840.10046.1", "fieldType" },
	{ "1.2.840.10046.1.1", "gf-prime" },
	{ "1.2.840.10046.2", "numberType" },
	{ "1.2.840.10046.2.1", "dhPublicKey" },
	{ "1.2.840.10046.3", "scheme" },
	{ "1.2.840.10046.3.1", "dhStatic" },
	{ "1.2.840.10046.3.2", "dhEphem" },
	{ "1.2.840.10046.3.3", "dhHybrid1" },
	{ "1.2.840.10046.3.4", "dhHybrid2" },
	{ "1.2.840.10046.3.5", "mqv2" },
	{ "1.2.840.10046.3.6", "mqv1" },
	{ "1.2.840.10065.2.2", "?" },
	{ "1.2.840.10065.2.3", "healthcareLicense" },
	{ "1.2.840.10065.2.3.1.1", "license?" },
	{ "1.2.840.10070.", "iec62351" },
	{ "1.2.840.10070.8", "iec62351_8" },
	{ "1.2.840.10070.8.1", "iecUserRoles" },
	{ "1.2.840.113533.7", "nsn" },
	{ "1.2.840.113533.7.65", "nsn-ce" },
	{ "1.2.840.113533.7.65.0", "entrustVersInfo" },
	{ "1.2.840.113533.7.65.1", "clearance" },
	{ "1.2.840.113533.7.65.2", "noCRL" },
	{ "1.2.840.113533.7.66", "nsn-alg" },
	{ "1.2.840.113533.7.66.0", "cast40CBC" },
	{ "1.2.840.113533.7.66.1", "cast64CBC" },
	{ "1.2.840.113533.7.66.10", "cast5CBC" },
	{ "1.2.840.113533.7.66.11", "cast5MAC" },
	{ "1.2.840.113533.7.66.12", "pbeWithMD5AndCAST5-CBC" },
	{ "1.2.840.113533.7.66.13", "passwordBasedMac" },
	{ "1.2.840.113533.7.66.2", "cast64MAC" },
	{ "1.2.840.113533.7.66.3", "cast3CBC" },
	{ "1.2.840.113533.7.67", "nsn-oc" },
	{ "1.2.840.113533.7.67.0", "entrustUser" },
	{ "1.2.840.113533.7.67.1", "entrustCA" },
	{ "1.2.840.113533.7.68", "nsn-at" },
	{ "1.2.840.113533.7.68.0", "entrustCAInfo" },
	{ "1.2.840.113533.7.68.10", "attributeCertificate" },
	{ "1.2.840.113533.7.68.16", "entrustPwordPolicy" },
	{ "1.2.840.113533.7.68.29", "entrustUserRole" },
	{ "1.2.840.113533.7.77.0", "entrustRoleMap" },
	{ "1.2.840.113533.7.77.1", "entrustPasswordRules" },
	{ "1.2.840.113533.7.77.10", "entrustEncKeyType" },
	{ "1.2.840.113533.7.77.11", "entrustBusCtrlPolOids" },
	{ "1.2.840.113533.7.77.12", "entrustBusCtrlFlags" },
	{ "1.2.840.113533.7.77.13", "entrustPCertLifetime" },
	{ "1.2.840.113533.7.77.14", "entrustDNEncoding" },
	{ "1.2.840.113533.7.77.15", "entrustCertConsistencyChecking" },
	{ "1.2.840.113533.7.77.16", "entrustUserEncAlgm" },
	{ "1.2.840.113533.7.77.17", "entrustCRLGracePeriod" },
	{ "1.2.840.113533.7.77.18", "entrustSkipRLChecks" },
	{ "1.2.840.113533.7.77.19", "entrustHTTPProxySetting" },
	{ "1.2.840.113533.7.77.20", "entrustOfflineProfileUse" },
	{ "1.2.840.113533.7.77.21", "entrustAllowServerLogin" },
	{ "1.2.840.113533.7.77.22", "entrustEnforceIdentityUse" },
	{ "1.2.840.113533.7.77.23", "entrustAllowPKCS12Export" },
	{ "1.2.840.113533.7.77.24", "entrustPKCS12ExportMinimumHashCount" },
	{ "1.2.840.113533.7.77.25", "entrustClientNKeyType" },
	{ "1.2.840.113533.7.77.26", "entrustAllowed3rdPartySymmetricAlgms" },
	{ "1.2.840.113533.7.77.27", "entrustPreventManualAppRegistration" },
	{ "1.2.840.113533.7.77.28", "entrustPasswordMaxAttempts" },
	{ "1.2.840.113533.7.77.29", "entrustPasswordMinTime" },
	{ "1.2.840.113533.7.77.3", "entrustAllowedSymmetricAlgms" },
	{ "1.2.840.113533.7.77.30", "entrustPasswordMinSuspend" },
	{ "1.2.840.113533.7.77.31", "entrustAllowCAPIExport" },
	{ "1.2.840.113533.7.77.32", "entrustICEAdminPolicy" },
	{ "1.2.840.113533.7.77.33", "entrustEnableCacheUsage" },
	{ "1.2.840.113533.7.77.34", "entrustUserEncAlgm2" },
	{ "1.2.840.113533.7.77.35", "entrustSecureDeliveryServiceSMTP" },
	{ "1.2.840.113533.7.77.36", "entrustContentScannerServiceSMTP" },
	{ "1.2.840.113533.7.77.37", "entrustExpressSearchSourceOrder" },
	{ "1.2.840.113533.7.77.38", "entrustCAPIPolicy" },
	{ "1.2.840.113533.7.77.39", "entrustSearchbaseSearchOrder" },
	{ "1.2.840.113533.7.77.4", "entrustAllowedHashAlgms" },
	{ "1.2.840.113533.7.77.40", "entrustCRLGracePercentage" },
	{ "1.2.840.113533.7.77.49", "entrustPublicTokenCerts" },
	{ "1.2.840.113533.7.77.5", "entrustCSetFlags" },
	{ "1.2.840.113533.7.77.50", "entrustProtectKeyTransfer" },
	{ "1.2.840.113533.7.77.57", "entrustAllowTokenSpilloverFile" },
	{ "1.2.840.113533.7.77.58", "entrustMaximumTokenKeyHistory" },
	{ "1.2.840.113533.7.77.59", "entrustSelfRevokePolicy" },
	{ "1.2.840.113533.7.77.6", "entrustMessageOfTheDay" },
	{ "1.2.840.113533.7.77.60", "entrustAllowPSSwitch" },
	{ "1.2.840.113533.7.77.61", "entrustManagementClient" },
	{ "1.2.840.113533.7.77.62", "entrustForceOriginalCDPolicyCompliance" },
	{ "1.2.840.113533.7.77.63", "entrustAllExportable" },
	{ "1.2.840.113533.7.77.64", "entrustProtocolSymmetricEncAlgs" },
	{ "1.2.840.113533.7.77.65", "entrustProtocolSigningAlgs" },
	{ "1.2.840.113533.7.77.7", "entrustAttrName" },
	{ "1.2.840.113533.7.77.8", "entrustApplicationFlags" },
	{ "1.2.840.113533.7.77.9", "entrustSignKeyType" },
	{ "1.2.840.113549.1.1", "pkcs-1" },
	{ "1.2.840.113549.1.1.1", "rsaEncryption" },
	{ "1.2.840.113549.1.1.10", "rsaPSS" },
	{ "1.2.840.113549.1.1.11", "sha256WithRSAEncryption" },
	{ "1.2.840.113549.1.1.12", "sha384WithRSAEncryption" },
	{ "1.2.840.113549.1.1.13", "sha512WithRSAEncryption" },
	{ "1.2.840.113549.1.1.14", "sha224WithRSAEncryption" },
	{ "1.2.840.113549.1.1.2", "md2WithRSAEncryption" },
	{ "1.2.840.113549.1.1.3", "md4WithRSAEncryption" },
	{ "1.2.840.113549.1.1.4", "md5WithRSAEncryption" },
	{ "1.2.840.113549.1.1.5", "sha1WithRSAEncryption" },
	{ "1.2.840.113549.1.1.6", "rsaOAEPEncryptionSET" },
	{ "1.2.840.113549.1.1.7", "rsaOAEP" },
	{ "1.2.840.113549.1.1.8", "pkcs1-MGF" },
	{ "1.2.840.113549.1.1.9", "rsaOAEP-pSpecified" },
	{ "1.2.840.113549.1.12", "pkcs-12" },
	{ "1.2.840.113549.1.12.1", "pkcs-12-PbeIds" },
	{ "1.2.840.113549.1.12.1.1", "pbeWithSHAAnd128BitRC4" },
	{ "1.2.840.113549.1.12.1.2", "pbeWithSHAAnd40BitRC4" },
	{ "1.2.840.113549.1.12.1.3", "pbeWithSHAAnd3-KeyTripleDES-CBC" },
	{ "1.2.840.113549.1.12.1.4", "pbeWithSHAAnd2-KeyTripleDES-CBC" },
	{ "1.2.840.113549.1.12.1.5", "pbeWithSHAAnd128BitRC2-CBC" },
	{ "1.2.840.113549.1.12.1.6", "pbeWithSHAAnd40BitRC2-CBC" },
	{ "1.2.840.113549.1.12.10", "pkcs-12Version1" },
	{ "1.2.840.113549.1.12.10.1", "pkcs-12BadIds" },
	{ "1.2.840.113549.1.12.10.1.1", "pkcs-12-keyBag" },
	{ "1.2.840.113549.1.12.10.1.2", "pkcs-12-pkcs-8ShroudedKeyBag" },
	{ "1.2.840.113549.1.12.10.1.3", "pkcs-12-certBag" },
	{ "1.2.840.113549.1.12.10.1.4", "pkcs-12-crlBag" },
	{ "1.2.840.113549.1.12.10.1.5", "pkcs-12-secretBag" },
	{ "1.2.840.113549.1.12.10.1.6", "pkcs-12-safeContentsBag" },
	{ "1.2.840.113549.1.12.2", "pkcs-12-ESPVKID" },
	{ "1.2.840.113549.1.12.2.1", "pkcs-12-PKCS8KeyShrouding" },
	{ "1.2.840.113549.1.12.3", "pkcs-12-BagIds" },
	{ "1.2.840.113549.1.12.3.1", "pkcs-12-keyBagId" },
	{ "1.2.840.113549.1.12.3.2", "pkcs-12-certAndCRLBagId" },
	{ "1.2.840.113549.1.12.3.3", "pkcs-12-secretBagId" },
	{ "1.2.840.113549.1.12.3.4", "pkcs-12-safeContentsId" },
	{ "1.2.840.113549.1.12.3.5", "pkcs-12-pkcs-8ShroudedKeyBagId" },
	{ "1.2.840.113549.1.12.4", "pkcs-12-CertBagID" },
	{ "1.2.840.113549.1.12.4.1", "pkcs-12-X509CertCRLBagID" },
	{ "1.2.840.113549.1.12.4.2", "pkcs-12-SDSICertBagID" },
	{ "1.2.840.113549.1.12.5", "pkcs-12-OID" },
	{ "1.2.840.113549.1.12.5.1", "pkcs-12-PBEID" },
	{ "1.2.840.113549.1.12.5.1.1", "pkcs-12-PBEWithSha1And128BitRC4" },
	{ "1.2.840.113549.1.12.5.1.2", "pkcs-12-PBEWithSha1And40BitRC4" },
	{ "1.2.840.113549.1.12.5.1.3", "pkcs-12-PBEWithSha1AndTripleDESCBC" },
	{ "1.2.840.113549.1.12.5.1.4", "pkcs-12-PBEWithSha1And128BitRC2CBC" },
	{ "1.2.840.113549.1.12.5.1.5", "pkcs-12-PBEWithSha1And40BitRC2CBC" },
	{ "1.2.840.113549.1.12.5.1.6", "pkcs-12-PBEWithSha1AndRC4" },
	{ "1.2.840.113549.1.12.5.1.7", "pkcs-12-PBEWithSha1AndRC2CBC" },
	{ "1.2.840.113549.1.12.5.2", "pkcs-12-EnvelopingID" },
	{ "1.2.840.113549.1.12.5.2.1", "pkcs-12-RSAEncryptionWith128BitRC4" },
	{ "1.2.840.113549.1.12.5.2.2", "pkcs-12-RSAEncryptionWith40BitRC4" },
	{ "1.2.840.113549.1.12.5.2.3", "pkcs-12-RSAEncryptionWithTripleDES" },
	{ "1.2.840.113549.1.12.5.3", "pkcs-12-SignatureID" },
	{ "1.2.840.113549.1.12.5.3.1", "pkcs-12-RSASignatureWithSHA1Digest" },
	{ "1.2.840.113549.1.15.1", "pkcs15modules" },
	{ "1.2.840.113549.1.15.2", "pkcs15attributes" },
	{ "1.2.840.113549.1.15.3", "pkcs15contentType" },
	{ "1.2.840.113549.1.15.3.1", "pkcs15content" },
	{ "1.2.840.113549.1.2", "bsafeRsaEncr" },
	{ "1.2.840.113549.1.3", "pkcs-3" },
	{ "1.2.840.113549.1.3.1", "dhKeyAgreement" },
	{ "1.2.840.113549.1.5", "pkcs-5" },
	{ "1.2.840.113549.1.5.1", "pbeWithMD2AndDES-CBC" },
	{ "1.2.840.113549.1.5.10", "pbeWithSHAAndDES-CBC" },
	{ "1.2.840.113549.1.5.12", "pkcs5PBKDF2" },
	{ "1.2.840.113549.1.5.13", "pkcs5PBES2" },
	{ "1.2.840.113549.1.5.14", "pkcs5PBMAC1" },
	{ "1.2.840.113549.1.5.3", "pbeWithMD5AndDES-CBC" },
	{ "1.2.840.113549.1.5.4", "pbeWithMD2AndRC2-CBC" },
	{ "1.2.840.113549.1.5.6", "pbeWithMD5AndRC2-CBC" },
	{ "1.2.840.113549.1.5.9", "pbeWithMD5AndXOR" },
	{ "1.2.840.113549.1.7", "pkcs-7" },
	{ "1.2.840.113549.1.7.1", "pkcs-7-data" },
	{ "1.2.840.113549.1.7.2", "pkcs-7-signedData" },
	{ "1.2.840.113549.1.7.3", "pkcs-7-envelopedData" },
	{ "1.2.840.113549.1.7.4", "pkcs-7-signedAndEnvelopedData" },
	{ "1.2.840.113549.1.7.5", "pkcs-7-digestedData" },
	{ "1.2.840.113549.1.7.6", "pkcs-7-encryptedData" },
	{ "1.2.840.113549.1.7.7", "pkcs-7-dataWithAttributes" },
	{ "1.2.840.113549.1.7.8", "pkcs-7-encryptedPrivateKeyInfo" },
	{ "1.2.840.113549.1.9", "pkcs-9" },
	{ "1.2.840.113549.1.9.1", "emailAddress" },
	{ "1.2.840.113549.1.9.10", "issuerAndSerialNumber" },
	{ "1.2.840.113549.1.9.11", "passwordCheck" },
	{ "1.2.840.113549.1.9.12", "publicKey" },
	{ "1.2.840.113549.1.9.13", "signingDescription" },
	{ "1.2.840.113549.1.9.14", "extensionRequest" },
	{ "1.2.840.113549.1.9.15", "sMIMECapabilities" },
	{ "1.2.840.113549.1.9.15.1", "preferSignedData" },
	{ "1.2.840.113549.1.9.15.2", "canNotDecryptAny" },
	{ "1.2.840.113549.1.9.15.3", "receiptRequest" },
	{ "1.2.840.113549.1.9.15.4", "receipt" },
	{ "1.2.840.113549.1.9.15.5", "contentHints" },
	{ "1.2.840.113549.1.9.15.6", "mlExpansionHistory" },
	{ "1.2.840.113549.1.9.16", "id-sMIME" },
	{ "1.2.840.113549.1.9.16.0", "id-mod" },
	{ "1.2.840.113549.1.9.16.0.1", "id-mod-cms" },
	{ "1.2.840.113549.1.9.16.0.2", "id-mod-ess" },
	{ "1.2.840.113549.1.9.16.0.3", "id-mod-oid" },
	{ "1.2.840.113549.1.9.16.0.4", "id-mod-msg-v3" },
	{ "1.2.840.113549.1.9.16.0.5", "id-mod-ets-eSignature-88" },
	{ "1.2.840.113549.1.9.16.0.6", "id-mod-ets-eSignature-97" },
	{ "1.2.840.113549.1.9.16.0.7", "id-mod-ets-eSigPolicy-88" },
	{ "1.2.840.113549.1.9.16.0.8", "id-mod-ets-eSigPolicy-88" },
	{ "1.2.840.113549.1.9.16.1", "contentType" },
	{ "1.2.840.113549.1.9.16.1.1", "receipt" },
	{ "1.2.840.113549.1.9.16.1.10", "scvpCertValRequest" },
	{ "1.2.840.113549.1.9.16.1.11", "scvpCertValResponse" },
	{ "1.2.840.113549.1.9.16.1.12", "scvpValPolRequest" },
	{ "1.2.840.113549.1.9.16.1.13", "scvpValPolResponse" },
	{ "1.2.840.113549.1.9.16.1.14", "attrCertEncAttrs" },
	{ "1.2.840.113549.1.9.16.1.15", "tSReq" },
	{ "1.2.840.113549.1.9.16.1.16", "firmwarePackage" },
	{ "1.2.840.113549.1.9.16.1.17", "firmwareLoadReceipt" },
	{ "1.2.840.113549.1.9.16.1.18", "firmwareLoadError" },
	{ "1.2.840.113549.1.9.16.1.19", "contentCollection" },
	{ "1.2.840.113549.1.9.16.1.2", "authData" },
	{ "1.2.840.113549.1.9.16.1.20", "contentWithAttrs" },
	{ "1.2.840.113549.1.9.16.1.21", "encKeyWithID" },
	{ "1.2.840.113549.1.9.16.1.22", "encPEPSI" },
	{ "1.2.840.113549.1.9.16.1.23", "authEnvelopedData" },
	{ "1.2.840.113549.1.9.16.1.24", "routeOriginAttest" },
	{ "1.2.840.113549.1.9.16.1.25", "symmetricKeyPackage" },
	{ "1.2.840.113549.1.9.16.1.26", "rpkiManifest" },
	{ "1.2.840.113549.1.9.16.1.27", "asciiTextWithCRLF" },
	{ "1.2.840.113549.1.9.16.1.28", "xml" },
	{ "1.2.840.113549.1.9.16.1.29", "pdf" },
	{ "1.2.840.113549.1.9.16.1.3", "publishCert" },
	{ "1.2.840.113549.1.9.16.1.30", "postscript" },
	{ "1.2.840.113549.1.9.16.1.31", "timestampedData" },
	{ "1.2.840.113549.1.9.16.1.32", "asAdjacencyAttest" },
	{ "1.2.840.113549.1.9.16.1.33", "rpkiTrustAnchor" },
	{ "1.2.840.113549.1.9.16.1.34", "trustAnchorList" },
	{ "1.2.840.113549.1.9.16.1.4", "tSTInfo" },
	{ "1.2.840.113549.1.9.16.1.5", "tDTInfo" },
	{ "1.2.840.113549.1.9.16.1.6", "contentInfo" },
	{ "1.2.840.113549.1.9.16.1.7", "dVCSRequestData" },
	{ "1.2.840.113549.1.9.16.1.8", "dVCSResponseData" },
	{ "1.2.840.113549.1.9.16.1.9", "compressedData" },
	{ "1.2.840.113549.1.9.16.11", "capabilities" },
	{ "1.2.840.113549.1.9.16.11.1", "preferBinaryInside" },
	{ "1.2.840.113549.1.9.16.2", "authenticatedAttributes" },
	{ "1.2.840.113549.1.9.16.2.1", "receiptRequest" },
	{ "1.2.840.113549.1.9.16.2.10", "contentReference" },
	{ "1.2.840.113549.1.9.16.2.11", "encrypKeyPref" },
	{ "1.2.840.113549.1.9.16.2.12", "signingCertificate" },
	{ "1.2.840.113549.1.9.16.2.13", "smimeEncryptCerts" },
	{ "1.2.840.113549.1.9.16.2.14", "timeStampToken" },
	{ "1.2.840.113549.1.9.16.2.15", "sigPolicyId" },
	{ "1.2.840.113549.1.9.16.2.16", "commitmentType" },
	{ "1.2.840.113549.1.9.16.2.17", "signerLocation" },
	{ "1.2.840.113549.1.9.16.2.18", "signerAttr" },
	{ "1.2.840.113549.1.9.16.2.19", "otherSigCert" },
	{ "1.2.840.113549.1.9.16.2.2", "securityLabel" },
	{ "1.2.840.113549.1.9.16.2.20", "contentTimestamp" },
	{ "1.2.840.113549.1.9.16.2.21", "certificateRefs" },
	{ "1.2.840.113549.1.9.16.2.22", "revocationRefs" },
	{ "1.2.840.113549.1.9.16.2.23", "certValues" },
	{ "1.2.840.113549.1.9.16.2.24", "revocationValues" },
	{ "1.2.840.113549.1.9.16.2.25", "escTimeStamp" },
	{ "1.2.840.113549.1.9.16.2.26", "certCRLTimestamp" },
	{ "1.2.840.113549.1.9.16.2.27", "archiveTimeStamp" },
	{ "1.2.840.113549.1.9.16.2.28", "signatureType" },
	{ "1.2.840.113549.1.9.16.2.29", "dvcsDvc" },
	{ "1.2.840.113549.1.9.16.2.3", "mlExpandHistory" },
	{ "1.2.840.113549.1.9.16.2.30", "cekReference" },
	{ "1.2.840.113549.1.9.16.2.31", "maxCEKDecrypts" },
	{ "1.2.840.113549.1.9.16.2.32", "kekDerivationAlg" },
	{ "1.2.840.113549.1.9.16.2.33", "intendedRecipients" },
	{ "1.2.840.113549.1.9.16.2.34", "cmcUnsignedData" },
	{ "1.2.840.113549.1.9.16.2.35", "fwPackageID" },
	{ "1.2.840.113549.1.9.16.2.36", "fwTargetHardwareIDs" },
	{ "1.2.840.113549.1.9.16.2.37", "fwDecryptKeyID" },
	{ "1.2.840.113549.1.9.16.2.38", "fwImplCryptAlgs" },
	{ "1.2.840.113549.1.9.16.2.39", "fwWrappedFirmwareKey" },
	{ "1.2.840.113549.1.9.16.2.4", "contentHint" },
	{ "1.2.840.113549.1.9.16.2.40", "fwCommunityIdentifiers" },
	{ "1.2.840.113549.1.9.16.2.41", "fwPkgMessageDigest" },
	{ "1.2.840.113549.1.9.16.2.42", "fwPackageInfo" },
	{ "1.2.840.113549.1.9.16.2.43", "fwImplCompressAlgs" },
	{ "1.2.840.113549.1.9.16.2.44", "etsAttrCertificateRefs" },
	{ "1.2.840.113549.1.9.16.2.45", "etsAttrRevocationRefs" },
	{ "1.2.840.113549.1.9.16.2.46", "binarySigningTime" },
	{ "1.2.840.113549.1.9.16.2.47", "signingCertificateV2" },
	{ "1.2.840.113549.1.9.16.2.48", "etsArchiveTimeStampV2" },
	{ "1.2.840.113549.1.9.16.2.49", "erInternal" },
	{ "1.2.840.113549.1.9.16.2.5", "msgSigDigest" },
	{ "1.2.840.113549.1.9.16.2.50", "erExternal" },
	{ "1.2.840.113549.1.9.16.2.51", "multipleSignatures" },
	{ "1.2.840.113549.1.9.16.2.6", "encapContentType" },
	{ "1.2.840.113549.1.9.16.2.7", "contentIdentifier" },
	{ "1.2.840.113549.1.9.16.2.8", "macValue" },
	{ "1.2.840.113549.1.9.16.2.9", "equivalentLabels" },
	{ "1.2.840.113549.1.9.16.3.1", "esDHwith3DES" },
	{ "1.2.840.113549.1.9.16.3.10", "ssDH" },
	{ "1.2.840.113549.1.9.16.3.11", "hmacWith3DESwrap" },
	{ "1.2.840.113549.1.9.16.3.12", "hmacWithAESwrap" },
	{ "1.2.840.113549.1.9.16.3.13", "md5XorExperiment" },
	{ "1.2.840.113549.1.9.16.3.14", "rsaKEM" },
	{ "1.2.840.113549.1.9.16.3.15", "authEnc128" },
	{ "1.2.840.113549.1.9.16.3.16", "authEnc256" },
	{ "1.2.840.113549.1.9.16.3.2", "esDHwithRC2" },
	{ "1.2.840.113549.1.9.16.3.3", "3desWrap" },
	{ "1.2.840.113549.1.9.16.3.4", "rc2Wrap" },
	{ "1.2.840.113549.1.9.16.3.5", "esDH" },
	{ "1.2.840.113549.1.9.16.3.6", "cms3DESwrap" },
	{ "1.2.840.113549.1.9.16.3.7", "cmsRC2wrap" },
	{ "1.2.840.113549.1.9.16.3.8", "zlib" },
	{ "1.2.840.113549.1.9.16.3.9", "pwriKEK" },
	{ "1.2.840.113549.1.9.16.4.1", "certDist-ldap" },
	{ "1.2.840.113549.1.9.16.5.1", "sigPolicyQualifier-spuri.x" },
	{ "1.2.840.113549.1.9.16.5.2", "sigPolicyQualifier-spUserNotice" },
	{ "1.2.840.113549.1.9.16.6.1", "proofOfOrigin" },
	{ "1.2.840.113549.1.9.16.6.2", "proofOfReceipt" },
	{ "1.2.840.113549.1.9.16.6.3", "proofOfDelivery" },
	{ "1.2.840.113549.1.9.16.6.4", "proofOfSender" },
	{ "1.2.840.113549.1.9.16.6.5", "proofOfApproval" },
	{ "1.2.840.113549.1.9.16.6.6", "proofOfCreation" },
	{ "1.2.840.113549.1.9.16.8.1", "glUseKEK" },
	{ "1.2.840.113549.1.9.16.8.10", "glFailInfo" },
	{ "1.2.840.113549.1.9.16.8.11", "glaQueryRequest" },
	{ "1.2.840.113549.1.9.16.8.12", "glaQueryResponse" },
	{ "1.2.840.113549.1.9.16.8.13", "glProvideCert" },
	{ "1.2.840.113549.1.9.16.8.14", "glUpdateCert" },
	{ "1.2.840.113549.1.9.16.8.15", "glKey" },
	{ "1.2.840.113549.1.9.16.8.2", "glDelete" },
	{ "1.2.840.113549.1.9.16.8.3", "glAddMember" },
	{ "1.2.840.113549.1.9.16.8.4", "glDeleteMember" },
	{ "1.2.840.113549.1.9.16.8.5", "glRekey" },
	{ "1.2.840.113549.1.9.16.8.6", "glAddOwner" },
	{ "1.2.840.113549.1.9.16.8.7", "glRemoveOwner" },
	{ "1.2.840.113549.1.9.16.8.8", "glkCompromise" },
	{ "1.2.840.113549.1.9.16.8.9", "glkRefresh" },
	{ "1.2.840.113549.1.9.16.9", "signatureTypeIdentifier" },
	{ "1.2.840.113549.1.9.16.9.1", "originatorSig" },
	{ "1.2.840.113549.1.9.16.9.2", "domainSig" },
	{ "1.2.840.113549.1.9.16.9.3", "additionalAttributesSig" },
	{ "1.2.840.113549.1.9.16.9.4", "reviewSig" },
	{ "1.2.840.113549.1.9.2", "unstructuredName" },
	{ "1.2.840.113549.1.9.20", "friendlyName.(for.PKCS.#12)" },
	{ "1.2.840.113549.1.9.21", "localKeyID.(for.PKCS.#12)" },
	{ "1.2.840.113549.1.9.22", "certTypes.(for.PKCS.#12)" },
	{ "1.2.840.113549.1.9.22.1", "x509Certificate.(for.PKCS.#12)" },
	{ "1.2.840.113549.1.9.22.2", "sdsiCertificate.(for.PKCS.#12)" },
	{ "1.2.840.113549.1.9.23", "crlTypes.(for.PKCS.#12)" },
	{ "1.2.840.113549.1.9.23.1", "x509Crl.(for.PKCS.#12)" },
	{ "1.2.840.113549.1.9.24", "pkcs9objectClass" },
	{ "1.2.840.113549.1.9.25", "pkcs9attributes" },
	{ "1.2.840.113549.1.9.25.1", "pkcs15Token" },
	{ "1.2.840.113549.1.9.25.2", "encryptedPrivateKeyInfo" },
	{ "1.2.840.113549.1.9.25.3", "randomNonce" },
	{ "1.2.840.113549.1.9.25.4", "sequenceNumber" },
	{ "1.2.840.113549.1.9.25.5", "pkcs7PDU" },
	{ "1.2.840.113549.1.9.26", "pkcs9syntax" },
	{ "1.2.840.113549.1.9.27", "pkcs9matchingRules" },
	{ "1.2.840.113549.1.9.3", "contentType" },
	{ "1.2.840.113549.1.9.4", "messageDigest" },
	{ "1.2.840.113549.1.9.5", "signingTime" },
	{ "1.2.840.113549.1.9.6", "countersignature" },
	{ "1.2.840.113549.1.9.7", "challengePassword" },
	{ "1.2.840.113549.1.9.8", "unstructuredAddress" },
	{ "1.2.840.113549.1.9.9", "extendedCertificateAttributes" },
	{ "1.2.840.113549.2", "digestAlgorithm" },
	{ "1.2.840.113549.2.10", "hmacWithSHA384" },
	{ "1.2.840.113549.2.11", "hmacWithSHA512" },
	{ "1.2.840.113549.2.2", "md2" },
	{ "1.2.840.113549.2.4", "md4" },
	{ "1.2.840.113549.2.5", "md5" },
	{ "1.2.840.113549.2.7", "hmacWithSHA1" },
	{ "1.2.840.113549.2.8", "hmacWithSHA224" },
	{ "1.2.840.113549.2.9", "hmacWithSHA256" },
	{ "1.2.840.113549.3", "encryptionAlgorithm" },
	{ "1.2.840.113549.3.10", "desCDMF" },
	{ "1.2.840.113549.3.2", "rc2CBC" },
	{ "1.2.840.113549.3.3", "rc2ECB" },
	{ "1.2.840.113549.3.4", "rc4" },
	{ "1.2.840.113549.3.5", "rc4WithMAC" },
	{ "1.2.840.113549.3.6", "desx-CBC" },
	{ "1.2.840.113549.3.7", "des-EDE3-CBC" },
	{ "1.2.840.113549.3.8", "rc5CBC" },
	{ "1.2.840.113549.3.9", "rc5-CBCPad" },
	{ "1.2.840.113556.1.2.241", "deliveryMechanism" },
	{ "1.2.840.113556.1.2.281", "ntSecurityDescriptor" },
	{ "1.2.840.113556.1.3.0", "site-Addressing" },
	{ "1.2.840.113556.1.3.13", "classSchema" },
	{ "1.2.840.113556.1.3.14", "attributeSchema" },
	{ "1.2.840.113556.1.3.17", "mailbox-Agent" },
	{ "1.2.840.113556.1.3.22", "mailbox" },
	{ "1.2.840.113556.1.3.23", "container" },
	{ "1.2.840.113556.1.3.46", "mailRecipient" },
	{ "1.2.840.113556.1.4.1327", "pKIDefaultKeySpec" },
	{ "1.2.840.113556.1.4.1328", "pKIKeyUsage" },
	{ "1.2.840.113556.1.4.1329", "pKIMaxIssuingDepth" },
	{ "1.2.840.113556.1.4.1330", "pKICriticalExtensions" },
	{ "1.2.840.113556.1.4.1331", "pKIExpirationPeriod" },
	{ "1.2.840.113556.1.4.1332", "pKIOverlapPeriod" },
	{ "1.2.840.113556.1.4.1333", "pKIExtendedKeyUsage" },
	{ "1.2.840.113556.1.4.1334", "pKIDefaultCSPs" },
	{ "1.2.840.113556.1.4.1335", "pKIEnrollmentAccess" },
	{ "1.2.840.113556.1.4.1429", "msPKI-RA-Signature" },
	{ "1.2.840.113556.1.4.1430", "msPKI-Enrollment-Flag" },
	{ "1.2.840.113556.1.4.1431", "msPKI-Private-Key-Flag" },
	{ "1.2.840.113556.1.4.1432", "msPKI-Certificate-Name-Flag" },
	{ "1.2.840.113556.1.4.1433", "msPKI-Minimal-Key-Size" },
	{ "1.2.840.113556.1.4.1434", "msPKI-Template-Schema-Version" },
	{ "1.2.840.113556.1.4.1435", "msPKI-Template-Minor-Revision" },
	{ "1.2.840.113556.1.4.1436", "msPKI-Cert-Template-OID" },
	{ "1.2.840.113556.1.4.1437", "msPKI-Supersede-Templates" },
	{ "1.2.840.113556.1.4.1438", "msPKI-RA-Policies" },
	{ "1.2.840.113556.1.4.1439", "msPKI-Certificate-Policy" },
	{ "1.2.840.113556.1.4.145", "revision" },
	{ "1.2.840.113556.1.4.1674", "msPKI-Certificate-Application-Policy" },
	{ "1.2.840.113556.1.4.1675", "msPKI-RA-Application-Policies" },
	{ "1.2.840.113556.4.3", "microsoftExcel" },
	{ "1.2.840.113556.4.4", "titledWithOID" },
	{ "1.2.840.113556.4.5", "microsoftPowerPoint" },
	{ "1.2.840.113583.1", "adobeAcrobat" },
	{ "1.2.840.113583.1.1", "acrobatSecurity" },
	{ "1.2.840.113583.1.1.1", "pdfPassword" },
	{ "1.2.840.113583.1.1.10", "pdfPPLKLiteCredential" },
	{ "1.2.840.113583.1.1.2", "pdfDefaultSigningCredential" },
	{ "1.2.840.113583.1.1.3", "pdfDefaultEncryptionCredential" },
	{ "1.2.840.113583.1.1.4", "pdfPasswordTimeout" },
	{ "1.2.840.113583.1.1.5", "pdfAuthenticDocumentsTrust" },
	{ "1.2.840.113583.1.1.6", "pdfDynamicContentTrust" },
	{ "1.2.840.113583.1.1.7", "pdfUbiquityTrust" },
	{ "1.2.840.113583.1.1.8", "pdfRevocationInfoArchival" },
	{ "1.2.840.113583.1.1.9", "pdfX509Extension" },
	{ "1.2.840.113583.1.1.9.1", "pdfTimeStamp" },
	{ "1.2.840.113583.1.1.9.2", "pdfArchiveRevInfo" },
	{ "1.2.840.113583.1.2.", "acrobatCPS" },
	{ "1.2.840.113583.1.2.1", "pdfAuthenticDocumentsCPS" },
	{ "1.2.840.113583.1.2.2", "pdfTestCPS" },
	{ "1.2.840.113583.1.2.3", "pdfUbiquityCPS" },
	{ "1.2.840.113583.1.2.4", "pdfAdhocCPS" },
	{ "1.2.840.113583.1.7", "acrobatUbiquity" },
	{ "1.2.840.113583.1.7.1", "pdfUbiquitySubRights" },
	{ "1.2.840.113583.1.9", "acrobatExtension" },
	{ "1.2.840.113628.114.1.7", "adobePKCS7" },
	{ "1.2.840.113635.100", "appleDataSecurity" },
	{ "1.2.840.113635.100.1", "appleTrustPolicy" },
	{ "1.2.840.113635.100.1.1", "appleISignTP" },
	{ "1.2.840.113635.100.1.10", "appleSWUpdateSigningPolicy" },
	{ "1.2.840.113635.100.1.11", "appleIPSecPolicy" },
	{ "1.2.840.113635.100.1.12", "appleIChatPolicy" },
	{ "1.2.840.113635.100.1.13", "appleResourceSignPolicy" },
	{ "1.2.840.113635.100.1.14", "applePKINITClientPolicy" },
	{ "1.2.840.113635.100.1.15", "applePKINITServerPolicy" },
	{ "1.2.840.113635.100.1.16", "appleCodeSigningPolicy" },
	{ "1.2.840.113635.100.1.17", "applePackageSigningPolicy" },
	{ "1.2.840.113635.100.1.2", "appleX509Basic" },
	{ "1.2.840.113635.100.1.3", "appleSSLPolicy" },
	{ "1.2.840.113635.100.1.4", "appleLocalCertGenPolicy" },
	{ "1.2.840.113635.100.1.5", "appleCSRGenPolicy" },
	{ "1.2.840.113635.100.1.6", "appleCRLPolicy" },
	{ "1.2.840.113635.100.1.7", "appleOCSPPolicy" },
	{ "1.2.840.113635.100.1.8", "appleSMIMEPolicy" },
	{ "1.2.840.113635.100.1.9", "appleEAPPolicy" },
	{ "1.2.840.113635.100.2", "appleSecurityAlgorithm" },
	{ "1.2.840.113635.100.2.1", "appleFEE" },
	{ "1.2.840.113635.100.2.2", "appleASC" },
	{ "1.2.840.113635.100.2.3", "appleFEE_MD5" },
	{ "1.2.840.113635.100.2.4", "appleFEE_SHA1" },
	{ "1.2.840.113635.100.2.5", "appleFEED" },
	{ "1.2.840.113635.100.2.6", "appleFEEDEXP" },
	{ "1.2.840.113635.100.2.7", "appleECDSA" },
	{ "1.2.840.113635.100.3", "appleDotMacCertificate" },
	{ "1.2.840.113635.100.3.1", "appleDotMacCertificateRequest" },
	{ "1.2.840.113635.100.3.2", "appleDotMacCertificateExtension" },
	{ "1.2.840.113635.100.3.2.1", "appleDotMacCertificateExtensionIdentity" },
	{ "1.2.840.113635.100.3.2.2", "appleDotMacCertificateExtensionEmailSign" },
	{ "1.2.840.113635.100.3.2.3", "appleDotMacCertificateExtensionEmailEncrypt" },
	{ "1.2.840.113635.100.3.3", "appleDotMacCertificateRequestValues" },
	{ "1.2.840.113635.100.4", "appleExtendedKeyUsage" },
	{ "1.2.840.113635.100.4.1", "appleCodeSigning" },
	{ "1.2.840.113635.100.4.1.1", "appleCodeSigningDevelopment" },
	{ "1.2.840.113635.100.4.1.2", "appleSoftwareUpdateSigning" },
	{ "1.2.840.113635.100.4.1.3", "appleCodeSigningThirdParty" },
	{ "1.2.840.113635.100.4.1.4", "appleResourceSigning" },
	{ "1.2.840.113635.100.4.10", "appleMacAppStoreInstallerPackageSigning" },
	{ "1.2.840.113635.100.4.11", "appleExtensionProvisioningProfileSigning" },
	{ "1.2.840.113635.100.4.13", "appleDeveloperIdInstaller" },
	{ "1.2.840.113635.100.4.14", "appleEkuPassbookSigning" },
	{ "1.2.840.113635.100.4.15", "appleExtendedKeyUsage_15" }, // unknown but defined in Apple_WWDR_CPS_v1.14.pdf
	{ "1.2.840.113635.100.4.16", "appleEkuProfileSigning" },
	{ "1.2.840.113635.100.4.17", "appleEkuQaProfileSigning" },
	{ "1.2.840.113635.100.4.2", "appleIChatSigning" },
	{ "1.2.840.113635.100.4.3", "appleIChatEncryption" },
	{ "1.2.840.113635.100.4.4", "appleSystemIdentity" },
	{ "1.2.840.113635.100.4.5", "appleCryptoEnv" },
	{ "1.2.840.113635.100.4.5.1", "appleCryptoProductionEnv" },
	{ "1.2.840.113635.100.4.5.2", "appleCryptoMaintenanceEnv" },
	{ "1.2.840.113635.100.4.5.3", "appleCryptoTestEnv" },
	{ "1.2.840.113635.100.4.5.4", "appleCryptoDevelopmentEnv" },
	{ "1.2.840.113635.100.4.6", "appleCryptoQoS" },
	{ "1.2.840.113635.100.4.6.1", "appleCryptoTier0QoS" },
	{ "1.2.840.113635.100.4.6.2", "appleCryptoTier1QoS" },
	{ "1.2.840.113635.100.4.6.3", "appleCryptoTier2QoS" },
	{ "1.2.840.113635.100.4.6.4", "appleCryptoTier3QoS" },
	{ "1.2.840.113635.100.4.7.0", "appleExtensionAppleIdSharing" },
	{ "1.2.840.113635.100.4.8", "appleSafariExtensionSigning" },
	{ "1.2.840.113635.100.4.9", "appleThirdPartyMacDeveloperInstaller" },
	{ "1.2.840.113635.100.5", "appleCertificatePolicies" },
	{ "1.2.840.113635.100.5.1", "appleCertificatePolicyID" },
	{ "1.2.840.113635.100.5.12", "appleMobileStoreSigningPolicy" },
	{ "1.2.840.113635.100.5.12.1", "appleTestMobileStoreSigningPolicy" },
	{ "1.2.840.113635.100.5.2", "appleDotMacCertificatePolicyID" },
	{ "1.2.840.113635.100.5.3", "appleADCCertificatePolicyID" },
	{ "1.2.840.113635.100.5.6", "appleMacAppStoreCertPolicy" },
	{ "1.2.840.113635.100.5.6.1", "appleMacAppStoreReceiptCertPolicy" },
	{ "1.2.840.113635.100.5.7", "appleAppleIdCertPolicy" },
	{ "1.2.840.113635.100.5.7.1", "appleAppleIdSharingCertPolicy" },
	{ "1.2.840.113635.100.6", "appleCertificateExtensions" },
	{ "1.2.840.113635.100.6.1", "appleCertificateExtensionCodeSigning" },
	{ "1.2.840.113635.100.6.1.1", "appleCertificateExtensionAppleSigning" },
	{ "1.2.840.113635.100.6.1.10", "appleMacAppStoreInstallerSigning" },
	{ "1.2.840.113635.100.6.1.11", "appleMacAppStoreReceipt" },
	{ "1.2.840.113635.100.6.1.12", "appleMacAppStoreDevSigning" },
	{ "1.2.840.113635.100.6.1.13", "appleDeveloperIdApplication" },
	{ "1.2.840.113635.100.6.1.14", "appleDeveloperIdInstaller" },
	{ "1.2.840.113635.100.6.1.16", "applePayPassbookSigning" },
	{ "1.2.840.113635.100.6.1.17", "appleWebsitePushNotificationSigning" },
	{ "1.2.840.113635.100.6.1.18", "appleDeveloperIdKernel" },
	{ "1.2.840.113635.100.6.1.2", "appleIPhoneSoftwareDevelopmentSigning" },
	{ "1.2.840.113635.100.6.1.2.0", "appleCertificateExtensionADCDeveloperSigning" },
	{ "1.2.840.113635.100.6.1.2.0.0", "appleCertificateExtensionADCAppleSigning" },
	{ "1.2.840.113635.100.6.1.25.1", "appleTestFlight" },
	{ "1.2.840.113635.100.6.1.25.2", "appleInternalRelease" },
	{ "1.2.840.113635.100.6.1.26", "appleCertificateExtensionCodeSigning_26" }, // unknown but defined in Apple_WWDR_CPS_v1.14.pdf
	{ "1.2.840.113635.100.6.1.30", "appleDeveloperIDTicket" },
	{ "1.2.840.113635.100.6.1.3", "appleCertificateExtensionADCAppleSigning" },
	{ "1.2.840.113635.100.6.1.33", "appleDeveloperIdDate" },
	{ "1.2.840.113635.100.6.1.4", "appleIPhoneSoftwareSubmissionSigning" },
	{ "1.2.840.113635.100.6.1.5", "appleSafariExtensionSigningDeveloper" },
	{ "1.2.840.113635.100.6.1.6", "appleIPhoneOsVpnSigning" },
	{ "1.2.840.113635.100.6.1.7", "appleMacAppSigningDevelopment" },
	{ "1.2.840.113635.100.6.1.8", "appleMacAppSigningSubmission" },
	{ "1.2.840.113635.100.6.1.9", "appleMacAppStoreCodeSigning" },
	{ "1.2.840.113635.100.6.11.1", "appleExtensionMacAppStoreReceipt" },
	{ "1.2.840.113635.100.6.2", "appleExtensionIntermediateMarker" },
	{ "1.2.840.113635.100.6.2.1", "appleExtensionWwdrIntermediate" },
	{ "1.2.840.113635.100.6.2.1", "appleWorldwideDeveloperRelations" },
	{ "1.2.840.113635.100.6.2.10", "appleExtensionSysint2Intermediate" },
	{ "1.2.840.113635.100.6.2.11", "appleDeveloperAuthentication" },
	{ "1.2.840.113635.100.6.2.11", "appleExtensionDeveloperAuthentication" },
	{ "1.2.840.113635.100.6.2.12", "appleExtensionServerAuthentication" },
	{ "1.2.840.113635.100.6.2.14", "appleApplicationIntegrationG3" },
	{ "1.2.840.113635.100.6.2.15", "appleWorldwideDeveloperRelationsG2" },
	{ "1.2.840.113635.100.6.2.19", "appleSoftwareUpdateCertification" },
	{ "1.2.840.113635.100.6.2.2", "appleExtensionItmsIntermediate" },
	{ "1.2.840.113635.100.6.2.3", "appleApplicationIntegration" },
	{ "1.2.840.113635.100.6.2.6", "appleDeveloperId" },
	{ "1.2.840.113635.100.6.2.7", "appleExtensionAppleIdIntermediate" },
	{ "1.2.840.113635.100.6.2.9", "appleTimestamp" },
	{ "1.2.840.113635.100.6.21", "appleCertificateExtensions_21" }, // unknown but defined in Apple_WWDR_CPS_v1.14.pdf
	{ "1.2.840.113635.100.6.22", "appleExtensionSoftwareSigning" },
	{ "1.2.840.113635.100.6.23.1.0", "appleExtensionEscrowService" },
	{ "1.2.840.113635.100.6.3.1", "applePushNotificationServiceDevelopment" },
	{ "1.2.840.113635.100.6.3.2", "applePushNotificationServiceProduction" },
	{ "1.2.840.113635.100.6.3.3", "applePushNotificationServiceBundleId" },
	{ "1.2.840.113635.100.6.3.4", "applePushNotificationServiceVoIPTopics" },
	{ "1.2.840.113635.100.6.3.5", "applePushNotificationServiceVoIP" },
	{ "1.2.840.113635.100.6.3.6", "applePushNotificationServiceTopics" },
	{ "1.2.840.113635.100.6.32", "appleMerchantIdHash" },
	{ "1.2.840.113635.100.6.39", "applePayIssuerEncryptionPolicy" },
	{ "1.2.840.113635.100.6.46", "applePayNotOnlyChina" },
	{ "1.2.840.114021.1.6.1", "Identrus.unknown.policyIdentifier" },
	{ "1.2.840.114021.4.1", "identrusOCSP" },
	{ "1.3.101.1.4", "thawte-ce" },
	{ "1.3.101.1.4.1", "strongExtranet" },
	{ "1.3.101.110", "x25519" },
	{ "1.3.101.111", "x448" },
	{ "1.3.101.112", "ed25519" },
	{ "1.3.101.113", "ed448" },
	{ "1.3.101.114", "edDSA25519ph" },
	{ "1.3.101.115", "edDSA448ph" },
	{ "1.3.12.2.1011.7.1", "decEncryptionAlgorithm" },
	{ "1.3.12.2.1011.7.1.2", "decDEA" },
	{ "1.3.12.2.1011.7.2", "decHashAlgorithm" },
	{ "1.3.12.2.1011.7.2.1", "decMD2" },
	{ "1.3.12.2.1011.7.2.2", "decMD4" },
	{ "1.3.12.2.1011.7.3", "decSignatureAlgorithm" },
	{ "1.3.12.2.1011.7.3.1", "decMD2withRSA" },
	{ "1.3.12.2.1011.7.3.2", "decMD4withRSA" },
	{ "1.3.12.2.1011.7.3.3", "decDEAMAC" },
	{ "1.3.132.0.1", "sect163k1" },
	{ "1.3.132.0.10", "secp256k1" },
	{ "1.3.132.0.15", "sect163r2" },
	{ "1.3.132.0.16", "sect283k1" },
	{ "1.3.132.0.17", "sect283r1" },
	{ "1.3.132.0.2", "sect163r1" },
	{ "1.3.132.0.22", "sect131r1" },
	{ "1.3.132.0.23", "sect131r2" },
	{ "1.3.132.0.24", "sect193r1" },
	{ "1.3.132.0.25", "sect193r2" },
	{ "1.3.132.0.26", "sect233k1" },
	{ "1.3.132.0.27", "sect233r1" },
	{ "1.3.132.0.28", "secp128r1" },
	{ "1.3.132.0.29", "secp128r2" },
	{ "1.3.132.0.3", "sect239k1" },
	{ "1.3.132.0.30", "secp160r2" },
	{ "1.3.132.0.31", "secp192k1" },
	{ "1.3.132.0.32", "secp224k1" },
	{ "1.3.132.0.33", "secp224r1" },
	{ "1.3.132.0.34", "secp384r1" },
	{ "1.3.132.0.35", "secp521r1" },
	{ "1.3.132.0.36", "sect409k1" },
	{ "1.3.132.0.37", "sect409r1" },
	{ "1.3.132.0.38", "sect571k1" },
	{ "1.3.132.0.39", "sect571r1" },
	{ "1.3.132.0.4", "sect113r1" },
	{ "1.3.132.0.5", "sect113r2" },
	{ "1.3.132.0.6", "secp112r1" },
	{ "1.3.132.0.7", "secp112r2" },
	{ "1.3.132.0.8", "secp160r1" },
	{ "1.3.132.0.9", "secp160k1" },
	{ "1.3.132.1.11.0", "dhSinglePass-stdDH-sha224kdf-scheme" },
	{ "1.3.132.1.11.1", "dhSinglePass-stdDH-sha256kdf-scheme" },
	{ "1.3.132.1.11.2", "dhSinglePass-stdDH-sha384kdf-scheme" },
	{ "1.3.132.1.11.3", "dhSinglePass-stdDH-sha512kdf-scheme" },
	{ "1.3.132.1.12", "ecDH" },
	{ "1.3.132.1.13", "ecMQV" },
	{ "1.3.132.1.14.0", "dhSinglePass-cofactorDH-sha224kdf-scheme" },
	{ "1.3.132.1.14.1", "dhSinglePass-cofactorDH-sha256kdf-scheme" },
	{ "1.3.132.1.14.2", "dhSinglePass-cofactorDH-sha384kdf-scheme" },
	{ "1.3.132.1.14.3", "dhSinglePass-cofactorDH-sha512kdf-scheme" },
	{ "1.3.132.1.15.0", "mqvSinglePass-sha224kdf-scheme" },
	{ "1.3.132.1.15.1", "mqvSinglePass-sha256kdf-scheme" },
	{ "1.3.132.1.15.2", "mqvSinglePass-sha384kdf-scheme" },
	{ "1.3.132.1.15.3", "mqvSinglePass-sha512kdf-scheme" },
	{ "1.3.133.16.840.63.0.16", "mqvSinglePass-sha1kdf-scheme" },
	{ "1.3.133.16.840.63.0.2", "dhSinglePass-stdDH-sha1kdf-scheme" },
	{ "1.3.133.16.840.63.0.3", "dhSinglePass-cofactorDH-sha1kdf-scheme" },
	{ "1.3.133.16.840.9.84", "x984" },
	{ "1.3.133.16.840.9.84.0", "x984Module" },
	{ "1.3.133.16.840.9.84.0.1", "x984Biometrics" },
	{ "1.3.133.16.840.9.84.0.2", "x984CMS" },
	{ "1.3.133.16.840.9.84.0.3", "x984Identifiers" },
	{ "1.3.133.16.840.9.84.1", "x984Biometric" },
	{ "1.3.133.16.840.9.84.1", "x984ProcessingAlgorithm" },
	{ "1.3.133.16.840.9.84.1.0", "biometricUnknownType" },
	{ "1.3.133.16.840.9.84.1.1", "biometricBodyOdor" },
	{ "1.3.133.16.840.9.84.1.10", "biometricPalm" },
	{ "1.3.133.16.840.9.84.1.11", "biometricRetina" },
	{ "1.3.133.16.840.9.84.1.12", "biometricSignature" },
	{ "1.3.133.16.840.9.84.1.13", "biometricSpeechPattern" },
	{ "1.3.133.16.840.9.84.1.14", "biometricThermalImage" },
	{ "1.3.133.16.840.9.84.1.15", "biometricVeinPattern" },
	{ "1.3.133.16.840.9.84.1.16", "biometricThermalFaceImage" },
	{ "1.3.133.16.840.9.84.1.17", "biometricThermalHandImage" },
	{ "1.3.133.16.840.9.84.1.18", "biometricLipMovement" },
	{ "1.3.133.16.840.9.84.1.19", "biometricGait" },
	{ "1.3.133.16.840.9.84.1.2", "biometricDNA" },
	{ "1.3.133.16.840.9.84.1.3", "biometricEarShape" },
	{ "1.3.133.16.840.9.84.1.4", "biometricFacialFeatures" },
	{ "1.3.133.16.840.9.84.1.5", "biometricFingerImage" },
	{ "1.3.133.16.840.9.84.1.6", "biometricFingerGeometry" },
	{ "1.3.133.16.840.9.84.1.7", "biometricHandGeometry" },
	{ "1.3.133.16.840.9.84.1.8", "biometricIrisFeatures" },
	{ "1.3.133.16.840.9.84.1.9", "biometricKeystrokeDynamics" },
	{ "1.3.133.16.840.9.84.3", "x984MatchingMethod" },
	{ "1.3.133.16.840.9.84.4", "x984FormatOwner" },
	{ "1.3.133.16.840.9.84.4.0", "x984CbeffOwner" },
	{ "1.3.133.16.840.9.84.4.1", "x984IbiaOwner" },
	{ "1.3.133.16.840.9.84.4.1", "x984X9Owner" },
	{ "1.3.133.16.840.9.84.4.1.1", "ibiaOwnerSAFLINK" },
	{ "1.3.133.16.840.9.84.4.1.10", "ibiaOwnerSecuGen" },
	{ "1.3.133.16.840.9.84.4.1.11", "ibiaOwnerPreciseBiometric" },
	{ "1.3.133.16.840.9.84.4.1.12", "ibiaOwnerIdentix" },
	{ "1.3.133.16.840.9.84.4.1.13", "ibiaOwnerDERMALOG" },
	{ "1.3.133.16.840.9.84.4.1.14", "ibiaOwnerLOGICO" },
	{ "1.3.133.16.840.9.84.4.1.15", "ibiaOwnerNIST" },
	{ "1.3.133.16.840.9.84.4.1.16", "ibiaOwnerA3Vision" },
	{ "1.3.133.16.840.9.84.4.1.17", "ibiaOwnerNEC" },
	{ "1.3.133.16.840.9.84.4.1.18", "ibiaOwnerSTMicroelectronics" },
	{ "1.3.133.16.840.9.84.4.1.2", "ibiaOwnerBioscrypt" },
	{ "1.3.133.16.840.9.84.4.1.3", "ibiaOwnerVisionics" },
	{ "1.3.133.16.840.9.84.4.1.4", "ibiaOwnerInfineonTechnologiesAG" },
	{ "1.3.133.16.840.9.84.4.1.5", "ibiaOwnerIridianTechnologies" },
	{ "1.3.133.16.840.9.84.4.1.6", "ibiaOwnerVeridicom" },
	{ "1.3.133.16.840.9.84.4.1.7", "ibiaOwnerCyberSIGN" },
	{ "1.3.133.16.840.9.84.4.1.8", "ibiaOwnereCryp" },
	{ "1.3.133.16.840.9.84.4.1.9", "ibiaOwnerFingerprintCardsAB" },
	{ "1.3.14.2.26.5", "sha" },
	{ "1.3.14.3.2.1.1", "rsa" },
	{ "1.3.14.3.2.10", "desMAC" },
	{ "1.3.14.3.2.11", "rsaSignature" },
	{ "1.3.14.3.2.12", "dsa" },
	{ "1.3.14.3.2.13", "dsaWithSHA" },
	{ "1.3.14.3.2.14", "mdc2WithRSASignature" },
	{ "1.3.14.3.2.15", "shaWithRSASignature" },
	{ "1.3.14.3.2.16", "dhWithCommonModulus" },
	{ "1.3.14.3.2.17", "desEDE" },
	{ "1.3.14.3.2.18", "sha" },
	{ "1.3.14.3.2.19", "mdc-2" },
	{ "1.3.14.3.2.2", "md4WitRSA" },
	{ "1.3.14.3.2.2.1", "sqmod-N" },
	{ "1.3.14.3.2.20", "dsaCommon" },
	{ "1.3.14.3.2.21", "dsaCommonWithSHA" },
	{ "1.3.14.3.2.22", "rsaKeyTransport" },
	{ "1.3.14.3.2.23", "keyed-hash-seal" },
	{ "1.3.14.3.2.24", "md2WithRSASignature" },
	{ "1.3.14.3.2.25", "md5WithRSASignature" },
	{ "1.3.14.3.2.26", "sha1" },
	{ "1.3.14.3.2.27", "dsaWithSHA1" },
	{ "1.3.14.3.2.28", "dsaWithCommonSHA1" },
	{ "1.3.14.3.2.29", "sha-1WithRSAEncryption" },
	{ "1.3.14.3.2.3", "md5WithRSA" },
	{ "1.3.14.3.2.3.1", "sqmod-NwithRSA" },
	{ "1.3.14.3.2.4", "md4WithRSAEncryption" },
	{ "1.3.14.3.2.6", "desECB" },
	{ "1.3.14.3.2.7", "desCBC" },
	{ "1.3.14.3.2.8", "desOFB" },
	{ "1.3.14.3.2.9", "desCFB" },
	{ "1.3.14.3.3.1", "simple-strong-auth-mechanism" },
	{ "1.3.14.7.2.1.1", "ElGamal" },
	{ "1.3.14.7.2.3.1", "md2WithRSA" },
	{ "1.3.14.7.2.3.2", "md2WithElGamal" },
	{ "1.3.36.1", "document" },
	{ "1.3.36.1.1", "finalVersion" },
	{ "1.3.36.1.2", "draft" },
	{ "1.3.36.2", "sio" },
	{ "1.3.36.2.1", "sedu" },
	{ "1.3.36.3", "algorithm" },
	{ "1.3.36.3.1", "encryptionAlgorithm" },
	{ "1.3.36.3.1.1", "des" },
	{ "1.3.36.3.1.1.1", "desECB_pad" },
	{ "1.3.36.3.1.1.1.1", "desECB_ISOpad" },
	{ "1.3.36.3.1.1.2.1", "desCBC_pad" },
	{ "1.3.36.3.1.1.2.1.1", "desCBC_ISOpad" },
	{ "1.3.36.3.1.2", "idea" },
	{ "1.3.36.3.1.2.1", "ideaECB" },
	{ "1.3.36.3.1.2.1.1", "ideaECB_pad" },
	{ "1.3.36.3.1.2.1.1.1", "ideaECB_ISOpad" },
	{ "1.3.36.3.1.2.2", "ideaCBC" },
	{ "1.3.36.3.1.2.2.1", "ideaCBC_pad" },
	{ "1.3.36.3.1.2.2.1.1", "ideaCBC_ISOpad" },
	{ "1.3.36.3.1.2.3", "ideaOFB" },
	{ "1.3.36.3.1.2.4", "ideaCFB" },
	{ "1.3.36.3.1.3", "des_3" },
	{ "1.3.36.3.1.3.1.1", "des_3ECB_pad" },
	{ "1.3.36.3.1.3.1.1.1", "des_3ECB_ISOpad" },
	{ "1.3.36.3.1.3.2.1", "des_3CBC_pad" },
	{ "1.3.36.3.1.3.2.1.1", "des_3CBC_ISOpad" },
	{ "1.3.36.3.1.4", "rsaEncryption" },
	{ "1.3.36.3.1.4.512.17", "rsaEncryptionWithlmod512expe17" },
	{ "1.3.36.3.1.5", "bsi-1" },
	{ "1.3.36.3.1.5.1", "bsi_1ECB_pad" },
	{ "1.3.36.3.1.5.2", "bsi_1CBC_pad" },
	{ "1.3.36.3.1.5.2.1", "bsi_1CBC_PEMpad" },
	{ "1.3.36.3.2", "hashAlgorithm" },
	{ "1.3.36.3.2.1", "ripemd160" },
	{ "1.3.36.3.2.2", "ripemd128" },
	{ "1.3.36.3.2.3", "ripemd256" },
	{ "1.3.36.3.2.4", "mdc2singleLength" },
	{ "1.3.36.3.2.5", "mdc2doubleLength" },
	{ "1.3.36.3.3", "signatureAlgorithm" },
	{ "1.3.36.3.3.1", "rsaSignature" },
	{ "1.3.36.3.3.1.1", "rsaSignatureWithsha1" },
	{ "1.3.36.3.3.1.1.1024.11", "rsaSignatureWithsha1_l1024_l11" },
	{ "1.3.36.3.3.1.1.1024.2", "rsaSignatureWithsha1_l1024_l2" },
	{ "1.3.36.3.3.1.1.1024.3", "rsaSignatureWithsha1_l1024_l3" },
	{ "1.3.36.3.3.1.1.1024.5", "rsaSignatureWithsha1_l1024_l5" },
	{ "1.3.36.3.3.1.1.1024.9", "rsaSignatureWithsha1_l1024_l9" },
	{ "1.3.36.3.3.1.1.512.11", "rsaSignatureWithsha1_l512_l11" },
	{ "1.3.36.3.3.1.1.512.2", "rsaSignatureWithsha1_l512_l2" },
	{ "1.3.36.3.3.1.1.512.3", "rsaSignatureWithsha1_l512_l3" },
	{ "1.3.36.3.3.1.1.512.5", "rsaSignatureWithsha1_l512_l5" },
	{ "1.3.36.3.3.1.1.512.9", "rsaSignatureWithsha1_l512_l9" },
	{ "1.3.36.3.3.1.1.640.11", "rsaSignatureWithsha1_l640_l11" },
	{ "1.3.36.3.3.1.1.640.2", "rsaSignatureWithsha1_l640_l2" },
	{ "1.3.36.3.3.1.1.640.3", "rsaSignatureWithsha1_l640_l3" },
	{ "1.3.36.3.3.1.1.640.5", "rsaSignatureWithsha1_l640_l5" },
	{ "1.3.36.3.3.1.1.640.9", "rsaSignatureWithsha1_l640_l9" },
	{ "1.3.36.3.3.1.1.768.11", "rsaSignatureWithsha1_l768_l11" },
	{ "1.3.36.3.3.1.1.768.2", "rsaSignatureWithsha1_l768_l2" },
	{ "1.3.36.3.3.1.1.768.3", "rsaSignatureWithsha1_l768_l3" },
	{ "1.3.36.3.3.1.1.768.5", "rsaSignatureWithsha1_l768_l5" },
	{ "1.3.36.3.3.1.1.768.9", "rsaSignatureWithsha1_l768_l9" },
	{ "1.3.36.3.3.1.1.896.11", "rsaSignatureWithsha1_l896_l11" },
	{ "1.3.36.3.3.1.1.896.2", "rsaSignatureWithsha1_l896_l2" },
	{ "1.3.36.3.3.1.1.896.3", "rsaSignatureWithsha1_l896_l3" },
	{ "1.3.36.3.3.1.1.896.5", "rsaSignatureWithsha1_l896_l5" },
	{ "1.3.36.3.3.1.1.896.9", "rsaSignatureWithsha1_l896_l9" },
	{ "1.3.36.3.3.1.2", "rsaSignatureWithripemd160" },
	{ "1.3.36.3.3.1.2.1024.11", "rsaSignatureWithripemd160_l1024_l11" },
	{ "1.3.36.3.3.1.2.1024.2", "rsaSignatureWithripemd160_l1024_l2" },
	{ "1.3.36.3.3.1.2.1024.3", "rsaSignatureWithripemd160_l1024_l3" },
	{ "1.3.36.3.3.1.2.1024.5", "rsaSignatureWithripemd160_l1024_l5" },
	{ "1.3.36.3.3.1.2.1024.9", "rsaSignatureWithripemd160_l1024_l9" },
	{ "1.3.36.3.3.1.2.512.11", "rsaSignatureWithripemd160_l512_l11" },
	{ "1.3.36.3.3.1.2.512.2", "rsaSignatureWithripemd160_l512_l2" },
	{ "1.3.36.3.3.1.2.512.3", "rsaSignatureWithripemd160_l512_l3" },
	{ "1.3.36.3.3.1.2.512.5", "rsaSignatureWithripemd160_l512_l5" },
	{ "1.3.36.3.3.1.2.512.9", "rsaSignatureWithripemd160_l512_l9" },
	{ "1.3.36.3.3.1.2.640.11", "rsaSignatureWithripemd160_l640_l11" },
	{ "1.3.36.3.3.1.2.640.2", "rsaSignatureWithripemd160_l640_l2" },
	{ "1.3.36.3.3.1.2.640.3", "rsaSignatureWithripemd160_l640_l3" },
	{ "1.3.36.3.3.1.2.640.5", "rsaSignatureWithripemd160_l640_l5" },
	{ "1.3.36.3.3.1.2.640.9", "rsaSignatureWithripemd160_l640_l9" },
	{ "1.3.36.3.3.1.2.768.11", "rsaSignatureWithripemd160_l768_l11" },
	{ "1.3.36.3.3.1.2.768.2", "rsaSignatureWithripemd160_l768_l2" },
	{ "1.3.36.3.3.1.2.768.3", "rsaSignatureWithripemd160_l768_l3" },
	{ "1.3.36.3.3.1.2.768.5", "rsaSignatureWithripemd160_l768_l5" },
	{ "1.3.36.3.3.1.2.768.9", "rsaSignatureWithripemd160_l768_l9" },
	{ "1.3.36.3.3.1.2.896.11", "rsaSignatureWithripemd160_l896_l11" },
	{ "1.3.36.3.3.1.2.896.2", "rsaSignatureWithripemd160_l896_l2" },
	{ "1.3.36.3.3.1.2.896.3", "rsaSignatureWithripemd160_l896_l3" },
	{ "1.3.36.3.3.1.2.896.5", "rsaSignatureWithripemd160_l896_l5" },
	{ "1.3.36.3.3.1.2.896.9", "rsaSignatureWithripemd160_l896_l9" },
	{ "1.3.36.3.3.1.3", "rsaSignatureWithrimpemd128" },
	{ "1.3.36.3.3.1.4", "rsaSignatureWithrimpemd256" },
	{ "1.3.36.3.3.2", "ecsieSign" },
	{ "1.3.36.3.3.2.1", "ecsieSignWithsha1" },
	{ "1.3.36.3.3.2.2", "ecsieSignWithripemd160" },
	{ "1.3.36.3.3.2.3", "ecsieSignWithmd2" },
	{ "1.3.36.3.3.2.4", "ecsieSignWithmd5" },
	{ "1.3.36.3.3.2.8.1.1.1", "brainpoolP160r1" },
	{ "1.3.36.3.3.2.8.1.1.10", "brainpoolP320t1" },
	{ "1.3.36.3.3.2.8.1.1.11", "brainpoolP384r1" },
	{ "1.3.36.3.3.2.8.1.1.12", "brainpoolP384t1" },
	{ "1.3.36.3.3.2.8.1.1.13", "brainpoolP512r1" },
	{ "1.3.36.3.3.2.8.1.1.14", "brainpoolP512t1" },
	{ "1.3.36.3.3.2.8.1.1.2", "brainpoolP160t1" },
	{ "1.3.36.3.3.2.8.1.1.3", "brainpoolP192r1" },
	{ "1.3.36.3.3.2.8.1.1.4", "brainpoolP192t1" },
	{ "1.3.36.3.3.2.8.1.1.5", "brainpoolP224r1" },
	{ "1.3.36.3.3.2.8.1.1.6", "brainpoolP224t1" },
	{ "1.3.36.3.3.2.8.1.1.7", "brainpoolP256r1" },
	{ "1.3.36.3.3.2.8.1.1.8", "brainpoolP256t1" },
	{ "1.3.36.3.3.2.8.1.1.9", "brainpoolP320r1" },
	{ "1.3.36.3.4", "signatureScheme" },
	{ "1.3.36.3.4.1", "sigS_ISO9796-1" },
	{ "1.3.36.3.4.2", "sigS_ISO9796-2" },
	{ "1.3.36.3.4.2.1", "sigS_ISO9796-2Withred" },
	{ "1.3.36.3.4.2.2", "sigS_ISO9796-2Withrsa" },
	{ "1.3.36.3.4.2.3", "sigS_ISO9796-2Withrnd" },
	{ "1.3.36.4", "attribute" },
	{ "1.3.36.5", "policy" },
	{ "1.3.36.6", "api" },
	{ "1.3.36.6.1", "manufacturer-specific_api" },
	{ "1.3.36.6.1.1", "utimaco-api" },
	{ "1.3.36.6.2", "functionality-specific_api" },
	{ "1.3.36.7", "keymgmnt" },
	{ "1.3.36.7.1", "keyagree" },
	{ "1.3.36.7.1.1", "bsiPKE" },
	{ "1.3.36.7.2", "keytrans" },
	{ "1.3.36.7.2.1", "encISO9796-2Withrsa" },
	{ "1.3.36.8.1.1", "Teletrust.SigGConform.policyIdentifier" },
	{ "1.3.36.8.2.1", "directoryService" },
	{ "1.3.36.8.3.1", "dateOfCertGen" },
	{ "1.3.36.8.3.10", "requestedCertificate" },
	{ "1.3.36.8.3.11", "namingAuthorities" },
	{ "1.3.36.8.3.11.1", "rechtWirtschaftSteuern" },
	{ "1.3.36.8.3.11.1.1", "rechtsanwaeltin" },
	{ "1.3.36.8.3.11.1.10", "notarVertreterin" },
	{ "1.3.36.8.3.11.1.11", "notarVertreter" },
	{ "1.3.36.8.3.11.1.12", "notariatsVerwalterin" },
	{ "1.3.36.8.3.11.1.13", "notariatsVerwalter" },
	{ "1.3.36.8.3.11.1.14", "wirtschaftsPrueferin" },
	{ "1.3.36.8.3.11.1.15", "wirtschaftsPruefer" },
	{ "1.3.36.8.3.11.1.16", "vereidigteBuchprueferin" },
	{ "1.3.36.8.3.11.1.17", "vereidigterBuchpruefer" },
	{ "1.3.36.8.3.11.1.18", "patentAnwaeltin" },
	{ "1.3.36.8.3.11.1.19", "patentAnwalt" },
	{ "1.3.36.8.3.11.1.2", "rechtsanwalt" },
	{ "1.3.36.8.3.11.1.3", "rechtsBeistand" },
	{ "1.3.36.8.3.11.1.4", "steuerBeraterin" },
	{ "1.3.36.8.3.11.1.5", "steuerBerater" },
	{ "1.3.36.8.3.11.1.6", "steuerBevollmaechtigte" },
	{ "1.3.36.8.3.11.1.7", "steuerBevollmaechtigter" },
	{ "1.3.36.8.3.11.1.8", "notarin" },
	{ "1.3.36.8.3.11.1.9", "notar" },
	{ "1.3.36.8.3.12", "certInDirSince" },
	{ "1.3.36.8.3.13", "certHash" },
	{ "1.3.36.8.3.14", "nameAtBirth" },
	{ "1.3.36.8.3.15", "additionalInformation" },
	{ "1.3.36.8.3.2", "procuration" },
	{ "1.3.36.8.3.3", "admission" },
	{ "1.3.36.8.3.4", "monetaryLimit" },
	{ "1.3.36.8.3.5", "declarationOfMajority" },
	{ "1.3.36.8.3.6", "integratedCircuitCardSerialNumber" },
	{ "1.3.36.8.3.7", "pKReference" },
	{ "1.3.36.8.3.8", "restriction" },
	{ "1.3.36.8.3.9", "retrieveIfAllowed" },
	{ "1.3.36.8.4.1", "personalData" },
	{ "1.3.36.8.4.8", "restriction" },
	{ "1.3.36.8.5.1.1.1", "rsaIndicateSHA1" },
	{ "1.3.36.8.5.1.1.2", "rsaIndicateRIPEMD160" },
	{ "1.3.36.8.5.1.1.3", "rsaWithSHA1" },
	{ "1.3.36.8.5.1.1.4", "rsaWithRIPEMD160" },
	{ "1.3.36.8.5.1.2.1", "dsaExtended" },
	{ "1.3.36.8.5.1.2.2", "dsaWithRIPEMD160" },
	{ "1.3.36.8.6.1", "cert" },
	{ "1.3.36.8.6.10", "autoGen" },
	{ "1.3.36.8.6.2", "certRef" },
	{ "1.3.36.8.6.3", "attrCert" },
	{ "1.3.36.8.6.4", "attrRef" },
	{ "1.3.36.8.6.5", "fileName" },
	{ "1.3.36.8.6.6", "storageTime" },
	{ "1.3.36.8.6.7", "fileSize" },
	{ "1.3.36.8.6.8", "location" },
	{ "1.3.36.8.6.9", "sigNumber" },
	{ "1.3.36.8.7.1.1", "ptAdobeILL" },
	{ "1.3.36.8.7.1.10", "ptCorelPHT" },
	{ "1.3.36.8.7.1.11", "ptDraw" },
	{ "1.3.36.8.7.1.12", "ptDVI" },
	{ "1.3.36.8.7.1.13", "ptEPS" },
	{ "1.3.36.8.7.1.14", "ptExcel" },
	{ "1.3.36.8.7.1.15", "ptGEM" },
	{ "1.3.36.8.7.1.16", "ptGIF" },
	{ "1.3.36.8.7.1.17", "ptHPGL" },
	{ "1.3.36.8.7.1.18", "ptJPEG" },
	{ "1.3.36.8.7.1.19", "ptKodak" },
	{ "1.3.36.8.7.1.2", "ptAmiPro" },
	{ "1.3.36.8.7.1.20", "ptLaTeX" },
	{ "1.3.36.8.7.1.21", "ptLotus" },
	{ "1.3.36.8.7.1.22", "ptLotusPIC" },
	{ "1.3.36.8.7.1.23", "ptMacPICT" },
	{ "1.3.36.8.7.1.24", "ptMacWord" },
	{ "1.3.36.8.7.1.25", "ptMSWfD" },
	{ "1.3.36.8.7.1.26", "ptMSWord" },
	{ "1.3.36.8.7.1.27", "ptMSWord2" },
	{ "1.3.36.8.7.1.28", "ptMSWord6" },
	{ "1.3.36.8.7.1.29", "ptMSWord8" },
	{ "1.3.36.8.7.1.3", "ptAutoCAD" },
	{ "1.3.36.8.7.1.30", "ptPDF" },
	{ "1.3.36.8.7.1.31", "ptPIF" },
	{ "1.3.36.8.7.1.32", "ptPostscript" },
	{ "1.3.36.8.7.1.33", "ptRTF" },
	{ "1.3.36.8.7.1.34", "ptSCITEX" },
	{ "1.3.36.8.7.1.35", "ptTAR" },
	{ "1.3.36.8.7.1.36", "ptTarga" },
	{ "1.3.36.8.7.1.37", "ptTeX" },
	{ "1.3.36.8.7.1.38", "ptText" },
	{ "1.3.36.8.7.1.39", "ptTIFF" },
	{ "1.3.36.8.7.1.4", "ptBinary" },
	{ "1.3.36.8.7.1.40", "ptTIFF-FC" },
	{ "1.3.36.8.7.1.41", "ptUID" },
	{ "1.3.36.8.7.1.42", "ptUUEncode" },
	{ "1.3.36.8.7.1.43", "ptWMF" },
	{ "1.3.36.8.7.1.44", "ptWordPerfect" },
	{ "1.3.36.8.7.1.45", "ptWPGrph" },
	{ "1.3.36.8.7.1.5", "ptBMP" },
	{ "1.3.36.8.7.1.6", "ptCGM" },
	{ "1.3.36.8.7.1.7", "ptCorelCRT" },
	{ "1.3.36.8.7.1.8", "ptCorelDRW" },
	{ "1.3.36.8.7.1.9", "ptCorelEXC" },
	{ "1.3.6.1.4.1.11591", "gnu" },
	{ "1.3.6.1.4.1.11591.1", "gnuRadius" },
	{ "1.3.6.1.4.1.11591.12", "gnuDigestAlgorithm" },
	{ "1.3.6.1.4.1.11591.12.2", "tiger" },
	{ "1.3.6.1.4.1.11591.13", "gnuEncryptionAlgorithm" },
	{ "1.3.6.1.4.1.11591.13.2", "serpent" },
	{ "1.3.6.1.4.1.11591.13.2.1", "serpent128_ECB" },
	{ "1.3.6.1.4.1.11591.13.2.2", "serpent128_CBC" },
	{ "1.3.6.1.4.1.11591.13.2.21", "serpent192_ECB" },
	{ "1.3.6.1.4.1.11591.13.2.22", "serpent192_CBC" },
	{ "1.3.6.1.4.1.11591.13.2.23", "serpent192_OFB" },
	{ "1.3.6.1.4.1.11591.13.2.24", "serpent192_CFB" },
	{ "1.3.6.1.4.1.11591.13.2.3", "serpent128_OFB" },
	{ "1.3.6.1.4.1.11591.13.2.4", "serpent128_CFB" },
	{ "1.3.6.1.4.1.11591.13.2.41", "serpent256_ECB" },
	{ "1.3.6.1.4.1.11591.13.2.42", "serpent256_CBC" },
	{ "1.3.6.1.4.1.11591.13.2.43", "serpent256_OFB" },
	{ "1.3.6.1.4.1.11591.13.2.44", "serpent256_CFB" },
	{ "1.3.6.1.4.1.11591.3", "gnuRadar" },
	{ "1.3.6.1.4.1.16334.509.1.1", "Northrop.Grumman.extKeyUsage?" },
	{ "1.3.6.1.4.1.16334.509.2.1", "ngcClass1" },
	{ "1.3.6.1.4.1.16334.509.2.2", "ngcClass2" },
	{ "1.3.6.1.4.1.16334.509.2.3", "ngcClass3" },
	{ "1.3.6.1.4.1.188.7.1.1", "ascom" },
	{ "1.3.6.1.4.1.188.7.1.1.1", "ideaECB" },
	{ "1.3.6.1.4.1.188.7.1.1.2", "ideaCBC" },
	{ "1.3.6.1.4.1.188.7.1.1.3", "ideaCFB" },
	{ "1.3.6.1.4.1.188.7.1.1.4", "ideaOFB" },
	{ "1.3.6.1.4.1.23629.1.4.2.1.1", "safenetUsageLimit" },
	{ "1.3.6.1.4.1.23629.1.4.2.1.2", "safenetEndDate" },
	{ "1.3.6.1.4.1.23629.1.4.2.1.3", "safenetStartDate" },
	{ "1.3.6.1.4.1.23629.1.4.2.1.4", "safenetAdminCert" },
	{ "1.3.6.1.4.1.23629.1.4.2.2.1", "safenetKeyDigest" },
	{ "1.3.6.1.4.1.2428.10.1.1", "UNINETT.policyIdentifier" },
	{ "1.3.6.1.4.1.2712.10", "ICE-TEL.policyIdentifier" },
	{ "1.3.6.1.4.1.2786.1.1.1", "ICE-TEL.Italian.policyIdentifier" },
	{ "1.3.6.1.4.1.3029.1.1.1", "blowfishECB" },
	{ "1.3.6.1.4.1.3029.1.1.2", "blowfishCBC" },
	{ "1.3.6.1.4.1.3029.1.1.3", "blowfishCFB" },
	{ "1.3.6.1.4.1.3029.1.1.4", "blowfishOFB" },
	{ "1.3.6.1.4.1.3029.1.2.1", "elgamal" },
	{ "1.3.6.1.4.1.3029.1.2.1.1", "elgamalWithSHA-1" },
	{ "1.3.6.1.4.1.3029.1.2.1.2", "elgamalWithRIPEMD-160" },
	{ "1.3.6.1.4.1.3029.3.1.1", "cryptlibPresenceCheck" },
	{ "1.3.6.1.4.1.3029.3.1.2", "pkiBoot" },
	{ "1.3.6.1.4.1.3029.3.1.4", "crlExtReason" },
	{ "1.3.6.1.4.1.3029.3.1.5", "keyFeatures" },
	{ "1.3.6.1.4.1.3029.4.1", "cryptlibContent" },
	{ "1.3.6.1.4.1.3029.4.1.1", "cryptlibConfigData" },
	{ "1.3.6.1.4.1.3029.4.1.2", "cryptlibUserIndex" },
	{ "1.3.6.1.4.1.3029.4.1.3", "cryptlibUserInfo" },
	{ "1.3.6.1.4.1.3029.4.1.4", "rtcsRequest" },
	{ "1.3.6.1.4.1.3029.4.1.5", "rtcsResponse" },
	{ "1.3.6.1.4.1.3029.4.1.6", "rtcsResponseExt" },
	{ "1.3.6.1.4.1.3029.42.11172.1", "mpeg-1" },
	{ "1.3.6.1.4.1.3029.88.89.90.90.89", "xYZZY.policyIdentifier" },
	{ "1.3.6.1.4.1.311.10.1", "certTrustList" },
	{ "1.3.6.1.4.1.311.10.1.1", "sortedCtl" },
	{ "1.3.6.1.4.1.311.10.10.1", "cmcAddAttributes" },
	{ "1.3.6.1.4.1.311.10.11", "certPropIdPrefix" },
	{ "1.3.6.1.4.1.311.10.11.20", "certKeyIdentifierPropId" },
	{ "1.3.6.1.4.1.311.10.11.28", "certIssuerSerialNumberMd5HashPropId" },
	{ "1.3.6.1.4.1.311.10.11.29", "certSubjectNameMd5HashPropId" },
	{ "1.3.6.1.4.1.311.10.11.4", "certMd5HashPropId" },
	{ "1.3.6.1.4.1.311.10.12.1", "anyApplicationPolicy" },
	{ "1.3.6.1.4.1.311.10.2", "nextUpdateLocation" },
	{ "1.3.6.1.4.1.311.10.3.1", "certTrustListSigning" },
	{ "1.3.6.1.4.1.311.10.3.10", "qualifiedSubordination" },
	{ "1.3.6.1.4.1.311.10.3.11", "keyRecovery" },
	{ "1.3.6.1.4.1.311.10.3.12", "documentSigning" },
	{ "1.3.6.1.4.1.311.10.3.13", "lifetimeSigning" },
	{ "1.3.6.1.4.1.311.10.3.14", "mobileDeviceSoftware" },
	{ "1.3.6.1.4.1.311.10.3.15", "smartDisplay" },
	{ "1.3.6.1.4.1.311.10.3.16", "cspSignature" },
	{ "1.3.6.1.4.1.311.10.3.2", "timeStampSigning" },
	{ "1.3.6.1.4.1.311.10.3.3", "serverGatedCrypto" },
	{ "1.3.6.1.4.1.311.10.3.3.1", "serialized" },
	{ "1.3.6.1.4.1.311.10.3.4", "encryptedFileSystem" },
	{ "1.3.6.1.4.1.311.10.3.4.1", "efsRecovery" },
	{ "1.3.6.1.4.1.311.10.3.5", "whqlCrypto" },
	{ "1.3.6.1.4.1.311.10.3.6", "nt5Crypto" },
	{ "1.3.6.1.4.1.311.10.3.7", "oemWHQLCrypto" },
	{ "1.3.6.1.4.1.311.10.3.8", "embeddedNTCrypto" },
	{ "1.3.6.1.4.1.311.10.3.9", "rootListSigner" },
	{ "1.3.6.1.4.1.311.10.4.1", "yesnoTrustAttr" },
	{ "1.3.6.1.4.1.311.10.5.1", "drm" },
	{ "1.3.6.1.4.1.311.10.5.2", "drmIndividualization" },
	{ "1.3.6.1.4.1.311.10.6.1", "licenses" },
	{ "1.3.6.1.4.1.311.10.6.2", "licenseServer" },
	{ "1.3.6.1.4.1.311.10.7.1", "keyidRdn" },
	{ "1.3.6.1.4.1.311.10.8.1", "removeCertificate" },
	{ "1.3.6.1.4.1.311.10.9.1", "crossCertDistPoints" },
	{ "1.3.6.1.4.1.311.12", "catalog" },
	{ "1.3.6.1.4.1.311.12.1.1", "catalogList" },
	{ "1.3.6.1.4.1.311.12.1.2", "catalogListMember" },
	{ "1.3.6.1.4.1.311.12.2.1", "catalogNameValueObjID" },
	{ "1.3.6.1.4.1.311.12.2.2", "catalogMemberInfoObjID" },
	{ "1.3.6.1.4.1.311.13.1", "renewalCertificate" },
	{ "1.3.6.1.4.1.311.13.2.1", "enrolmentNameValuePair" },
	{ "1.3.6.1.4.1.311.13.2.2", "enrolmentCSP" },
	{ "1.3.6.1.4.1.311.13.2.3", "osVersion" },
	{ "1.3.6.1.4.1.311.16.4", "microsoftRecipientInfo" },
	{ "1.3.6.1.4.1.311.17.1", "pkcs12KeyProviderNameAttr" },
	{ "1.3.6.1.4.1.311.17.2", "localMachineKeyset" },
	{ "1.3.6.1.4.1.311.17.3", "pkcs12ExtendedAttributes" },
	{ "1.3.6.1.4.1.311.2.1.10", "spcAgencyInfo" },
	{ "1.3.6.1.4.1.311.2.1.11", "spcStatementType" },
	{ "1.3.6.1.4.1.311.2.1.12", "spcSpOpusInfo" },
	{ "1.3.6.1.4.1.311.2.1.14", "certReqExtensions" },
	{ "1.3.6.1.4.1.311.2.1.15", "spcPEImageData" },
	{ "1.3.6.1.4.1.311.2.1.18", "spcRawFileData" },
	{ "1.3.6.1.4.1.311.2.1.19", "spcStructuredStorageData" },
	{ "1.3.6.1.4.1.311.2.1.20", "spcJavaClassData.(type.1)" },
	{ "1.3.6.1.4.1.311.2.1.21", "individualCodeSigning" },
	{ "1.3.6.1.4.1.311.2.1.22", "commercialCodeSigning" },
	{ "1.3.6.1.4.1.311.2.1.25", "spcLink.(type.2)" },
	{ "1.3.6.1.4.1.311.2.1.26", "spcMinimalCriteriaInfo" },
	{ "1.3.6.1.4.1.311.2.1.27", "spcFinancialCriteriaInfo" },
	{ "1.3.6.1.4.1.311.2.1.28", "spcLink.(type.3)" },
	{ "1.3.6.1.4.1.311.2.1.29", "spcHashInfoObjID" },
	{ "1.3.6.1.4.1.311.2.1.30", "spcSipInfoObjID" },
	{ "1.3.6.1.4.1.311.2.1.4", "spcIndirectDataContext" },
	{ "1.3.6.1.4.1.311.2.2", "ctl" },
	{ "1.3.6.1.4.1.311.2.2.1", "ctlTrustedCodesigningCAList" },
	{ "1.3.6.1.4.1.311.2.2.2", "ctlTrustedClientAuthCAList" },
	{ "1.3.6.1.4.1.311.2.2.3", "ctlTrustedServerAuthCAList" },
	{ "1.3.6.1.4.1.311.20.1", "autoEnrollCtlUsage" },
	{ "1.3.6.1.4.1.311.20.2", "enrollCerttypeExtension" },
	{ "1.3.6.1.4.1.311.20.2.1", "enrollmentAgent" },
	{ "1.3.6.1.4.1.311.20.2.2", "smartcardLogon" },
	{ "1.3.6.1.4.1.311.20.2.3", "universalPrincipalName" },
	{ "1.3.6.1.4.1.311.20.3", "certManifold" },
	{ "1.3.6.1.4.1.311.21.1", "cAKeyCertIndexPair" },
	{ "1.3.6.1.4.1.311.21.10", "applicationCertPolicies" },
	{ "1.3.6.1.4.1.311.21.11", "applicationPolicyMappings" },
	{ "1.3.6.1.4.1.311.21.12", "applicationPolicyConstraints" },
	{ "1.3.6.1.4.1.311.21.13", "archivedKey" },
	{ "1.3.6.1.4.1.311.21.14", "crlSelfCDP" },
	{ "1.3.6.1.4.1.311.21.15", "requireCertChainPolicy" },
	{ "1.3.6.1.4.1.311.21.16", "archivedKeyCertHash" },
	{ "1.3.6.1.4.1.311.21.17", "issuedCertHash" },
	{ "1.3.6.1.4.1.311.21.19", "dsEmailReplication" },
	{ "1.3.6.1.4.1.311.21.2", "certSrvPreviousCertHash" },
	{ "1.3.6.1.4.1.311.21.20", "requestClientInfo" },
	{ "1.3.6.1.4.1.311.21.21", "encryptedKeyHash" },
	{ "1.3.6.1.4.1.311.21.22", "certsrvCrossCaVersion" },
	{ "1.3.6.1.4.1.311.21.3", "crlVirtualBase" },
	{ "1.3.6.1.4.1.311.21.4", "crlNextPublish" },
	{ "1.3.6.1.4.1.311.21.5", "caExchange" },
	{ "1.3.6.1.4.1.311.21.6", "keyRecovery" },
	{ "1.3.6.1.4.1.311.21.7", "certificateTemplate" },
	{ "1.3.6.1.4.1.311.21.9", "rdnDummySigner" },
	{ "1.3.6.1.4.1.311.25.1", "ntdsReplication" },
	{ "1.3.6.1.4.1.311.3.2.1", "timestampRequest" },
	{ "1.3.6.1.4.1.311.3.3.1", "spcRFC3161" },
	{ "1.3.6.1.4.1.311.31.1", "productUpdate" },
	{ "1.3.6.1.4.1.311.47.1.1", "systemHealth" },
	{ "1.3.6.1.4.1.311.47.1.3", "systemHealthLoophole" },
	{ "1.3.6.1.4.1.311.60.1.1", "rootProgramFlags" },
	{ "1.3.6.1.4.1.311.60.2.1.1", "jurisdictionOfIncorporationL" },
	{ "1.3.6.1.4.1.311.60.2.1.2", "jurisdictionOfIncorporationSP" },
	{ "1.3.6.1.4.1.311.60.2.1.3", "jurisdictionOfIncorporationC" },
	{ "1.3.6.1.4.1.311.61.1.1", "kernelModeCodeSigning" },
	{ "1.3.6.1.4.1.311.88", "capiCom" },
	{ "1.3.6.1.4.1.311.88.1", "capiComVersion" },
	{ "1.3.6.1.4.1.311.88.2", "capiComAttribute" },
	{ "1.3.6.1.4.1.311.88.2.1", "capiComDocumentName" },
	{ "1.3.6.1.4.1.311.88.2.2", "capiComDocumentDescription" },
	{ "1.3.6.1.4.1.311.88.3", "capiComEncryptedData" },
	{ "1.3.6.1.4.1.311.88.3.1", "capiComEncryptedContent" },
	{ "1.3.6.1.4.1.3401.8.1.1", "pgpExtension" },
	{ "1.3.6.1.4.1.3576.7", "eciaAscX12Edi" },
	{ "1.3.6.1.4.1.3576.7.1", "plainEDImessage" },
	{ "1.3.6.1.4.1.3576.7.2", "signedEDImessage" },
	{ "1.3.6.1.4.1.3576.7.5", "integrityEDImessage" },
	{ "1.3.6.1.4.1.3576.7.65", "iaReceiptMessage" },
	{ "1.3.6.1.4.1.3576.7.97", "iaStatusMessage" },
	{ "1.3.6.1.4.1.3576.8", "eciaEdifact" },
	{ "1.3.6.1.4.1.3576.9", "eciaNonEdi" },
	{ "1.3.6.1.4.1.4146", "Globalsign" },
	{ "1.3.6.1.4.1.4146.1", "globalsignPolicy" },
	{ "1.3.6.1.4.1.4146.1.10", "globalsignDVPolicy" },
	{ "1.3.6.1.4.1.4146.1.20", "globalsignOVPolicy" },
	{ "1.3.6.1.4.1.4146.1.30", "globalsignTSAPolicy" },
	{ "1.3.6.1.4.1.4146.1.40", "globalsignClientCertPolicy" },
	{ "1.3.6.1.4.1.4146.1.50", "globalsignCodeSignPolicy" },
	{ "1.3.6.1.4.1.4146.1.60", "globalsignRootSignPolicy" },
	{ "1.3.6.1.4.1.4146.1.70", "globalsignTrustedRootPolicy" },
	{ "1.3.6.1.4.1.4146.1.80", "globalsignEDIClientPolicy" },
	{ "1.3.6.1.4.1.4146.1.81", "globalsignEDIServerPolicy" },
	{ "1.3.6.1.4.1.4146.1.90", "globalsignTPMRootPolicy" },
	{ "1.3.6.1.4.1.4146.1.95", "globalsignOCSPPolicy" },
	{ "1.3.6.1.4.1.5309.1", "edelWebPolicy" },
	{ "1.3.6.1.4.1.5309.1.2", "edelWebCustomerPolicy" },
	{ "1.3.6.1.4.1.5309.1.2.1", "edelWebClepsydrePolicy" },
	{ "1.3.6.1.4.1.5309.1.2.2", "edelWebExperimentalTSAPolicy" },
	{ "1.3.6.1.4.1.5309.1.2.3", "edelWebOpenEvidenceTSAPolicy" },
	{ "1.3.6.1.4.1.5472", "timeproof" },
	{ "1.3.6.1.4.1.5472.1", "tss" },
	{ "1.3.6.1.4.1.5472.1.1", "tss80" },
	{ "1.3.6.1.4.1.5472.1.2", "tss380" },
	{ "1.3.6.1.4.1.5472.1.3", "tss400" },
	{ "1.3.6.1.4.1.5770.0.3", "secondaryPractices" },
	{ "1.3.6.1.4.1.5770.0.4", "physicianIdentifiers" },
	{ "1.3.6.1.4.1.6449.1.2.1.3.1", "comodoPolicy" },
	{ "1.3.6.1.4.1.6449.1.2.2.15", "wotrustPolicy" },
	{ "1.3.6.1.4.1.6449.1.3.5.2", "comodoCertifiedDeliveryService" },
	{ "1.3.6.1.4.1.6449.2.1.1", "comodoTimestampingPolicy" },
	{ "1.3.6.1.4.1.8231.1", "rolUnicoNacional" },
	{ "1.3.6.1.4.1.8301.3.5.1", "validityModelChain" },
	{ "1.3.6.1.4.1.8301.3.5.2", "validityModelShell" },
	{ "1.3.6.1.5.5.1.1", "SPKM1" },
	{ "1.3.6.1.5.5.1.2", "SPKM2" },
	{ "1.3.6.1.5.5.7", "pkix" },
	{ "1.3.6.1.5.5.7.0.12", "attributeCert" },
	{ "1.3.6.1.5.5.7.1", "privateExtension" },
	{ "1.3.6.1.5.5.7.1.1", "authorityInfoAccess" },
	{ "1.3.6.1.5.5.7.1.10", "acProxying" },
	{ "1.3.6.1.5.5.7.1.11", "subjectInfoAccess" },
	{ "1.3.6.1.5.5.7.1.12", "logoType" },
	{ "1.3.6.1.5.5.7.1.13", "wlanSSID" },
	{ "1.3.6.1.5.5.7.1.2", "biometricInfo" },
	{ "1.3.6.1.5.5.7.1.3", "qcStatements" },
	{ "1.3.6.1.5.5.7.1.4", "acAuditIdentity" },
	{ "1.3.6.1.5.5.7.1.5", "acTargeting" },
	{ "1.3.6.1.5.5.7.1.6", "acAaControls" },
	{ "1.3.6.1.5.5.7.1.7", "ipAddrBlocks" },
	{ "1.3.6.1.5.5.7.1.8", "autonomousSysIds" },
	{ "1.3.6.1.5.5.7.1.9", "routerIdentifier" },
	{ "1.3.6.1.5.5.7.10", "attributeCertificate" },
	{ "1.3.6.1.5.5.7.10.1", "authenticationInfo" },
	{ "1.3.6.1.5.5.7.10.2", "accessIdentity" },
	{ "1.3.6.1.5.5.7.10.3", "chargingIdentity" },
	{ "1.3.6.1.5.5.7.10.4", "group" },
	{ "1.3.6.1.5.5.7.10.5", "role" },
	{ "1.3.6.1.5.5.7.10.6", "wlanSSID" },
	{ "1.3.6.1.5.5.7.11", "personalData" },
	{ "1.3.6.1.5.5.7.11.1", "pkixQCSyntax-v1" },
	{ "1.3.6.1.5.5.7.14.2", "resourceCertificatePolicy" },
	{ "1.3.6.1.5.5.7.2", "policyQualifierIds" },
	{ "1.3.6.1.5.5.7.2.1", "cps" },
	{ "1.3.6.1.5.5.7.2.2", "unotice" },
	{ "1.3.6.1.5.5.7.2.3", "textNotice" },
	{ "1.3.6.1.5.5.7.20", "logo" },
	{ "1.3.6.1.5.5.7.20.1", "logoLoyalty" },
	{ "1.3.6.1.5.5.7.20.2", "logoBackground" },
	{ "1.3.6.1.5.5.7.3", "keyPurpose" },
	{ "1.3.6.1.5.5.7.3.1", "serverAuth" },
	{ "1.3.6.1.5.5.7.3.10", "dvcs" },
	{ "1.3.6.1.5.5.7.3.11", "sbgpCertAAServerAuth" },
	{ "1.3.6.1.5.5.7.3.13", "eapOverPPP" },
	{ "1.3.6.1.5.5.7.3.14", "eapOverLAN" },
	{ "1.3.6.1.5.5.7.3.2", "clientAuth" },
	{ "1.3.6.1.5.5.7.3.3", "codeSigning" },
	{ "1.3.6.1.5.5.7.3.4", "emailProtection" },
	{ "1.3.6.1.5.5.7.3.5", "ipsecEndSystem" },
	{ "1.3.6.1.5.5.7.3.6", "ipsecTunnel" },
	{ "1.3.6.1.5.5.7.3.7", "ipsecUser" },
	{ "1.3.6.1.5.5.7.3.8", "timeStamping" },
	{ "1.3.6.1.5.5.7.3.9", "ocspSigning" },
	{ "1.3.6.1.5.5.7.4", "cmpInformationTypes" },
	{ "1.3.6.1.5.5.7.4.1", "caProtEncCert" },
	{ "1.3.6.1.5.5.7.4.10", "keyPairParamReq" },
	{ "1.3.6.1.5.5.7.4.11", "keyPairParamRep" },
	{ "1.3.6.1.5.5.7.4.12", "revPassphrase" },
	{ "1.3.6.1.5.5.7.4.13", "implicitConfirm" },
	{ "1.3.6.1.5.5.7.4.14", "confirmWaitTime" },
	{ "1.3.6.1.5.5.7.4.15", "origPKIMessage" },
	{ "1.3.6.1.5.5.7.4.16", "suppLangTags" },
	{ "1.3.6.1.5.5.7.4.2", "signKeyPairTypes" },
	{ "1.3.6.1.5.5.7.4.3", "encKeyPairTypes" },
	{ "1.3.6.1.5.5.7.4.4", "preferredSymmAlg" },
	{ "1.3.6.1.5.5.7.4.5", "caKeyUpdateInfo" },
	{ "1.3.6.1.5.5.7.4.6", "currentCRL" },
	{ "1.3.6.1.5.5.7.4.7", "unsupportedOIDs" },
	{ "1.3.6.1.5.5.7.48.1", "ocsp" },
	{ "1.3.6.1.5.5.7.48.1.1", "ocspBasic" },
	{ "1.3.6.1.5.5.7.48.1.2", "ocspNonce" },
	{ "1.3.6.1.5.5.7.48.1.3", "ocspCRL" },
	{ "1.3.6.1.5.5.7.48.1.4", "ocspResponse" },
	{ "1.3.6.1.5.5.7.48.1.5", "ocspNoCheck" },
	{ "1.3.6.1.5.5.7.48.1.6", "ocspArchiveCutoff" },
	{ "1.3.6.1.5.5.7.48.1.7", "ocspServiceLocator" },
	{ "1.3.6.1.5.5.7.48.10", "rpkiManifest" },
	{ "1.3.6.1.5.5.7.48.11", "signedObject" },
	{ "1.3.6.1.5.5.7.48.2", "caIssuers" },
	{ "1.3.6.1.5.5.7.48.3", "timeStamping" },
	{ "1.3.6.1.5.5.7.48.4", "dvcs" },
	{ "1.3.6.1.5.5.7.48.5", "caRepository" },
	{ "1.3.6.1.5.5.7.48.7", "signedObjectRepository" },
	{ "1.3.6.1.5.5.7.5", "crmfRegistration" },
	{ "1.3.6.1.5.5.7.5.1", "regCtrl" },
	{ "1.3.6.1.5.5.7.5.1.1", "regToken" },
	{ "1.3.6.1.5.5.7.5.1.2", "authenticator" },
	{ "1.3.6.1.5.5.7.5.1.3", "pkiPublicationInfo" },
	{ "1.3.6.1.5.5.7.5.1.4", "pkiArchiveOptions" },
	{ "1.3.6.1.5.5.7.5.1.5", "oldCertID" },
	{ "1.3.6.1.5.5.7.5.1.6", "protocolEncrKey" },
	{ "1.3.6.1.5.5.7.5.1.7", "altCertTemplate" },
	{ "1.3.6.1.5.5.7.5.1.8", "wtlsTemplate" },
	{ "1.3.6.1.5.5.7.5.2", "utf8Pairs" },
	{ "1.3.6.1.5.5.7.5.2.1", "utf8Pairs" },
	{ "1.3.6.1.5.5.7.5.2.2", "certReq" },
	{ "1.3.6.1.5.5.7.6", "algorithms" },
	{ "1.3.6.1.5.5.7.6.1", "des40" },
	{ "1.3.6.1.5.5.7.6.2", "noSignature" },
	{ "1.3.6.1.5.5.7.6.3", "dh-sig-hmac-sha1" },
	{ "1.3.6.1.5.5.7.6.4", "dh-pop" },
	{ "1.3.6.1.5.5.7.7", "cmcControls" },
	{ "1.3.6.1.5.5.7.8", "otherNames" },
	{ "1.3.6.1.5.5.7.8.1", "personalData" },
	{ "1.3.6.1.5.5.7.8.2", "userGroup" },
	{ "1.3.6.1.5.5.7.8.5", "xmppAddr" },
	{ "1.3.6.1.5.5.7.9", "personalData" },
	{ "1.3.6.1.5.5.7.9.1", "dateOfBirth" },
	{ "1.3.6.1.5.5.7.9.2", "placeOfBirth" },
	{ "1.3.6.1.5.5.7.9.3", "gender" },
	{ "1.3.6.1.5.5.7.9.4", "countryOfCitizenship" },
	{ "1.3.6.1.5.5.7.9.5", "countryOfResidence" },
	{ "1.3.6.1.5.5.8.1.1", "hmacMD5" },
	{ "1.3.6.1.5.5.8.1.2", "hmacSHA" },
	{ "1.3.6.1.5.5.8.1.3", "hmacTiger" },
	{ "1.3.6.1.5.5.8.2.2", "iKEIntermediate" },
	{ "2.16.724.1.2.2.4.1", "personalDataInfo" },
	{ "2.16.840.1.101.2.1.1.1", "sdnsSignatureAlgorithm" },
	{ "2.16.840.1.101.2.1.1.10", "fortezzaKeyManagementAlgorithm" },
	{ "2.16.840.1.101.2.1.1.11", "sdnsKMandSigAlgorithm" },
	{ "2.16.840.1.101.2.1.1.12", "fortezzaKMandSigAlgorithm" },
	{ "2.16.840.1.101.2.1.1.13", "suiteASignatureAlgorithm" },
	{ "2.16.840.1.101.2.1.1.14", "suiteAConfidentialityAlgorithm" },
	{ "2.16.840.1.101.2.1.1.15", "suiteAIntegrityAlgorithm" },
	{ "2.16.840.1.101.2.1.1.16", "suiteATokenProtectionAlgorithm" },
	{ "2.16.840.1.101.2.1.1.17", "suiteAKeyManagementAlgorithm" },
	{ "2.16.840.1.101.2.1.1.18", "suiteAKMandSigAlgorithm" },
	{ "2.16.840.1.101.2.1.1.19", "fortezzaUpdatedSigAlgorithm" },
	{ "2.16.840.1.101.2.1.1.2", "fortezzaSignatureAlgorithm" },
	{ "2.16.840.1.101.2.1.1.20", "fortezzaKMandUpdSigAlgorithms" },
	{ "2.16.840.1.101.2.1.1.21", "fortezzaUpdatedIntegAlgorithm" },
	{ "2.16.840.1.101.2.1.1.22", "keyExchangeAlgorithm" },
	{ "2.16.840.1.101.2.1.1.23", "fortezzaWrap80Algorithm" },
	{ "2.16.840.1.101.2.1.1.24", "kEAKeyEncryptionAlgorithm" },
	{ "2.16.840.1.101.2.1.1.3", "sdnsConfidentialityAlgorithm" },
	{ "2.16.840.1.101.2.1.1.4", "fortezzaConfidentialityAlgorithm" },
	{ "2.16.840.1.101.2.1.1.5", "sdnsIntegrityAlgorithm" },
	{ "2.16.840.1.101.2.1.1.6", "fortezzaIntegrityAlgorithm" },
	{ "2.16.840.1.101.2.1.1.7", "sdnsTokenProtectionAlgorithm" },
	{ "2.16.840.1.101.2.1.1.8", "fortezzaTokenProtectionAlgorithm" },
	{ "2.16.840.1.101.2.1.1.9", "sdnsKeyManagementAlgorithm" },
	{ "2.16.840.1.101.2.1.10.1", "sigPrivileges" },
	{ "2.16.840.1.101.2.1.10.2", "kmPrivileges" },
	{ "2.16.840.1.101.2.1.10.3", "namedTagSetPrivilege" },
	{ "2.16.840.1.101.2.1.11.1", "ukDemo" },
	{ "2.16.840.1.101.2.1.11.2", "usDODClass2" },
	{ "2.16.840.1.101.2.1.11.3", "usMediumPilot" },
	{ "2.16.840.1.101.2.1.11.4", "usDODClass4" },
	{ "2.16.840.1.101.2.1.11.5", "usDODClass3" },
	{ "2.16.840.1.101.2.1.11.6", "usDODClass5" },
	{ "2.16.840.1.101.2.1.12.0", "testSecurityPolicy" },
	{ "2.16.840.1.101.2.1.12.0.1", "tsp1" },
	{ "2.16.840.1.101.2.1.12.0.1.0", "tsp1SecurityCategories" },
	{ "2.16.840.1.101.2.1.12.0.1.0.0", "tsp1TagSetZero" },
	{ "2.16.840.1.101.2.1.12.0.1.0.1", "tsp1TagSetOne" },
	{ "2.16.840.1.101.2.1.12.0.1.0.2", "tsp1TagSetTwo" },
	{ "2.16.840.1.101.2.1.12.0.2", "tsp2" },
	{ "2.16.840.1.101.2.1.12.0.2.0", "tsp2SecurityCategories" },
	{ "2.16.840.1.101.2.1.12.0.2.0.0", "tsp2TagSetZero" },
	{ "2.16.840.1.101.2.1.12.0.2.0.1", "tsp2TagSetOne" },
	{ "2.16.840.1.101.2.1.12.0.2.0.2", "tsp2TagSetTwo" },
	{ "2.16.840.1.101.2.1.12.0.3", "kafka" },
	{ "2.16.840.1.101.2.1.12.0.3.0", "kafkaSecurityCategories" },
	{ "2.16.840.1.101.2.1.12.0.3.0.1", "kafkaTagSetName1" },
	{ "2.16.840.1.101.2.1.12.0.3.0.2", "kafkaTagSetName2" },
	{ "2.16.840.1.101.2.1.12.0.3.0.3", "kafkaTagSetName3" },
	{ "2.16.840.1.101.2.1.12.1.1", "tcp1" },
	{ "2.16.840.1.101.2.1.2.1", "rfc822MessageFormat" },
	{ "2.16.840.1.101.2.1.2.2", "emptyContent" },
	{ "2.16.840.1.101.2.1.2.3", "cspContentType" },
	{ "2.16.840.1.101.2.1.2.42", "mspRev3ContentType" },
	{ "2.16.840.1.101.2.1.2.48", "mspContentType" },
	{ "2.16.840.1.101.2.1.2.49", "mspRekeyAgentProtocol" },
	{ "2.16.840.1.101.2.1.2.50", "mspMMP" },
	{ "2.16.840.1.101.2.1.2.66", "mspRev3-1ContentType" },
	{ "2.16.840.1.101.2.1.2.72", "forwardedMSPMessageBodyPart" },
	{ "2.16.840.1.101.2.1.2.73", "mspForwardedMessageParameters" },
	{ "2.16.840.1.101.2.1.2.74", "forwardedCSPMsgBodyPart" },
	{ "2.16.840.1.101.2.1.2.75", "cspForwardedMessageParameters" },
	{ "2.16.840.1.101.2.1.2.76", "mspMMP2" },
	{ "2.16.840.1.101.2.1.3.1", "sdnsSecurityPolicy" },
	{ "2.16.840.1.101.2.1.3.10", "siSecurityPolicy" },
	{ "2.16.840.1.101.2.1.3.10.0", "siNASP" },
	{ "2.16.840.1.101.2.1.3.10.1", "siELCO" },
	{ "2.16.840.1.101.2.1.3.10.10", "siREL_UK" },
	{ "2.16.840.1.101.2.1.3.10.11", "siREL-NZ" },
	{ "2.16.840.1.101.2.1.3.10.12", "siGeneric" },
	{ "2.16.840.1.101.2.1.3.10.2", "siTK" },
	{ "2.16.840.1.101.2.1.3.10.3", "siDSAP" },
	{ "2.16.840.1.101.2.1.3.10.4", "siSSSS" },
	{ "2.16.840.1.101.2.1.3.10.5", "siDNASP" },
	{ "2.16.840.1.101.2.1.3.10.6", "siBYEMAN" },
	{ "2.16.840.1.101.2.1.3.10.7", "siREL-US" },
	{ "2.16.840.1.101.2.1.3.10.8", "siREL-AUS" },
	{ "2.16.840.1.101.2.1.3.10.9", "siREL-CAN" },
	{ "2.16.840.1.101.2.1.3.11", "genser" },
	{ "2.16.840.1.101.2.1.3.11.0", "genserNations" },
	{ "2.16.840.1.101.2.1.3.11.1", "genserComsec" },
	{ "2.16.840.1.101.2.1.3.11.2", "genserAcquisition" },
	{ "2.16.840.1.101.2.1.3.11.3", "genserSecurityCategories" },
	{ "2.16.840.1.101.2.1.3.11.3.0", "genserTagSetName" },
	{ "2.16.840.1.101.2.1.3.12", "defaultSecurityPolicy" },
	{ "2.16.840.1.101.2.1.3.13", "capcoMarkings" },
	{ "2.16.840.1.101.2.1.3.13.0", "capcoSecurityCategories" },
	{ "2.16.840.1.101.2.1.3.13.0.1", "capcoTagSetName1" },
	{ "2.16.840.1.101.2.1.3.13.0.2", "capcoTagSetName2" },
	{ "2.16.840.1.101.2.1.3.13.0.3", "capcoTagSetName3" },
	{ "2.16.840.1.101.2.1.3.13.0.4", "capcoTagSetName4" },
	{ "2.16.840.1.101.2.1.3.2", "sdnsPRBAC" },
	{ "2.16.840.1.101.2.1.3.3", "mosaicPRBAC" },
	{ "2.16.840.1.101.2.1.5.1", "sdnsKeyManagementCertificate" },
	{ "2.16.840.1.101.2.1.5.10", "auxiliaryVector" },
	{ "2.16.840.1.101.2.1.5.11", "mlReceiptPolicy" },
	{ "2.16.840.1.101.2.1.5.12", "mlMembership" },
	{ "2.16.840.1.101.2.1.5.13", "mlAdministrators" },
	{ "2.16.840.1.101.2.1.5.14", "alid" },
	{ "2.16.840.1.101.2.1.5.2", "sdnsUserSignatureCertificate" },
	{ "2.16.840.1.101.2.1.5.20", "janUKMs" },
	{ "2.16.840.1.101.2.1.5.21", "febUKMs" },
	{ "2.16.840.1.101.2.1.5.22", "marUKMs" },
	{ "2.16.840.1.101.2.1.5.23", "aprUKMs" },
	{ "2.16.840.1.101.2.1.5.24", "mayUKMs" },
	{ "2.16.840.1.101.2.1.5.25", "junUKMs" },
	{ "2.16.840.1.101.2.1.5.26", "julUKMs" },
	{ "2.16.840.1.101.2.1.5.27", "augUKMs" },
	{ "2.16.840.1.101.2.1.5.28", "sepUKMs" },
	{ "2.16.840.1.101.2.1.5.29", "octUKMs" },
	{ "2.16.840.1.101.2.1.5.3", "sdnsKMandSigCertificate" },
	{ "2.16.840.1.101.2.1.5.30", "novUKMs" },
	{ "2.16.840.1.101.2.1.5.31", "decUKMs" },
	{ "2.16.840.1.101.2.1.5.4", "fortezzaKeyManagementCertificate" },
	{ "2.16.840.1.101.2.1.5.40", "metaSDNSckl" },
	{ "2.16.840.1.101.2.1.5.41", "sdnsCKL" },
	{ "2.16.840.1.101.2.1.5.42", "metaSDNSsignatureCKL" },
	{ "2.16.840.1.101.2.1.5.43", "sdnsSignatureCKL" },
	{ "2.16.840.1.101.2.1.5.44", "sdnsCertificateRevocationList" },
	{ "2.16.840.1.101.2.1.5.45", "fortezzaCertificateRevocationList" },
	{ "2.16.840.1.101.2.1.5.46", "fortezzaCKL" },
	{ "2.16.840.1.101.2.1.5.47", "alExemptedAddressProcessor" },
	{ "2.16.840.1.101.2.1.5.48", "guard" },
	{ "2.16.840.1.101.2.1.5.49", "algorithmsSupported" },
	{ "2.16.840.1.101.2.1.5.5", "fortezzaKMandSigCertificate" },
	{ "2.16.840.1.101.2.1.5.50", "suiteAKeyManagementCertificate" },
	{ "2.16.840.1.101.2.1.5.51", "suiteAKMandSigCertificate" },
	{ "2.16.840.1.101.2.1.5.52", "suiteAUserSignatureCertificate" },
	{ "2.16.840.1.101.2.1.5.53", "prbacInfo" },
	{ "2.16.840.1.101.2.1.5.54", "prbacCAConstraints" },
	{ "2.16.840.1.101.2.1.5.55", "sigOrKMPrivileges" },
	{ "2.16.840.1.101.2.1.5.56", "commPrivileges" },
	{ "2.16.840.1.101.2.1.5.57", "labeledAttribute" },
	{ "2.16.840.1.101.2.1.5.58", "policyInformationFile" },
	{ "2.16.840.1.101.2.1.5.59", "secPolicyInformationFile" },
	{ "2.16.840.1.101.2.1.5.6", "fortezzaUserSignatureCertificate" },
	{ "2.16.840.1.101.2.1.5.60", "cAClearanceConstraint" },
	{ "2.16.840.1.101.2.1.5.7", "fortezzaCASignatureCertificate" },
	{ "2.16.840.1.101.2.1.5.8", "sdnsCASignatureCertificate" },
	{ "2.16.840.1.101.2.1.7.1", "cspExtns" },
	{ "2.16.840.1.101.2.1.7.1.0", "cspCsExtn" },
	{ "2.16.840.1.101.2.1.8.1", "mISSISecurityCategories" },
	{ "2.16.840.1.101.2.1.8.2", "standardSecurityLabelPrivileges" },
	{ "2.16.840.1.101.3.1", "slabel" },
	{ "2.16.840.1.101.3.2", "pki" },
	{ "2.16.840.1.101.3.2.1", "NIST.policyIdentifier" },
	{ "2.16.840.1.101.3.2.1.3.1", "fbcaRudimentaryPolicy" },
	{ "2.16.840.1.101.3.2.1.3.2", "fbcaBasicPolicy" },
	{ "2.16.840.1.101.3.2.1.3.3", "fbcaMediumPolicy" },
	{ "2.16.840.1.101.3.2.1.3.4", "fbcaHighPolicy" },
	{ "2.16.840.1.101.3.2.1.48.1", "nistTestPolicy1" },
	{ "2.16.840.1.101.3.2.1.48.2", "nistTestPolicy2" },
	{ "2.16.840.1.101.3.2.1.48.3", "nistTestPolicy3" },
	{ "2.16.840.1.101.3.2.1.48.4", "nistTestPolicy4" },
	{ "2.16.840.1.101.3.2.1.48.5", "nistTestPolicy5" },
	{ "2.16.840.1.101.3.2.1.48.6", "nistTestPolicy6" },
	{ "2.16.840.1.101.3.2.2", "gak" },
	{ "2.16.840.1.101.3.2.2.1", "kRAKey" },
	{ "2.16.840.1.101.3.2.3", "extensions" },
	{ "2.16.840.1.101.3.2.3.1", "kRTechnique" },
	{ "2.16.840.1.101.3.2.3.2", "kRecoveryCapable" },
	{ "2.16.840.1.101.3.2.3.3", "kR" },
	{ "2.16.840.1.101.3.2.4", "keyRecoverySchemes" },
	{ "2.16.840.1.101.3.2.5", "krapola" },
	{ "2.16.840.1.101.3.3", "arpa" },
	{ "2.16.840.1.101.3.4", "nistAlgorithm" },
	{ "2.16.840.1.101.3.4.1", "aes" },
	{ "2.16.840.1.101.3.4.1.1", "aes128-ECB" },
	{ "2.16.840.1.101.3.4.1.2", "aes128-CBC" },
	{ "2.16.840.1.101.3.4.1.21", "aes192-ECB" },
	{ "2.16.840.1.101.3.4.1.22", "aes192-CBC" },
	{ "2.16.840.1.101.3.4.1.23", "aes192-OFB" },
	{ "2.16.840.1.101.3.4.1.24", "aes192-CFB" },
	{ "2.16.840.1.101.3.4.1.25", "aes192-wrap" },
	{ "2.16.840.1.101.3.4.1.26", "aes192-GCM" },
	{ "2.16.840.1.101.3.4.1.27", "aes192-CCM" },
	{ "2.16.840.1.101.3.4.1.28", "aes192-wrap-pad" },
	{ "2.16.840.1.101.3.4.1.3", "aes128-OFB" },
	{ "2.16.840.1.101.3.4.1.4", "aes128-CFB" },
	{ "2.16.840.1.101.3.4.1.41", "aes256-ECB" },
	{ "2.16.840.1.101.3.4.1.42", "aes256-CBC" },
	{ "2.16.840.1.101.3.4.1.43", "aes256-OFB" },
	{ "2.16.840.1.101.3.4.1.44", "aes256-CFB" },
	{ "2.16.840.1.101.3.4.1.45", "aes256-wrap" },
	{ "2.16.840.1.101.3.4.1.46", "aes256-GCM" },
	{ "2.16.840.1.101.3.4.1.47", "aes256-CCM" },
	{ "2.16.840.1.101.3.4.1.48", "aes256-wrap-pad" },
	{ "2.16.840.1.101.3.4.1.5", "aes128-wrap" },
	{ "2.16.840.1.101.3.4.1.6", "aes128-GCM" },
	{ "2.16.840.1.101.3.4.1.7", "aes128-CCM" },
	{ "2.16.840.1.101.3.4.1.8", "aes128-wrap-pad" },
	{ "2.16.840.1.101.3.4.2", "hashAlgos" },
	{ "2.16.840.1.101.3.4.2.1", "sha-256" },
	{ "2.16.840.1.101.3.4.2.2", "sha-384" },
	{ "2.16.840.1.101.3.4.2.3", "sha-512" },
	{ "2.16.840.1.101.3.4.2.4", "sha-224" },
	{ "2.16.840.1.101.3.4.3.1", "dsaWithSha224" },
	{ "2.16.840.1.101.3.4.3.2", "dsaWithSha256" },
	{ "2.16.840.1.113719.1.2.8", "novellAlgorithm" },
	{ "2.16.840.1.113719.1.2.8.130", "md4Packet" },
	{ "2.16.840.1.113719.1.2.8.131", "rsaEncryptionBsafe1" },
	{ "2.16.840.1.113719.1.2.8.132", "nwPassword" },
	{ "2.16.840.1.113719.1.2.8.133", "novellObfuscate-1" },
	{ "2.16.840.1.113719.1.2.8.22", "desCbcIV8" },
	{ "2.16.840.1.113719.1.2.8.23", "desCbcPadIV8" },
	{ "2.16.840.1.113719.1.2.8.24", "desEDE2CbcIV8" },
	{ "2.16.840.1.113719.1.2.8.25", "desEDE2CbcPadIV8" },
	{ "2.16.840.1.113719.1.2.8.26", "desEDE3CbcIV8" },
	{ "2.16.840.1.113719.1.2.8.27", "desEDE3CbcPadIV8" },
	{ "2.16.840.1.113719.1.2.8.28", "rc5CbcPad" },
	{ "2.16.840.1.113719.1.2.8.29", "md2WithRSAEncryptionBSafe1" },
	{ "2.16.840.1.113719.1.2.8.30", "md5WithRSAEncryptionBSafe1" },
	{ "2.16.840.1.113719.1.2.8.31", "sha1WithRSAEncryptionBSafe1" },
	{ "2.16.840.1.113719.1.2.8.32", "lmDigest" },
	{ "2.16.840.1.113719.1.2.8.40", "md2" },
	{ "2.16.840.1.113719.1.2.8.50", "md5" },
	{ "2.16.840.1.113719.1.2.8.51", "ikeHmacWithSHA1-RSA" },
	{ "2.16.840.1.113719.1.2.8.52", "ikeHmacWithMD5-RSA" },
	{ "2.16.840.1.113719.1.2.8.69", "rc2CbcPad" },
	{ "2.16.840.1.113719.1.2.8.82", "sha-1" },
	{ "2.16.840.1.113719.1.2.8.92", "rc2BSafe1Cbc" },
	{ "2.16.840.1.113719.1.2.8.95", "md4" },
	{ "2.16.840.1.113719.1.9", "pki" },
	{ "2.16.840.1.113719.1.9.4", "pkiAttributeType" },
	{ "2.16.840.1.113719.1.9.4.1", "securityAttributes" },
	{ "2.16.840.1.113719.1.9.4.2", "relianceLimit" },
	{ "2.16.840.1.113730", "netscape" },
	{ "2.16.840.1.113730.1", "cert-extension" },
	{ "2.16.840.1.113730.1.1", "netscape-cert-type" },
	{ "2.16.840.1.113730.1.10", "EntityLogo" },
	{ "2.16.840.1.113730.1.11", "UserPicture" },
	{ "2.16.840.1.113730.1.12", "netscape-ssl-server-name" },
	{ "2.16.840.1.113730.1.13", "netscape-comment" },
	{ "2.16.840.1.113730.1.2", "netscape-base-url" },
	{ "2.16.840.1.113730.1.3", "netscape-revocation-url" },
	{ "2.16.840.1.113730.1.4", "netscape-ca-revocation-url" },
	{ "2.16.840.1.113730.1.7", "netscape-cert-renewal-url" },
	{ "2.16.840.1.113730.1.8", "netscape-ca-policy-url" },
	{ "2.16.840.1.113730.1.9", "HomePage-url" },
	{ "2.16.840.1.113730.2", "data-type" },
	{ "2.16.840.1.113730.2.1", "dataGIF" },
	{ "2.16.840.1.113730.2.2", "dataJPEG" },
	{ "2.16.840.1.113730.2.3", "dataURL" },
	{ "2.16.840.1.113730.2.4", "dataHTML" },
	{ "2.16.840.1.113730.2.5", "certSequence" },
	{ "2.16.840.1.113730.2.6", "certURL" },
	{ "2.16.840.1.113730.3", "directory" },
	{ "2.16.840.1.113730.3.1", "ldapDefinitions" },
	{ "2.16.840.1.113730.3.1.1", "carLicense" },
	{ "2.16.840.1.113730.3.1.2", "departmentNumber" },
	{ "2.16.840.1.113730.3.1.3", "employeeNumber" },
	{ "2.16.840.1.113730.3.1.4", "employeeType" },
	{ "2.16.840.1.113730.3.2.2", "inetOrgPerson" },
	{ "2.16.840.1.113730.4.1", "serverGatedCrypto" },
	{ "2.16.840.1.113733.1", "pki" },
	{ "2.16.840.1.113733.1.9", "pkcs7Attribute" },
	{ "2.16.840.1.113733.1.9.2", "messageType" },
	{ "2.16.840.1.113733.1.9.3", "pkiStatus" },
	{ "2.16.840.1.113733.1.9.4", "failInfo" },
	{ "2.16.840.1.113733.1.9.5", "senderNonce" },
	{ "2.16.840.1.113733.1.9.6", "recipientNonce" },
	{ "2.16.840.1.113733.1.9.7", "transID" },
	{ "2.16.840.1.113733.1.9.8", "extensionReq" },
	{ "2.16.840.1.113741.2", "intelCDSA" },
	{ "2.16.840.1.114027.10.4", "entrustAdminServicesClients" },
	{ "2.16.840.1.114027.10.5", "entrustAdminServicesServer" },
	{ "2.16.840.1.114027.80.2.1", "id-PKIXCMP-stdECDHwithX963SHA1" },
	{ "2.16.840.1.114027.80.2.1", "id-PKIXCMP-stdECDHwithX963SHA1" },
	{ "2.16.840.1.114412.1", "digiCertNonEVCerts" },
	{ "2.16.840.1.114412.1.1", "digiCertOVCert" },
	{ "2.16.840.1.114412.1.11", "digiCertFederatedDeviceCert" },
	{ "2.16.840.1.114412.1.2", "digiCertDVCert" },
	{ "2.16.840.1.114412.1.3.0.1", "digiCertGlobalCAPolicy" },
	{ "2.16.840.1.114412.1.3.0.2", "digiCertHighAssuranceEVCAPolicy" },
	{ "2.16.840.1.114412.1.3.0.3", "digiCertGlobalRootCAPolicy" },
	{ "2.16.840.1.114412.1.3.0.4", "digiCertAssuredIDRootCAPolicy" },
	{ "2.16.840.1.114412.2.2", "digiCertEVCert" },
	{ "2.16.840.1.114412.2.3", "digiCertObjectSigningCert" },
	{ "2.16.840.1.114412.2.3.1", "digiCertCodeSigningCert" },
	{ "2.16.840.1.114412.2.3.11", "digiCertKernelCodeSigningCert" },
	{ "2.16.840.1.114412.2.3.2", "digiCertEVCodeSigningCert" },
	{ "2.16.840.1.114412.2.3.21", "digiCertDocumentSigningCert" },
	{ "2.16.840.1.114412.2.4", "digiCertClientCert" },
	{ "2.16.840.1.114412.2.4.1.1", "digiCertLevel1PersonalClientCert" },
	{ "2.16.840.1.114412.2.4.1.2", "digiCertLevel1EnterpriseClientCert" },
	{ "2.16.840.1.114412.2.4.2", "digiCertLevel2ClientCert" },
	{ "2.16.840.1.114412.2.4.3.1", "digiCertLevel3USClientCert" },
	{ "2.16.840.1.114412.2.4.3.2", "digiCertLevel3CBPClientCert" },
	{ "2.16.840.1.114412.2.4.4.1", "digiCertLevel4USClientCert" },
	{ "2.16.840.1.114412.2.4.4.2", "digiCertLevel4CBPClientCert" },
	{ "2.16.840.1.114412.2.4.5.1", "digiCertPIVHardwareCert" },
	{ "2.16.840.1.114412.2.4.5.2", "digiCertPIVCardAuthCert" },
	{ "2.16.840.1.114412.2.4.5.3", "digiCertPIVContentSigningCert" },
	{ "2.16.840.1.114412.31.4.31.1", "digiCertGridHostCert" },
	{ "2.16.840.1.114412.4.31", "digiCertGridClassicCert" },
	{ "2.16.840.1.114412.4.31.5", "digiCertGridIntegratedCert" },
	{ "2.23.133", "tCPA" },
	{ "2.23.133.1", "tcpaSpecVersion" },
	{ "2.23.133.2", "tcpaAttribute" },
	{ "2.23.133.2.1", "tcpaTpmManufacturer" },
	{ "2.23.133.2.10", "tcpaSecurityQualities" },
	{ "2.23.133.2.11", "tcpaTpmProtectionProfile" },
	{ "2.23.133.2.12", "tcpaTpmSecurityTarget" },
	{ "2.23.133.2.13", "tcpaFoundationProtectionProfile" },
	{ "2.23.133.2.14", "tcpaFoundationSecurityTarget" },
	{ "2.23.133.2.15", "tcpaTpmIdLabel" },
	{ "2.23.133.2.2", "tcpaTpmModel" },
	{ "2.23.133.2.3", "tcpaTpmVersion" },
	{ "2.23.133.2.4", "tcpaPlatformManufacturer" },
	{ "2.23.133.2.5", "tcpaPlatformModel" },
	{ "2.23.133.2.6", "tcpaPlatformVersion" },
	{ "2.23.133.2.7", "tcpaComponentManufacturer" },
	{ "2.23.133.2.8", "tcpaComponentModel" },
	{ "2.23.133.2.9", "tcpaComponentVersion" },
	{ "2.23.133.3", "tcpaProtocol" },
	{ "2.23.133.3.1", "tcpaPrttTpmIdProtocol" },
	{ "2.23.134.1.2.1.8.210", "postSignumCommercialServerPolicy" },
	{ "2.23.134.1.2.2.3", "postSignumPublicCA." },
	{ "2.23.134.1.4.2.1", "postSignumRootQCA.." },
	{ "2.23.136.1.1.1", "mRTDSignatureData" },
	{ "2.23.136.1.1.3", "id-icao-cscaMasterListSigningKey" },
	{ "2.23.140.1.2", "baseline-requirements" },
	{ "2.23.140.1.2.1", "domain-validated" },
	{ "2.23.140.1.2.2", "subject-identity-validated" },
	{ "2.23.140.1.4", "code-signing-requirements" },
	{ "2.23.42.0", "contentType" },
	{ "2.23.42.0.0", "panData" },
	{ "2.23.42.0.1", "panToken" },
	{ "2.23.42.0.2", "panOnly" },
	{ "2.23.42.1", "msgExt" },
	{ "2.23.42.10", "national" },
	{ "2.23.42.10.392", "Japan" },
	{ "2.23.42.2", "field" },
	{ "2.23.42.2.0", "fullName" },
	{ "2.23.42.2.1", "givenName" },
	{ "2.23.42.2.10", "amount" },
	{ "2.23.42.2.11", "accountNumber" },
	{ "2.23.42.2.12", "passPhrase" },
	{ "2.23.42.2.2", "familyName" },
	{ "2.23.42.2.3", "birthFamilyName" },
	{ "2.23.42.2.4", "placeName" },
	{ "2.23.42.2.5", "identificationNumber" },
	{ "2.23.42.2.6", "month" },
	{ "2.23.42.2.7", "date" },
	{ "2.23.42.2.7.11", "accountNumber" },
	{ "2.23.42.2.7.12", "passPhrase" },
	{ "2.23.42.2.8", "address" },
	{ "2.23.42.2.9", "telephone" },
	{ "2.23.42.3", "attribute" },
	{ "2.23.42.3.0", "cert" },
	{ "2.23.42.3.0.0", "rootKeyThumb" },
	{ "2.23.42.3.0.1", "additionalPolicy" },
	{ "2.23.42.4", "algorithm" },
	{ "2.23.42.5", "policy" },
	{ "2.23.42.5.0", "root" },
	{ "2.23.42.6", "module" },
	{ "2.23.42.7", "certExt" },
	{ "2.23.42.7.0", "hashedRootKey" },
	{ "2.23.42.7.1", "certificateType" },
	{ "2.23.42.7.2", "merchantData" },
	{ "2.23.42.7.3", "cardCertRequired" },
	{ "2.23.42.7.4", "tunneling" },
	{ "2.23.42.7.5", "setExtensions" },
	{ "2.23.42.7.6", "setQualifier" },
	{ "2.23.42.8", "brand" },
	{ "2.23.42.8.1", "IATA-ATA" },
	{ "2.23.42.8.30", "Diners" },
	{ "2.23.42.8.34", "AmericanExpress" },
	{ "2.23.42.8.4", "VISA" },
	{ "2.23.42.8.5", "MasterCard" },
	{ "2.23.42.8.6011", "Novus" },
	{ "2.23.42.9", "vendor" },
	{ "2.23.42.9.0", "GlobeSet" },
	{ "2.23.42.9.1", "IBM" },
	{ "2.23.42.9.10", "Griffin" },
	{ "2.23.42.9.11", "Certicom" },
	{ "2.23.42.9.12", "OSS" },
	{ "2.23.42.9.13", "TenthMountain" },
	{ "2.23.42.9.14", "Antares" },
	{ "2.23.42.9.15", "ECC" },
	{ "2.23.42.9.16", "Maithean" },
	{ "2.23.42.9.17", "Netscape" },
	{ "2.23.42.9.18", "Verisign" },
	{ "2.23.42.9.19", "BlueMoney" },
	{ "2.23.42.9.2", "CyberCash" },
	{ "2.23.42.9.20", "Lacerte" },
	{ "2.23.42.9.21", "Fujitsu" },
	{ "2.23.42.9.22", "eLab" },
	{ "2.23.42.9.23", "Entrust" },
	{ "2.23.42.9.24", "VIAnet" },
	{ "2.23.42.9.25", "III" },
	{ "2.23.42.9.26", "OpenMarket" },
	{ "2.23.42.9.27", "Lexem" },
	{ "2.23.42.9.28", "Intertrader" },
	{ "2.23.42.9.29", "Persimmon" },
	{ "2.23.42.9.3", "Terisa" },
	{ "2.23.42.9.30", "NABLE" },
	{ "2.23.42.9.31", "espace-net" },
	{ "2.23.42.9.32", "Hitachi" },
	{ "2.23.42.9.33", "Microsoft" },
	{ "2.23.42.9.34", "NEC" },
	{ "2.23.42.9.35", "Mitsubishi" },
	{ "2.23.42.9.36", "NCR" },
	{ "2.23.42.9.37", "e-COMM" },
	{ "2.23.42.9.38", "Gemplus" },
	{ "2.23.42.9.4", "RSADSI" },
	{ "2.23.42.9.5", "VeriFone" },
	{ "2.23.42.9.6", "TrinTech" },
	{ "2.23.42.9.7", "BankGate" },
	{ "2.23.42.9.8", "GTE" },
	{ "2.23.42.9.9", "CompuSource" },
	{ "2.23.43.1.4", "wTLS-ECC" },
	{ "2.23.43.1.4.1", "wTLS-ECC-curve1" },
	{ "2.23.43.1.4.6", "wTLS-ECC-curve6" },
	{ "2.23.43.1.4.8", "wTLS-ECC-curve8" },
	{ "2.23.43.1.4.9", "wTLS-ECC-curve9" },
	{ "2.5.29.1", "authorityKeyIdentifier" },
	{ "2.5.29.10", "basicConstraints" },
	{ "2.5.29.11", "nameConstraints" },
	{ "2.5.29.12", "policyConstraints" },
	{ "2.5.29.13", "basicConstraints" },
	{ "2.5.29.14", "subjectKeyIdentifier" },
	{ "2.5.29.15", "keyUsage" },
	{ "2.5.29.16", "privateKeyUsagePeriod" },
	{ "2.5.29.17", "subjectAltName" },
	{ "2.5.29.18", "issuerAltName" },
	{ "2.5.29.19", "basicConstraints" },
	{ "2.5.29.2", "keyAttributes" },
	{ "2.5.29.20", "cRLNumber" },
	{ "2.5.29.21", "cRLReason" },
	{ "2.5.29.22", "expirationDate" },
	{ "2.5.29.23", "instructionCode" },
	{ "2.5.29.24", "invalidityDate" },
	{ "2.5.29.25", "cRLDistributionPoints" },
	{ "2.5.29.26", "issuingDistributionPoint" },
	{ "2.5.29.27", "deltaCRLIndicator" },
	{ "2.5.29.28", "issuingDistributionPoint" },
	{ "2.5.29.29", "certificateIssuer" },
	{ "2.5.29.3", "certificatePolicies" },
	{ "2.5.29.30", "nameConstraints" },
	{ "2.5.29.31", "cRLDistributionPoints" },
	{ "2.5.29.32", "certificatePolicies" },
	{ "2.5.29.32.0", "anyPolicy" },
	{ "2.5.29.33", "policyMappings" },
	{ "2.5.29.34", "policyConstraints" },
	{ "2.5.29.35", "authorityKeyIdentifier" },
	{ "2.5.29.36", "policyConstraints" },
	{ "2.5.29.37", "extKeyUsage" },
	{ "2.5.29.37.0", "anyExtendedKeyUsage" },
	{ "2.5.29.38", "authorityAttributeIdentifier" },
	{ "2.5.29.39", "roleSpecCertIdentifier" },
	{ "2.5.29.4", "keyUsageRestriction" },
	{ "2.5.29.40", "cRLStreamIdentifier" },
	{ "2.5.29.41", "basicAttConstraints" },
	{ "2.5.29.42", "delegatedNameConstraints" },
	{ "2.5.29.43", "timeSpecification" },
	{ "2.5.29.44", "cRLScope" },
	{ "2.5.29.45", "statusReferrals" },
	{ "2.5.29.46", "freshestCRL" },
	{ "2.5.29.47", "orderedList" },
	{ "2.5.29.48", "attributeDescriptor" },
	{ "2.5.29.49", "userNotice" },
	{ "2.5.29.5", "policyMapping" },
	{ "2.5.29.50", "sOAIdentifier" },
	{ "2.5.29.51", "baseUpdateTime" },
	{ "2.5.29.52", "acceptableCertPolicies" },
	{ "2.5.29.53", "deltaInfo" },
	{ "2.5.29.54", "inhibitAnyPolicy" },
	{ "2.5.29.55", "targetInformation" },
	{ "2.5.29.56", "noRevAvail" },
	{ "2.5.29.57", "acceptablePrivilegePolicies" },
	{ "2.5.29.58", "toBeRevoked" },
	{ "2.5.29.59", "revokedGroups" },
	{ "2.5.29.6", "subtreesConstraint" },
	{ "2.5.29.60", "expiredCertsOnCRL" },
	{ "2.5.29.61", "indirectIssuer" },
	{ "2.5.29.62", "noAssertion" },
	{ "2.5.29.63", "aAissuingDistributionPoint" },
	{ "2.5.29.64", "issuedOnBehalfOf" },
	{ "2.5.29.65", "singleUse" },
	{ "2.5.29.66", "groupAC" },
	{ "2.5.29.67", "allowedAttAss" },
	{ "2.5.29.68", "attributeMappings" },
	{ "2.5.29.69", "holderNameConstraints" },
	{ "2.5.29.7", "subjectAltName" },
	{ "2.5.29.8", "issuerAltName" },
	{ "2.5.29.9", "subjectDirectoryAttributes" },
	{ "2.5.4.0", "objectClass" },
	{ "2.5.4.1", "aliasedEntryName" },
	{ "2.5.4.10", "organizationName" },
	{ "2.5.4.10.1", "collectiveOrganizationName" },
	{ "2.5.4.11", "organizationalUnitName" },
	{ "2.5.4.11.1", "collectiveOrganizationalUnitName" },
	{ "2.5.4.12", "title" },
	{ "2.5.4.13", "description" },
	{ "2.5.4.14", "searchGuide" },
	{ "2.5.4.15", "businessCategory" },
	{ "2.5.4.16", "postalAddress" },
	{ "2.5.4.16.1", "collectivePostalAddress" },
	{ "2.5.4.17", "postalCode" },
	{ "2.5.4.17.1", "collectivePostalCode" },
	{ "2.5.4.18", "postOfficeBox" },
	{ "2.5.4.18.1", "collectivePostOfficeBox" },
	{ "2.5.4.19", "physicalDeliveryOfficeName" },
	{ "2.5.4.19.1", "collectivePhysicalDeliveryOfficeName" },
	{ "2.5.4.2", "knowledgeInformation" },
	{ "2.5.4.20", "telephoneNumber" },
	{ "2.5.4.20.1", "collectiveTelephoneNumber" },
	{ "2.5.4.21", "telexNumber" },
	{ "2.5.4.21.1", "collectiveTelexNumber" },
	{ "2.5.4.22", "teletexTerminalIdentifier" },
	{ "2.5.4.22.1", "collectiveTeletexTerminalIdentifier" },
	{ "2.5.4.23", "facsimileTelephoneNumber" },
	{ "2.5.4.23.1", "collectiveFacsimileTelephoneNumber" },
	{ "2.5.4.24", "x121Address" },
	{ "2.5.4.25", "internationalISDNNumber" },
	{ "2.5.4.25.1", "collectiveInternationalISDNNumber" },
	{ "2.5.4.26", "registeredAddress" },
	{ "2.5.4.27", "destinationIndicator" },
	{ "2.5.4.28", "preferredDeliveryMehtod" },
	{ "2.5.4.29", "presentationAddress" },
	{ "2.5.4.3", "commonName" },
	{ "2.5.4.30", "supportedApplicationContext" },
	{ "2.5.4.31", "member" },
	{ "2.5.4.32", "owner" },
	{ "2.5.4.33", "roleOccupant" },
	{ "2.5.4.34", "seeAlso" },
	{ "2.5.4.35", "userPassword" },
	{ "2.5.4.36", "userCertificate" },
	{ "2.5.4.37", "caCertificate" },
	{ "2.5.4.38", "authorityRevocationList" },
	{ "2.5.4.39", "certificateRevocationList" },
	{ "2.5.4.4", "surname" },
	{ "2.5.4.40", "crossCertificatePair" },
	{ "2.5.4.41", "name" },
	{ "2.5.4.42", "givenName" },
	{ "2.5.4.43", "initials" },
	{ "2.5.4.44", "generationQualifier" },
	{ "2.5.4.45", "uniqueIdentifier" },
	{ "2.5.4.46", "dnQualifier" },
	{ "2.5.4.47", "enhancedSearchGuide" },
	{ "2.5.4.48", "protocolInformation" },
	{ "2.5.4.49", "distinguishedName" },
	{ "2.5.4.5", "serialNumber" },
	{ "2.5.4.50", "uniqueMember" },
	{ "2.5.4.51", "houseIdentifier" },
	{ "2.5.4.52", "supportedAlgorithms" },
	{ "2.5.4.53", "deltaRevocationList" },
	{ "2.5.4.54", "dmdName" },
	{ "2.5.4.55", "clearance" },
	{ "2.5.4.56", "defaultDirQop" },
	{ "2.5.4.57", "attributeIntegrityInfo" },
	{ "2.5.4.58", "attributeCertificate" },
	{ "2.5.4.59", "attributeCertificateRevocationList" },
	{ "2.5.4.6", "countryName" },
	{ "2.5.4.60", "confKeyInfo" },
	{ "2.5.4.61", "aACertificate" },
	{ "2.5.4.62", "attributeDescriptorCertificate" },
	{ "2.5.4.63", "attributeAuthorityRevocationList" },
	{ "2.5.4.64", "familyInformation" },
	{ "2.5.4.65", "pseudonym" },
	{ "2.5.4.66", "communicationsService" },
	{ "2.5.4.67", "communicationsNetwork" },
	{ "2.5.4.68", "certificationPracticeStmt" },
	{ "2.5.4.69", "certificatePolicy" },
	{ "2.5.4.7", "localityName" },
	{ "2.5.4.7.1", "collectiveLocalityName" },
	{ "2.5.4.70", "pkiPath" },
	{ "2.5.4.71", "privPolicy" },
	{ "2.5.4.72", "role" },
	{ "2.5.4.73", "delegationPath" },
	{ "2.5.4.74", "protPrivPolicy" },
	{ "2.5.4.75", "xMLPrivilegeInfo" },
	{ "2.5.4.76", "xmlPrivPolicy" },
	{ "2.5.4.8", "stateOrProvinceName" },
	{ "2.5.4.8.1", "collectiveStateOrProvinceName" },
	{ "2.5.4.82", "permission" },
	{ "2.5.4.9", "streetAddress" },
	{ "2.5.4.9.1", "collectiveStreetAddress" },
	{ "2.5.6.0", "top" },
	{ "2.5.6.1", "alias" },
	{ "2.5.6.10", "residentialPerson" },
	{ "2.5.6.11", "applicationProcess" },
	{ "2.5.6.12", "applicationEntity" },
	{ "2.5.6.13", "dSA" },
	{ "2.5.6.14", "device" },
	{ "2.5.6.15", "strongAuthenticationUser" },
	{ "2.5.6.16", "certificateAuthority" },
	{ "2.5.6.17", "groupOfUniqueNames" },
	{ "2.5.6.19", "cRLDistributionPoint" },
	{ "2.5.6.2", "country" },
	{ "2.5.6.21", "pkiUser" },
	{ "2.5.6.22", "pkiCA" },
	{ "2.5.6.3", "locality" },
	{ "2.5.6.4", "organization" },
	{ "2.5.6.5", "organizationalUnit" },
	{ "2.5.6.6", "person" },
	{ "2.5.6.7", "organizationalPerson" },
	{ "2.5.6.8", "organizationalRole" },
	{ "2.5.6.9", "groupOfNames" },
	{ "2.5.8", "X.500-Algorithms" },
	{ "2.5.8.1", "X.500-Alg-Encryption" },
	{ "2.5.8.1.1", "rsa" },
	{ "2.5.8.2.1", "sqMod_n" },
	{ "2.5.8.3.1", "sqMod_nWithRSA" },
	{ "2.54.1775.2", "hashedRootKey" },
	{ "2.54.1775.3", "certificateType" },
	{ "2.54.1775.4", "merchantData" },
	{ "2.54.1775.5", "cardCertRequired" },
	{ "2.54.1775.6", "tunneling" },
	{ "2.54.1775.7", "setQualifier" },
	{ "2.54.1775.99", "setData" },
	{ 0, 0 }
};

#endif /* RZ_OIDS_H */
