#ifndef __SOURCE4_TORTURE_SMB2_PROTO_H__
#define __SOURCE4_TORTURE_SMB2_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/torture/smb2/acls.c  */

struct torture_suite *torture_smb2_acls_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_acls_non_canonical_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/attr.c  */

bool torture_smb2_openattrtest(struct torture_context *tctx,
			       struct smb2_tree *tree);
bool torture_smb2_winattrtest(struct torture_context *tctx,
			      struct smb2_tree *tree);
bool torture_smb2_winattr2(struct torture_context *tctx,
			   struct smb2_tree *tree);
bool torture_smb2_sdreadtest(struct torture_context *tctx,
			      struct smb2_tree *tree);

/* The following definitions come from ../../source4/torture/smb2/block.c  */

uint16_t torture_get_local_port_from_transport(struct smb2_transport *t);
bool torture_block_tcp_output_port(struct torture_context *tctx,
				   const char *name,
				   uint16_t port);
bool torture_unblock_tcp_output_port(struct torture_context *tctx,
				     const char *name,
				     uint16_t port);
bool torture_block_tcp_output_setup(struct torture_context *tctx);
bool torture_unblock_tcp_output_cleanup(struct torture_context *tctx);
bool _test_block_smb2_transport(struct torture_context *tctx,
				struct smb2_transport *transport,
				const char *name);
bool _test_unblock_smb2_transport(struct torture_context *tctx,
				  struct smb2_transport *transport,
				  const char *name);
bool test_setup_blocked_transports(struct torture_context *tctx);
void test_cleanup_blocked_transports(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/smb2/bench.c  */

bool test_smb2_bench_path_contention_shared(struct torture_context *tctx,
					    struct smb2_tree *tree);
struct torture_suite *torture_smb2_bench_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/charset.c  */

struct torture_suite *torture_smb2_charset(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/smb2/compound.c  */

struct torture_suite *torture_smb2_compound_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_compound_find_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_compound_async_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/connect.c  */

NTSTATUS torture_smb2_createfile(struct torture_context *tctx,
				 struct smb2_tree *tree,
				 const char *fname,
				 struct smb2_handle *handle);
bool torture_smb2_connect(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/smb2/create.c  */


/**
  Find Maximum Path Length
 */
struct torture_suite *torture_smb2_create_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_twrp_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_fileid_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_create_no_streams_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/credits.c  */


/**
 * Request 64K credits in a single SMB2 request and requite at least 8192
 *
 * This passes against Windows 2016
 **/
struct torture_suite *torture_smb2_crediting_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/delete-on-close.c  */

struct torture_suite *torture_smb2_doc_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/deny.c  */

struct torture_suite *torture_smb2_deny_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/dir.c  */

NTSTATUS torture_single_file_search(struct smb2_tree *tree,
				    TALLOC_CTX *mem_ctx,
				    const char *pattern,
				    uint8_t level,
				    enum smb_search_data_level data_level,
				    int idx,
				    union smb_search_data *d,
				    unsigned int *count,
				    struct smb2_handle *h);
bool fill_result(void *private_data,
		 union smb_search_data *file,
		 int count,
		 uint8_t level,
		 enum smb_search_data_level data_level);
struct torture_suite *torture_smb2_dir_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/dosmode.c  */

bool torture_smb2_dosmode(struct torture_context *tctx);
bool torture_smb2_async_dosmode(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/smb2/durable_open.c  */


/**
 * lease variant of reopen1a
 *
 * Basic test for doing a durable open and doing a session
 * reconnect while the first session is still active and the
 * handle is still open in the client.
 * This closes the original session and  a durable reconnect on
 * the new session succeeds depending on the client guid:
 *
 * Durable reconnect on a session with a different client guid fails.
 * Durable reconnect on a session with the original client guid succeeds.
 */
bool test_durable_open_reopen1a_lease(struct torture_context *tctx,
				      struct smb2_tree *tree);

/**
 * durable stat open with lease.
 */
struct torture_suite *torture_smb2_durable_open_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_durable_open_disconnect_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/durable_v2_open.c  */


/**
 * testing various create blob combinations.
 */
bool test_durable_v2_open_create_blob(struct torture_context *tctx,
				      struct smb2_tree *tree);

/**
 * basic durable_open test.
 * durable state should only be granted when requested
 * along with a batch oplock or a handle lease.
 *
 * This test tests durable open with all possible oplock types.
 */
bool test_durable_v2_open_oplock(struct torture_context *tctx,
				 struct smb2_tree *tree);

/**
 * basic durable handle open test.
 * persistent state should only be granted when requested
 * along with a batch oplock or a handle lease.
 *
 * This test tests persistent open with all valid lease types.
 */
bool test_durable_v2_open_lease(struct torture_context *tctx,
				struct smb2_tree *tree);

/**
 * basic test for doing a durable open
 * and do a durable reopen on the same connection
 * while the first open is still active (fails)
 */
bool test_durable_v2_open_reopen1(struct torture_context *tctx,
				  struct smb2_tree *tree);

/**
 * Basic test for doing a durable open
 * and do a session reconnect while the first
 * session is still active and the handle is
 * still open in the client.
 * This closes the original session and  a
 * durable reconnect on the new session succeeds.
 */
bool test_durable_v2_open_reopen1a(struct torture_context *tctx,
				   struct smb2_tree *tree);

/**
 * lease variant of reopen1a
 *
 * Basic test for doing a durable open and doing a session
 * reconnect while the first session is still active and the
 * handle is still open in the client.
 * This closes the original session and  a durable reconnect on
 * the new session succeeds depending on the client guid:
 *
 * Durable reconnect on a session with a different client guid fails.
 * Durable reconnect on a session with the original client guid succeeds.
 */
bool test_durable_v2_open_reopen1a_lease(struct torture_context *tctx,
					 struct smb2_tree *tree);

/**
 * basic test for doing a durable open
 * tcp disconnect, reconnect, do a durable reopen (succeeds)
 */
bool test_durable_v2_open_reopen2(struct torture_context *tctx,
				  struct smb2_tree *tree);

/**
 * durable reconnect test:
 * connect with v2, reconnect with v1
 */
bool test_durable_v2_open_reopen2b(struct torture_context *tctx,
				   struct smb2_tree *tree);

/**
 * durable reconnect test:
 * connect with v1, reconnect with v2 : fails (no create_guid...)
 */
bool test_durable_v2_open_reopen2c(struct torture_context *tctx,
				   struct smb2_tree *tree);

/**
 * lease variant of reopen2
 * basic test for doing a durable open
 * tcp disconnect, reconnect, do a durable reopen (succeeds)
 */
bool test_durable_v2_open_reopen2_lease(struct torture_context *tctx,
					struct smb2_tree *tree);

/**
 * lease_v2 variant of reopen2
 * basic test for doing a durable open
 * tcp disconnect, reconnect, do a durable reopen (succeeds)
 */
bool test_durable_v2_open_reopen2_lease_v2(struct torture_context *tctx,
					   struct smb2_tree *tree);

/**
 * Test durable request / reconnect with AppInstanceId
 */
bool test_durable_v2_open_app_instance(struct torture_context *tctx,
				       struct smb2_tree *tree1,
				       struct smb2_tree *tree2);

/**
 * basic persistent open test.
 *
 * This test tests durable open with all possible oplock types.
 */
bool test_persistent_open_oplock(struct torture_context *tctx,
				 struct smb2_tree *tree);

/**
 * basic persistent handle open test.
 * persistent state should only be granted when requested
 * along with a batch oplock or a handle lease.
 *
 * This test tests persistent open with all valid lease types.
 */
bool test_persistent_open_lease(struct torture_context *tctx,
				struct smb2_tree *tree);

/**
 * setfileinfo test for doing a durable open
 * create the file with lease and durable handle,
 * write to it (via set end-of-file), tcp disconnect,
 * reconnect, do a durable reopen - should succeed.
 *
 * BUG: https://bugzilla.samba.org/show_bug.cgi?id=15022
 */
bool test_durable_v2_setinfo(struct torture_context *tctx,
					   struct smb2_tree *tree);
struct torture_suite *torture_smb2_durable_v2_open_init(TALLOC_CTX *ctx);

/**
 * basic test for doing a durable open
 * tcp disconnect, reconnect, do a durable reopen (succeeds)
 */
struct torture_suite *torture_smb2_durable_v2_delay_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_durable_v2_regressions_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/ea.c  */

struct torture_suite *torture_smb2_ea(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/getinfo.c  */

struct torture_suite *torture_smb2_getinfo_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/ioctl.c  */


/**
 * Create a file
 **/
bool test_ioctl_set_sparse(struct torture_context *tctx);
bool test_ioctl_alternate_data_stream(struct torture_context *tctx);
bool test_ioctl_zero_data(struct torture_context *tctx);
struct torture_suite *torture_smb2_ioctl_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/lease.c  */


/**
 * upgrade3:
 * full matrix of lease upgrade combinations
 * (contended case)
 *
 * We start with 2 leases, and check how one can
 * be upgraded
 *
 * The summary of the behaviour is this:
 * -------------------------------------
 *
 * If we have two leases (lease1 and lease2) on the same file,
 * then attempt to upgrade lease1 results in a change if and only
 * if the requested lease state:
 * - is valid,
 * - is strictly a superset of lease1, and
 * - can held together with lease2.
 *
 * In that case, the resulting lease state of the upgraded lease1
 * is the state requested in the upgrade. lease2 is not broken
 * and remains unchanged.
 *
 * Note that this contrasts the case of directly opening with
 * an initial requested lease state, in which case you get that
 * portion of the requested state that can be shared with the
 * already existing leases (or the states that they get broken to).
 */
struct torture_suite *torture_smb2_lease_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_dirlease_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/lease_break_handler.c  */

bool torture_lease_handler(struct smb2_transport *transport,
			   const struct smb2_lease_break *lb,
			   void *private_data);
void torture_wait_for_lease_break(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/smb2/lock.c  */


/**
 * Test lock interaction between smbd and ctdb with tombstone records.
 *
 * Re-locking an unlocked record could lead to a deadlock between
 * smbd and ctdb. Make sure we don't regress.
 *
 * https://bugzilla.samba.org/show_bug.cgi?id=12005
 * https://bugzilla.samba.org/show_bug.cgi?id=10008
 */
struct torture_suite *torture_smb2_lock_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/max_allowed.c  */

struct torture_suite *torture_smb2_max_allowed(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/mangle.c  */

struct torture_suite *torture_smb2_name_mangling_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/maxfid.c  */

bool torture_smb2_maxfid(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/smb2/maxwrite.c  */

bool torture_smb2_maxwrite(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/smb2/mkdir.c  */

bool torture_smb2_mkdir(struct torture_context *tctx, struct smb2_tree *tree);

/* The following definitions come from ../../source4/torture/smb2/multichannel.c  */

bool test_multichannel_create_channel_array(
				struct torture_context *tctx,
				const char *host,
				const char *share,
				struct cli_credentials *credentials,
				struct smbcli_options *transport_options,
				uint8_t num_trees,
				struct smb2_tree **trees);
bool test_multichannel_create_channels(
				struct torture_context *tctx,
				const char *host,
				const char *share,
				struct cli_credentials *credentials,
				struct smbcli_options *transport_options,
				struct smb2_tree **tree2A,
				struct smb2_tree **tree2B,
				struct smb2_tree **tree2C
				);
struct torture_suite *torture_smb2_multichannel_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/oplock_break_handler.c  */


/**
 * A general oplock break notification handler.  This should be used when a
 * test expects to break from batch or exclusive to a lower level.
 */
bool torture_oplock_ack_handler(struct smb2_transport *transport,
				const struct smb2_handle *handle,
				uint8_t level,
				void *private_data);

/**
 * A oplock break handler designed to ignore incoming break requests.
 * This is used when incoming oplock break requests need to be ignored
 */
bool torture_oplock_ignore_handler(struct smb2_transport *transport,
				   const struct smb2_handle *handle,
				   uint8_t level, void *private_data);
void torture_wait_for_oplock_break(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/smb2/notify.c  */

struct torture_suite *torture_smb2_notify_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_notify_inotify_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/notify_disabled.c  */

struct torture_suite *torture_smb2_notify_disabled_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/oplock.c  */

struct torture_suite *torture_smb2_oplocks_init(TALLOC_CTX *ctx);
bool test_smb2_bench_oplock(struct torture_context *tctx,
				   struct smb2_tree *tree);
bool test_smb2_hold_oplock(struct torture_context *tctx,
			   struct smb2_tree *tree);

/**
 * Recreate regression test from bug:
 *
 * https://bugzilla.samba.org/show_bug.cgi?id=13058
 *
 * 1. smbd-1 opens the file and sets the oplock
 * 2. smbd-2 tries to open the file. open() fails(EAGAIN) and open is deferred.
 * 3. smbd-1 sends oplock break request to the client.
 * 4. smbd-1 closes the file.
 * 5. smbd-1 opens the file and sets the oplock.
 * 6. smbd-2 calls defer_open_done(), and should re-break the oplock.
 **/
struct torture_suite *torture_smb2_kernel_oplocks_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/read.c  */

struct torture_suite *torture_smb2_read_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_aio_delay_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/read_write.c  */

struct torture_suite *torture_smb2_readwrite_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/rename.c  */

struct torture_suite *torture_smb2_rename_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/replay.c  */


/**
 * Test Error Codes when a DurableHandleReqV2 with matching CreateGuid is
 * re-sent with or without SMB2_FLAGS_REPLAY_OPERATION
 */
struct torture_suite *torture_smb2_replay_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/scan.c  */

struct torture_suite *torture_smb2_scan_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/secleak.c  */

bool torture_smb2_sec_leak(struct torture_context *tctx, struct smb2_tree *tree);

/* The following definitions come from ../../source4/torture/smb2/session.c  */


/**
 * basic test for doing a session reconnect
 */
bool test_session_reconnect1(struct torture_context *tctx, struct smb2_tree *tree);

/**
 * basic test for doing a session reconnect on one connection
 */
bool test_session_reconnect2(struct torture_context *tctx, struct smb2_tree *tree);
bool test_session_reauth1(struct torture_context *tctx, struct smb2_tree *tree);
bool test_session_reauth2(struct torture_context *tctx, struct smb2_tree *tree);

/**
 * test getting security descriptor after reauth
 */
bool test_session_reauth3(struct torture_context *tctx, struct smb2_tree *tree);

/**
 * test setting security descriptor after reauth.
 */
bool test_session_reauth4(struct torture_context *tctx, struct smb2_tree *tree);

/**
 * test renaming after reauth.
 * compare security descriptors before and after rename/reauth
 */
bool test_session_reauth5(struct torture_context *tctx, struct smb2_tree *tree);

/**
 * do reauth with wrong credentials,
 * hence triggering the error path in reauth.
 * The invalid reauth deletes the session.
 */
bool test_session_reauth6(struct torture_context *tctx, struct smb2_tree *tree);
bool test_session_bind1(struct torture_context *tctx, struct smb2_tree *tree1);
struct torture_suite *torture_smb2_session_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_session_req_sign_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/sessid.c  */


/**
  Try with a wrong session id and check error message.
 */
bool run_sessidtest(struct torture_context *tctx, struct smb2_tree *tree);

/* The following definitions come from ../../source4/torture/smb2/setinfo.c  */

bool torture_smb2_setinfo(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/smb2/sharemode.c  */

bool torture_smb2_hold_sharemode(struct torture_context *tctx);
bool torture_smb2_check_sharemode(struct torture_context *tctx);
struct torture_suite *torture_smb2_sharemode_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/smb2.c  */

struct torture_test *torture_suite_add_1smb2_test(struct torture_suite *suite,
						  const char *name,
						  bool (*run)(struct torture_context *,
							      struct smb2_tree *));
struct torture_test *torture_suite_add_2smb2_test(struct torture_suite *suite,
						  const char *name,
						  bool (*run)(struct torture_context *,
							      struct smb2_tree *,
							      struct smb2_tree *));
NTSTATUS torture_smb2_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/streams.c  */

bool test_stream_inherit_perms(struct torture_context *tctx,
			       struct smb2_tree *tree);
struct torture_suite *torture_smb2_streams_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/samba3misc.c  */

struct torture_suite *torture_smb2_samba3misc_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/tcon.c  */


/**
  this checks to see if a secondary tconx can use open files from an
  earlier tconx
 */
bool run_tcon_test(struct torture_context *tctx, struct smb2_tree *tree);

/* The following definitions come from ../../source4/torture/smb2/timestamps.c  */

struct torture_suite *torture_smb2_timestamps_init(TALLOC_CTX *ctx);
struct torture_suite *torture_smb2_timestamp_resolution_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/smb2/util.c  */

NTSTATUS smb2_util_write(struct smb2_tree *tree,
			 struct smb2_handle handle, 
			 const void *buf, off_t offset, size_t size);
NTSTATUS smb2_create_complex_file(struct torture_context *tctx,
				  struct smb2_tree *tree, const char *fname,
				  struct smb2_handle *handle);
NTSTATUS smb2_create_complex_dir(struct torture_context *tctx,
				 struct smb2_tree *tree, const char *fname,
				 struct smb2_handle *handle);
void torture_smb2_all_info(struct torture_context *tctx,
			   struct smb2_tree *tree, struct smb2_handle handle);
NTSTATUS torture_smb2_get_allinfo_access(struct smb2_tree *tree,
					 struct smb2_handle handle,
					 uint32_t *granted_access);

/**
 * open a smb2 tree connect
 */
bool torture_smb2_tree_connect(struct torture_context *tctx,
			       struct smb2_session *session,
			       TALLOC_CTX *mem_ctx,
			       struct smb2_tree **_tree);

/**
 * do a smb2 session setup (without a tree connect)
 */
bool torture_smb2_session_setup(struct torture_context *tctx,
				struct smb2_transport *transport,
				uint64_t previous_session_id,
				TALLOC_CTX *mem_ctx,
				struct smb2_session **_session);
bool torture_smb2_connection_ext(struct torture_context *tctx,
				 uint64_t previous_session_id,
				 const struct smbcli_options *options,
				 struct smb2_tree **tree);
bool torture_smb2_connection(struct torture_context *tctx, struct smb2_tree **tree);

/**
 * SMB2 connect with share from soption
 **/
bool torture_smb2_con_share(struct torture_context *tctx,
			    const char *share,
			    struct smb2_tree **tree);

/**
 * SMB2 connect with share from soption
 **/
bool torture_smb2_con_sopt(struct torture_context *tctx,
			   const char *soption,
			   struct smb2_tree **tree);
NTSTATUS torture_smb2_testfile_access(struct smb2_tree *tree, const char *fname,
				      struct smb2_handle *handle,
				      uint32_t desired_access);
NTSTATUS torture_smb2_testfile(struct smb2_tree *tree, const char *fname,
			       struct smb2_handle *handle);
NTSTATUS torture_smb2_open(struct smb2_tree *tree,
			   const char *fname,
			   uint32_t desired_access,
			   struct smb2_handle *handle);
NTSTATUS torture_smb2_testdir_access(struct smb2_tree *tree, const char *fname,
				     struct smb2_handle *handle,
				     uint32_t desired_access);
NTSTATUS torture_smb2_testdir(struct smb2_tree *tree, const char *fname,
			      struct smb2_handle *handle);
NTSTATUS smb2_create_simple_file(struct torture_context *tctx,
				 struct smb2_tree *tree, const char *fname,
				 struct smb2_handle *handle);
NTSTATUS torture_setup_simple_file(struct torture_context *tctx,
				   struct smb2_tree *tree, const char *fname);
NTSTATUS torture_setup_complex_file(struct torture_context *tctx,
				    struct smb2_tree *tree, const char *fname);
NTSTATUS torture_setup_complex_dir(struct torture_context *tctx,
				   struct smb2_tree *tree, const char *fname);
NTSTATUS smb2_util_roothandle(struct smb2_tree *tree, struct smb2_handle *handle);
bool smb2_util_setup_dir(struct torture_context *tctx, struct smb2_tree *tree,
    const char *dname);
bool smb2_util_verify_sd(TALLOC_CTX *tctx, struct smb2_tree *tree,
    struct smb2_handle handle, struct security_descriptor *sd);
bool smb2_util_verify_attrib(TALLOC_CTX *tctx, struct smb2_tree *tree,
    struct smb2_handle handle, uint32_t attrib);
uint32_t smb2_util_lease_state(const char *ls);
char *smb2_util_lease_state_string(TALLOC_CTX *mem_ctx, uint32_t ls);
uint32_t smb2_util_share_access(const char *sharemode);
uint8_t smb2_util_oplock_level(const char *op);

/**
 * Helper functions to fill a smb2_create struct for several
 * open scenarios.
 */
void smb2_generic_create_share(struct smb2_create *io, struct smb2_lease *ls,
			       bool dir, const char *name, uint32_t disposition,
			       uint32_t share_access,
			       uint8_t oplock, uint64_t leasekey,
			       uint32_t leasestate);
void smb2_generic_create(struct smb2_create *io, struct smb2_lease *ls,
			 bool dir, const char *name, uint32_t disposition,
			 uint8_t oplock, uint64_t leasekey,
			 uint32_t leasestate);
void smb2_lease_create_share(struct smb2_create *io, struct smb2_lease *ls,
			     bool dir, const char *name, uint32_t share_access,
			     uint64_t leasekey, uint32_t leasestate);
void smb2_lease_create(struct smb2_create *io, struct smb2_lease *ls,
		       bool dir, const char *name, uint64_t leasekey,
		       uint32_t leasestate);
void smb2_lease_v2_create_share(struct smb2_create *io,
				struct smb2_lease *ls,
				bool dir,
				const char *name,
				uint32_t share_access,
				uint64_t leasekey,
				const uint64_t *parentleasekey,
				uint32_t leasestate,
				uint16_t lease_epoch);
void smb2_lease_v2_create(struct smb2_create *io,
			  struct smb2_lease *ls,
			  bool dir,
			  const char *name,
			  uint64_t leasekey,
			  const uint64_t *parentleasekey,
			  uint32_t leasestate,
			  uint16_t lease_epoch);
void smb2_oplock_create_share(struct smb2_create *io, const char *name,
			      uint32_t share_access, uint8_t oplock);
void smb2_oplock_create(struct smb2_create *io, const char *name, uint8_t oplock);
NTSTATUS torture_smb2_check_privilege(struct smb2_tree *tree,
				     const char *sid_str,
				     const char *privilege);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_TORTURE_SMB2_PROTO_H__ */

