/* EntryMultiCompletion.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from EntryMultiCompletion.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Entry completion for values separated by separators (e.g. comma in the case of tags)*/
/* Partly inspired by the class of the same name in gtkmm-utils by Marko Anastasov*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENTRY_MULTI_COMPLETION (entry_multi_completion_get_type ())
#define ENTRY_MULTI_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion))
#define ENTRY_MULTI_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletionClass))
#define IS_ENTRY_MULTI_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENTRY_MULTI_COMPLETION))
#define IS_ENTRY_MULTI_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENTRY_MULTI_COMPLETION))
#define ENTRY_MULTI_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletionClass))

typedef struct _EntryMultiCompletion EntryMultiCompletion;
typedef struct _EntryMultiCompletionClass EntryMultiCompletionClass;
typedef struct _EntryMultiCompletionPrivate EntryMultiCompletionPrivate;
enum  {
	ENTRY_MULTI_COMPLETION_0_PROPERTY,
	ENTRY_MULTI_COMPLETION_NUM_PROPERTIES
};
static GParamSpec* entry_multi_completion_properties[ENTRY_MULTI_COMPLETION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EntryMultiCompletion {
	GtkEntryCompletion parent_instance;
	EntryMultiCompletionPrivate * priv;
};

struct _EntryMultiCompletionClass {
	GtkEntryCompletionClass parent_class;
};

struct _EntryMultiCompletionPrivate {
	gchar* delimiter;
};

static gint EntryMultiCompletion_private_offset;
static gpointer entry_multi_completion_parent_class = NULL;

VALA_EXTERN GType entry_multi_completion_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EntryMultiCompletion, g_object_unref)
VALA_EXTERN EntryMultiCompletion* entry_multi_completion_new (GeeCollection* completion_list,
                                                  const gchar* delimiter);
VALA_EXTERN EntryMultiCompletion* entry_multi_completion_construct (GType object_type,
                                                        GeeCollection* completion_list,
                                                        const gchar* delimiter);
static GtkListStore* entry_multi_completion_create_completion_store (GeeCollection* completion_list);
static gboolean entry_multi_completion_match_func (EntryMultiCompletion* self,
                                            GtkEntryCompletion* completion,
                                            const gchar* key,
                                            GtkTreeIter* iter);
static gboolean _entry_multi_completion_match_func_gtk_entry_completion_match_func (GtkEntryCompletion* completion,
                                                                             const gchar* key,
                                                                             GtkTreeIter* iter,
                                                                             gpointer self);
static gchar* entry_multi_completion_get_last_part (const gchar* s,
                                             const gchar* delimiter);
static gboolean entry_multi_completion_real_match_selected (GtkEntryCompletion* base,
                                                     GtkTreeModel* model,
                                                     GtkTreeIter* iter);
static void entry_multi_completion_finalize (GObject * obj);
static GType entry_multi_completion_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
entry_multi_completion_get_instance_private (EntryMultiCompletion* self)
{
	return G_STRUCT_MEMBER_P (self, EntryMultiCompletion_private_offset);
}

static gboolean
_entry_multi_completion_match_func_gtk_entry_completion_match_func (GtkEntryCompletion* completion,
                                                                    const gchar* key,
                                                                    GtkTreeIter* iter,
                                                                    gpointer self)
{
	gboolean result;
	result = entry_multi_completion_match_func ((EntryMultiCompletion*) self, completion, key, iter);
	return result;
}

EntryMultiCompletion*
entry_multi_completion_construct (GType object_type,
                                  GeeCollection* completion_list,
                                  const gchar* delimiter)
{
	EntryMultiCompletion * self = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	GtkListStore* _tmp4_;
	GtkListStore* _tmp5_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (completion_list, GEE_TYPE_COLLECTION), NULL);
	self = (EntryMultiCompletion*) g_object_new (object_type, NULL);
	if (delimiter == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (delimiter);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 1;
	}
	_vala_assert (_tmp0_, "delimiter == null || delimiter.length == 1");
	_tmp3_ = g_strdup (delimiter);
	_g_free0 (self->priv->delimiter);
	self->priv->delimiter = _tmp3_;
	_tmp4_ = entry_multi_completion_create_completion_store (completion_list);
	_tmp5_ = _tmp4_;
	gtk_entry_completion_set_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_tree_model_get_type (), GtkTreeModel));
	_g_object_unref0 (_tmp5_);
	gtk_entry_completion_set_text_column (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), 0);
	gtk_entry_completion_set_match_func (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), _entry_multi_completion_match_func_gtk_entry_completion_match_func, g_object_ref (self), g_object_unref);
	return self;
}

EntryMultiCompletion*
entry_multi_completion_new (GeeCollection* completion_list,
                            const gchar* delimiter)
{
	return entry_multi_completion_construct (TYPE_ENTRY_MULTI_COMPLETION, completion_list, delimiter);
}

static GtkListStore*
entry_multi_completion_create_completion_store (GeeCollection* completion_list)
{
	GtkListStore* completion_store = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter store_iter = {0};
	GeeIterator* completion_iter = NULL;
	GeeIterator* _tmp1_;
	GtkListStore* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (completion_list, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
	completion_store = _tmp0_;
	_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (completion_list, GEE_TYPE_ITERABLE, GeeIterable));
	completion_iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_;
		GtkTreeIter _tmp6_;
		GeeIterator* _tmp7_;
		gpointer _tmp8_;
		gchar* _tmp9_;
		_tmp2_ = completion_iter;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = completion_store;
		gtk_list_store_append (_tmp3_, &_tmp4_);
		store_iter = _tmp4_;
		_tmp5_ = completion_store;
		_tmp6_ = store_iter;
		_tmp7_ = completion_iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		_tmp9_ = (gchar*) _tmp8_;
		gtk_list_store_set (_tmp5_, &_tmp6_, 0, _tmp9_, -1, -1);
		_g_free0 (_tmp9_);
	}
	result = completion_store;
	_g_object_unref0 (completion_iter);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
entry_multi_completion_match_func (EntryMultiCompletion* self,
                                   GtkEntryCompletion* completion,
                                   const gchar* key,
                                   GtkTreeIter* iter)
{
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	gchar* possible_match = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* normed_key = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean result;
	g_return_val_if_fail (IS_ENTRY_MULTI_COMPLETION (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (completion, gtk_entry_completion_get_type ()), FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = gtk_entry_completion_get_model (completion);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = *iter;
	gtk_tree_model_get (_tmp2_, &_tmp3_, 0, &_tmp4_, -1);
	_g_free0 (possible_match);
	possible_match = _tmp4_;
	_tmp5_ = possible_match;
	_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_normalize (_tmp7_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
	_g_free0 (possible_match);
	possible_match = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = g_utf8_normalize (key, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
	normed_key = _tmp9_;
	_tmp10_ = self->priv->delimiter;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp11_ = possible_match;
		_tmp12_ = normed_key;
		_tmp13_ = string_strip (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_str_has_prefix (_tmp11_, _tmp14_);
		_g_free0 (_tmp14_);
		result = _tmp15_;
		_g_free0 (normed_key);
		_g_free0 (possible_match);
		_g_object_unref0 (model);
		return result;
	} else {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* last_part = NULL;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gboolean _tmp35_;
		_tmp16_ = normed_key;
		_tmp17_ = self->priv->delimiter;
		if (string_contains (_tmp16_, _tmp17_)) {
			gint offset = 0;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gint position = 0;
			GtkWidget* _tmp21_;
			_tmp18_ = normed_key;
			_tmp19_ = normed_key;
			_tmp20_ = self->priv->delimiter;
			offset = g_utf8_strlen (_tmp18_, (gssize) string_last_index_of_char (_tmp19_, (gunichar) string_get (_tmp20_, (glong) 0), 0));
			_tmp21_ = gtk_entry_completion_get_entry (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion));
			position = gtk_editable_get_position (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_entry_get_type (), GtkEntry), gtk_editable_get_type (), GtkEditable));
			if (position <= offset) {
				result = FALSE;
				_g_free0 (normed_key);
				_g_free0 (possible_match);
				_g_object_unref0 (model);
				return result;
			}
		}
		_tmp22_ = normed_key;
		_tmp23_ = string_strip (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->delimiter;
		_tmp26_ = entry_multi_completion_get_last_part (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp24_);
		last_part = _tmp27_;
		_tmp28_ = last_part;
		_tmp29_ = strlen (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == 0) {
			result = FALSE;
			_g_free0 (last_part);
			_g_free0 (normed_key);
			_g_free0 (possible_match);
			_g_object_unref0 (model);
			return result;
		}
		_tmp31_ = possible_match;
		_tmp32_ = last_part;
		_tmp33_ = string_strip (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_str_has_prefix (_tmp31_, _tmp34_);
		_g_free0 (_tmp34_);
		result = _tmp35_;
		_g_free0 (last_part);
		_g_free0 (normed_key);
		_g_free0 (possible_match);
		_g_object_unref0 (model);
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
entry_multi_completion_real_match_selected (GtkEntryCompletion* base,
                                            GtkTreeModel* model,
                                            GtkTreeIter* iter)
{
	EntryMultiCompletion * self;
	gchar* match = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	GtkEntry* entry = NULL;
	GtkWidget* _tmp2_;
	GtkEntry* _tmp3_;
	gchar* old_text = NULL;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_;
	gchar* new_text = NULL;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkEntry* _tmp32_;
	GtkEntry* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1);
	_g_free0 (match);
	match = _tmp1_;
	_tmp2_ = gtk_entry_completion_get_entry (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion));
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_entry_get_type (), GtkEntry));
	entry = _tmp3_;
	_tmp4_ = entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = g_utf8_normalize (_tmp5_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
	old_text = _tmp6_;
	_tmp7_ = old_text;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > 0) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = old_text;
		_tmp11_ = self->priv->delimiter;
		if (string_contains (_tmp10_, _tmp11_)) {
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp13_ = self->priv->delimiter;
			if (g_strcmp0 (_tmp13_, " ") != 0) {
				_tmp12_ = " ";
			} else {
				_tmp12_ = "";
			}
			_tmp14_ = old_text;
			_tmp15_ = old_text;
			_tmp16_ = self->priv->delimiter;
			_tmp17_ = string_substring (_tmp14_, (glong) 0, (glong) (string_last_index_of_char (_tmp15_, (gunichar) string_get (_tmp16_, (glong) 0), 0) + 1));
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, _tmp12_, NULL);
			_g_free0 (old_text);
			old_text = _tmp19_;
			_g_free0 (_tmp18_);
		} else {
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			_g_free0 (old_text);
			old_text = _tmp20_;
		}
	}
	_tmp22_ = self->priv->delimiter;
	if (g_strcmp0 (_tmp22_, " ") != 0) {
		_tmp21_ = " ";
	} else {
		_tmp21_ = "";
	}
	_tmp23_ = old_text;
	_tmp24_ = match;
	_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->delimiter;
	_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, _tmp21_, NULL);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	new_text = _tmp31_;
	_tmp32_ = entry;
	gtk_entry_set_text (_tmp32_, new_text);
	_tmp33_ = entry;
	_tmp34_ = strlen (new_text);
	_tmp35_ = _tmp34_;
	gtk_editable_set_position (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_editable_get_type (), GtkEditable), (gint) _tmp35_);
	result = TRUE;
	_g_free0 (new_text);
	_g_free0 (old_text);
	_g_object_unref0 (entry);
	_g_free0 (match);
	return result;
}

static gchar*
entry_multi_completion_get_last_part (const gchar* s,
                                      const gchar* delimiter)
{
	gchar** split = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint split_length1;
	gint _split_size_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	g_return_val_if_fail (delimiter != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (s, delimiter, 0);
	split = _tmp1_;
	split_length1 = _vala_array_length (_tmp0_);
	_split_size_ = split_length1;
	_tmp3_ = split;
	_tmp3__length1 = split_length1;
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		_tmp4_ = split;
		_tmp4__length1 = split_length1;
		_tmp5_ = _tmp4_[0];
		_tmp2_ = _tmp5_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = split;
		_tmp6__length1 = split_length1;
		_tmp7_ = split;
		_tmp7__length1 = split_length1;
		_tmp8_ = _tmp6_[_tmp7__length1 - 1];
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		result = _tmp10_;
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
}

static void
entry_multi_completion_class_init (EntryMultiCompletionClass * klass,
                                   gpointer klass_data)
{
	entry_multi_completion_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EntryMultiCompletion_private_offset);
	((GtkEntryCompletionClass *) klass)->match_selected = (gboolean (*) (GtkEntryCompletion*, GtkTreeModel*, GtkTreeIter*)) entry_multi_completion_real_match_selected;
	G_OBJECT_CLASS (klass)->finalize = entry_multi_completion_finalize;
}

static void
entry_multi_completion_instance_init (EntryMultiCompletion * self,
                                      gpointer klass)
{
	self->priv = entry_multi_completion_get_instance_private (self);
}

static void
entry_multi_completion_finalize (GObject * obj)
{
	EntryMultiCompletion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion);
	_g_free0 (self->priv->delimiter);
	G_OBJECT_CLASS (entry_multi_completion_parent_class)->finalize (obj);
}

static GType
entry_multi_completion_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EntryMultiCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) entry_multi_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EntryMultiCompletion), 0, (GInstanceInitFunc) entry_multi_completion_instance_init, NULL };
	GType entry_multi_completion_type_id;
	entry_multi_completion_type_id = g_type_register_static (gtk_entry_completion_get_type (), "EntryMultiCompletion", &g_define_type_info, 0);
	EntryMultiCompletion_private_offset = g_type_add_instance_private (entry_multi_completion_type_id, sizeof (EntryMultiCompletionPrivate));
	return entry_multi_completion_type_id;
}

GType
entry_multi_completion_get_type (void)
{
	static volatile gsize entry_multi_completion_type_id__once = 0;
	if (g_once_init_enter (&entry_multi_completion_type_id__once)) {
		GType entry_multi_completion_type_id;
		entry_multi_completion_type_id = entry_multi_completion_get_type_once ();
		g_once_init_leave (&entry_multi_completion_type_id__once, entry_multi_completion_type_id);
	}
	return entry_multi_completion_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

