/* window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from window.vala, do not modify */

/*
   This file is part of Swell-Foop.

   Copyright (C) 2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>
   Copyright (C) 2023 Ben Corby

   Swell-Foop is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   Swell-Foop is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Swell-Foop.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libgnome-games-support.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SWELL_FOOP_WINDOW (swell_foop_window_get_type ())
#define SWELL_FOOP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow))
#define SWELL_FOOP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindowClass))
#define IS_SWELL_FOOP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWELL_FOOP_WINDOW))
#define IS_SWELL_FOOP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWELL_FOOP_WINDOW))
#define SWELL_FOOP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindowClass))

typedef struct _SwellFoopWindow SwellFoopWindow;
typedef struct _SwellFoopWindowClass SwellFoopWindowClass;
typedef struct _SwellFoopWindowPrivate SwellFoopWindowPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
enum  {
	SWELL_FOOP_WINDOW_0_PROPERTY,
	SWELL_FOOP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* swell_foop_window_properties[SWELL_FOOP_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SWELL_FOOP_WINDOW_TYPE_SIZE (swell_foop_window_size_get_type ())
typedef struct _SwellFoopWindowSize SwellFoopWindowSize;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _SwellFoopWindowShowNewGameConfirmationDialogData SwellFoopWindowShowNewGameConfirmationDialogData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SwellFoopWindow {
	AdwApplicationWindow parent_instance;
	SwellFoopWindowPrivate * priv;
	GtkMenuButton* hamburger_button;
};

struct _SwellFoopWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _SwellFoopWindowPrivate {
	GtkOverlay* overlay;
	GtkStack* stack;
	AdwWindowTitle* window_title;
	GtkAspectFrame* aspect_frame;
	GtkLabel* score_label;
	GtkLabel* to_high_score_label;
	GtkBox* game_over_box;
	GSettings* settings;
	Game* game;
	GameView* view;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GamesScoresContext* scores_context;
};

struct _SwellFoopWindowSize {
	gchar* id;
	gchar* name;
	guint8 columns;
	guint8 rows;
};

struct _Block2Data {
	int _ref_count_;
	SwellFoopWindow* self;
	GtkBox* box;
};

struct _Block3Data {
	int _ref_count_;
	SwellFoopWindow* self;
	GamesScoresCategory* category;
};

struct _SwellFoopWindowShowNewGameConfirmationDialogData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwellFoopWindow* self;
	AdwAlertDialog* dialog;
	AdwAlertDialog* _tmp0_;
	AdwAlertDialog* _tmp1_;
	AdwAlertDialog* _tmp2_;
	AdwAlertDialog* _tmp3_;
	AdwAlertDialog* _tmp4_;
	gchar* response;
	AdwAlertDialog* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
};

static gint SwellFoopWindow_private_offset;
static gpointer swell_foop_window_parent_class = NULL;
static SwellFoopWindowSize* swell_foop_window_sizes;
static gint swell_foop_window_sizes_length1;
static SwellFoopWindowSize* swell_foop_window_sizes = NULL;
static gint swell_foop_window_sizes_length1 = 0;
static gint _swell_foop_window_sizes_size_ = 0;
static GHashTable* swell_foop_window_score_categories;
static GHashTable* swell_foop_window_score_categories = NULL;

VALA_EXTERN GType swell_foop_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwellFoopWindow, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
static inline void swell_foop_window_change_theme_cb (SwellFoopWindow* self,
                                        GSimpleAction* action,
                                        GVariant* variant);
static void _swell_foop_window_change_theme_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                              GVariant* value,
                                                                              gpointer self);
static inline void swell_foop_window_change_colors_cb (SwellFoopWindow* self,
                                         GSimpleAction* action,
                                         GVariant* variant);
static void _swell_foop_window_change_colors_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                               GVariant* value,
                                                                               gpointer self);
static inline void swell_foop_window_new_game_cb (SwellFoopWindow* self);
static void _swell_foop_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static inline void swell_foop_window_scores_cb (SwellFoopWindow* self);
static void _swell_foop_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static inline void swell_foop_window_toggle_hamburger (SwellFoopWindow* self);
static void _swell_foop_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static inline void swell_foop_window_undo (SwellFoopWindow* self);
static void _swell_foop_window_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static inline void swell_foop_window_redo (SwellFoopWindow* self);
static void _swell_foop_window_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static GType swell_foop_window_size_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SwellFoopWindowSize* swell_foop_window_size_dup (const SwellFoopWindowSize* self);
static void swell_foop_window_size_free (SwellFoopWindowSize* self);
static void swell_foop_window_size_copy (const SwellFoopWindowSize* self,
                                  SwellFoopWindowSize* dest);
static void swell_foop_window_size_destroy (SwellFoopWindowSize* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SwellFoopWindowSize, swell_foop_window_size_destroy)
static inline void swell_foop_window_class_init_sizes (void);
static void _vala_SwellFoopWindowSize_array_free (SwellFoopWindowSize * array,
                                           gssize array_length);
VALA_EXTERN SwellFoopWindow* swell_foop_window_new (GtkApplication* application);
VALA_EXTERN SwellFoopWindow* swell_foop_window_construct (GType object_type,
                                              GtkApplication* application);
static void swell_foop_window_new_game (SwellFoopWindow* self,
                                 GVariant* saved_game);
static inline GtkWidget* swell_foop_window_build_first_run_view (SwellFoopWindow* self);
static void __lambda18_ (SwellFoopWindow* self);
static void ___lambda18__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static inline GtkBox* swell_foop_window_build_game_over_view (SwellFoopWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda19_ (Block2Data* _data2_);
static void ___lambda19__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void swell_foop_window_update_score_cb (SwellFoopWindow* self);
VALA_EXTERN gboolean game_get_is_started (Game* self);
VALA_EXTERN guint game_get_score (Game* self);
static void swell_foop_window_complete_cb (SwellFoopWindow* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void swell_foop_window_get_board_size (SwellFoopWindow* self,
                                       SwellFoopWindowSize* result);
VALA_EXTERN guint8 game_get_color_num (Game* self);
static gboolean __lambda16_ (Block3Data* _data3_);
static inline void swell_foop_window_add_score (SwellFoopWindow* self,
                                  GamesScoresCategory* category);
static gboolean ___lambda16__gsource_func (gpointer self);
VALA_EXTERN Game* game_new (guint8 rows,
                guint8 columns,
                guint8 color_num,
                GameView* view,
                GVariant* saved_game);
VALA_EXTERN Game* game_construct (GType object_type,
                      guint8 rows,
                      guint8 columns,
                      guint8 color_num,
                      GameView* view,
                      GVariant* saved_game);
static void _swell_foop_window_update_score_cb_game_update_score (Game* _sender,
                                                           gint points_awarded,
                                                           gpointer self);
static void _swell_foop_window_complete_cb_game_complete (Game* _sender,
                                                   gpointer self);
static void _swell_foop_window_update_score_cb_game_started (Game* _sender,
                                                      gpointer self);
VALA_EXTERN void game_view_set_theme_name (GameView* self,
                               const gchar* theme_name);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* game);
static void swell_foop_window_show_new_game_confirmation_dialog (SwellFoopWindow* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void swell_foop_window_show_new_game_confirmation_dialog_finish (SwellFoopWindow* self,
                                                                 GAsyncResult* _res_);
static void swell_foop_window_show_new_game_confirmation_dialog_data_free (gpointer _data);
static gboolean swell_foop_window_show_new_game_confirmation_dialog_co (SwellFoopWindowShowNewGameConfirmationDialogData* _data_);
static void swell_foop_window_show_new_game_confirmation_dialog_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN void game_redo (Game* self);
static inline void swell_foop_window_class_init_scores (void);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static inline void swell_foop_window_init_scores (SwellFoopWindow* self);
static inline GamesScoresCategory* swell_foop_window_category_request (SwellFoopWindow* self,
                                                         const gchar* key);
static GamesScoresCategory* _swell_foop_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                     gpointer self);
static void __lambda17_ (SwellFoopWindow* self,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda17__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GObject * swell_foop_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _swell_foop_window___lambda20_ (SwellFoopWindow* self);
static void __swell_foop_window___lambda20__gtk_popover_closed (GtkPopover* _sender,
                                                         gpointer self);
VALA_EXTERN GameView* game_view_new (void);
VALA_EXTERN GameView* game_view_construct (GType object_type);
static gboolean _swell_foop_window___lambda21_ (SwellFoopWindow* self);
VALA_EXTERN GVariant* game_get_saved_game (Game* self);
VALA_EXTERN guint8 game_get_rows (Game* self);
VALA_EXTERN guint8 game_get_columns (Game* self);
static gboolean __swell_foop_window___lambda21__gtk_window_close_request (GtkWindow* _sender,
                                                                   gpointer self);
static void swell_foop_window_finalize (GObject * obj);
static GType swell_foop_window_get_type_once (void);

static const GActionEntry SWELL_FOOP_WINDOW_win_actions[7] = {{"change-theme", NULL, "s", "'shapesandcolors'", _swell_foop_window_change_theme_cb_gsimple_action_change_state_callback}, {"change-colors", NULL, "s", "'3'", _swell_foop_window_change_colors_cb_gsimple_action_change_state_callback}, {"new-game", _swell_foop_window_new_game_cb_gsimple_action_activate_callback}, {"scores", _swell_foop_window_scores_cb_gsimple_action_activate_callback}, {"toggle-hamburger", _swell_foop_window_toggle_hamburger_gsimple_action_activate_callback}, {"undo", _swell_foop_window_undo_gsimple_action_activate_callback}, {"redo", _swell_foop_window_redo_gsimple_action_activate_callback}};

static inline gpointer
swell_foop_window_get_instance_private (SwellFoopWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SwellFoopWindow_private_offset);
}

static void
_swell_foop_window_change_theme_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                         GVariant* value,
                                                                         gpointer self)
{
	swell_foop_window_change_theme_cb ((SwellFoopWindow*) self, action, value);
}

static void
_swell_foop_window_change_colors_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                          GVariant* value,
                                                                          gpointer self)
{
	swell_foop_window_change_colors_cb ((SwellFoopWindow*) self, action, value);
}

static void
_swell_foop_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	swell_foop_window_new_game_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	swell_foop_window_scores_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	swell_foop_window_toggle_hamburger ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	swell_foop_window_undo ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	swell_foop_window_redo ((SwellFoopWindow*) self);
}

static void
_vala_SwellFoopWindowSize_array_free (SwellFoopWindowSize * array,
                                      gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			swell_foop_window_size_destroy (&array[i]);
		}
	}
	g_free (array);
}

static inline void
swell_foop_window_class_init_sizes (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	SwellFoopWindowSize _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
	SwellFoopWindowSize _tmp5_ = {0};
	gchar* _tmp6_;
	gchar* _tmp7_;
	SwellFoopWindowSize _tmp8_ = {0};
	SwellFoopWindowSize* _tmp9_;
	_tmp0_ = g_strdup ("small");
	_tmp1_ = g_strdup (_ ("Small"));
	memset (&_tmp2_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp2_.id);
	_tmp2_.id = _tmp0_;
	_g_free0 (_tmp2_.name);
	_tmp2_.name = _tmp1_;
	_tmp2_.columns = (guint8) 6;
	_tmp2_.rows = (guint8) 5;
	_tmp3_ = g_strdup ("normal");
	_tmp4_ = g_strdup (_ ("Normal"));
	memset (&_tmp5_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp5_.id);
	_tmp5_.id = _tmp3_;
	_g_free0 (_tmp5_.name);
	_tmp5_.name = _tmp4_;
	_tmp5_.columns = (guint8) 15;
	_tmp5_.rows = (guint8) 10;
	_tmp6_ = g_strdup ("large");
	_tmp7_ = g_strdup (_ ("Large"));
	memset (&_tmp8_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp8_.id);
	_tmp8_.id = _tmp6_;
	_g_free0 (_tmp8_.name);
	_tmp8_.name = _tmp7_;
	_tmp8_.columns = (guint8) 20;
	_tmp8_.rows = (guint8) 15;
	_tmp9_ = g_new0 (SwellFoopWindowSize, 3);
	_tmp9_[0] = _tmp2_;
	_tmp9_[1] = _tmp5_;
	_tmp9_[2] = _tmp8_;
	swell_foop_window_sizes = (_vala_SwellFoopWindowSize_array_free (swell_foop_window_sizes, swell_foop_window_sizes_length1), NULL);
	swell_foop_window_sizes = _tmp9_;
	swell_foop_window_sizes_length1 = 3;
	_swell_foop_window_sizes_size_ = swell_foop_window_sizes_length1;
}

SwellFoopWindow*
swell_foop_window_construct (GType object_type,
                             GtkApplication* application)
{
	SwellFoopWindow * self = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (SwellFoopWindow*) g_object_new (object_type, "application", application, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "saved-game");
	_tmp2_ = _tmp1_;
	swell_foop_window_new_game (self, _tmp2_);
	_g_variant_unref0 (_tmp2_);
	return self;
}

SwellFoopWindow*
swell_foop_window_new (GtkApplication* application)
{
	return swell_foop_window_construct (TYPE_SWELL_FOOP_WINDOW, application);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda18_ (SwellFoopWindow* self)
{
	GtkStack* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "game");
	_tmp1_ = self->priv->settings;
	g_settings_set_boolean (_tmp1_, "first-run", FALSE);
}

static void
___lambda18__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda18_ ((SwellFoopWindow*) self);
}

static inline GtkWidget*
swell_foop_window_build_first_run_view (SwellFoopWindow* self)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	AdwStatusPage* page = NULL;
	GObject* _tmp1_;
	AdwStatusPage* _tmp2_;
	GtkButton* play_button = NULL;
	GObject* _tmp3_;
	GtkButton* _tmp4_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/SwellFoop/ui/first-run.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "first_run_page");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, adw_status_page_get_type (), AdwStatusPage));
	page = _tmp2_;
	adw_status_page_set_description (page, _ ("Clear as many blocks as you can.\nFewer clicks means more points."));
	_tmp3_ = gtk_builder_get_object (builder, "play_button");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton));
	play_button = _tmp4_;
	g_signal_connect_object (play_button, "clicked", (GCallback) ___lambda18__gtk_button_clicked, self, 0);
	result = (GtkWidget*) page;
	_g_object_unref0 (play_button);
	_g_object_unref0 (builder);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SwellFoopWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->box);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda19_ (Block2Data* _data2_)
{
	SwellFoopWindow* self;
	self = _data2_->self;
	gtk_widget_set_visible ((GtkWidget*) _data2_->box, FALSE);
}

static void
___lambda19__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda19_ (self);
}

static inline GtkBox*
swell_foop_window_build_game_over_view (SwellFoopWindow* self)
{
	Block2Data* _data2_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GtkBox* _tmp2_;
	GObject* _tmp3_;
	GtkLabel* _tmp4_;
	GObject* _tmp5_;
	GtkLabel* _tmp6_;
	GtkButton* play_button = NULL;
	GObject* _tmp7_;
	GtkButton* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/SwellFoop/ui/game-over.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "game_over");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_box_get_type (), GtkBox));
	_data2_->box = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "score_label");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->score_label);
	self->priv->score_label = _tmp4_;
	_tmp5_ = gtk_builder_get_object (builder, "to_high_score_label");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->to_high_score_label);
	self->priv->to_high_score_label = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "play_button");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_button_get_type (), GtkButton));
	play_button = _tmp8_;
	g_signal_connect_data (play_button, "clicked", (GCallback) ___lambda19__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp9_ = _g_object_ref0 (_data2_->box);
	result = _tmp9_;
	_g_object_unref0 (play_button);
	_g_object_unref0 (builder);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static void
swell_foop_window_update_score_cb (SwellFoopWindow* self)
{
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		Game* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->game;
		_tmp3_ = game_get_is_started (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint score = 0U;
		Game* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		AdwWindowTitle* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = self->priv->game;
		_tmp6_ = game_get_score (_tmp5_);
		_tmp7_ = _tmp6_;
		score = _tmp7_;
		_tmp8_ = self->priv->window_title;
		_tmp9_ = g_strdup_printf (_ ("Score: %u"), score);
		_tmp10_ = _tmp9_;
		adw_window_title_set_subtitle (_tmp8_, _tmp10_);
		_g_free0 (_tmp10_);
	} else {
		AdwWindowTitle* _tmp11_;
		_tmp11_ = self->priv->window_title;
		adw_window_title_set_subtitle (_tmp11_, "");
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SwellFoopWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->category);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
__lambda16_ (Block3Data* _data3_)
{
	SwellFoopWindow* self;
	gboolean result;
	self = _data3_->self;
	swell_foop_window_add_score (self, _data3_->category);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ (self);
	return result;
}

static void
swell_foop_window_complete_cb (SwellFoopWindow* self)
{
	Block3Data* _data3_;
	GSimpleAction* _tmp0_;
	gchar* id = NULL;
	SwellFoopWindowSize _tmp1_ = {0};
	SwellFoopWindowSize _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	Game* _tmp5_;
	guint8 _tmp6_;
	guint8 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gconstpointer _tmp13_;
	GamesScoresCategory* _tmp14_;
	GtkLabel* _tmp15_;
	Game* _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp21_;
	GeeList* _tmp22_;
	glong _tmp23_ = 0L;
	GeeList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	glong lowest_high_score = 0L;
	gboolean _tmp32_ = FALSE;
	GtkBox* _tmp41_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	swell_foop_window_get_board_size (self, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_color_num (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%hhu", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp4_, "-", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	swell_foop_window_size_destroy (&_tmp2_);
	id = _tmp11_;
	_tmp12_ = swell_foop_window_score_categories;
	_tmp13_ = g_hash_table_lookup (_tmp12_, id);
	_tmp14_ = _g_object_ref0 ((GamesScoresCategory*) _tmp13_);
	_data3_->category = _tmp14_;
	if (_data3_->category == NULL) {
		g_assert_not_reached ();
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda16__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	_tmp15_ = self->priv->score_label;
	_tmp16_ = self->priv->game;
	_tmp17_ = game_get_score (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf (_ ("%u Points"), _tmp18_);
	_tmp20_ = _tmp19_;
	gtk_label_set_label (_tmp15_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->scores_context;
	_tmp22_ = games_scores_context_get_high_scores (_tmp21_, _data3_->category, 10);
	scores = _tmp22_;
	_tmp24_ = scores;
	_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == 10) {
		GeeList* _tmp27_;
		gpointer _tmp28_;
		GamesScoresScore* _tmp29_;
		glong _tmp30_;
		glong _tmp31_;
		_tmp27_ = scores;
		_tmp28_ = gee_list_last (_tmp27_);
		_tmp29_ = (GamesScoresScore*) _tmp28_;
		_tmp30_ = games_scores_score_get_score (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp23_ = _tmp31_;
		_g_object_unref0 (_tmp29_);
	} else {
		_tmp23_ = (glong) -1;
	}
	lowest_high_score = _tmp23_;
	if (lowest_high_score != ((glong) -1)) {
		Game* _tmp33_;
		guint _tmp34_;
		guint _tmp35_;
		_tmp33_ = self->priv->game;
		_tmp34_ = game_get_score (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp32_ = lowest_high_score > ((glong) _tmp35_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GtkLabel* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GtkLabel* _tmp39_;
		_tmp36_ = self->priv->to_high_score_label;
		_tmp37_ = g_strdup_printf (_ ("%u points to reach the leaderboard"), (guint) lowest_high_score);
		_tmp38_ = _tmp37_;
		gtk_label_set_label (_tmp36_, _tmp38_);
		_g_free0 (_tmp38_);
		_tmp39_ = self->priv->to_high_score_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp39_, TRUE);
	} else {
		GtkLabel* _tmp40_;
		_tmp40_ = self->priv->to_high_score_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp40_, FALSE);
	}
	_tmp41_ = self->priv->game_over_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp41_, TRUE);
	_g_object_unref0 (scores);
	_g_free0 (id);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
swell_foop_window_get_board_size (SwellFoopWindow* self,
                                  SwellFoopWindowSize* result)
{
	gchar* current_size = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	SwellFoopWindowSize* _tmp13_;
	gint _tmp13__length1;
	SwellFoopWindowSize _tmp14_;
	SwellFoopWindowSize _tmp15_;
	SwellFoopWindowSize _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "size");
	current_size = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp4_;
				gint _tmp4__length1;
				SwellFoopWindowSize* _tmp5_;
				gint _tmp5__length1;
				SwellFoopWindowSize _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = swell_foop_window_sizes;
				_tmp4__length1 = swell_foop_window_sizes_length1;
				if (!(i < _tmp4__length1)) {
					break;
				}
				_tmp5_ = swell_foop_window_sizes;
				_tmp5__length1 = swell_foop_window_sizes_length1;
				_tmp6_ = _tmp5_[i];
				_tmp7_ = _tmp6_.id;
				_tmp8_ = current_size;
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					SwellFoopWindowSize* _tmp9_;
					gint _tmp9__length1;
					SwellFoopWindowSize _tmp10_;
					SwellFoopWindowSize _tmp11_;
					SwellFoopWindowSize _tmp12_ = {0};
					_tmp9_ = swell_foop_window_sizes;
					_tmp9__length1 = swell_foop_window_sizes_length1;
					_tmp10_ = _tmp9_[i];
					_tmp11_ = _tmp10_;
					swell_foop_window_size_copy (&_tmp11_, &_tmp12_);
					*result = _tmp12_;
					_g_free0 (current_size);
					return;
				}
			}
		}
	}
	_tmp13_ = swell_foop_window_sizes;
	_tmp13__length1 = swell_foop_window_sizes_length1;
	_tmp14_ = _tmp13_[0];
	_tmp15_ = _tmp14_;
	swell_foop_window_size_copy (&_tmp15_, &_tmp16_);
	*result = _tmp16_;
	_g_free0 (current_size);
	return;
}

static void
_swell_foop_window_update_score_cb_game_update_score (Game* _sender,
                                                      gint points_awarded,
                                                      gpointer self)
{
	swell_foop_window_update_score_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_complete_cb_game_complete (Game* _sender,
                                              gpointer self)
{
	swell_foop_window_complete_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_update_score_cb_game_started (Game* _sender,
                                                 gpointer self)
{
	swell_foop_window_update_score_cb ((SwellFoopWindow*) self);
}

static void
swell_foop_window_new_game (SwellFoopWindow* self,
                            GVariant* saved_game)
{
	SwellFoopWindowSize size = {0};
	SwellFoopWindowSize _tmp0_ = {0};
	GtkAspectFrame* _tmp1_;
	SwellFoopWindowSize _tmp2_;
	SwellFoopWindowSize _tmp3_;
	SwellFoopWindowSize _tmp4_;
	SwellFoopWindowSize _tmp5_;
	GSettings* _tmp6_;
	GameView* _tmp7_;
	Game* _tmp8_;
	Game* _tmp9_;
	Game* _tmp10_;
	Game* _tmp11_;
	GameView* _tmp12_;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GameView* _tmp16_;
	Game* _tmp17_;
	GtkBox* _tmp18_;
	GAction* _tmp19_;
	GSimpleAction* _tmp20_;
	Game* _tmp21_;
	GSimpleAction* _tmp22_;
	GAction* _tmp23_;
	GSimpleAction* _tmp24_;
	Game* _tmp25_;
	GSimpleAction* _tmp26_;
	GameView* _tmp27_;
	g_return_if_fail (self != NULL);
	swell_foop_window_get_board_size (self, &_tmp0_);
	size = _tmp0_;
	_tmp1_ = self->priv->aspect_frame;
	_tmp2_ = size;
	_tmp3_ = size;
	gtk_aspect_frame_set_ratio (_tmp1_, ((gfloat) _tmp2_.columns) / _tmp3_.rows);
	_tmp4_ = size;
	_tmp5_ = size;
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->view;
	_tmp8_ = game_new (_tmp4_.rows, _tmp5_.columns, (guint8) g_settings_get_int (_tmp6_, "colors"), _tmp7_, saved_game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp8_;
	swell_foop_window_update_score_cb (self);
	_tmp9_ = self->priv->game;
	g_signal_connect_object (_tmp9_, "update-score", (GCallback) _swell_foop_window_update_score_cb_game_update_score, self, 0);
	_tmp10_ = self->priv->game;
	g_signal_connect_object (_tmp10_, "complete", (GCallback) _swell_foop_window_complete_cb_game_complete, self, 0);
	_tmp11_ = self->priv->game;
	g_signal_connect_object (_tmp11_, "started", (GCallback) _swell_foop_window_update_score_cb_game_started, self, 0);
	_tmp12_ = self->priv->view;
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_string (_tmp13_, "theme");
	_tmp15_ = _tmp14_;
	game_view_set_theme_name (_tmp12_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = self->priv->view;
	_tmp17_ = self->priv->game;
	game_view_set_game (_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_GAME, Game));
	_tmp18_ = self->priv->game_over_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp18_, FALSE);
	_tmp19_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp20_;
	_tmp21_ = self->priv->game;
	_tmp22_ = self->priv->undo_action;
	g_object_bind_property_with_closures ((GObject*) _tmp21_, "can-undo", (GObject*) _tmp22_, "enabled", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp23_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp24_;
	_tmp25_ = self->priv->game;
	_tmp26_ = self->priv->redo_action;
	g_object_bind_property_with_closures ((GObject*) _tmp25_, "can-redo", (GObject*) _tmp26_, "enabled", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp27_ = self->priv->view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp27_);
	swell_foop_window_size_destroy (&size);
}

static inline void
swell_foop_window_change_theme_cb (SwellFoopWindow* self,
                                   GSimpleAction* action,
                                   GVariant* variant)
{
	gchar* new_theme = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GameView* _tmp2_;
	const gchar* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	new_theme = _tmp1_;
	g_simple_action_set_state (action, (GVariant*) variant);
	_tmp2_ = self->priv->view;
	_tmp3_ = new_theme;
	game_view_set_theme_name (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_string (_tmp4_, "theme");
	_tmp6_ = _tmp5_;
	_tmp7_ = new_theme;
	_tmp8_ = g_strcmp0 (_tmp6_, _tmp7_) != 0;
	_g_free0 (_tmp6_);
	if (_tmp8_) {
		GSettings* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->settings;
		_tmp10_ = new_theme;
		g_settings_set_string (_tmp9_, "theme", _tmp10_);
	}
	_g_free0 (new_theme);
}

static inline void
swell_foop_window_change_colors_cb (SwellFoopWindow* self,
                                    GSimpleAction* action,
                                    GVariant* variant)
{
	gint32 new_colors = 0;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) variant, NULL);
	new_colors = (gint32) atoi (_tmp0_);
	g_simple_action_set_state (action, (GVariant*) variant);
	_tmp1_ = self->priv->settings;
	if (g_settings_get_int (_tmp1_, "colors") != ((gint) new_colors)) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "colors", (gint) new_colors);
	}
}

static inline void
swell_foop_window_scores_cb (SwellFoopWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scores_context;
	games_scores_context_present_dialog (_tmp0_);
}

static inline void
swell_foop_window_new_game_cb (SwellFoopWindow* self)
{
	Game* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_is_started (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		swell_foop_window_show_new_game_confirmation_dialog (self, NULL, NULL);
	} else {
		swell_foop_window_new_game (self, NULL);
	}
}

static void
swell_foop_window_show_new_game_confirmation_dialog_data_free (gpointer _data)
{
	SwellFoopWindowShowNewGameConfirmationDialogData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwellFoopWindowShowNewGameConfirmationDialogData, _data_);
}

static void
swell_foop_window_show_new_game_confirmation_dialog (SwellFoopWindow* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SwellFoopWindowShowNewGameConfirmationDialogData* _data_;
	SwellFoopWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SwellFoopWindowShowNewGameConfirmationDialogData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, swell_foop_window_show_new_game_confirmation_dialog_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	swell_foop_window_show_new_game_confirmation_dialog_co (_data_);
}

static void
swell_foop_window_show_new_game_confirmation_dialog_finish (SwellFoopWindow* self,
                                                            GAsyncResult* _res_)
{
	SwellFoopWindowShowNewGameConfirmationDialogData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
swell_foop_window_show_new_game_confirmation_dialog_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	SwellFoopWindowShowNewGameConfirmationDialogData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	swell_foop_window_show_new_game_confirmation_dialog_co (_data_);
}

static gboolean
swell_foop_window_show_new_game_confirmation_dialog_co (SwellFoopWindowShowNewGameConfirmationDialogData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Start New Game?"), _ ("Abandon this game to start a new one?"));
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	adw_alert_dialog_add_responses (_data_->_tmp1_, "cancel", _ ("_Cancel"), "new", _ ("_New Game"), NULL, NULL);
	_data_->_tmp2_ = _data_->dialog;
	adw_alert_dialog_set_default_response (_data_->_tmp2_, "new");
	_data_->_tmp3_ = _data_->dialog;
	adw_alert_dialog_set_close_response (_data_->_tmp3_, "cancel");
	_data_->_tmp4_ = _data_->dialog;
	adw_alert_dialog_set_response_appearance (_data_->_tmp4_, "new", ADW_RESPONSE_SUGGESTED);
	_data_->_tmp5_ = _data_->dialog;
	_data_->_state_ = 1;
	adw_alert_dialog_choose (_data_->_tmp5_, (GtkWidget*) _data_->self, NULL, swell_foop_window_show_new_game_confirmation_dialog_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = adw_alert_dialog_choose_finish (_data_->_tmp5_, _data_->_res_);
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->response = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->response;
	if (g_strcmp0 (_data_->_tmp8_, "new") == 0) {
		swell_foop_window_new_game (_data_->self, NULL);
	}
	_g_free0 (_data_->response);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline void
swell_foop_window_toggle_hamburger (SwellFoopWindow* self)
{
	g_return_if_fail (self != NULL);
}

static inline void
swell_foop_window_undo (SwellFoopWindow* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_undo (_tmp0_);
}

static inline void
swell_foop_window_redo (SwellFoopWindow* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_redo (_tmp0_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
swell_foop_window_class_init_scores (void)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (swell_foop_window_score_categories);
	swell_foop_window_score_categories = _tmp2_;
	{
		guint8 i = 0U;
		i = (guint8) 2;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp5_;
				gint _tmp5__length1;
				if (!_tmp3_) {
					guint8 _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((gint) i) <= 4)) {
					break;
				}
				_tmp5_ = swell_foop_window_sizes;
				_tmp5__length1 = swell_foop_window_sizes_length1;
				{
					SwellFoopWindowSize* size_collection = NULL;
					gint size_collection_length1 = 0;
					gint _size_collection_size_ = 0;
					gint size_it = 0;
					size_collection = _tmp5_;
					size_collection_length1 = _tmp5__length1;
					for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
						SwellFoopWindowSize size = {0};
						size = size_collection[size_it];
						{
							gchar* id = NULL;
							SwellFoopWindowSize _tmp6_;
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* name = NULL;
							SwellFoopWindowSize _tmp13_;
							const gchar* _tmp14_;
							gchar* _tmp15_;
							GamesScoresCategory* category = NULL;
							const gchar* _tmp16_;
							const gchar* _tmp17_;
							GamesScoresCategory* _tmp18_;
							GHashTable* _tmp19_;
							const gchar* _tmp20_;
							gchar* _tmp21_;
							GamesScoresCategory* _tmp22_;
							_tmp6_ = size;
							_tmp7_ = _tmp6_.id;
							_tmp8_ = string_to_string (_tmp7_);
							_tmp9_ = g_strdup_printf ("%hhu", i);
							_tmp10_ = _tmp9_;
							_tmp11_ = g_strconcat (_tmp8_, "-", _tmp10_, NULL);
							_tmp12_ = _tmp11_;
							_g_free0 (_tmp10_);
							id = _tmp12_;
							_tmp13_ = size;
							_tmp14_ = _tmp13_.name;
							_tmp15_ = g_strdup_printf (ngettext ("%s, %d color", "%s, %d colors", (gulong) i), _tmp14_, (gint) i);
							name = _tmp15_;
							_tmp16_ = id;
							_tmp17_ = name;
							_tmp18_ = games_scores_category_new (_tmp16_, _tmp17_);
							category = _tmp18_;
							_tmp19_ = swell_foop_window_score_categories;
							_tmp20_ = id;
							_tmp21_ = g_strdup (_tmp20_);
							_tmp22_ = category;
							category = NULL;
							g_hash_table_insert (_tmp19_, _tmp21_, _tmp22_);
							_g_object_unref0 (category);
							_g_free0 (name);
							_g_free0 (id);
						}
					}
				}
			}
		}
	}
}

static GamesScoresCategory*
_swell_foop_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                gpointer self)
{
	GamesScoresCategory* result;
	result = swell_foop_window_category_request ((SwellFoopWindow*) self, category_key);
	return result;
}

static inline void
swell_foop_window_init_scores (SwellFoopWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_scores_context_new ("swell-foop", _ ("Type"), (GtkWindow*) self, _swell_foop_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "org.gnome.SwellFoop");
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp0_;
}

static inline GamesScoresCategory*
swell_foop_window_category_request (SwellFoopWindow* self,
                                    const gchar* key)
{
	GamesScoresCategory* category = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresCategory* _tmp3_;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = swell_foop_window_score_categories;
	_tmp1_ = g_hash_table_lookup (_tmp0_, key);
	_tmp2_ = _g_object_ref0 ((GamesScoresCategory*) _tmp1_);
	category = _tmp2_;
	if (category == NULL) {
		g_assert_not_reached ();
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (category, GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory));
	result = _tmp3_;
	_g_object_unref0 (category);
	return result;
}

static void
__lambda17_ (SwellFoopWindow* self,
             GObject* object,
             GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->scores_context;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("window.vala:426: Failed to add score: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda17__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda17_ ((SwellFoopWindow*) self, source_object, res);
	g_object_unref (self);
}

static inline void
swell_foop_window_add_score (SwellFoopWindow* self,
                             GamesScoresCategory* category)
{
	GamesScoresContext* _tmp0_;
	Game* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_tmp0_ = self->priv->scores_context;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_score (_tmp1_);
	_tmp3_ = _tmp2_;
	games_scores_context_add_score (_tmp0_, (glong) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (category, GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory), NULL, ___lambda17__gasync_ready_callback, g_object_ref (self));
}

static void
swell_foop_window_size_copy (const SwellFoopWindowSize* self,
                             SwellFoopWindowSize* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).id);
	(*dest).id = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	(*dest).columns = (*self).columns;
	(*dest).rows = (*self).rows;
}

static void
swell_foop_window_size_destroy (SwellFoopWindowSize* self)
{
	_g_free0 ((*self).id);
	_g_free0 ((*self).name);
}

static SwellFoopWindowSize*
swell_foop_window_size_dup (const SwellFoopWindowSize* self)
{
	SwellFoopWindowSize* dup;
	dup = g_new0 (SwellFoopWindowSize, 1);
	swell_foop_window_size_copy (self, dup);
	return dup;
}

static void
swell_foop_window_size_free (SwellFoopWindowSize* self)
{
	swell_foop_window_size_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
swell_foop_window_size_get_type_once (void)
{
	GType swell_foop_window_size_type_id;
	swell_foop_window_size_type_id = g_boxed_type_register_static ("SwellFoopWindowSize", (GBoxedCopyFunc) swell_foop_window_size_dup, (GBoxedFreeFunc) swell_foop_window_size_free);
	return swell_foop_window_size_type_id;
}

static GType
swell_foop_window_size_get_type (void)
{
	static gsize swell_foop_window_size_type_id__once = 0;
	if (g_once_init_enter (&swell_foop_window_size_type_id__once)) {
		GType swell_foop_window_size_type_id;
		swell_foop_window_size_type_id = swell_foop_window_size_get_type_once ();
		g_once_init_leave (&swell_foop_window_size_type_id__once, swell_foop_window_size_type_id);
	}
	return swell_foop_window_size_type_id__once;
}

static void
_swell_foop_window___lambda20_ (SwellFoopWindow* self)
{
	GameView* _tmp0_;
	_tmp0_ = self->priv->view;
	if (NULL != _tmp0_) {
		GameView* _tmp1_;
		_tmp1_ = self->priv->view;
		gtk_root_set_focus ((GtkRoot*) self, (GtkWidget*) _tmp1_);
	}
}

static void
__swell_foop_window___lambda20__gtk_popover_closed (GtkPopover* _sender,
                                                    gpointer self)
{
	_swell_foop_window___lambda20_ ((SwellFoopWindow*) self);
}

static gboolean
_swell_foop_window___lambda21_ (SwellFoopWindow* self)
{
	GSettings* _tmp0_;
	gint window_width = 0;
	gint window_height = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GSettings* _tmp8_;
	Game* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GSettings* _tmp12_;
	Game* _tmp13_;
	guint8 _tmp14_;
	guint8 _tmp15_;
	GSettings* _tmp34_;
	gboolean result;
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	gtk_window_get_default_size ((GtkWindow*) self, &_tmp1_, &_tmp2_);
	window_width = _tmp1_;
	window_height = _tmp2_;
	_tmp3_ = self->priv->settings;
	g_settings_set_int (_tmp3_, "window-width", window_width);
	_tmp4_ = self->priv->settings;
	g_settings_set_int (_tmp4_, "window-height", window_height);
	_tmp5_ = self->priv->settings;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	g_settings_set_boolean (_tmp5_, "window-is-maximized", _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->game;
	_tmp10_ = game_get_saved_game (_tmp9_);
	_tmp11_ = _tmp10_;
	g_settings_set_value (_tmp8_, "saved-game", _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = self->priv->game;
	_tmp14_ = game_get_color_num (_tmp13_);
	_tmp15_ = _tmp14_;
	g_settings_set_int (_tmp12_, "colors", (gint) _tmp15_);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp18_;
				gint _tmp18__length1;
				gboolean _tmp19_ = FALSE;
				Game* _tmp20_;
				guint8 _tmp21_;
				guint8 _tmp22_;
				SwellFoopWindowSize* _tmp23_;
				gint _tmp23__length1;
				SwellFoopWindowSize _tmp24_;
				if (!_tmp16_) {
					guint8 _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = swell_foop_window_sizes;
				_tmp18__length1 = swell_foop_window_sizes_length1;
				if (!(((gint) i) < _tmp18__length1)) {
					break;
				}
				_tmp20_ = self->priv->game;
				_tmp21_ = game_get_rows (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = swell_foop_window_sizes;
				_tmp23__length1 = swell_foop_window_sizes_length1;
				_tmp24_ = _tmp23_[i];
				if (_tmp22_ == _tmp24_.rows) {
					Game* _tmp25_;
					guint8 _tmp26_;
					guint8 _tmp27_;
					SwellFoopWindowSize* _tmp28_;
					gint _tmp28__length1;
					SwellFoopWindowSize _tmp29_;
					_tmp25_ = self->priv->game;
					_tmp26_ = game_get_columns (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = swell_foop_window_sizes;
					_tmp28__length1 = swell_foop_window_sizes_length1;
					_tmp29_ = _tmp28_[i];
					_tmp19_ = _tmp27_ == _tmp29_.columns;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					GSettings* _tmp30_;
					SwellFoopWindowSize* _tmp31_;
					gint _tmp31__length1;
					SwellFoopWindowSize _tmp32_;
					const gchar* _tmp33_;
					_tmp30_ = self->priv->settings;
					_tmp31_ = swell_foop_window_sizes;
					_tmp31__length1 = swell_foop_window_sizes_length1;
					_tmp32_ = _tmp31_[i];
					_tmp33_ = _tmp32_.id;
					g_settings_set_string (_tmp30_, "size", _tmp33_);
					break;
				}
			}
		}
	}
	_tmp34_ = self->priv->settings;
	g_settings_apply (_tmp34_);
	result = FALSE;
	return result;
}

static gboolean
__swell_foop_window___lambda21__gtk_window_close_request (GtkWindow* _sender,
                                                          gpointer self)
{
	gboolean result;
	result = _swell_foop_window___lambda21_ ((SwellFoopWindow*) self);
	return result;
}

static GObject *
swell_foop_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwellFoopWindow * self;
	GSettings* _tmp0_;
	GtkMenuButton* _tmp1_;
	GtkPopover* _tmp2_;
	GSettings* _tmp3_;
	GAction* _tmp4_;
	GAction* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	gchar* theme = NULL;
	GSettings* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	GSimpleAction* theme_action = NULL;
	GAction* _tmp17_;
	GSimpleAction* _tmp18_;
	GSimpleAction* _tmp19_;
	const gchar* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	gint32 colors = 0;
	GSettings* _tmp23_;
	GSimpleAction* colors_action = NULL;
	GAction* _tmp24_;
	GSimpleAction* _tmp25_;
	GSimpleAction* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	GameView* _tmp31_;
	GtkSettings* _tmp32_;
	GameView* _tmp33_;
	GameView* _tmp34_;
	SwellFoopWindowSize size = {0};
	SwellFoopWindowSize _tmp35_ = {0};
	SwellFoopWindowSize _tmp36_;
	SwellFoopWindowSize _tmp37_;
	GtkAspectFrame* _tmp38_;
	GtkAspectFrame* _tmp39_;
	GtkAspectFrame* _tmp40_;
	GtkAspectFrame* _tmp41_;
	GtkAspectFrame* _tmp42_;
	GameView* _tmp43_;
	gboolean first_run = FALSE;
	GSettings* _tmp44_;
	GtkWidget* first_run_view = NULL;
	GtkWidget* _tmp45_;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkOverlay* _tmp48_;
	GtkBox* _tmp49_;
	GtkStack* _tmp50_;
	GtkWidget* _tmp51_;
	GtkStack* _tmp52_;
	GtkAspectFrame* _tmp53_;
	const gchar* _tmp54_ = NULL;
	GtkStack* _tmp55_;
	parent_class = G_OBJECT_CLASS (swell_foop_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow);
	_tmp0_ = g_settings_new ("org.gnome.SwellFoop");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->hamburger_button;
	_tmp2_ = gtk_menu_button_get_popover (_tmp1_);
	g_signal_connect_object (_tmp2_, "closed", (GCallback) __swell_foop_window___lambda20__gtk_popover_closed, self, 0);
	g_action_map_add_action_entries ((GActionMap*) self, SWELL_FOOP_WINDOW_win_actions, (gint) G_N_ELEMENTS (SWELL_FOOP_WINDOW_win_actions), self);
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_create_action (_tmp3_, "size");
	_tmp5_ = _tmp4_;
	g_action_map_add_action ((GActionMap*) self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp6_, "window-width"), g_settings_get_int (_tmp7_, "window-height"));
	_tmp8_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp8_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_string (_tmp9_, "theme");
	theme = _tmp10_;
	_tmp13_ = theme;
	if (g_strcmp0 (_tmp13_, "colors") != 0) {
		const gchar* _tmp14_;
		_tmp14_ = theme;
		_tmp12_ = g_strcmp0 (_tmp14_, "shapesandcolors") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp15_;
		_tmp15_ = theme;
		_tmp11_ = g_strcmp0 (_tmp15_, "boringshapes") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("shapesandcolors");
		_g_free0 (theme);
		theme = _tmp16_;
	}
	_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, "change-theme");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_simple_action_get_type (), GSimpleAction));
	theme_action = _tmp18_;
	_tmp19_ = theme_action;
	_tmp20_ = theme;
	_tmp21_ = g_variant_new_string (_tmp20_);
	g_variant_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	g_simple_action_set_state (_tmp19_, _tmp22_);
	_g_variant_unref0 (_tmp22_);
	_tmp23_ = self->priv->settings;
	colors = (gint32) g_settings_get_int (_tmp23_, "colors");
	_tmp24_ = g_action_map_lookup_action ((GActionMap*) self, "change-colors");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_simple_action_get_type (), GSimpleAction));
	colors_action = _tmp25_;
	_tmp26_ = colors_action;
	_tmp27_ = g_strdup_printf ("%i", colors);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_variant_new_string (_tmp28_);
	g_variant_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	g_simple_action_set_state (_tmp26_, _tmp30_);
	_g_variant_unref0 (_tmp30_);
	_g_free0 (_tmp28_);
	swell_foop_window_init_scores (self);
	_tmp31_ = game_view_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp31_;
	_tmp32_ = gtk_settings_get_default ();
	_tmp33_ = self->priv->view;
	g_object_bind_property_with_closures ((GObject*) _tmp32_, "gtk-enable-animations", (GObject*) _tmp33_, "animated", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp34_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp34_);
	swell_foop_window_get_board_size (self, &_tmp35_);
	size = _tmp35_;
	_tmp36_ = size;
	_tmp37_ = size;
	_tmp38_ = (GtkAspectFrame*) gtk_aspect_frame_new (0.5f, 0.5f, ((gfloat) _tmp36_.columns) / _tmp37_.rows, FALSE);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->aspect_frame);
	self->priv->aspect_frame = _tmp38_;
	_tmp39_ = self->priv->aspect_frame;
	gtk_widget_show ((GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->aspect_frame;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp40_, TRUE);
	_tmp41_ = self->priv->aspect_frame;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp41_, TRUE);
	_tmp42_ = self->priv->aspect_frame;
	_tmp43_ = self->priv->view;
	gtk_aspect_frame_set_child (_tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = self->priv->settings;
	first_run = g_settings_get_boolean (_tmp44_, "first-run");
	_tmp45_ = swell_foop_window_build_first_run_view (self);
	first_run_view = _tmp45_;
	_tmp46_ = swell_foop_window_build_game_over_view (self);
	_g_object_unref0 (self->priv->game_over_box);
	self->priv->game_over_box = _tmp46_;
	_tmp47_ = self->priv->game_over_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp47_, FALSE);
	_tmp48_ = self->priv->overlay;
	_tmp49_ = self->priv->game_over_box;
	gtk_overlay_add_overlay (_tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = self->priv->stack;
	_tmp51_ = first_run_view;
	gtk_stack_add_named (_tmp50_, _tmp51_, "first_run");
	_tmp52_ = self->priv->stack;
	_tmp53_ = self->priv->aspect_frame;
	gtk_stack_add_named (_tmp52_, (GtkWidget*) _tmp53_, "game");
	if (first_run) {
		_tmp54_ = "first_run";
	} else {
		_tmp54_ = "game";
	}
	_tmp55_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp55_, _tmp54_);
	g_signal_connect_object ((GtkWindow*) self, "close-request", (GCallback) __swell_foop_window___lambda21__gtk_window_close_request, self, 0);
	_g_object_unref0 (first_run_view);
	swell_foop_window_size_destroy (&size);
	_g_object_unref0 (colors_action);
	_g_object_unref0 (theme_action);
	_g_free0 (theme);
	return obj;
}

static void
swell_foop_window_base_init (SwellFoopWindowClass * klass)
{
	swell_foop_window_class_init_sizes ();
	swell_foop_window_class_init_scores ();
}

static void
swell_foop_window_class_init (SwellFoopWindowClass * klass,
                              gpointer klass_data)
{
	swell_foop_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwellFoopWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = swell_foop_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = swell_foop_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SwellFoop/ui/swell-foop.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "window_title", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, window_title));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hamburger_button", FALSE, G_STRUCT_OFFSET (SwellFoopWindow, hamburger_button));
}

static void
swell_foop_window_instance_init (SwellFoopWindow * self,
                                 gpointer klass)
{
	self->priv = swell_foop_window_get_instance_private (self);
	self->priv->game = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
swell_foop_window_finalize (GObject * obj)
{
	SwellFoopWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow);
	_g_object_unref0 (self->priv->aspect_frame);
	_g_object_unref0 (self->priv->score_label);
	_g_object_unref0 (self->priv->to_high_score_label);
	_g_object_unref0 (self->priv->game_over_box);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->scores_context);
	G_OBJECT_CLASS (swell_foop_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
swell_foop_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwellFoopWindowClass), (GBaseInitFunc) swell_foop_window_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swell_foop_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwellFoopWindow), 0, (GInstanceInitFunc) swell_foop_window_instance_init, NULL };
	GType swell_foop_window_type_id;
	swell_foop_window_type_id = g_type_register_static (adw_application_window_get_type (), "SwellFoopWindow", &g_define_type_info, 0);
	SwellFoopWindow_private_offset = g_type_add_instance_private (swell_foop_window_type_id, sizeof (SwellFoopWindowPrivate));
	return swell_foop_window_type_id;
}

GType
swell_foop_window_get_type (void)
{
	static gsize swell_foop_window_type_id__once = 0;
	if (g_once_init_enter (&swell_foop_window_type_id__once)) {
		GType swell_foop_window_type_id;
		swell_foop_window_type_id = swell_foop_window_get_type_once ();
		g_once_init_leave (&swell_foop_window_type_id__once, swell_foop_window_type_id);
	}
	return swell_foop_window_type_id__once;
}

