// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by hack/docgen tool. DO NOT EDIT.

package block

import (
	"github.com/siderolabs/talos/pkg/machinery/config/encoder"
)

func (EncryptionSpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EncryptionSpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EncryptionSpec represents volume encryption settings." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EncryptionSpec represents volume encryption settings.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "RawVolumeConfigV1Alpha1",
				FieldName: "encryption",
			},
			{
				TypeName:  "SwapVolumeConfigV1Alpha1",
				FieldName: "encryption",
			},
			{
				TypeName:  "UserVolumeConfigV1Alpha1",
				FieldName: "encryption",
			},
			{
				TypeName:  "VolumeConfigV1Alpha1",
				FieldName: "encryption",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "provider",
				Type:        "EncryptionProviderType",
				Note:        "",
				Description: "Encryption provider to use for the encryption.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Encryption provider to use for the encryption." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"luks2",
				},
			},
			{
				Name:        "keys",
				Type:        "[]EncryptionKey",
				Note:        "",
				Description: "Defines the encryption keys generation and storage method.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Defines the encryption keys generation and storage method." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "cipher",
				Type:        "string",
				Note:        "",
				Description: "Cipher to use for the encryption. Depends on the encryption provider.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Cipher to use for the encryption. Depends on the encryption provider." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"aes-xts-plain64",
					"xchacha12,aes-adiantum-plain64",
					"xchacha20,aes-adiantum-plain64",
				},
			},
			{
				Name:        "keySize",
				Type:        "uint",
				Note:        "",
				Description: "Defines the encryption key length.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Defines the encryption key length." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "blockSize",
				Type:        "uint64",
				Note:        "",
				Description: "Defines the encryption sector size.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Defines the encryption sector size." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "options",
				Type:        "[]string",
				Note:        "",
				Description: "Additional --perf parameters for the LUKS2 encryption.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Additional --perf parameters for the LUKS2 encryption." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"no_read_workqueue",
					"no_write_workqueue",
					"same_cpu_crypt",
				},
			},
		},
	}

	doc.AddExample("", exampleEncryptionSpec())

	doc.Fields[2].AddExample("", "aes-xts-plain64")
	doc.Fields[4].AddExample("", 4096)
	doc.Fields[5].AddExample("", []string{"no_read_workqueue", "no_write_workqueue"})

	return doc
}

func (EncryptionKey) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EncryptionKey",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EncryptionKey represents configuration for disk encryption key." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EncryptionKey represents configuration for disk encryption key.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EncryptionSpec",
				FieldName: "keys",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "slot",
				Type:        "int",
				Note:        "",
				Description: "Key slot number for LUKS2 encryption.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Key slot number for LUKS2 encryption." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "static",
				Type:        "EncryptionKeyStatic",
				Note:        "",
				Description: "Key which value is stored in the configuration file.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Key which value is stored in the configuration file." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "nodeID",
				Type:        "EncryptionKeyNodeID",
				Note:        "",
				Description: "Deterministically generated key from the node UUID and PartitionLabel.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Deterministically generated key from the node UUID and PartitionLabel." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "kms",
				Type:        "EncryptionKeyKMS",
				Note:        "",
				Description: "KMS managed encryption key.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "KMS managed encryption key." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tpm",
				Type:        "EncryptionKeyTPM",
				Note:        "",
				Description: "Enable TPM based disk encryption.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable TPM based disk encryption." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "lockToState",
				Type:        "bool",
				Note:        "",
				Description: "Lock the disk encryption key to the random salt stored in the STATE partition. This is useful to prevent the volume from being unlocked if STATE partition is compromised or replaced. It is recommended to use this option with TPM disk encryption for non-STATE volumes.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Lock the disk encryption key to the random salt stored in the STATE partition. This is useful to prevent the volume from being unlocked if STATE partition is compromised or replaced. It is recommended to use this option with TPM disk encryption for non-STATE volumes." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (EncryptionKeyStatic) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EncryptionKeyStatic",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EncryptionKeyStatic represents throw away key type." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EncryptionKeyStatic represents throw away key type.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EncryptionKey",
				FieldName: "static",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "passphrase",
				Type:        "string",
				Note:        "",
				Description: "Defines the static passphrase value.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Defines the static passphrase value." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (EncryptionKeyKMS) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EncryptionKeyKMS",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EncryptionKeyKMS represents a key that is generated and then sealed/unsealed by the KMS server." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EncryptionKeyKMS represents a key that is generated and then sealed/unsealed by the KMS server.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EncryptionKey",
				FieldName: "kms",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "endpoint",
				Type:        "string",
				Note:        "",
				Description: "KMS endpoint to Seal/Unseal the key.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "KMS endpoint to Seal/Unseal the key." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleKMSKey())

	return doc
}

func (EncryptionKeyTPM) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EncryptionKeyTPM",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EncryptionKeyTPM represents a key that is generated and then sealed/unsealed by the TPM." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EncryptionKeyTPM represents a key that is generated and then sealed/unsealed by the TPM.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EncryptionKey",
				FieldName: "tpm",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "options",
				Type:        "EncryptionKeyTPMOptions",
				Note:        "",
				Description: "TPM options for key protection.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "TPM options for key protection." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "checkSecurebootStatusOnEnroll",
				Type:        "bool",
				Note:        "",
				Description: "Check that Secureboot is enabled in the EFI firmware.\nIf Secureboot is not enabled, the enrollment of the key will fail.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Check that Secureboot is enabled in the EFI firmware." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (EncryptionKeyTPMOptions) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EncryptionKeyTPMOptions",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EncryptionKeyTPMOptions represents the options for TPM-based key protection." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EncryptionKeyTPMOptions represents the options for TPM-based key protection.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EncryptionKeyTPM",
				FieldName: "options",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "pcrs",
				Type:        "[]int",
				Note:        "",
				Description: "List of PCRs to bind the key to. If not set, defaults to PCR 7, can be disabled by passing an empty list.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "List of PCRs to bind the key to. If not set, defaults to PCR 7, can be disabled by passing an empty list." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (EncryptionKeyNodeID) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EncryptionKeyNodeID",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EncryptionKeyNodeID represents deterministically generated key from the node UUID and PartitionLabel." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EncryptionKeyNodeID represents deterministically generated key from the node UUID and PartitionLabel.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EncryptionKey",
				FieldName: "nodeID",
			},
		},
		Fields: []encoder.Doc{},
	}

	return doc
}

func (ExistingVolumeConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ExistingVolumeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ExistingVolumeConfig is an existing volume configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ExistingVolumeConfig is an existing volume configuration document.\nExisting volumes allow to mount partitions (or whole disks) that were created\noutside of Talos. Volume will be mounted under `/var/mnt/<name>`.\nThe existing volume config name should not conflict with user volume names.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the volume.\n\nName can only contain:\nlowercase and uppercase ASCII letters, digits, and hyphens.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "discovery",
				Type:        "VolumeDiscoverySpec",
				Note:        "",
				Description: "The discovery describes how to find a volume.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The discovery describes how to find a volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mount",
				Type:        "ExistingMountSpec",
				Note:        "",
				Description: "The mount describes additional mount options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The mount describes additional mount options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleExistingVolumeConfigV1Alpha1())

	return doc
}

func (VolumeDiscoverySpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "VolumeDiscoverySpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "VolumeDiscoverySpec describes how the volume is discovered." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "VolumeDiscoverySpec describes how the volume is discovered.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ExistingVolumeConfigV1Alpha1",
				FieldName: "discovery",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "volumeSelector",
				Type:        "VolumeSelector",
				Note:        "",
				Description: "The volume selector expression.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The volume selector expression." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (VolumeSelector) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "VolumeSelector",
		Comments:    [3]string{"" /* encoder.HeadComment */, "VolumeSelector selects an existing volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "VolumeSelector selects an existing volume.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "VolumeDiscoverySpec",
				FieldName: "volumeSelector",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "match",
				Type:        "Expression",
				Note:        "",
				Description: "The Common Expression Language (CEL) expression to match the volume.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The Common Expression Language (CEL) expression to match the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("match volumes with partition label MY-DATA", exampleVolumeSelector1())
	doc.Fields[0].AddExample("match xfs volume on disk with serial 'SERIAL123'", exampleVolumeSelector2())

	return doc
}

func (ExistingMountSpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ExistingMountSpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ExistingMountSpec describes how the volume is mounted." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ExistingMountSpec describes how the volume is mounted.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ExistingVolumeConfigV1Alpha1",
				FieldName: "mount",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "readOnly",
				Type:        "bool",
				Note:        "",
				Description: "Mount the volume read-only.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Mount the volume read-only." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "disableAccessTime",
				Type:        "bool",
				Note:        "",
				Description: "If true, disable file access time updates.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "If true, disable file access time updates." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "secure",
				Type:        "bool",
				Note:        "",
				Description: "Enable secure mount options (nosuid, nodev).\n\nDefaults to true for better security.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable secure mount options (nosuid, nodev)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (ExternalVolumeConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ExternalVolumeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ExternalVolumeConfig is an external disk mount configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ExternalVolumeConfig is an external disk mount configuration document.\nExternal volumes allow to mount volumes that were created outside of Talos,\nover the network or API. Volume will be mounted under `/var/mnt/<name>`.\nThe external volume config name should not conflict with user volume names.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the mount.\n\nName might be between 1 and 34 characters long and can only contain:\nlowercase and uppercase ASCII letters, digits, and hyphens.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the mount." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "filesystemType",
				Type:        "FilesystemType",
				Note:        "",
				Description: "Filesystem type.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Filesystem type." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"virtiofs",
					"nfs",
				},
			},
			{
				Name:        "mount",
				Type:        "ExternalMountSpec",
				Note:        "",
				Description: "The mount describes additional mount options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The mount describes additional mount options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleExternalVolumeConfigV1Alpha1Virtiofs())

	return doc
}

func (ExternalMountSpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ExternalMountSpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ExternalMountSpec describes how the external volume is mounted." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ExternalMountSpec describes how the external volume is mounted.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ExternalVolumeConfigV1Alpha1",
				FieldName: "mount",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "readOnly",
				Type:        "bool",
				Note:        "",
				Description: "Mount the volume read-only.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Mount the volume read-only." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "disableAccessTime",
				Type:        "bool",
				Note:        "",
				Description: "If true, disable file access time updates.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "If true, disable file access time updates." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "secure",
				Type:        "bool",
				Note:        "",
				Description: "Enable secure mount options (nosuid, nodev).\n\nDefaults to true for better security.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable secure mount options (nosuid, nodev)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "virtiofs",
				Type:        "VirtiofsMountSpec",
				Note:        "",
				Description: "Virtiofs mount options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Virtiofs mount options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (VirtiofsMountSpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "VirtiofsMountSpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "VirtiofsMountSpec describes Virtiofs mount options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "VirtiofsMountSpec describes Virtiofs mount options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ExternalMountSpec",
				FieldName: "virtiofs",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "tag",
				Type:        "string",
				Note:        "",
				Description: "Selector tag for the Virtiofs mount.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Selector tag for the Virtiofs mount." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (RawVolumeConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RawVolumeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RawVolumeConfig is a raw volume configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RawVolumeConfig is a raw volume configuration document.\nRaw volumes allow to create partitions without formatting them.\n If you want to use local storage, user volumes is a better choice,\n raw volumes are intended to be used with CSI provisioners.\nThe partition label is automatically generated as `r-<name>`.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the volume.\n\nName might be between 1 and 34 characters long and can only contain:\nlowercase and uppercase ASCII letters, digits, and hyphens.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "provisioning",
				Type:        "ProvisioningSpec",
				Note:        "",
				Description: "The provisioning describes how the volume is provisioned.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The provisioning describes how the volume is provisioned." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "encryption",
				Type:        "EncryptionSpec",
				Note:        "",
				Description: "The encryption describes how the volume is encrypted.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The encryption describes how the volume is encrypted." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleRawVolumeConfigV1Alpha1())

	return doc
}

func (SwapVolumeConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "SwapVolumeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "SwapVolumeConfig is a disk swap volume configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "SwapVolumeConfig is a disk swap volume configuration document.\nSwap volume is automatically allocated as a partition on the specified disk\nand activated as swap, removing a swap volume deactivates swap.\nThe partition label is automatically generated as `s-<name>`.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the volume.\n\nName might be between 1 and 34 characters long and can only contain:\nlowercase and uppercase ASCII letters, digits, and hyphens.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "provisioning",
				Type:        "ProvisioningSpec",
				Note:        "",
				Description: "The provisioning describes how the volume is provisioned.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The provisioning describes how the volume is provisioned." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "encryption",
				Type:        "EncryptionSpec",
				Note:        "",
				Description: "The encryption describes how the volume is encrypted.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The encryption describes how the volume is encrypted." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleSwapVolumeConfigV1Alpha1())

	return doc
}

func (UserVolumeConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "UserVolumeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "UserVolumeConfig is a user volume configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "UserVolumeConfig is a user volume configuration document.\nUser volume is automatically allocated as a partition on the specified disk\nand mounted under `/var/mnt/<name>`.\nThe partition label is automatically generated as `u-<name>`.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the volume.\n\nName might be between 1 and 34 characters long and can only contain:\nlowercase and uppercase ASCII letters, digits, and hyphens.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "volumeType",
				Type:        "VolumeType",
				Note:        "",
				Description: "Volume type.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Volume type." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"directory",
					"disk",
					"partition",
				},
			},
			{
				Name:        "provisioning",
				Type:        "ProvisioningSpec",
				Note:        "",
				Description: "The provisioning describes how the volume is provisioned.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The provisioning describes how the volume is provisioned." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "filesystem",
				Type:        "FilesystemSpec",
				Note:        "",
				Description: "The filesystem describes how the volume is formatted.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The filesystem describes how the volume is formatted." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "encryption",
				Type:        "EncryptionSpec",
				Note:        "",
				Description: "The encryption describes how the volume is encrypted.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The encryption describes how the volume is encrypted." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mount",
				Type:        "UserMountSpec",
				Note:        "",
				Description: "The mount describes additional mount options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The mount describes additional mount options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleUserVolumeConfigV1Alpha1Directory())

	doc.AddExample("", exampleUserVolumeConfigV1Alpha1Disk())

	doc.AddExample("", exampleUserVolumeConfigV1Alpha1Partition())

	return doc
}

func (UserMountSpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "UserMountSpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "UserMountSpec describes how the volume is mounted." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "UserMountSpec describes how the volume is mounted.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "UserVolumeConfigV1Alpha1",
				FieldName: "mount",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "disableAccessTime",
				Type:        "bool",
				Note:        "",
				Description: "If true, disable file access time updates.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "If true, disable file access time updates." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "secure",
				Type:        "bool",
				Note:        "",
				Description: "Enable secure mount options (nosuid, nodev).\n\nDefaults to true for better security.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable secure mount options (nosuid, nodev)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (FilesystemSpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "FilesystemSpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "FilesystemSpec configures the filesystem for the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "FilesystemSpec configures the filesystem for the volume.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "UserVolumeConfigV1Alpha1",
				FieldName: "filesystem",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "type",
				Type:        "FilesystemType",
				Note:        "",
				Description: "Filesystem type. Default is `xfs`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Filesystem type. Default is `xfs`." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"ext4",
					"xfs",
				},
			},
			{
				Name:        "projectQuotaSupport",
				Type:        "bool",
				Note:        "",
				Description: "Enables project quota support, valid only for 'xfs' filesystem.\n\nNote: changing this value might require a full remount of the filesystem.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enables project quota support, valid only for 'xfs' filesystem." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (VolumeConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "VolumeConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "VolumeConfig is a system volume configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "VolumeConfig is a system volume configuration document.\nNote: at the moment, only `STATE`, `EPHEMERAL` and `IMAGE-CACHE` system volumes are supported.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the volume.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "provisioning",
				Type:        "ProvisioningSpec",
				Note:        "",
				Description: "The provisioning describes how the volume is provisioned.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The provisioning describes how the volume is provisioned." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "encryption",
				Type:        "EncryptionSpec",
				Note:        "",
				Description: "The encryption describes how the volume is encrypted.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The encryption describes how the volume is encrypted." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mount",
				Type:        "MountSpec",
				Note:        "",
				Description: "The mount describes additional mount options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The mount describes additional mount options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleVolumeConfigEphemeralV1Alpha1())

	return doc
}

func (MountSpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "MountSpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "MountSpec describes how the volume is mounted." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "MountSpec describes how the volume is mounted.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "VolumeConfigV1Alpha1",
				FieldName: "mount",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "secure",
				Type:        "bool",
				Note:        "",
				Description: "Enable secure mount options (nosuid, nodev).\n\nDefaults to true for better security.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable secure mount options (nosuid, nodev)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (ProvisioningSpec) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ProvisioningSpec",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ProvisioningSpec describes how the volume is provisioned." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ProvisioningSpec describes how the volume is provisioned.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "RawVolumeConfigV1Alpha1",
				FieldName: "provisioning",
			},
			{
				TypeName:  "SwapVolumeConfigV1Alpha1",
				FieldName: "provisioning",
			},
			{
				TypeName:  "UserVolumeConfigV1Alpha1",
				FieldName: "provisioning",
			},
			{
				TypeName:  "VolumeConfigV1Alpha1",
				FieldName: "provisioning",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "diskSelector",
				Type:        "DiskSelector",
				Note:        "",
				Description: "The disk selector expression.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The disk selector expression." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "grow",
				Type:        "bool",
				Note:        "",
				Description: "Should the volume grow to the size of the disk (if possible).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Should the volume grow to the size of the disk (if possible)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "minSize",
				Type:        "ByteSize",
				Note:        "",
				Description: "The minimum size of the volume.\n\nSize is specified in bytes, but can be expressed in human readable format, e.g. 100MB.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The minimum size of the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "maxSize",
				Type:        "Size",
				Note:        "",
				Description: "The maximum size of the volume, if not specified the volume can grow to the size of the\ndisk.\n\nSize is specified in bytes or in percents. It can be expressed in human readable format, e.g. 100MB.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The maximum size of the volume, if not specified the volume can grow to the size of the" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[2].AddExample("", "2.5GiB")
	doc.Fields[3].AddExample("", "50GiB")
	doc.Fields[3].AddExample("", "80%")

	return doc
}

func (DiskSelector) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "DiskSelector",
		Comments:    [3]string{"" /* encoder.HeadComment */, "DiskSelector selects a disk for the volume." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "DiskSelector selects a disk for the volume.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ProvisioningSpec",
				FieldName: "diskSelector",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "match",
				Type:        "Expression",
				Note:        "",
				Description: "The Common Expression Language (CEL) expression to match the disk.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The Common Expression Language (CEL) expression to match the disk." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("match disks with size between 120GB and 1TB", exampleDiskSelector1())
	doc.Fields[0].AddExample("match SATA disks that are not rotational and not system disks", exampleDiskSelector2())

	return doc
}

func (ZswapConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ZswapConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ZswapConfig is a zswap (compressed memory) configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ZswapConfig is a zswap (compressed memory) configuration document.\nWhen zswap is enabled, Linux kernel compresses pages that would otherwise be swapped out to disk.\nThe compressed pages are stored in a memory pool, which is used to avoid writing to disk\nwhen the system is under memory pressure.\n",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "maxPoolPercent",
				Type:        "int",
				Note:        "",
				Description: "The maximum percent of memory that zswap can use.\nThis is a percentage of the total system memory.\nThe value must be between 0 and 100.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The maximum percent of memory that zswap can use." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "shrinkerEnabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable the shrinker feature: kernel might move\ncold pages from zswap to swap device to free up memory\nfor other use cases.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable the shrinker feature: kernel might move" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleZswapConfigV1Alpha1())

	return doc
}

// GetFileDoc returns documentation for the file block_doc.go.
func GetFileDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "block",
		Description: "Package block provides block device and volume configuration documents.\n",
		Structs: []*encoder.Doc{
			EncryptionSpec{}.Doc(),
			EncryptionKey{}.Doc(),
			EncryptionKeyStatic{}.Doc(),
			EncryptionKeyKMS{}.Doc(),
			EncryptionKeyTPM{}.Doc(),
			EncryptionKeyTPMOptions{}.Doc(),
			EncryptionKeyNodeID{}.Doc(),
			ExistingVolumeConfigV1Alpha1{}.Doc(),
			VolumeDiscoverySpec{}.Doc(),
			VolumeSelector{}.Doc(),
			ExistingMountSpec{}.Doc(),
			ExternalVolumeConfigV1Alpha1{}.Doc(),
			ExternalMountSpec{}.Doc(),
			VirtiofsMountSpec{}.Doc(),
			RawVolumeConfigV1Alpha1{}.Doc(),
			SwapVolumeConfigV1Alpha1{}.Doc(),
			UserVolumeConfigV1Alpha1{}.Doc(),
			UserMountSpec{}.Doc(),
			FilesystemSpec{}.Doc(),
			VolumeConfigV1Alpha1{}.Doc(),
			MountSpec{}.Doc(),
			ProvisioningSpec{}.Doc(),
			DiskSelector{}.Doc(),
			ZswapConfigV1Alpha1{}.Doc(),
		},
	}
}
