// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by hack/docgen tool. DO NOT EDIT.

package v1alpha1

import (
	"github.com/siderolabs/go-pointer"

	"github.com/siderolabs/talos/pkg/machinery/config/encoder"
	"github.com/siderolabs/talos/pkg/machinery/constants"
)

func (Config) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "Config",
		Comments:    [3]string{"" /* encoder.HeadComment */, "Config defines the v1alpha1.Config Talos machine configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "Config defines the v1alpha1.Config Talos machine configuration document.",
		Fields: []encoder.Doc{
			{
				Name:        "version",
				Type:        "string",
				Note:        "",
				Description: "Indicates the schema used to decode the contents.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Indicates the schema used to decode the contents." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"v1alpha1",
				},
			},
			{
				Name:        "debug",
				Type:        "bool",
				Note:        "",
				Description: "Enable verbose logging to the console.\nAll system containers logs will flow into serial console.\n\n**Note:** To avoid breaking Talos bootstrap flow enable this option only if serial console can handle high message throughput.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable verbose logging to the console." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"true",
					"yes",
					"false",
					"no",
				},
			},
			{},
			{
				Name:        "machine",
				Type:        "MachineConfig",
				Note:        "",
				Description: "Provides machine specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Provides machine specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "cluster",
				Type:        "ClusterConfig",
				Note:        "",
				Description: "Provides cluster specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Provides cluster specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", configExample())

	return doc
}

func (MachineConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "MachineConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "MachineConfig represents the machine-specific config values." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "MachineConfig represents the machine-specific config values.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "Config",
				FieldName: "machine",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "type",
				Type:        "string",
				Note:        "",
				Description: "Defines the role of the machine within the cluster.\n\n**Control Plane**\n\nControl Plane node type designates the node as a control plane member.\nThis means it will host etcd along with the Kubernetes controlplane components such as API Server, Controller Manager, Scheduler.\n\n**Worker**\n\nWorker node type designates the node as a worker node.\nThis means it will be an available compute node for scheduling workloads.\n\nThis node type was previously known as \"join\"; that value is still supported but deprecated.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Defines the role of the machine within the cluster." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"controlplane",
					"worker",
				},
			},
			{
				Name:        "token",
				Type:        "string",
				Note:        "Warning: It is important to ensure that this token is correct since a machine's certificate has a short TTL by default.\n",
				Description: "The `token` is used by a machine to join the PKI of the cluster.\nUsing this token, a machine will create a certificate signing request (CSR), and request a certificate that will be used as its' identity.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `token` is used by a machine to join the PKI of the cluster." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ca",
				Type:        "PEMEncodedCertificateAndKey",
				Note:        "",
				Description: "The root certificate authority of the PKI.\nIt is composed of a base64 encoded `crt` and `key`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The root certificate authority of the PKI." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "acceptedCAs",
				Type:        "[]PEMEncodedCertificate",
				Note:        "",
				Description: "The certificates issued by certificate authorities are accepted in addition to issuing 'ca'.\nIt is composed of a base64 encoded `crt``.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The certificates issued by certificate authorities are accepted in addition to issuing 'ca'." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "certSANs",
				Type:        "[]string",
				Note:        "",
				Description: "Extra certificate subject alternative names for the machine's certificate.\nBy default, all non-loopback interface IPs are automatically added to the certificate's SANs.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra certificate subject alternative names for the machine's certificate." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "controlPlane",
				Type:        "MachineControlPlaneConfig",
				Note:        "",
				Description: "Provides machine specific control plane configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Provides machine specific control plane configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "kubelet",
				Type:        "KubeletConfig",
				Note:        "",
				Description: "Used to provide additional options to the kubelet.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Used to provide additional options to the kubelet." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "pods",
				Type:        "[]Unstructured",
				Note:        "",
				Description: "Used to provide static pod definitions to be run by the kubelet directly bypassing the kube-apiserver.\n\nStatic pods can be used to run components which should be started before the Kubernetes control plane is up.\nTalos doesn't validate the pod definition.\nUpdates to this field can be applied without a reboot.\n\nSee https://kubernetes.io/docs/tasks/configure-pod-container/static-pod/.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Used to provide static pod definitions to be run by the kubelet directly bypassing the kube-apiserver." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{},
			{
				Name:        "install",
				Type:        "InstallConfig",
				Note:        "",
				Description: "Used to provide instructions for installations.\n\nNote that this configuration section gets silently ignored by Talos images that are considered pre-installed.\nTo make sure Talos installs according to the provided configuration, Talos should be booted with ISO or PXE-booted.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Used to provide instructions for installations." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "files",
				Type:        "[]MachineFile",
				Note:        "Note: The specified `path` is relative to `/var`.\n",
				Description: "Allows the addition of user specified files.\nThe value of `op` can be `create`, `overwrite`, or `append`.\nIn the case of `create`, `path` must not exist.\nIn the case of `overwrite`, and `append`, `path` must be a valid file.\nIf an `op` value of `append` is used, the existing file will be appended.\nNote that the file contents are not required to be base64 encoded.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Allows the addition of user specified files." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{},
			{
				Name:        "sysctls",
				Type:        "map[string]string",
				Note:        "",
				Description: "Used to configure the machine's sysctls.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Used to configure the machine's sysctls." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "sysfs",
				Type:        "map[string]string",
				Note:        "",
				Description: "Used to configure the machine's sysfs.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Used to configure the machine's sysfs." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{},
			{
				Name:        "features",
				Type:        "FeaturesConfig",
				Note:        "",
				Description: "Features describe individual Talos features that can be switched on or off.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Features describe individual Talos features that can be switched on or off." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "udev",
				Type:        "UdevConfig",
				Note:        "",
				Description: "Configures the udev system.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures the udev system." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "logging",
				Type:        "LoggingConfig",
				Note:        "",
				Description: "Configures the logging system.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures the logging system." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "kernel",
				Type:        "KernelConfig",
				Note:        "",
				Description: "Configures the kernel.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures the kernel." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "seccompProfiles",
				Type:        "[]MachineSeccompProfile",
				Note:        "",
				Description: "Configures the seccomp profiles for the machine.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures the seccomp profiles for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "baseRuntimeSpecOverrides",
				Type:        "Unstructured",
				Note:        "",
				Description: "Override (patch) settings in the default OCI runtime spec for CRI containers.\n\nIt can be used to set some default container settings which are not configurable in Kubernetes,\nfor example default ulimits.\nNote: this change applies to all newly created containers, and it requires a reboot to take effect.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Override (patch) settings in the default OCI runtime spec for CRI containers." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "nodeLabels",
				Type:        "map[string]string",
				Note:        "",
				Description: "Configures the node labels for the machine.\n\nNote: In the default Kubernetes configuration, worker nodes are restricted to set\nlabels with some prefixes (see [NodeRestriction](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#noderestriction) admission plugin).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures the node labels for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "nodeAnnotations",
				Type:        "map[string]string",
				Note:        "",
				Description: "Configures the node annotations for the machine.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures the node annotations for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "nodeTaints",
				Type:        "map[string]string",
				Note:        "",
				Description: "Configures the node taints for the machine. Effect is optional.\n\nNote: In the default Kubernetes configuration, worker nodes are not allowed to\nmodify the taints (see [NodeRestriction](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#noderestriction) admission plugin).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures the node taints for the machine. Effect is optional." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", machineConfigExample())

	doc.Fields[1].AddExample("example token", "328hom.uqjzh6jnn2eie9oi")
	doc.Fields[2].AddExample("machine CA example", pemEncodedCertificateExample())
	doc.Fields[4].AddExample("Uncomment this to enable SANs.", []string{"10.0.0.10", "172.16.0.10", "192.168.0.10"})
	doc.Fields[5].AddExample("ControlPlane definition example.", machineControlplaneExample())
	doc.Fields[6].AddExample("Kubelet definition example.", machineKubeletExample())
	doc.Fields[7].AddExample("nginx static pod.", machinePodsExample())
	doc.Fields[10].AddExample("MachineInstall config usage example.", machineInstallExample())
	doc.Fields[11].AddExample("MachineFiles usage example.", machineFilesExample())
	doc.Fields[14].AddExample("MachineSysctls usage example.", machineSysctlsExample())
	doc.Fields[15].AddExample("MachineSysfs usage example.", machineSysfsExample())
	doc.Fields[18].AddExample("", machineFeaturesExample())
	doc.Fields[19].AddExample("", machineUdevExample())
	doc.Fields[20].AddExample("", machineLoggingExample())
	doc.Fields[21].AddExample("", machineKernelExample())
	doc.Fields[22].AddExample("", machineSeccompExample())
	doc.Fields[23].AddExample("override default open file limit", machineBaseRuntimeSpecOverridesExample())
	doc.Fields[24].AddExample("node labels example.", map[string]string{"exampleLabel": "exampleLabelValue"})
	doc.Fields[25].AddExample("node annotations example.", map[string]string{"customer.io/rack": "r13a25"})
	doc.Fields[26].AddExample("node taints example.", map[string]string{"exampleTaint": "exampleTaintValue:NoSchedule"})

	return doc
}

func (MachineSeccompProfile) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "MachineSeccompProfile",
		Comments:    [3]string{"" /* encoder.HeadComment */, "MachineSeccompProfile defines seccomp profiles for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "MachineSeccompProfile defines seccomp profiles for the machine.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "seccompProfiles",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "The `name` field is used to provide the file name of the seccomp profile.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `name` field is used to provide the file name of the seccomp profile." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "value",
				Type:        "Unstructured",
				Note:        "",
				Description: "The `value` field is used to provide the seccomp profile.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `value` field is used to provide the seccomp profile." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", machineSeccompExample())

	return doc
}

func (ClusterConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ClusterConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ClusterConfig represents the cluster-wide config values." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ClusterConfig represents the cluster-wide config values.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "Config",
				FieldName: "cluster",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "id",
				Type:        "string",
				Note:        "",
				Description: "Globally unique identifier for this cluster (base64 encoded random 32 bytes).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Globally unique identifier for this cluster (base64 encoded random 32 bytes)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "secret",
				Type:        "string",
				Note:        "",
				Description: "Shared secret of cluster (base64 encoded random 32 bytes).\nThis secret is shared among cluster members but should never be sent over the network.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Shared secret of cluster (base64 encoded random 32 bytes)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "controlPlane",
				Type:        "ControlPlaneConfig",
				Note:        "",
				Description: "Provides control plane specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Provides control plane specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "clusterName",
				Type:        "string",
				Note:        "",
				Description: "Configures the cluster's name.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures the cluster's name." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "network",
				Type:        "ClusterNetworkConfig",
				Note:        "",
				Description: "Provides cluster specific network configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Provides cluster specific network configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "token",
				Type:        "string",
				Note:        "",
				Description: "The [bootstrap token](https://kubernetes.io/docs/reference/access-authn-authz/bootstrap-tokens/) used to join the cluster.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The [bootstrap token](https://kubernetes.io/docs/reference/access-authn-authz/bootstrap-tokens/) used to join the cluster." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "aescbcEncryptionSecret",
				Type:        "string",
				Note:        "",
				Description: "A key used for the [encryption of secret data at rest](https://kubernetes.io/docs/tasks/administer-cluster/encrypt-data/).\nEnables encryption with AESCBC.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A key used for the [encryption of secret data at rest](https://kubernetes.io/docs/tasks/administer-cluster/encrypt-data/)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "secretboxEncryptionSecret",
				Type:        "string",
				Note:        "",
				Description: "A key used for the [encryption of secret data at rest](https://kubernetes.io/docs/tasks/administer-cluster/encrypt-data/).\nEnables encryption with secretbox.\nSecretbox has precedence over AESCBC.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A key used for the [encryption of secret data at rest](https://kubernetes.io/docs/tasks/administer-cluster/encrypt-data/)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ca",
				Type:        "PEMEncodedCertificateAndKey",
				Note:        "",
				Description: "The base64 encoded root certificate authority used by Kubernetes.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The base64 encoded root certificate authority used by Kubernetes." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "acceptedCAs",
				Type:        "[]PEMEncodedCertificate",
				Note:        "",
				Description: "The list of base64 encoded accepted certificate authorities used by Kubernetes.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The list of base64 encoded accepted certificate authorities used by Kubernetes." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "aggregatorCA",
				Type:        "PEMEncodedCertificateAndKey",
				Note:        "",
				Description: "The base64 encoded aggregator certificate authority used by Kubernetes for front-proxy certificate generation.\n\nThis CA can be self-signed.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The base64 encoded aggregator certificate authority used by Kubernetes for front-proxy certificate generation." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "serviceAccount",
				Type:        "PEMEncodedKey",
				Note:        "",
				Description: "The base64 encoded private key for service account token generation.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The base64 encoded private key for service account token generation." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "apiServer",
				Type:        "APIServerConfig",
				Note:        "",
				Description: "API server specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "API server specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "controllerManager",
				Type:        "ControllerManagerConfig",
				Note:        "",
				Description: "Controller manager server specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Controller manager server specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "proxy",
				Type:        "ProxyConfig",
				Note:        "",
				Description: "Kube-proxy server-specific configuration options",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Kube-proxy server-specific configuration options" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "scheduler",
				Type:        "SchedulerConfig",
				Note:        "",
				Description: "Scheduler server specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Scheduler server specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "discovery",
				Type:        "ClusterDiscoveryConfig",
				Note:        "",
				Description: "Configures cluster member discovery.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures cluster member discovery." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "etcd",
				Type:        "EtcdConfig",
				Note:        "",
				Description: "Etcd specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Etcd specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "coreDNS",
				Type:        "CoreDNS",
				Note:        "",
				Description: "Core DNS specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Core DNS specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "externalCloudProvider",
				Type:        "ExternalCloudProviderConfig",
				Note:        "",
				Description: "External cloud provider configuration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "External cloud provider configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraManifests",
				Type:        "[]string",
				Note:        "",
				Description: "A list of urls that point to additional manifests.\nThese will get automatically deployed as part of the bootstrap.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A list of urls that point to additional manifests." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraManifestHeaders",
				Type:        "map[string]string",
				Note:        "",
				Description: "A map of key value pairs that will be added while fetching the extraManifests.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A map of key value pairs that will be added while fetching the extraManifests." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "inlineManifests",
				Type:        "[]ClusterInlineManifest",
				Note:        "",
				Description: "A list of inline Kubernetes manifests.\nThese will get automatically deployed as part of the bootstrap.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A list of inline Kubernetes manifests." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "adminKubeconfig",
				Type:        "AdminKubeconfigConfig",
				Note:        "",
				Description: "Settings for admin kubeconfig generation.\nCertificate lifetime can be configured.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Settings for admin kubeconfig generation." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{
				Name:        "allowSchedulingOnControlPlanes",
				Type:        "bool",
				Note:        "",
				Description: "Allows running workload on control-plane nodes.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Allows running workload on control-plane nodes." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"true",
					"yes",
					"false",
					"no",
				},
			},
		},
	}

	doc.AddExample("", clusterConfigExample())

	doc.Fields[2].AddExample("Setting controlplane endpoint address to 1.2.3.4 and port to 443 example.", clusterControlPlaneExample())
	doc.Fields[4].AddExample("Configuring with flannel CNI and setting up subnets.", clusterNetworkExample())
	doc.Fields[5].AddExample("Bootstrap token example (do not use in production!).", "wlzjyw.bei2zfylhs2by0wd")
	doc.Fields[6].AddExample("Decryption secret example (do not use in production!).", "z01mye6j16bspJYtTB/5SFX8j7Ph4JXxM2Xuu4vsBPM=")
	doc.Fields[7].AddExample("Decryption secret example (do not use in production!).", "z01mye6j16bspJYtTB/5SFX8j7Ph4JXxM2Xuu4vsBPM=")
	doc.Fields[8].AddExample("ClusterCA example.", pemEncodedCertificateExample())
	doc.Fields[10].AddExample("AggregatorCA example.", pemEncodedCertificateExample())
	doc.Fields[11].AddExample("AggregatorCA example.", pemEncodedKeyExample())
	doc.Fields[12].AddExample("", clusterAPIServerExample())
	doc.Fields[13].AddExample("", clusterControllerManagerExample())
	doc.Fields[14].AddExample("", clusterProxyExample())
	doc.Fields[15].AddExample("", clusterSchedulerExample())
	doc.Fields[16].AddExample("", clusterDiscoveryExample())
	doc.Fields[17].AddExample("", clusterEtcdExample())
	doc.Fields[18].AddExample("", clusterCoreDNSExample())
	doc.Fields[19].AddExample("", clusterExternalCloudProviderConfigExample())
	doc.Fields[20].AddExample("", []string{
		"https://www.example.com/manifest1.yaml",
		"https://www.example.com/manifest2.yaml",
	})
	doc.Fields[21].AddExample("", map[string]string{
		"Token":       "1234567",
		"X-ExtraInfo": "info",
	})
	doc.Fields[22].AddExample("", clusterInlineManifestsExample())
	doc.Fields[23].AddExample("", clusterAdminKubeconfigExample())
	doc.Fields[25].AddExample("", true)

	return doc
}

func (LinuxIDMapping) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "LinuxIDMapping",
		Comments:    [3]string{"" /* encoder.HeadComment */, "LinuxIDMapping represents the Linux ID mapping." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "LinuxIDMapping represents the Linux ID mapping.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ExtraMount",
				FieldName: "uidMappings",
			},
			{
				TypeName:  "ExtraMount",
				FieldName: "gidMappings",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "containerID",
				Type:        "uint32",
				Note:        "",
				Description: "ContainerID is the starting UID/GID in the container.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "ContainerID is the starting UID/GID in the container." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "hostID",
				Type:        "uint32",
				Note:        "",
				Description: "HostID is the starting UID/GID on the host to be mapped to 'ContainerID'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "HostID is the starting UID/GID on the host to be mapped to 'ContainerID'." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "size",
				Type:        "uint32",
				Note:        "",
				Description: "Size is the number of IDs to be mapped.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Size is the number of IDs to be mapped." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (ExtraMount) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ExtraMount",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ExtraMount wraps OCI Mount specification." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ExtraMount wraps OCI Mount specification.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "KubeletConfig",
				FieldName: "extraMounts",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "destination",
				Type:        "string",
				Note:        "",
				Description: "Destination is the absolute path where the mount will be placed in the container.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Destination is the absolute path where the mount will be placed in the container." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "type",
				Type:        "string",
				Note:        "",
				Description: "Type specifies the mount kind.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Type specifies the mount kind." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "source",
				Type:        "string",
				Note:        "",
				Description: "Source specifies the source path of the mount.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Source specifies the source path of the mount." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "options",
				Type:        "[]string",
				Note:        "",
				Description: "Options are fstab style mount options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Options are fstab style mount options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "uidMappings",
				Type:        "[]LinuxIDMapping",
				Note:        "",
				Description: "UID/GID mappings used for changing file owners w/o calling chown, fs should support it.\n\nEvery mount point could have its own mapping.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "UID/GID mappings used for changing file owners w/o calling chown, fs should support it." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "gidMappings",
				Type:        "[]LinuxIDMapping",
				Note:        "",
				Description: "UID/GID mappings used for changing file owners w/o calling chown, fs should support it.\n\nEvery mount point could have its own mapping.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "UID/GID mappings used for changing file owners w/o calling chown, fs should support it." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", kubeletExtraMountsExample())

	return doc
}

func (MachineControlPlaneConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "MachineControlPlaneConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "MachineControlPlaneConfig machine specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "MachineControlPlaneConfig machine specific configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "controlPlane",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "controllerManager",
				Type:        "MachineControllerManagerConfig",
				Note:        "",
				Description: "Controller manager machine specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Controller manager machine specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "scheduler",
				Type:        "MachineSchedulerConfig",
				Note:        "",
				Description: "Scheduler machine specific configuration options.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Scheduler machine specific configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("ControlPlane definition example.", machineControlplaneExample())

	return doc
}

func (MachineControllerManagerConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "MachineControllerManagerConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "MachineControllerManagerConfig represents the machine specific ControllerManager config values." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "MachineControllerManagerConfig represents the machine specific ControllerManager config values.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineControlPlaneConfig",
				FieldName: "controllerManager",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "disabled",
				Type:        "bool",
				Note:        "",
				Description: "Disable kube-controller-manager on the node.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disable kube-controller-manager on the node." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (MachineSchedulerConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "MachineSchedulerConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "MachineSchedulerConfig represents the machine specific Scheduler config values." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "MachineSchedulerConfig represents the machine specific Scheduler config values.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineControlPlaneConfig",
				FieldName: "scheduler",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "disabled",
				Type:        "bool",
				Note:        "",
				Description: "Disable kube-scheduler on the node.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disable kube-scheduler on the node." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (KubeletConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KubeletConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KubeletConfig represents the kubelet config values." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KubeletConfig represents the kubelet config values.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "kubelet",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "image",
				Type:        "string",
				Note:        "",
				Description: "The `image` field is an optional reference to an alternative kubelet image.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `image` field is an optional reference to an alternative kubelet image." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "clusterDNS",
				Type:        "[]string",
				Note:        "",
				Description: "The `ClusterDNS` field is an optional reference to an alternative kubelet clusterDNS ip list.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `ClusterDNS` field is an optional reference to an alternative kubelet clusterDNS ip list." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraArgs",
				Type:        "Args",
				Note:        "",
				Description: "The `extraArgs` field is used to provide additional flags to the kubelet.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `extraArgs` field is used to provide additional flags to the kubelet." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraMounts",
				Type:        "[]ExtraMount",
				Note:        "",
				Description: "The `extraMounts` field is used to add additional mounts to the kubelet container.\nNote that either `bind` or `rbind` are required in the `options`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `extraMounts` field is used to add additional mounts to the kubelet container." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraConfig",
				Type:        "Unstructured",
				Note:        "",
				Description: "The `extraConfig` field is used to provide kubelet configuration overrides.\n\nSome fields are not allowed to be overridden: authentication and authorization, cgroups\nconfiguration, ports, etc.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `extraConfig` field is used to provide kubelet configuration overrides." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "credentialProviderConfig",
				Type:        "Unstructured",
				Note:        "",
				Description: "The `KubeletCredentialProviderConfig` field is used to provide kubelet credential configuration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `KubeletCredentialProviderConfig` field is used to provide kubelet credential configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "defaultRuntimeSeccompProfileEnabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable container runtime default Seccomp profile.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable container runtime default Seccomp profile." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"true",
					"yes",
					"false",
					"no",
				},
			},
			{
				Name:        "registerWithFQDN",
				Type:        "bool",
				Note:        "",
				Description: "The `registerWithFQDN` field is used to force kubelet to use the node FQDN for registration.\nThis is required in clouds like AWS.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `registerWithFQDN` field is used to force kubelet to use the node FQDN for registration." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"true",
					"yes",
					"false",
					"no",
				},
			},
			{
				Name:        "nodeIP",
				Type:        "KubeletNodeIPConfig",
				Note:        "",
				Description: "The `nodeIP` field is used to configure `--node-ip` flag for the kubelet.\nThis is used when a node has multiple addresses to choose from.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `nodeIP` field is used to configure `--node-ip` flag for the kubelet." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "skipNodeRegistration",
				Type:        "bool",
				Note:        "",
				Description: "The `skipNodeRegistration` is used to run the kubelet without registering with the apiserver.\nThis runs kubelet as standalone and only runs static pods.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `skipNodeRegistration` is used to run the kubelet without registering with the apiserver." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"true",
					"yes",
					"false",
					"no",
				},
			},
			{
				Name:        "disableManifestsDirectory",
				Type:        "bool",
				Note:        "",
				Description: "The `disableManifestsDirectory` field configures the kubelet to get static pod manifests from the /etc/kubernetes/manifests directory.\nIt's recommended to configure static pods with the \"pods\" key instead.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `disableManifestsDirectory` field configures the kubelet to get static pod manifests from the /etc/kubernetes/manifests directory." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"true",
					"yes",
					"false",
					"no",
				},
			},
		},
	}

	doc.AddExample("Kubelet definition example.", machineKubeletExample())

	doc.Fields[0].AddExample("", kubeletImageExample())
	doc.Fields[1].AddExample("", []string{"10.96.0.10", "169.254.2.53"})
	doc.Fields[2].AddExample("", Args{
		"key": ArgValue{strValue: "value"},
	})
	doc.Fields[2].AddExample("", Args{
		"key": ArgValue{listValue: []string{"value1", "value2"}},
	})
	doc.Fields[3].AddExample("", kubeletExtraMountsExample())
	doc.Fields[4].AddExample("", kubeletExtraConfigExample())
	doc.Fields[5].AddExample("", kubeletCredentialProviderConfigExample())
	doc.Fields[8].AddExample("", kubeletNodeIPExample())

	return doc
}

func (KubeletNodeIPConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KubeletNodeIPConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KubeletNodeIPConfig represents the kubelet node IP configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KubeletNodeIPConfig represents the kubelet node IP configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "KubeletConfig",
				FieldName: "nodeIP",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "validSubnets",
				Type:        "[]string",
				Note:        "",
				Description: "The `validSubnets` field configures the networks to pick kubelet node IP from.\nFor dual stack configuration, there should be two subnets: one for IPv4, another for IPv6.\nIPs can be excluded from the list by using negative match with `!`, e.g `!10.0.0.0/8`.\nNegative subnet matches should be specified last to filter out IPs picked by positive matches.\nIf not specified, node IP is picked based on cluster podCIDRs: IPv4/IPv6 address or both.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `validSubnets` field configures the networks to pick kubelet node IP from." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", kubeletNodeIPExample())

	return doc
}

func (InstallConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "InstallConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "InstallConfig represents the installation options for preparing a node." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "InstallConfig represents the installation options for preparing a node.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "install",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "disk",
				Type:        "string",
				Note:        "",
				Description: "The disk used for installations.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The disk used for installations." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "diskSelector",
				Type:        "InstallDiskSelector",
				Note:        "",
				Description: "Look up disk using disk attributes like model, size, serial and others.\nAlways has priority over `disk`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Look up disk using disk attributes like model, size, serial and others." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{
				Name:        "image",
				Type:        "string",
				Note:        "",
				Description: "Allows for supplying the image used to perform the installation.\nImage reference for each Talos release can be found on\n[GitHub releases page](https://github.com/siderolabs/talos/releases).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Allows for supplying the image used to perform the installation." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{},
			{
				Name:        "wipe",
				Type:        "bool",
				Note:        "",
				Description: "Indicates if the installation disk should be wiped at installation time.\nDefaults to `true`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Indicates if the installation disk should be wiped at installation time." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"true",
					"yes",
					"false",
					"no",
				},
			},
			{
				Name:        "legacyBIOSSupport",
				Type:        "bool",
				Note:        "",
				Description: "Indicates if MBR partition should be marked as bootable (active).\nShould be enabled only for the systems with legacy BIOS that doesn't support GPT partitioning scheme.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Indicates if MBR partition should be marked as bootable (active)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "grubUseUKICmdline",
				Type:        "bool",
				Note:        "",
				Description: "Indicates if legacy GRUB bootloader should use kernel cmdline from the UKI instead of building it on the host.\nThis changes the way cmdline is managed with GRUB bootloader to be more consistent with UKI/systemd-boot.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Indicates if legacy GRUB bootloader should use kernel cmdline from the UKI instead of building it on the host." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("MachineInstall config usage example.", machineInstallExample())

	doc.Fields[0].AddExample("", "/dev/sda")
	doc.Fields[0].AddExample("", "/dev/nvme0")
	doc.Fields[1].AddExample("", machineInstallDiskSelectorExample())
	doc.Fields[3].AddExample("", "ghcr.io/siderolabs/installer:latest")

	return doc
}

func (InstallDiskSelector) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "InstallDiskSelector",
		Comments:    [3]string{"" /* encoder.HeadComment */, "InstallDiskSelector represents a disk query parameters for the install disk lookup." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "InstallDiskSelector represents a disk query parameters for the install disk lookup.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "InstallConfig",
				FieldName: "diskSelector",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "size",
				Type:        "InstallDiskSizeMatcher",
				Note:        "",
				Description: "Disk size.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk size." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Disk name `/sys/block/<dev>/device/name`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk name `/sys/block/<dev>/device/name`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "model",
				Type:        "string",
				Note:        "",
				Description: "Disk model `/sys/block/<dev>/device/model`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk model `/sys/block/<dev>/device/model`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "serial",
				Type:        "string",
				Note:        "",
				Description: "Disk serial number `/sys/block/<dev>/serial`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk serial number `/sys/block/<dev>/serial`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "modalias",
				Type:        "string",
				Note:        "",
				Description: "Disk modalias `/sys/block/<dev>/device/modalias`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk modalias `/sys/block/<dev>/device/modalias`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "uuid",
				Type:        "string",
				Note:        "",
				Description: "Disk UUID `/sys/block/<dev>/uuid`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk UUID `/sys/block/<dev>/uuid`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "wwid",
				Type:        "string",
				Note:        "",
				Description: "Disk WWID `/sys/block/<dev>/wwid`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk WWID `/sys/block/<dev>/wwid`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "type",
				Type:        "InstallDiskType",
				Note:        "",
				Description: "Disk Type.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk Type." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"ssd",
					"hdd",
					"nvme",
					"sd",
				},
			},
			{
				Name:        "busPath",
				Type:        "string",
				Note:        "",
				Description: "Disk bus path.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disk bus path." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", machineInstallDiskSelectorExample())

	doc.Fields[0].AddExample("Select a disk which size is equal to 4GB.", machineInstallDiskSizeMatcherExamples0())
	doc.Fields[0].AddExample("Select a disk which size is greater than 1TB.", machineInstallDiskSizeMatcherExamples1())
	doc.Fields[0].AddExample("Select a disk which size is less or equal than 2TB.", machineInstallDiskSizeMatcherExamples2())
	doc.Fields[8].AddExample("", "/pci0000:00/0000:00:17.0/ata1/host0/target0:0:0/0:0:0:0")
	doc.Fields[8].AddExample("", "/pci0000:00/*")

	return doc
}

func (CoreDNS) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "CoreDNS",
		Comments:    [3]string{"" /* encoder.HeadComment */, "CoreDNS represents the CoreDNS config values." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "CoreDNS represents the CoreDNS config values.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "coreDNS",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "disabled",
				Type:        "bool",
				Note:        "",
				Description: "Disable coredns deployment on cluster bootstrap.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disable coredns deployment on cluster bootstrap." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "image",
				Type:        "string",
				Note:        "",
				Description: "The `image` field is an override to the default coredns image.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `image` field is an override to the default coredns image." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterCoreDNSExample())

	return doc
}

func (Endpoint) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "Endpoint",
		Comments:    [3]string{"" /* encoder.HeadComment */, "Endpoint represents the endpoint URL parsed out of the machine config." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "Endpoint represents the endpoint URL parsed out of the machine config.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ControlPlaneConfig",
				FieldName: "endpoint",
			},
			{
				TypeName:  "LoggingDestination",
				FieldName: "endpoint",
			},
		},
		Fields: []encoder.Doc{
			{},
		},
	}

	doc.AddExample("", clusterEndpointExample1())

	doc.AddExample("", clusterEndpointExample2())

	doc.AddExample("", loggingEndpointExample1())

	doc.AddExample("", loggingEndpointExample2())

	return doc
}

func (ControlPlaneConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ControlPlaneConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ControlPlaneConfig represents the control plane configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ControlPlaneConfig represents the control plane configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "controlPlane",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "endpoint",
				Type:        "Endpoint",
				Note:        "",
				Description: "Endpoint is the canonical controlplane endpoint, which can be an IP address or a DNS hostname.\nIt is single-valued, and may optionally include a port number.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Endpoint is the canonical controlplane endpoint, which can be an IP address or a DNS hostname." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "localAPIServerPort",
				Type:        "int",
				Note:        "",
				Description: "The port that the API server listens on internally.\nThis may be different than the port portion listed in the endpoint field above.\nThe default is `6443`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The port that the API server listens on internally." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("Setting controlplane endpoint address to 1.2.3.4 and port to 443 example.", clusterControlPlaneExample())

	doc.Fields[0].AddExample("", clusterEndpointExample1())
	doc.Fields[0].AddExample("", clusterEndpointExample2())

	return doc
}

func (APIServerConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "APIServerConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "APIServerConfig represents the kube apiserver configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "APIServerConfig represents the kube apiserver configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "apiServer",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "image",
				Type:        "string",
				Note:        "",
				Description: "The container image used in the API server manifest.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The container image used in the API server manifest." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraArgs",
				Type:        "Args",
				Note:        "",
				Description: "Extra arguments to supply to the API server.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra arguments to supply to the API server." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraVolumes",
				Type:        "[]VolumeMountConfig",
				Note:        "",
				Description: "Extra volumes to mount to the API server static pod.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra volumes to mount to the API server static pod." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "env",
				Type:        "Env",
				Note:        "",
				Description: "The `env` field allows for the addition of environment variables for the control plane component.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `env` field allows for the addition of environment variables for the control plane component." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "certSANs",
				Type:        "[]string",
				Note:        "",
				Description: "Extra certificate subject alternative names for the API server's certificate.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra certificate subject alternative names for the API server's certificate." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{
				Name:        "admissionControl",
				Type:        "[]AdmissionPluginConfig",
				Note:        "",
				Description: "Configure the API server admission plugins.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure the API server admission plugins." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "auditPolicy",
				Type:        "Unstructured",
				Note:        "",
				Description: "Configure the API server audit policy.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure the API server audit policy." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "resources",
				Type:        "ResourcesConfig",
				Note:        "",
				Description: "Configure the API server resources.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure the API server resources." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "authorizationConfig",
				Type:        "[]AuthorizationConfigAuthorizerConfig",
				Note:        "",
				Description: "Configure the API server authorization config. Node and RBAC authorizers are always added irrespective of the configuration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure the API server authorization config. Node and RBAC authorizers are always added irrespective of the configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterAPIServerExample())

	doc.Fields[0].AddExample("", clusterAPIServerImageExample())
	doc.Fields[6].AddExample("", admissionControlConfigExample())
	doc.Fields[7].AddExample("", APIServerDefaultAuditPolicy)
	doc.Fields[9].AddExample("", authorizationConfigExample())

	return doc
}

func (AdmissionPluginConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "AdmissionPluginConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "AdmissionPluginConfig represents the API server admission plugin configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "AdmissionPluginConfig represents the API server admission plugin configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "APIServerConfig",
				FieldName: "admissionControl",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name is the name of the admission controller.\nIt must match the registered admission plugin name.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name is the name of the admission controller." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "configuration",
				Type:        "Unstructured",
				Note:        "",
				Description: "Configuration is an embedded configuration object to be used as the plugin's\nconfiguration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configuration is an embedded configuration object to be used as the plugin's" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", admissionControlConfigExample())

	return doc
}

func (AuthorizationConfigAuthorizerConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "AuthorizationConfigAuthorizerConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "AuthorizationConfigAuthorizerConfig represents the API server authorization config authorizer configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "AuthorizationConfigAuthorizerConfig represents the API server authorization config authorizer configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "APIServerConfig",
				FieldName: "authorizationConfig",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "type",
				Type:        "string",
				Note:        "",
				Description: "Type is the name of the authorizer. Allowed values are `Node`, `RBAC`, and `Webhook`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Type is the name of the authorizer. Allowed values are `Node`, `RBAC`, and `Webhook`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name is used to describe the authorizer.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name is used to describe the authorizer." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "webhook",
				Type:        "Unstructured",
				Note:        "",
				Description: "webhook is the configuration for the webhook authorizer.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "webhook is the configuration for the webhook authorizer." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", authorizationConfigExample())

	return doc
}

func (ControllerManagerConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ControllerManagerConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ControllerManagerConfig represents the kube controller manager configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ControllerManagerConfig represents the kube controller manager configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "controllerManager",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "image",
				Type:        "string",
				Note:        "",
				Description: "The container image used in the controller manager manifest.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The container image used in the controller manager manifest." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraArgs",
				Type:        "Args",
				Note:        "",
				Description: "Extra arguments to supply to the controller manager.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra arguments to supply to the controller manager." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraVolumes",
				Type:        "[]VolumeMountConfig",
				Note:        "",
				Description: "Extra volumes to mount to the controller manager static pod.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra volumes to mount to the controller manager static pod." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "env",
				Type:        "Env",
				Note:        "",
				Description: "The `env` field allows for the addition of environment variables for the control plane component.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `env` field allows for the addition of environment variables for the control plane component." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "resources",
				Type:        "ResourcesConfig",
				Note:        "",
				Description: "Configure the controller manager resources.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure the controller manager resources." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterControllerManagerExample())

	doc.Fields[0].AddExample("", clusterControllerManagerImageExample())

	return doc
}

func (ProxyConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ProxyConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ProxyConfig represents the kube proxy configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ProxyConfig represents the kube proxy configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "proxy",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "disabled",
				Type:        "bool",
				Note:        "",
				Description: "Disable kube-proxy deployment on cluster bootstrap.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disable kube-proxy deployment on cluster bootstrap." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "image",
				Type:        "string",
				Note:        "",
				Description: "The container image used in the kube-proxy manifest.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The container image used in the kube-proxy manifest." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mode",
				Type:        "string",
				Note:        "",
				Description: "proxy mode of kube-proxy.\nThe default is 'iptables'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "proxy mode of kube-proxy." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraArgs",
				Type:        "Args",
				Note:        "",
				Description: "Extra arguments to supply to kube-proxy.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra arguments to supply to kube-proxy." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterProxyExample())

	doc.Fields[0].AddExample("", pointer.To(false))
	doc.Fields[1].AddExample("", clusterProxyImageExample())

	return doc
}

func (SchedulerConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "SchedulerConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "SchedulerConfig represents the kube scheduler configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "SchedulerConfig represents the kube scheduler configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "scheduler",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "image",
				Type:        "string",
				Note:        "",
				Description: "The container image used in the scheduler manifest.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The container image used in the scheduler manifest." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraArgs",
				Type:        "Args",
				Note:        "",
				Description: "Extra arguments to supply to the scheduler.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra arguments to supply to the scheduler." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraVolumes",
				Type:        "[]VolumeMountConfig",
				Note:        "",
				Description: "Extra volumes to mount to the scheduler static pod.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra volumes to mount to the scheduler static pod." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "env",
				Type:        "Env",
				Note:        "",
				Description: "The `env` field allows for the addition of environment variables for the control plane component.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `env` field allows for the addition of environment variables for the control plane component." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "resources",
				Type:        "ResourcesConfig",
				Note:        "",
				Description: "Configure the scheduler resources.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure the scheduler resources." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "config",
				Type:        "Unstructured",
				Note:        "",
				Description: "Specify custom kube-scheduler configuration.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Specify custom kube-scheduler configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterSchedulerExample())

	doc.Fields[0].AddExample("", clusterSchedulerImageExample())

	return doc
}

func (EtcdConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EtcdConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EtcdConfig represents the etcd configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EtcdConfig represents the etcd configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "etcd",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "image",
				Type:        "string",
				Note:        "",
				Description: "The container image used to create the etcd service.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The container image used to create the etcd service." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ca",
				Type:        "PEMEncodedCertificateAndKey",
				Note:        "",
				Description: "The `ca` is the root certificate authority of the PKI.\nIt is composed of a base64 encoded `crt` and `key`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `ca` is the root certificate authority of the PKI." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "extraArgs",
				Type:        "Args",
				Note:        "",
				Description: "Extra arguments to supply to etcd.\nNote that the following args are not allowed:\n\n- `name`\n- `data-dir`\n- `initial-cluster-state`\n- `listen-peer-urls`\n- `listen-client-urls`\n- `cert-file`\n- `key-file`\n- `trusted-ca-file`\n- `peer-client-cert-auth`\n- `peer-cert-file`\n- `peer-trusted-ca-file`\n- `peer-key-file`",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra arguments to supply to etcd." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{
				Name:        "advertisedSubnets",
				Type:        "[]string",
				Note:        "",
				Description: "The `advertisedSubnets` field configures the networks to pick etcd advertised IP from.\n\nIPs can be excluded from the list by using negative match with `!`, e.g `!10.0.0.0/8`.\nNegative subnet matches should be specified last to filter out IPs picked by positive matches.\nIf not specified, advertised IP is selected as the first routable address of the node.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `advertisedSubnets` field configures the networks to pick etcd advertised IP from." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "listenSubnets",
				Type:        "[]string",
				Note:        "",
				Description: "The `listenSubnets` field configures the networks for the etcd to listen for peer and client connections.\n\nIf `listenSubnets` is not set, but `advertisedSubnets` is set, `listenSubnets` defaults to\n`advertisedSubnets`.\n\nIf neither `advertisedSubnets` nor `listenSubnets` is set, `listenSubnets` defaults to listen on all addresses.\n\nIPs can be excluded from the list by using negative match with `!`, e.g `!10.0.0.0/8`.\nNegative subnet matches should be specified last to filter out IPs picked by positive matches.\nIf not specified, advertised IP is selected as the first routable address of the node.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The `listenSubnets` field configures the networks for the etcd to listen for peer and client connections." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterEtcdExample())

	doc.Fields[0].AddExample("", clusterEtcdImageExample())
	doc.Fields[1].AddExample("", pemEncodedCertificateExample())
	doc.Fields[4].AddExample("", clusterEtcdAdvertisedSubnetsExample())

	return doc
}

func (ClusterNetworkConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ClusterNetworkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ClusterNetworkConfig represents kube networking configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ClusterNetworkConfig represents kube networking configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "network",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "cni",
				Type:        "CNIConfig",
				Note:        "",
				Description: "The CNI used.\nComposed of \"name\" and \"urls\".\nThe \"name\" key supports the following options: \"flannel\", \"custom\", and \"none\".\n\"flannel\" uses Talos-managed Flannel CNI, and that's the default option.\n\"custom\" uses custom manifests that should be provided in \"urls\".\n\"none\" indicates that Talos will not manage any CNI installation.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The CNI used." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "dnsDomain",
				Type:        "string",
				Note:        "",
				Description: "The domain used by Kubernetes DNS.\nThe default is `cluster.local`",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The domain used by Kubernetes DNS." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "podSubnets",
				Type:        "[]string",
				Note:        "",
				Description: "The pod subnet CIDR.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The pod subnet CIDR." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "serviceSubnets",
				Type:        "[]string",
				Note:        "",
				Description: "The service subnet CIDR.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The service subnet CIDR." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("Configuring with flannel CNI and setting up subnets.", clusterNetworkExample())

	doc.Fields[0].AddExample("", clusterCustomCNIExample())
	doc.Fields[1].AddExample("", "cluster.local")
	doc.Fields[2].AddExample("", []string{"10.244.0.0/16"})
	doc.Fields[3].AddExample("", []string{"10.96.0.0/12"})

	return doc
}

func (CNIConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "CNIConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "CNIConfig represents the CNI configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "CNIConfig represents the CNI configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterNetworkConfig",
				FieldName: "cni",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of CNI to use.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of CNI to use." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"flannel",
					"custom",
					"none",
				},
			},
			{
				Name:        "urls",
				Type:        "[]string",
				Note:        "",
				Description: "URLs containing manifests to apply for the CNI.\nShould be present for \"custom\", must be empty for \"flannel\" and \"none\".",
				Comments:    [3]string{"" /* encoder.HeadComment */, "URLs containing manifests to apply for the CNI." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "flannel",
				Type:        "FlannelCNIConfig",
				Note:        "",
				Description: "description: |\nFlannel configuration options.\n",
				Comments:    [3]string{"" /* encoder.HeadComment */, "description: |" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterCustomCNIExample())

	return doc
}

func (FlannelCNIConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "FlannelCNIConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "FlannelCNIConfig represents the Flannel CNI configuration options." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "FlannelCNIConfig represents the Flannel CNI configuration options.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "CNIConfig",
				FieldName: "flannel",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "extraArgs",
				Type:        "[]string",
				Note:        "",
				Description: "Extra arguments for 'flanneld'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra arguments for 'flanneld'." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", []string{"--iface-can-reach=192.168.1.1"})

	return doc
}

func (ExternalCloudProviderConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ExternalCloudProviderConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ExternalCloudProviderConfig contains external cloud provider configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ExternalCloudProviderConfig contains external cloud provider configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "externalCloudProvider",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "enabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable external cloud provider.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable external cloud provider." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"true",
					"yes",
					"false",
					"no",
				},
			},
			{
				Name:        "manifests",
				Type:        "[]string",
				Note:        "",
				Description: "A list of urls that point to additional manifests for an external cloud provider.\nThese will get automatically deployed as part of the bootstrap.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A list of urls that point to additional manifests for an external cloud provider." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterExternalCloudProviderConfigExample())

	doc.Fields[1].AddExample("", []string{
		"https://raw.githubusercontent.com/kubernetes/cloud-provider-aws/v1.20.0-alpha.0/manifests/rbac.yaml",
		"https://raw.githubusercontent.com/kubernetes/cloud-provider-aws/v1.20.0-alpha.0/manifests/aws-cloud-controller-manager-daemonset.yaml",
	})

	return doc
}

func (AdminKubeconfigConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "AdminKubeconfigConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "AdminKubeconfigConfig contains admin kubeconfig settings." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "AdminKubeconfigConfig contains admin kubeconfig settings.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "adminKubeconfig",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "certLifetime",
				Type:        "Duration",
				Note:        "",
				Description: "Admin kubeconfig certificate lifetime (default is 1 year).\nField format accepts any Go time.Duration format ('1h' for one hour, '10m' for ten minutes).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Admin kubeconfig certificate lifetime (default is 1 year)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterAdminKubeconfigExample())

	return doc
}

func (ResourcesConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ResourcesConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ResourcesConfig represents the pod resources." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ResourcesConfig represents the pod resources.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "APIServerConfig",
				FieldName: "resources",
			},
			{
				TypeName:  "ControllerManagerConfig",
				FieldName: "resources",
			},
			{
				TypeName:  "SchedulerConfig",
				FieldName: "resources",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "requests",
				Type:        "Unstructured",
				Note:        "",
				Description: "Requests configures the reserved cpu/memory resources.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Requests configures the reserved cpu/memory resources." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "limits",
				Type:        "Unstructured",
				Note:        "",
				Description: "Limits configures the maximum cpu/memory resources a container can use.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Limits configures the maximum cpu/memory resources a container can use." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("resources requests.", resourcesConfigRequestsExample())
	doc.Fields[1].AddExample("resources requests.", resourcesConfigLimitsExample())

	return doc
}

func (MachineFile) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "MachineFile",
		Comments:    [3]string{"" /* encoder.HeadComment */, "MachineFile represents a file to write to disk." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "MachineFile represents a file to write to disk.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "files",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "content",
				Type:        "string",
				Note:        "",
				Description: "The contents of the file.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The contents of the file." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "permissions",
				Type:        "FileMode",
				Note:        "",
				Description: "The file's permissions in octal.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The file's permissions in octal." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "path",
				Type:        "string",
				Note:        "",
				Description: "The path of the file.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The path of the file." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "op",
				Type:        "string",
				Note:        "",
				Description: "The operation to use",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The operation to use" /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"create",
					"append",
					"overwrite",
				},
			},
		},
	}

	doc.AddExample("MachineFiles usage example.", machineFilesExample())

	return doc
}

func (FeaturesConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "FeaturesConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "FeaturesConfig describes individual Talos features that can be switched on or off." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "FeaturesConfig describes individual Talos features that can be switched on or off.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "features",
			},
		},
		Fields: []encoder.Doc{
			{},
			{},
			{
				Name:        "kubernetesTalosAPIAccess",
				Type:        "KubernetesTalosAPIAccessConfig",
				Note:        "",
				Description: "Configure Talos API access from Kubernetes pods.\n\nThis feature is disabled if the feature config is not specified.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure Talos API access from Kubernetes pods." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{},
			{
				Name:        "diskQuotaSupport",
				Type:        "bool",
				Note:        "",
				Description: "Enable XFS project quota support for EPHEMERAL partition and user disks.\nAlso enables kubelet tracking of ephemeral disk usage in the kubelet via quota.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable XFS project quota support for EPHEMERAL partition and user disks." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "kubePrism",
				Type:        "KubePrism",
				Note:        "",
				Description: "KubePrism - local proxy/load balancer on defined port that will distribute\nrequests to all API servers in the cluster.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "KubePrism - local proxy/load balancer on defined port that will distribute" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "hostDNS",
				Type:        "HostDNSConfig",
				Note:        "",
				Description: "Configures host DNS caching resolver.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configures host DNS caching resolver." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "imageCache",
				Type:        "ImageCacheConfig",
				Note:        "",
				Description: "Enable Image Cache feature.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable Image Cache feature." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "nodeAddressSortAlgorithm",
				Type:        "string",
				Note:        "",
				Description: "Select the node address sort algorithm.\nThe 'v1' algorithm sorts addresses by the address itself.\nThe 'v2' algorithm prefers more specific prefixes.\nIf unset, defaults to 'v1'.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Select the node address sort algorithm." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", machineFeaturesExample())

	doc.Fields[2].AddExample("", kubernetesTalosAPIAccessConfigExample())

	return doc
}

func (KubePrism) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KubePrism",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KubePrism describes the configuration for the KubePrism load balancer." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KubePrism describes the configuration for the KubePrism load balancer.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "FeaturesConfig",
				FieldName: "kubePrism",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "enabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable KubePrism support - will start local load balancing proxy.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable KubePrism support - will start local load balancing proxy." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "port",
				Type:        "int",
				Note:        "",
				Description: "KubePrism port.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "KubePrism port." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (ImageCacheConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ImageCacheConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ImageCacheConfig describes the configuration for the Image Cache feature." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ImageCacheConfig describes the configuration for the Image Cache feature.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "FeaturesConfig",
				FieldName: "imageCache",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "localEnabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable local image cache.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable local image cache." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (KubernetesTalosAPIAccessConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KubernetesTalosAPIAccessConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KubernetesTalosAPIAccessConfig describes the configuration for the Talos API access from Kubernetes pods." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KubernetesTalosAPIAccessConfig describes the configuration for the Talos API access from Kubernetes pods.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "FeaturesConfig",
				FieldName: "kubernetesTalosAPIAccess",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "enabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable Talos API access from Kubernetes pods.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable Talos API access from Kubernetes pods." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "allowedRoles",
				Type:        "[]string",
				Note:        "",
				Description: "The list of Talos API roles which can be granted for access from Kubernetes pods.\n\nEmpty list means that no roles can be granted, so access is blocked.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The list of Talos API roles which can be granted for access from Kubernetes pods." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "allowedKubernetesNamespaces",
				Type:        "[]string",
				Note:        "",
				Description: "The list of Kubernetes namespaces Talos API access is available from.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The list of Kubernetes namespaces Talos API access is available from." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", kubernetesTalosAPIAccessConfigExample())

	return doc
}

func (HostDNSConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "HostDNSConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "HostDNSConfig describes the configuration for the host DNS resolver." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "HostDNSConfig describes the configuration for the host DNS resolver.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "FeaturesConfig",
				FieldName: "hostDNS",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "enabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable host DNS caching resolver.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable host DNS caching resolver." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "forwardKubeDNSToHost",
				Type:        "bool",
				Note:        "",
				Description: "Use the host DNS resolver as upstream for Kubernetes CoreDNS pods.\n\nWhen enabled, CoreDNS pods use host DNS server as the upstream DNS (instead of\nusing configured upstream DNS resolvers directly).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Use the host DNS resolver as upstream for Kubernetes CoreDNS pods." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "resolveMemberNames",
				Type:        "bool",
				Note:        "",
				Description: "Resolve member hostnames using the host DNS resolver.\n\nWhen enabled, cluster member hostnames and node names are resolved using the host DNS resolver.\nThis requires service discovery to be enabled.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Resolve member hostnames using the host DNS resolver." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (VolumeMountConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "VolumeMountConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "VolumeMountConfig struct describes extra volume mount for the static pods." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "VolumeMountConfig struct describes extra volume mount for the static pods.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "APIServerConfig",
				FieldName: "extraVolumes",
			},
			{
				TypeName:  "ControllerManagerConfig",
				FieldName: "extraVolumes",
			},
			{
				TypeName:  "SchedulerConfig",
				FieldName: "extraVolumes",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "hostPath",
				Type:        "string",
				Note:        "",
				Description: "Path on the host.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Path on the host." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mountPath",
				Type:        "string",
				Note:        "",
				Description: "Path in the container.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Path in the container." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "readonly",
				Type:        "bool",
				Note:        "",
				Description: "Mount the volume read only.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Mount the volume read only." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", "/var/lib/auth")
	doc.Fields[1].AddExample("", "/etc/kubernetes/auth")
	doc.Fields[2].AddExample("", true)

	return doc
}

func (ClusterInlineManifest) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ClusterInlineManifest",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ClusterInlineManifest struct describes inline bootstrap manifests for the user." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ClusterInlineManifest struct describes inline bootstrap manifests for the user.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "inlineManifests",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the manifest.\nName should be unique.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the manifest." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "contents",
				Type:        "string",
				Note:        "",
				Description: "Manifest contents as a string.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Manifest contents as a string." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterInlineManifestsExample())

	doc.Fields[0].AddExample("", "csi")
	doc.Fields[1].AddExample("", "/etc/kubernetes/auth")

	return doc
}

func (ClusterDiscoveryConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "ClusterDiscoveryConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "ClusterDiscoveryConfig struct configures cluster membership discovery." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "ClusterDiscoveryConfig struct configures cluster membership discovery.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterConfig",
				FieldName: "discovery",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "enabled",
				Type:        "bool",
				Note:        "",
				Description: "Enable the cluster membership discovery feature.\nCluster discovery is based on individual registries which are configured under the registries field.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Enable the cluster membership discovery feature." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "registries",
				Type:        "DiscoveryRegistriesConfig",
				Note:        "",
				Description: "Configure registries used for cluster member discovery.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure registries used for cluster member discovery." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", clusterDiscoveryExample())

	return doc
}

func (DiscoveryRegistriesConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "DiscoveryRegistriesConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "DiscoveryRegistriesConfig struct configures cluster membership discovery." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "DiscoveryRegistriesConfig struct configures cluster membership discovery.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "ClusterDiscoveryConfig",
				FieldName: "registries",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "kubernetes",
				Type:        "RegistryKubernetesConfig",
				Note:        "",
				Description: "Kubernetes registry uses Kubernetes API server to discover cluster members and stores additional information\nas annotations on the Node resources.\n\nThis feature is deprecated as it is not compatible with Kubernetes 1.32+.\nSee https://github.com/siderolabs/talos/issues/9980 for more information.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Kubernetes registry uses Kubernetes API server to discover cluster members and stores additional information" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "service",
				Type:        "RegistryServiceConfig",
				Note:        "",
				Description: "Service registry is using an external service to push and pull information about cluster members.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Service registry is using an external service to push and pull information about cluster members." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (RegistryKubernetesConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RegistryKubernetesConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RegistryKubernetesConfig struct configures Kubernetes discovery registry." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RegistryKubernetesConfig struct configures Kubernetes discovery registry.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "DiscoveryRegistriesConfig",
				FieldName: "kubernetes",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "disabled",
				Type:        "bool",
				Note:        "",
				Description: "Disable Kubernetes discovery registry.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disable Kubernetes discovery registry." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (RegistryServiceConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RegistryServiceConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RegistryServiceConfig struct configures Kubernetes discovery registry." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RegistryServiceConfig struct configures Kubernetes discovery registry.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "DiscoveryRegistriesConfig",
				FieldName: "service",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "disabled",
				Type:        "bool",
				Note:        "",
				Description: "Disable external service discovery registry.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Disable external service discovery registry." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "endpoint",
				Type:        "string",
				Note:        "",
				Description: "External service endpoint.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "External service endpoint." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[1].AddExample("", constants.DefaultDiscoveryServiceEndpoint)

	return doc
}

func (UdevConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "UdevConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "UdevConfig describes how the udev system should be configured." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "UdevConfig describes how the udev system should be configured.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "udev",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "rules",
				Type:        "[]string",
				Note:        "",
				Description: "List of udev rules to apply to the udev system",
				Comments:    [3]string{"" /* encoder.HeadComment */, "List of udev rules to apply to the udev system" /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", machineUdevExample())

	return doc
}

func (LoggingConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "LoggingConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "LoggingConfig struct configures Talos logging." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "LoggingConfig struct configures Talos logging.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "logging",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "destinations",
				Type:        "[]LoggingDestination",
				Note:        "",
				Description: "Logging destination.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Logging destination." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", machineLoggingExample())

	return doc
}

func (LoggingDestination) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "LoggingDestination",
		Comments:    [3]string{"" /* encoder.HeadComment */, "LoggingDestination struct configures Talos logging destination." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "LoggingDestination struct configures Talos logging destination.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "LoggingConfig",
				FieldName: "destinations",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "endpoint",
				Type:        "Endpoint",
				Note:        "",
				Description: "Where to send logs. Supported protocols are \"tcp\" and \"udp\".",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Where to send logs. Supported protocols are \"tcp\" and \"udp\"." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "format",
				Type:        "string",
				Note:        "",
				Description: "Logs format.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Logs format." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"json_lines",
				},
			},
			{
				Name:        "extraTags",
				Type:        "map[string]string",
				Note:        "",
				Description: "Extra tags (key-value) pairs to attach to every log message sent.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Extra tags (key-value) pairs to attach to every log message sent." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", loggingEndpointExample1())
	doc.Fields[0].AddExample("", loggingEndpointExample2())

	return doc
}

func (KernelConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KernelConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KernelConfig struct configures Talos Linux kernel." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KernelConfig struct configures Talos Linux kernel.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "MachineConfig",
				FieldName: "kernel",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "modules",
				Type:        "[]KernelModuleConfig",
				Note:        "",
				Description: "Kernel modules to load.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Kernel modules to load." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", machineKernelExample())

	return doc
}

func (KernelModuleConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KernelModuleConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KernelModuleConfig struct configures Linux kernel modules to load." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KernelModuleConfig struct configures Linux kernel modules to load.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "KernelConfig",
				FieldName: "modules",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Module name.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Module name." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "parameters",
				Type:        "[]string",
				Note:        "",
				Description: "Module parameters, changes applied after reboot.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Module parameters, changes applied after reboot." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

// GetFileDoc returns documentation for the file ./v1alpha1_types_doc.go.
func GetFileDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "v1alpha1",
		Description: "Package v1alpha1 contains definition of the `v1alpha1` configuration document.\n\nEven though the machine configuration in Talos Linux is multi-document, at the moment\nthis configuration document contains most of the configuration options.\n\nIt is expected that new configuration options will be added as new documents, and existing ones\nmigrated to their own documents.\n",
		Structs: []*encoder.Doc{
			Config{}.Doc(),
			MachineConfig{}.Doc(),
			MachineSeccompProfile{}.Doc(),
			ClusterConfig{}.Doc(),
			LinuxIDMapping{}.Doc(),
			ExtraMount{}.Doc(),
			MachineControlPlaneConfig{}.Doc(),
			MachineControllerManagerConfig{}.Doc(),
			MachineSchedulerConfig{}.Doc(),
			KubeletConfig{}.Doc(),
			KubeletNodeIPConfig{}.Doc(),
			InstallConfig{}.Doc(),
			InstallDiskSelector{}.Doc(),
			CoreDNS{}.Doc(),
			Endpoint{}.Doc(),
			ControlPlaneConfig{}.Doc(),
			APIServerConfig{}.Doc(),
			AdmissionPluginConfig{}.Doc(),
			AuthorizationConfigAuthorizerConfig{}.Doc(),
			ControllerManagerConfig{}.Doc(),
			ProxyConfig{}.Doc(),
			SchedulerConfig{}.Doc(),
			EtcdConfig{}.Doc(),
			ClusterNetworkConfig{}.Doc(),
			CNIConfig{}.Doc(),
			FlannelCNIConfig{}.Doc(),
			ExternalCloudProviderConfig{}.Doc(),
			AdminKubeconfigConfig{}.Doc(),
			ResourcesConfig{}.Doc(),
			MachineFile{}.Doc(),
			FeaturesConfig{}.Doc(),
			KubePrism{}.Doc(),
			ImageCacheConfig{}.Doc(),
			KubernetesTalosAPIAccessConfig{}.Doc(),
			HostDNSConfig{}.Doc(),
			VolumeMountConfig{}.Doc(),
			ClusterInlineManifest{}.Doc(),
			ClusterDiscoveryConfig{}.Doc(),
			DiscoveryRegistriesConfig{}.Doc(),
			RegistryKubernetesConfig{}.Doc(),
			RegistryServiceConfig{}.Doc(),
			UdevConfig{}.Doc(),
			LoggingConfig{}.Doc(),
			LoggingDestination{}.Doc(),
			KernelConfig{}.Doc(),
			KernelModuleConfig{}.Doc(),
		},
	}
}
