// python wrapper for ttkScalarFieldSmoother
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkScalarFieldSmoother.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkScalarFieldSmoother(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkScalarFieldSmoother_ClassNew(); }


static PyObject *
PyttkScalarFieldSmoother_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkScalarFieldSmoother::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldSmoother *op = static_cast<ttkScalarFieldSmoother *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkScalarFieldSmoother::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkScalarFieldSmoother *tempr = ttkScalarFieldSmoother::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldSmoother *op = static_cast<ttkScalarFieldSmoother *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkScalarFieldSmoother *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkScalarFieldSmoother::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkScalarFieldSmoother::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldSmoother *op = static_cast<ttkScalarFieldSmoother *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkScalarFieldSmoother::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_SetNumberOfIterations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfIterations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldSmoother *op = static_cast<ttkScalarFieldSmoother *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfIterations(temp0);
    }
    else
    {
      op->ttkScalarFieldSmoother::SetNumberOfIterations(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_GetNumberOfIterations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfIterations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldSmoother *op = static_cast<ttkScalarFieldSmoother *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfIterations() :
      op->ttkScalarFieldSmoother::GetNumberOfIterations());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_SetForceInputMaskScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputMaskScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldSmoother *op = static_cast<ttkScalarFieldSmoother *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputMaskScalarField(temp0);
    }
    else
    {
      op->ttkScalarFieldSmoother::SetForceInputMaskScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkScalarFieldSmoother_GetForceInputMaskScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputMaskScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkScalarFieldSmoother *op = static_cast<ttkScalarFieldSmoother *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputMaskScalarField() :
      op->ttkScalarFieldSmoother::GetForceInputMaskScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkScalarFieldSmoother_Methods[] = {
  {"IsTypeOf", PyttkScalarFieldSmoother_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkScalarFieldSmoother_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkScalarFieldSmoother_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkScalarFieldSmoother\nC++: static ttkScalarFieldSmoother *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkScalarFieldSmoother_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkScalarFieldSmoother\nC++: ttkScalarFieldSmoother *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkScalarFieldSmoother_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkScalarFieldSmoother_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetNumberOfIterations", PyttkScalarFieldSmoother_SetNumberOfIterations, METH_VARARGS,
   "SetNumberOfIterations(self, _arg:int) -> None\nC++: virtual void SetNumberOfIterations(int _arg)\n\n"},
  {"GetNumberOfIterations", PyttkScalarFieldSmoother_GetNumberOfIterations, METH_VARARGS,
   "GetNumberOfIterations(self) -> int\nC++: virtual int GetNumberOfIterations()\n\n"},
  {"SetForceInputMaskScalarField", PyttkScalarFieldSmoother_SetForceInputMaskScalarField, METH_VARARGS,
   "SetForceInputMaskScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputMaskScalarField(bool _arg)\n\n"},
  {"GetForceInputMaskScalarField", PyttkScalarFieldSmoother_GetForceInputMaskScalarField, METH_VARARGS,
   "GetForceInputMaskScalarField(self) -> bool\nC++: virtual bool GetForceInputMaskScalarField()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkScalarFieldSmoother_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_mask_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldSmoother_GetForceInputMaskScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldSmoother_SetForceInputMaskScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldSmoother_SetForceInputMaskScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputMaskScalarField/SetForceInputMaskScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_iterations"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkScalarFieldSmoother_GetNumberOfIterations(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkScalarFieldSmoother_SetNumberOfIterations(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkScalarFieldSmoother_SetNumberOfIterations(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfIterations/SetNumberOfIterations\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkScalarFieldSmoother_Doc =
  "ttkScalarFieldSmoother - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\date November 2014.\n\n"
  "TTK VTK-filter for scalar field smoothing.\n\n"
  "This class is a dummy example for the development of TTK filters. It\n"
  "smooths an input scalar field by averaging the scalar values on the\n"
  "link of each vertex.\n\n"
  "\\param Input vtkDataSet\n"
  "\\param Output vtkDataSet\n\n"
  "The input data array needs to be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 0 (FIXED: the first array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "The optional mask array can be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 1 (FIXED: the second array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the mask array)\n\n"
  "ote: To use this optional array, `ForceInputMaskScalarField` needs to\n"
  "be\n"
  "enabled with the setter `setForceInputMaskScalarField()'.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the corresponding standalone program for a usage example:\n"
  "- standalone/ScalarFieldSmoother/main.cpp\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa vtkGeometrySmoother\n"
  "\\sa ttk::ScalarFieldSmoother\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morsePersistence/\"\n"
  "  >Morse Persistence example\\n\n"
  "- <a href=\"https://topology-tool-kit.github.io/examples/mpiExample/\">\n"
  "  MPI example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_darkSky/\"\n"
  "  >Persistent Generators Dark Sky example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_darkSky/\"\n"
  "  >Topological Optimization DarkSky\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_pegasus/\"\n"
  "  >Topological Optimization for Pegasus Genus Repair example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkScalarFieldSmoother_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkScalarFieldSmoother.ttkScalarFieldSmoother", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkScalarFieldSmoother_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkScalarFieldSmoother_StaticNew()
{
  return ttkScalarFieldSmoother::New();
}

PyObject *PyttkScalarFieldSmoother_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkScalarFieldSmoother_Type, PyttkScalarFieldSmoother_Methods,
    "ttkScalarFieldSmoother",
 &PyttkScalarFieldSmoother_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkScalarFieldSmoother_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkScalarFieldSmoother(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkScalarFieldSmoother_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkScalarFieldSmoother", o) != 0)
  {
    Py_DECREF(o);
  }

}

