/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	gatewayapiapisxv1alpha1 "sigs.k8s.io/gateway-api/apisx/v1alpha1"
	versioned "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned"
	internalinterfaces "sigs.k8s.io/gateway-api/pkg/client/informers/externalversions/internalinterfaces"
	apisxv1alpha1 "sigs.k8s.io/gateway-api/pkg/client/listers/apisx/v1alpha1"
)

// XBackendTrafficPolicyInformer provides access to a shared informer and lister for
// XBackendTrafficPolicies.
type XBackendTrafficPolicyInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() apisxv1alpha1.XBackendTrafficPolicyLister
}

type xBackendTrafficPolicyInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewXBackendTrafficPolicyInformer constructs a new informer for XBackendTrafficPolicy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewXBackendTrafficPolicyInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredXBackendTrafficPolicyInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredXBackendTrafficPolicyInformer constructs a new informer for XBackendTrafficPolicy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredXBackendTrafficPolicyInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ExperimentalV1alpha1().XBackendTrafficPolicies(namespace).List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ExperimentalV1alpha1().XBackendTrafficPolicies(namespace).Watch(context.Background(), options)
			},
			ListWithContextFunc: func(ctx context.Context, options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ExperimentalV1alpha1().XBackendTrafficPolicies(namespace).List(ctx, options)
			},
			WatchFuncWithContext: func(ctx context.Context, options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ExperimentalV1alpha1().XBackendTrafficPolicies(namespace).Watch(ctx, options)
			},
		},
		&gatewayapiapisxv1alpha1.XBackendTrafficPolicy{},
		resyncPeriod,
		indexers,
	)
}

func (f *xBackendTrafficPolicyInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredXBackendTrafficPolicyInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *xBackendTrafficPolicyInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&gatewayapiapisxv1alpha1.XBackendTrafficPolicy{}, f.defaultInformer)
}

func (f *xBackendTrafficPolicyInformer) Lister() apisxv1alpha1.XBackendTrafficPolicyLister {
	return apisxv1alpha1.NewXBackendTrafficPolicyLister(f.Informer().GetIndexer())
}
