/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

// RedisApplyConfiguration represents a declarative configuration of the Redis type for use
// with apply.
type RedisApplyConfiguration struct {
	Endpoints      []string                     `json:"endpoints,omitempty"`
	TLS            *ClientTLSApplyConfiguration `json:"tls,omitempty"`
	Secret         *string                      `json:"secret,omitempty"`
	DB             *int                         `json:"db,omitempty"`
	PoolSize       *int                         `json:"poolSize,omitempty"`
	MinIdleConns   *int                         `json:"minIdleConns,omitempty"`
	MaxActiveConns *int                         `json:"maxActiveConns,omitempty"`
	ReadTimeout    *intstr.IntOrString          `json:"readTimeout,omitempty"`
	WriteTimeout   *intstr.IntOrString          `json:"writeTimeout,omitempty"`
	DialTimeout    *intstr.IntOrString          `json:"dialTimeout,omitempty"`
}

// RedisApplyConfiguration constructs a declarative configuration of the Redis type for use with
// apply.
func Redis() *RedisApplyConfiguration {
	return &RedisApplyConfiguration{}
}

// WithEndpoints adds the given value to the Endpoints field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Endpoints field.
func (b *RedisApplyConfiguration) WithEndpoints(values ...string) *RedisApplyConfiguration {
	for i := range values {
		b.Endpoints = append(b.Endpoints, values[i])
	}
	return b
}

// WithTLS sets the TLS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TLS field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithTLS(value *ClientTLSApplyConfiguration) *RedisApplyConfiguration {
	b.TLS = value
	return b
}

// WithSecret sets the Secret field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Secret field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithSecret(value string) *RedisApplyConfiguration {
	b.Secret = &value
	return b
}

// WithDB sets the DB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DB field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithDB(value int) *RedisApplyConfiguration {
	b.DB = &value
	return b
}

// WithPoolSize sets the PoolSize field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PoolSize field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithPoolSize(value int) *RedisApplyConfiguration {
	b.PoolSize = &value
	return b
}

// WithMinIdleConns sets the MinIdleConns field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinIdleConns field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithMinIdleConns(value int) *RedisApplyConfiguration {
	b.MinIdleConns = &value
	return b
}

// WithMaxActiveConns sets the MaxActiveConns field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxActiveConns field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithMaxActiveConns(value int) *RedisApplyConfiguration {
	b.MaxActiveConns = &value
	return b
}

// WithReadTimeout sets the ReadTimeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReadTimeout field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithReadTimeout(value intstr.IntOrString) *RedisApplyConfiguration {
	b.ReadTimeout = &value
	return b
}

// WithWriteTimeout sets the WriteTimeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the WriteTimeout field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithWriteTimeout(value intstr.IntOrString) *RedisApplyConfiguration {
	b.WriteTimeout = &value
	return b
}

// WithDialTimeout sets the DialTimeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DialTimeout field is set to the value of the last call.
func (b *RedisApplyConfiguration) WithDialTimeout(value intstr.IntOrString) *RedisApplyConfiguration {
	b.DialTimeout = &value
	return b
}
