// python wrapper for vtkConduitSource
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkConduitSource.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkConduitSource(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkConduitSource_ClassNew(); }


static PyObject *
PyvtkConduitSource_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkConduitSource::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkConduitSource::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkConduitSource *tempr = vtkConduitSource::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkConduitSource *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkConduitSource::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkConduitSource::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkConduitSource::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_SetUseAMRMeshProtocol(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseAMRMeshProtocol");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseAMRMeshProtocol(temp0);
    }
    else
    {
      op->vtkConduitSource::SetUseAMRMeshProtocol(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_GetUseAMRMeshProtocol(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseAMRMeshProtocol");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseAMRMeshProtocol() :
      op->vtkConduitSource::GetUseAMRMeshProtocol());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_UseAMRMeshProtocolOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseAMRMeshProtocolOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseAMRMeshProtocolOn();
    }
    else
    {
      op->vtkConduitSource::UseAMRMeshProtocolOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_UseAMRMeshProtocolOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseAMRMeshProtocolOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseAMRMeshProtocolOff();
    }
    else
    {
      op->vtkConduitSource::UseAMRMeshProtocolOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_SetUseMultiMeshProtocol(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseMultiMeshProtocol");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseMultiMeshProtocol(temp0);
    }
    else
    {
      op->vtkConduitSource::SetUseMultiMeshProtocol(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_GetUseMultiMeshProtocol(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseMultiMeshProtocol");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseMultiMeshProtocol() :
      op->vtkConduitSource::GetUseMultiMeshProtocol());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_UseMultiMeshProtocolOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseMultiMeshProtocolOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseMultiMeshProtocolOn();
    }
    else
    {
      op->vtkConduitSource::UseMultiMeshProtocolOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_UseMultiMeshProtocolOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseMultiMeshProtocolOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseMultiMeshProtocolOff();
    }
    else
    {
      op->vtkConduitSource::UseMultiMeshProtocolOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_SetOutputMultiBlock(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputMultiBlock");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputMultiBlock(temp0);
    }
    else
    {
      op->vtkConduitSource::SetOutputMultiBlock(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_GetOutputMultiBlock(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputMultiBlock");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputMultiBlock() :
      op->vtkConduitSource::GetOutputMultiBlock());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_OutputMultiBlockOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OutputMultiBlockOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OutputMultiBlockOn();
    }
    else
    {
      op->vtkConduitSource::OutputMultiBlockOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkConduitSource_OutputMultiBlockOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OutputMultiBlockOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkConduitSource *op = static_cast<vtkConduitSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OutputMultiBlockOff();
    }
    else
    {
      op->vtkConduitSource::OutputMultiBlockOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkConduitSource_Methods[] = {
  {"IsTypeOf", PyvtkConduitSource_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkConduitSource_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkConduitSource_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkConduitSource\nC++: static vtkConduitSource *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkConduitSource_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkConduitSource\nC++: vtkConduitSource *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkConduitSource_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkConduitSource_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetUseAMRMeshProtocol", PyvtkConduitSource_SetUseAMRMeshProtocol, METH_VARARGS,
   "SetUseAMRMeshProtocol(self, _arg:bool) -> None\nC++: virtual void SetUseAMRMeshProtocol(bool _arg)\n\nvtkConduitSource supports single 'mesh' and multiple 'mesh' (aka\n'multimesh') as well as AMR mesh (aka 'amrmesh') protocols. Set\nthis to true if the source is handling amrmesh (default is\nfalse).\n"},
  {"GetUseAMRMeshProtocol", PyvtkConduitSource_GetUseAMRMeshProtocol, METH_VARARGS,
   "GetUseAMRMeshProtocol(self) -> bool\nC++: virtual bool GetUseAMRMeshProtocol()\n\n"},
  {"UseAMRMeshProtocolOn", PyvtkConduitSource_UseAMRMeshProtocolOn, METH_VARARGS,
   "UseAMRMeshProtocolOn(self) -> None\nC++: virtual void UseAMRMeshProtocolOn()\n\n"},
  {"UseAMRMeshProtocolOff", PyvtkConduitSource_UseAMRMeshProtocolOff, METH_VARARGS,
   "UseAMRMeshProtocolOff(self) -> None\nC++: virtual void UseAMRMeshProtocolOff()\n\n"},
  {"SetUseMultiMeshProtocol", PyvtkConduitSource_SetUseMultiMeshProtocol, METH_VARARGS,
   "SetUseMultiMeshProtocol(self, _arg:bool) -> None\nC++: virtual void SetUseMultiMeshProtocol(bool _arg)\n\nvtkConduitSource supports single 'mesh' and multiple 'mesh' (aka\n'multimesh') as well as AMR mesh (aka 'amrmesh') protocols. Set\nthis to true if the source is handling multimesh (default is\nfalse).\n"},
  {"GetUseMultiMeshProtocol", PyvtkConduitSource_GetUseMultiMeshProtocol, METH_VARARGS,
   "GetUseMultiMeshProtocol(self) -> bool\nC++: virtual bool GetUseMultiMeshProtocol()\n\n"},
  {"UseMultiMeshProtocolOn", PyvtkConduitSource_UseMultiMeshProtocolOn, METH_VARARGS,
   "UseMultiMeshProtocolOn(self) -> None\nC++: virtual void UseMultiMeshProtocolOn()\n\n"},
  {"UseMultiMeshProtocolOff", PyvtkConduitSource_UseMultiMeshProtocolOff, METH_VARARGS,
   "UseMultiMeshProtocolOff(self) -> None\nC++: virtual void UseMultiMeshProtocolOff()\n\n"},
  {"SetOutputMultiBlock", PyvtkConduitSource_SetOutputMultiBlock, METH_VARARGS,
   "SetOutputMultiBlock(self, _arg:bool) -> None\nC++: virtual void SetOutputMultiBlock(bool _arg)\n\nvtkConduitSource supports output vtkMultiBlock instead of\nvtkPartitionedDataSetCollection Set this to true if the source\nshould output vtkMultiBlock (default is false).\n"},
  {"GetOutputMultiBlock", PyvtkConduitSource_GetOutputMultiBlock, METH_VARARGS,
   "GetOutputMultiBlock(self) -> bool\nC++: virtual bool GetOutputMultiBlock()\n\n"},
  {"OutputMultiBlockOn", PyvtkConduitSource_OutputMultiBlockOn, METH_VARARGS,
   "OutputMultiBlockOn(self) -> None\nC++: virtual void OutputMultiBlockOn()\n\n"},
  {"OutputMultiBlockOff", PyvtkConduitSource_OutputMultiBlockOff, METH_VARARGS,
   "OutputMultiBlockOff(self) -> None\nC++: virtual void OutputMultiBlockOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkConduitSource_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_amr_mesh_protocol"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkConduitSource_GetUseAMRMeshProtocol(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkConduitSource_SetUseAMRMeshProtocol(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkConduitSource_SetUseAMRMeshProtocol(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseAMRMeshProtocol/SetUseAMRMeshProtocol\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_multi_mesh_protocol"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkConduitSource_GetUseMultiMeshProtocol(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkConduitSource_SetUseMultiMeshProtocol(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkConduitSource_SetUseMultiMeshProtocol(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseMultiMeshProtocol/SetUseMultiMeshProtocol\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_multi_block"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkConduitSource_GetOutputMultiBlock(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkConduitSource_SetOutputMultiBlock(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkConduitSource_SetOutputMultiBlock(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputMultiBlock/SetOutputMultiBlock\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkConduitSource_Doc =
  "vtkConduitSource - data source for Conduit Mesh Blueprint.\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "@ingroup Insitu\n\n"
  "vtkConduitSource is a data source that processes a Conduit node using\n"
  "[Conduit Mesh\n"
  "Blueprint](https://llnl-conduit.readthedocs.io/en/latest/blueprint_mes\n"
  "h.html#) to describe computational mesh and associated meta-data.\n\n"
  "vtkConduitSource currently produces a `vtkParitionedDataSet` or\n"
  "`vtkPartitionedDataSetCollection`\n\n"
  "@sa vtkConduitArrayUtilities\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkConduitSource_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOCatalystConduit.vtkConduitSource", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkConduitSource_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkConduitSource_StaticNew()
{
  return vtkConduitSource::New();
}

PyObject *PyvtkConduitSource_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkConduitSource_Type, PyvtkConduitSource_Methods,
    "vtkConduitSource",
 &PyvtkConduitSource_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkConduitSource_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkConduitSource(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkConduitSource_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkConduitSource", o) != 0)
  {
    Py_DECREF(o);
  }

}

