// java wrapper for vtkIncrementalOctreeNode object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkIncrementalOctreeNode.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkIncrementalOctreeNode_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkIncrementalOctreeNode",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetNumberOfPoints_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetPointIdSet_15(JNIEnv* env, jobject obj)
{
  vtkIdList * temp20;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointIdSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreeNode_DeleteChildNodes_16(JNIEnv* env, jobject obj)
{

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeleteChildNodes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreeNode_SetBounds_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetBounds_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetMinBounds_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetMaxBounds_110(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_IsLeaf_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsLeaf();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetChildIndex_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChildIndex(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetChild_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkIncrementalOctreeNode * temp20;
  temp0 = id0;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChild(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_ContainsPoint_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ContainsPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_ContainsPointByData_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ContainsPointByData(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetDistance2ToInnerBoundary_116(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkIncrementalOctreeNode * temp1;
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, id1));

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistance2ToInnerBoundary(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetDistance2ToBoundary_117(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1,jint id2)
{
  double temp0[3];
  vtkIncrementalOctreeNode * temp1;
  int   temp2;
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistance2ToBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetDistance2ToBoundary_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jobject id2,jint id3)
{
  double temp0[3];
  double temp1[3];
  vtkIncrementalOctreeNode * temp2;
  int   temp3;
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistance2ToBoundary(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkIncrementalOctreeNode_ExportAllPointIdsByInsertion_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdList * temp0;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExportAllPointIdsByInsertion(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetNumberOfLevels_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLevels();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetID_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetID();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkIncrementalOctreeNode_GetPointIds_122(JNIEnv* env, jobject obj)
{
  vtkIdList * temp20;

  vtkIncrementalOctreeNode* op = static_cast<vtkIncrementalOctreeNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointIds();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkIncrementalOctreeNode_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkIncrementalOctreeNode::New());
}
