// java wrapper for vtkStaticPointLocator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStaticPointLocator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractPointLocator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStaticPointLocator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStaticPointLocator",dType)) { return me; }
  if ((res= vtkAbstractPointLocator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStaticPointLocator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStaticPointLocator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStaticPointLocator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStaticPointLocator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_SetNumberOfPointsPerBucket_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPointsPerBucket(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStaticPointLocator_GetNumberOfPointsPerBucketMinValue_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBucketMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStaticPointLocator_GetNumberOfPointsPerBucketMaxValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBucketMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStaticPointLocator_GetNumberOfPointsPerBucket_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBucket();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_SetDivisions_18(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDivisions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_SetDivisions_19(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDivisions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkStaticPointLocator_GetDivisions_110(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDivisions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStaticPointLocator_FindClosestPoint_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_FindClosestNPoints_112(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindClosestNPoints(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_FindPointsWithinRadius_113(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jobject id2)
{
  double   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPointsWithinRadius(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_Initialize_114(JNIEnv* env, jobject obj)
{

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_FreeSearchStructure_115(JNIEnv* env, jobject obj)
{

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FreeSearchStructure();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_BuildLocator_116(JNIEnv* env, jobject obj)
{

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_ForceBuildLocator_117(JNIEnv* env, jobject obj)
{

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceBuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_GenerateRepresentation_118(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentation(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStaticPointLocator_GetNumberOfPointsInBucket_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsInBucket(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_GetBucketIds_120(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBucketIds(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_SetMaxNumberOfBuckets_121(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxNumberOfBuckets(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStaticPointLocator_GetMaxNumberOfBucketsMinValue_122(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNumberOfBucketsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStaticPointLocator_GetMaxNumberOfBucketsMaxValue_123(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNumberOfBucketsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStaticPointLocator_GetMaxNumberOfBuckets_124(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNumberOfBuckets();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStaticPointLocator_GetLargeIds_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLargeIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_GetSpacing_126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSpacing(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_SetTraversalOrder_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTraversalOrder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStaticPointLocator_GetTraversalOrderMinValue_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTraversalOrderMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStaticPointLocator_GetTraversalOrderMaxValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTraversalOrderMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStaticPointLocator_GetTraversalOrder_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTraversalOrder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_SetTraversalOrderToPointOrder_131(JNIEnv* env, jobject obj)
{

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTraversalOrderToPointOrder();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_SetTraversalOrderToBinOrder_132(JNIEnv* env, jobject obj)
{

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTraversalOrderToBinOrder();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStaticPointLocator_FindClosestPoint_133(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_FindClosestNPoints_134(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2,jdouble id3,jobject id4)
{
  int   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  vtkIdList * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindClosestNPoints(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStaticPointLocator_FindPointsWithinRadius_135(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jobject id4)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  vtkIdList * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));

  vtkStaticPointLocator* op = static_cast<vtkStaticPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPointsWithinRadius(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkStaticPointLocator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkStaticPointLocator::New());
}
