// java wrapper for vtkAlgorithm object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAlgorithm.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAlgorithm_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAlgorithm",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_HasExecutive_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasExecutive();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetExecutive_15(JNIEnv* env, jobject obj)
{
  vtkExecutive * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExecutive();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetExecutive_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkExecutive * temp0;
  temp0 = static_cast<vtkExecutive*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExecutive(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_ProcessRequest_17(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkInformation * temp0;
  vtkCollection * temp1;
  vtkInformationVector * temp2;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id2));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ProcessRequest(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_ModifyRequest_18(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformation * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ModifyRequest(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputPortInformation_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkInformation * temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputPortInformation(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetOutputPortInformation_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkInformation * temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPortInformation(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInformation_111(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInformation_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInformation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetNumberOfInputPorts_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfInputPorts();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetNumberOfOutputPorts_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfOutputPorts();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAlgorithm_UsesGarbageCollector_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UsesGarbageCollector();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetAbortExecuteAndUpdateTime_116(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAbortExecuteAndUpdateTime();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetAbortExecute_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAbortExecute(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetAbortExecute_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbortExecute();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_AbortExecuteOn_119(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->AbortExecuteOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_AbortExecuteOff_120(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->AbortExecuteOff();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAlgorithm_GetProgress_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProgress();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_UpdateProgress_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateProgress(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAlgorithm_CheckAbort_123(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckAbort();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetContainerAlgorithm_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithm * temp0;
  temp0 = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContainerAlgorithm(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetContainerAlgorithm_125(JNIEnv* env, jobject obj)
{
  vtkAlgorithm * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContainerAlgorithm();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetAbortOutput_126(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAbortOutput(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAlgorithm_GetAbortOutput_127(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbortOutput();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetProgressShiftScale_128(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProgressShiftScale(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAlgorithm_GetProgressShift_129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProgressShift();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAlgorithm_GetProgressScale_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProgressScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetProgressText_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProgressText(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAlgorithm_GetProgressText_132(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProgressText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetErrorCode_133(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetErrorCode();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_INPUT_1IS_1OPTIONAL_134(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->INPUT_IS_OPTIONAL();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_INPUT_1IS_1REPEATABLE_135(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->INPUT_IS_REPEATABLE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_INPUT_1REQUIRED_1FIELDS_136(JNIEnv* env, jobject obj)
{
  vtkInformationInformationVectorKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->INPUT_REQUIRED_FIELDS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_INPUT_1REQUIRED_1DATA_1TYPE_137(JNIEnv* env, jobject obj)
{
  vtkInformationStringVectorKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->INPUT_REQUIRED_DATA_TYPE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_INPUT_1ARRAYS_1TO_1PROCESS_138(JNIEnv* env, jobject obj)
{
  vtkInformationInformationVectorKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->INPUT_ARRAYS_TO_PROCESS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_INPUT_1PORT_139(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->INPUT_PORT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_INPUT_1CONNECTION_140(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->INPUT_CONNECTION();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_CAN_1PRODUCE_1SUB_1EXTENT_141(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CAN_PRODUCE_SUB_EXTENT();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_CAN_1HANDLE_1PIECE_1REQUEST_142(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CAN_HANDLE_PIECE_REQUEST();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_ABORTED_143(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ABORTED();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputArrayToProcess_144(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputArrayToProcess_145(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3, jbyteArray id4, jint len4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  char * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = vtkJavaUTF8ToChars(env, id4, len4);

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1,temp2,temp3,temp4);
  delete[] temp4;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputArrayToProcess_146(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputArrayToProcess_147(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputArrayToProcess_148(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2, jbyteArray id3, jint len3, jbyteArray id4, jint len4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  char * temp3;
  char * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = vtkJavaUTF8ToChars(env, id3, len3);
  temp4 = vtkJavaUTF8ToChars(env, id4, len4);

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1,temp2,temp3,temp4);
  delete[] temp3;
  delete[] temp4;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputArrayInformation_149(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkInformation * temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputArrayInformation(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_RemoveAllInputs_150(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllInputs();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetOutputDataObject_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataObject * temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputDataObject(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputDataObject_152(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkDataObject * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputDataObject(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputConnection_153(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAlgorithmOutput * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputConnection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputConnection_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_AddInputConnection_155(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAlgorithmOutput * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddInputConnection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_AddInputConnection_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddInputConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_RemoveInputConnection_157(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAlgorithmOutput * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveInputConnection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_RemoveInputConnection_158(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveInputConnection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_RemoveAllInputConnections_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllInputConnections(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputDataObject_160(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkDataObject * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputDataObject(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetInputDataObject_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputDataObject(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_AddInputDataObject_162(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkDataObject * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddInputDataObject(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_AddInputDataObject_163(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddInputDataObject(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetOutputPort_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPort(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetOutputPort_165(JNIEnv* env, jobject obj)
{
  vtkAlgorithmOutput * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPort();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetNumberOfInputConnections_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfInputConnections(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetTotalNumberOfInputConnections_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalNumberOfInputConnections();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputConnection_168(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkAlgorithmOutput * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputConnection(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputAlgorithm_169(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkAlgorithm * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputAlgorithm(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputAlgorithm_170(JNIEnv* env, jobject obj)
{
  vtkAlgorithm * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputAlgorithm();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputExecutive_171(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkExecutive * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputExecutive(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputExecutive_172(JNIEnv* env, jobject obj)
{
  vtkExecutive * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputExecutive();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputInformation_173(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkInformation * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputInformation(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetInputInformation_174(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputInformation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetOutputInformation_175(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkInformation * temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputInformation(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_Update_176(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_Update_177(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_Update_178(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformationVector * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Update(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_Update_179(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Update(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_UpdatePiece_180(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jintArray id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int temp3[6];
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  env->GetIntArrayRegion(id3, 0, 6, reinterpret_cast<jint*>(&temp3[0]));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdatePiece(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_UpdateExtent_181(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateExtent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_UpdateTimeStep_182(JNIEnv* env, jobject obj,jdouble id0,jint id1,jint id2,jint id3,jintArray id4)
{
  double   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int temp4[6];
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  env->GetIntArrayRegion(id4, 0, 6, reinterpret_cast<jint*>(&temp4[0]));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateTimeStep(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_UpdateInformation_183(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateInformation();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_UpdateDataObject_184(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateDataObject();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_PropagateUpdateExtent_185(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->PropagateUpdateExtent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_UpdateWholeExtent_186(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateWholeExtent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetReleaseDataFlag_187(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReleaseDataFlag(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetReleaseDataFlag_188(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReleaseDataFlag();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_ReleaseDataFlagOn_189(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseDataFlagOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_ReleaseDataFlagOff_190(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseDataFlagOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_UpdateExtentIsEmpty_191(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkInformation * temp0;
  vtkDataObject * temp1;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateExtentIsEmpty(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_UpdateExtentIsEmpty_192(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformation * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateExtentIsEmpty(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetDefaultExecutivePrototype_193(JNIEnv* env, jobject obj,jobject id0)
{
  vtkExecutive * temp0;
  temp0 = static_cast<vtkExecutive*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultExecutivePrototype(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkAlgorithm_GetUpdateExtent_194(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdateExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkAlgorithm_GetUpdateExtent_195(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int * temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdateExtent(temp0);
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_GetUpdateExtent_196(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetUpdateExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_GetUpdateExtent_197(JNIEnv* env, jobject obj,jint id0,jintArray id1)
{
  int   temp0;
  int temp1[6];
  temp0 = id0;
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetUpdateExtent(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetUpdatePiece_198(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdatePiece();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetUpdatePiece_199(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdatePiece(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetUpdateNumberOfPieces_1100(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdateNumberOfPieces();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetUpdateNumberOfPieces_1101(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdateNumberOfPieces(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetUpdateGhostLevel_1102(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdateGhostLevel();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAlgorithm_GetUpdateGhostLevel_1103(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUpdateGhostLevel(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetProgressObserver_1104(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProgressObserver * temp0;
  temp0 = static_cast<vtkProgressObserver*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProgressObserver(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAlgorithm_GetProgressObserver_1105(JNIEnv* env, jobject obj)
{
  vtkProgressObserver * temp20;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProgressObserver();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetNoPriorTemporalAccessInformationKey_1106(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNoPriorTemporalAccessInformationKey(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_SetNoPriorTemporalAccessInformationKey_1107(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNoPriorTemporalAccessInformationKey();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAlgorithm_RemoveNoPriorTemporalAccessInformationKey_1108(JNIEnv* env, jobject obj)
{

  vtkAlgorithm* op = static_cast<vtkAlgorithm*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveNoPriorTemporalAccessInformationKey();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAlgorithm_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAlgorithm::New());
}
