// java wrapper for vtkArrayRenderer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkArrayRenderer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMapper_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkArrayRenderer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkArrayRenderer",dType)) { return me; }
  if ((res= vtkMapper_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayRenderer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayRenderer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayRenderer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayRenderer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_PrepareColormap_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrepareColormap(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkArrayRenderer_GetBounds_15(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_Render_16(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_ReleaseGraphicsResources_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayRenderer_GetHasOpaque_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHasOpaque();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_SetHasOpaque_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHasOpaque(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArrayRenderer_GetHasTranslucent_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHasTranslucent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_SetHasTranslucent_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHasTranslucent(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayRenderer_HasOpaqueGeometry_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasOpaqueGeometry();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayRenderer_HasTranslucentPolygonalGeometry_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_SetVertexShaderSource_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexShaderSource(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayRenderer_GetVertexShaderSource_115(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexShaderSource();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_SetFragmentShaderSource_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFragmentShaderSource(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArrayRenderer_GetFragmentShaderSource_117(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFragmentShaderSource();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_ResetModsToDefault_118(JNIEnv* env, jobject obj)
{

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetModsToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_AddMod_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddMod(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_RemoveMod_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveMod(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_RemoveAllMods_121(JNIEnv* env, jobject obj)
{

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllMods();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArrayRenderer_GetBounds_122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArrayRenderer_GetShader_123(JNIEnv* env, jobject obj,jint id0)
{
  vtkShader::Type   temp0;
  vtkShader * temp20;
  temp0 = static_cast<vtkShader::Type>(id0);

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShader(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayRenderer_SetNumberOfInstances_124(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfInstances(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayRenderer_SetNumberOfElements_125(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArrayRenderer_SetElementType_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkArrayRenderer* op = static_cast<vtkArrayRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetElementType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkArrayRenderer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkArrayRenderer::New());
}
