﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/auditmanager/AuditManager_EXPORTS.h>
#include <aws/auditmanager/model/DelegationStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AuditManager {
namespace Model {

/**
 * <p> The metadata that's associated with the delegation. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/DelegationMetadata">AWS
 * API Reference</a></p>
 */
class DelegationMetadata {
 public:
  AWS_AUDITMANAGER_API DelegationMetadata() = default;
  AWS_AUDITMANAGER_API DelegationMetadata(Aws::Utils::Json::JsonView jsonValue);
  AWS_AUDITMANAGER_API DelegationMetadata& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_AUDITMANAGER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The unique identifier for the delegation. </p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  DelegationMetadata& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of the associated assessment. </p>
   */
  inline const Aws::String& GetAssessmentName() const { return m_assessmentName; }
  inline bool AssessmentNameHasBeenSet() const { return m_assessmentNameHasBeenSet; }
  template <typename AssessmentNameT = Aws::String>
  void SetAssessmentName(AssessmentNameT&& value) {
    m_assessmentNameHasBeenSet = true;
    m_assessmentName = std::forward<AssessmentNameT>(value);
  }
  template <typename AssessmentNameT = Aws::String>
  DelegationMetadata& WithAssessmentName(AssessmentNameT&& value) {
    SetAssessmentName(std::forward<AssessmentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The unique identifier for the assessment. </p>
   */
  inline const Aws::String& GetAssessmentId() const { return m_assessmentId; }
  inline bool AssessmentIdHasBeenSet() const { return m_assessmentIdHasBeenSet; }
  template <typename AssessmentIdT = Aws::String>
  void SetAssessmentId(AssessmentIdT&& value) {
    m_assessmentIdHasBeenSet = true;
    m_assessmentId = std::forward<AssessmentIdT>(value);
  }
  template <typename AssessmentIdT = Aws::String>
  DelegationMetadata& WithAssessmentId(AssessmentIdT&& value) {
    SetAssessmentId(std::forward<AssessmentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The current status of the delegation. </p>
   */
  inline DelegationStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(DelegationStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline DelegationMetadata& WithStatus(DelegationStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) of the IAM role. </p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  DelegationMetadata& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Specifies when the delegation was created. </p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DelegationMetadata& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Specifies the name of the control set that was delegated for review. </p>
   */
  inline const Aws::String& GetControlSetName() const { return m_controlSetName; }
  inline bool ControlSetNameHasBeenSet() const { return m_controlSetNameHasBeenSet; }
  template <typename ControlSetNameT = Aws::String>
  void SetControlSetName(ControlSetNameT&& value) {
    m_controlSetNameHasBeenSet = true;
    m_controlSetName = std::forward<ControlSetNameT>(value);
  }
  template <typename ControlSetNameT = Aws::String>
  DelegationMetadata& WithControlSetName(ControlSetNameT&& value) {
    SetControlSetName(std::forward<ControlSetNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_assessmentName;

  Aws::String m_assessmentId;

  DelegationStatus m_status{DelegationStatus::NOT_SET};

  Aws::String m_roleArn;

  Aws::Utils::DateTime m_creationTime{};

  Aws::String m_controlSetName;
  bool m_idHasBeenSet = false;
  bool m_assessmentNameHasBeenSet = false;
  bool m_assessmentIdHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_controlSetNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace AuditManager
}  // namespace Aws
