/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridPrivilage;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionAtomic;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class CubridUserManager
extends SQLObjectEditor<CubridPrivilage, GenericStructContainer> {
    private static final int MAX_NAME_GEN_ATTEMPTS = 100;

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, CubridPrivilage> getObjectsCache(CubridPrivilage object) {
        CubridDataSource parentObject = object.getParentObject();
        if (parentObject instanceof CubridDataSource) {
            CubridDataSource container = parentObject;
            return container.getDataSource().getCubridPrivilageCache();
        }
        return null;
    }

    protected CubridPrivilage createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @NotNull Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) {
        String newName = this.getNewName((CubridDataSource)((Object)container), "NEW_USER");
        return new CubridPrivilage((CubridDataSource)((Object)container), newName, null);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        CubridPrivilage user = (CubridPrivilage)command.getObject();
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE USER ");
        builder.append(DBUtils.getQuotedIdentifier((DBPDataSource)user.getDataSource(), (String)this.getUserName(user, command.getProperties())));
        this.buildBody(user, builder, command.getProperties());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create User", builder.toString()));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        String builder = "DROP USER " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()));
        actions.add((DBEPersistAction)new DeletePersistAction((CubridPrivilage)command.getObject(), builder));
    }

    private void buildBody(CubridPrivilage user, StringBuilder builder, Map<Object, Object> properties) {
        Object password = properties.get("PASSWORD");
        Object description = properties.get("DESCRIPTION");
        Object group = properties.get("GROUPS");
        if (password != null && CommonUtils.isNotEmpty((String)password.toString())) {
            builder.append(" PASSWORD ");
            builder.append(SQLUtils.quoteString((DBSObject)user, (String)password.toString()));
        }
        if (group != null && !CommonUtils.isEmpty((Collection)((List)properties.get("GROUPS")))) {
            builder.append(" GROUPS ");
            List groups = (List)properties.get("GROUPS");
            List<String> quotedGroups = groups.stream().map(quoteGroup -> DBUtils.getQuotedIdentifier((DBPDataSource)user.getDataSource(), (String)quoteGroup)).toList();
            builder.append(String.join((CharSequence)", ", quotedGroups));
        }
        if (description != null && CommonUtils.isNotEmpty((String)description.toString())) {
            builder.append(" COMMENT ");
            builder.append(SQLUtils.quoteString((DBSObject)user, (String)description.toString()));
        }
    }

    @NotNull
    private String getUserName(CubridPrivilage user, Map<Object, Object> properties) {
        Object name = properties.get("NAME");
        if (name != null) {
            user.setName(name.toString().toUpperCase());
        }
        return user.getName();
    }

    @NotNull
    private String getNewName(@NotNull CubridDataSource container, @NotNull String baseName) {
        int i = 0;
        while (i < 100) {
            String transform = DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)(i == 0 ? baseName : baseName + "_" + i));
            DBSObject child = container.getCubridPrivilageCache().getCachedObject(transform);
            if (child == null) {
                return transform;
            }
            ++i;
        }
        log.error((Object)"Error generating child object name: max attempts reached");
        return baseName;
    }

    public boolean canCreateObject(@NotNull Object container) {
        return !((CubridDataSource)((Object)container)).isShard();
    }

    public boolean canEditObject(CubridPrivilage object) {
        return !object.getDataSource().isShard();
    }

    public boolean canDeleteObject(CubridPrivilage object) {
        return !object.getDataSource().isShard();
    }

    private static class DeletePersistAction
    extends SQLDatabasePersistActionAtomic {
        CubridPrivilage database;

        public DeletePersistAction(CubridPrivilage privilage, String script) {
            super("drop user", script);
            this.database = privilage;
        }

        public void afterExecute(DBCSession session, Throwable error) throws DBCException {
            super.afterExecute(session, error);
            if (error == null) {
                GenericSchema user = this.database.getParentObject().getSchema(this.database.getName());
                DBUtils.fireObjectRemove((DBSObject)user);
            }
        }
    }
}

