/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OraclePrivTable
extends OracleObject<OracleTableBase>
implements DBAPrivilege {
    private String grantee;
    private String grantor;
    private boolean grantable;
    private boolean hierarchy;

    public OraclePrivTable(OracleTableBase table, ResultSet resultSet) {
        super(table, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PRIVILEGE"), true);
        this.grantee = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTEE");
        this.grantor = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTOR");
        this.grantable = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"GRANTABLE", (String)"Y");
        this.hierarchy = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"HIERARCHY", (String)"Y");
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=5, supportsPreview=true)
    public Object getGrantee(DBRProgressMonitor monitor) throws DBException {
        if (monitor == null) {
            return this.grantee;
        }
        return this.getDataSource().getGrantee(monitor, this.grantee);
    }

    @Property(viewable=true, order=6, supportsPreview=true)
    public Object getGrantor(DBRProgressMonitor monitor) throws DBException {
        if (monitor == null) {
            return this.grantor;
        }
        return this.getDataSource().getGrantee(monitor, this.grantor);
    }

    @Property(viewable=true, order=10)
    public boolean isGrantable() {
        return this.grantable;
    }

    @Property(viewable=true, order=11)
    public boolean isHierarchy() {
        return this.hierarchy;
    }
}

