/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

public enum DBPDataKind {
    BOOLEAN(false),
    NUMERIC(false),
    STRING(false),
    DATETIME(false),
    BINARY(false),
    CONTENT(false),
    STRUCT(true),
    DOCUMENT(true),
    ARRAY(true),
    OBJECT(true),
    REFERENCE(true),
    ROWID(false),
    ANY(true),
    UNKNOWN(false);

    private final boolean complex;

    private DBPDataKind(boolean complex) {
        this.complex = complex;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public boolean supportsRangeSearch() {
        return !this.complex && this != ROWID;
    }

    public int getCommonality() {
        switch (this.ordinal()) {
            case 4: 
            case 5: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 0: 
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
        }
        return 0;
    }

    public static boolean canConsume(DBPDataKind sourceKind, DBPDataKind targetKind) {
        if (targetKind == CONTENT || targetKind == BINARY) {
            return sourceKind == STRING || sourceKind == BINARY || sourceKind == CONTENT;
        }
        if (targetKind == STRING) {
            return sourceKind == STRING;
        }
        return sourceKind == targetKind;
    }
}

