/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model.data;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.IntStream;
import org.jkiss.code.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public final class DuckDBGeometryConverter {
    private DuckDBGeometryConverter() {
    }

    @NotNull
    public static Geometry deserialize(@NotNull ByteBuffer buffer, @NotNull GeometryFactory factory) {
        GeometryType.valueOf(buffer.get());
        byte flags = buffer.get();
        buffer.getShort();
        buffer.getInt();
        boolean hasZ = (flags & 1) != 0;
        boolean hasM = (flags & 2) != 0;
        boolean hasBBox = (flags & 4) != 0;
        int dimensions = 2 + (hasZ ? 1 : 0) + (hasM ? 1 : 0);
        if (hasBBox) {
            buffer.position(buffer.position() + dimensions * 4 * 2);
        }
        return DuckDBGeometryConverter.deserializeRecursive(buffer, hasZ, hasM, factory);
    }

    @NotNull
    private static Geometry deserializeRecursive(@NotNull ByteBuffer buffer, boolean hasZ, boolean hasM, @NotNull GeometryFactory factory) {
        GeometryType type = GeometryType.valueOf(buffer.getInt());
        int count = buffer.getInt();
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                CoordinateSequence coordinates = DuckDBGeometryConverter.readCoordinates(buffer, count, hasZ, hasM, factory);
                yield factory.createPoint(coordinates);
            }
            case 1 -> {
                CoordinateSequence coordinates = DuckDBGeometryConverter.readCoordinates(buffer, count, hasZ, hasM, factory);
                yield factory.createLineString(coordinates);
            }
            case 2 -> {
                int ringCount = count + (count % 2 == 1 ? 1 : 0);
                int[] ringSizes = IntStream.range(0, ringCount).map(i -> buffer.getInt()).toArray();
                List<LinearRing> rings = IntStream.range(0, count).mapToObj(i -> factory.createLinearRing(DuckDBGeometryConverter.readCoordinates(buffer, ringSizes[i], hasZ, hasM, factory))).toList();
                LinearRing shell = rings.get(0);
                LinearRing[] holes = (LinearRing[])rings.subList(1, rings.size()).toArray(LinearRing[]::new);
                yield factory.createPolygon(shell, holes);
            }
            case 3 -> {
                Point[] points = (Point[])IntStream.range(0, count).mapToObj(i -> (Point)DuckDBGeometryConverter.deserializeRecursive(buffer, hasZ, hasM, factory)).toArray(Point[]::new);
                yield factory.createMultiPoint(points);
            }
            case 4 -> {
                LineString[] lineStrings = (LineString[])IntStream.range(0, count).mapToObj(i -> (LineString)DuckDBGeometryConverter.deserializeRecursive(buffer, hasZ, hasM, factory)).toArray(LineString[]::new);
                yield factory.createMultiLineString(lineStrings);
            }
            case 5 -> {
                Polygon[] polygons = (Polygon[])IntStream.range(0, count).mapToObj(i -> (Polygon)DuckDBGeometryConverter.deserializeRecursive(buffer, hasZ, hasM, factory)).toArray(Polygon[]::new);
                yield factory.createMultiPolygon(polygons);
            }
            case 6 -> {
                Geometry[] geometries = (Geometry[])IntStream.range(0, count).mapToObj(i -> DuckDBGeometryConverter.deserializeRecursive(buffer, hasZ, hasM, factory)).toArray(Geometry[]::new);
                yield factory.createGeometryCollection(geometries);
            }
        };
    }

    @NotNull
    private static CoordinateSequence readCoordinates(@NotNull ByteBuffer buffer, int count, boolean hasZ, boolean hasM, @NotNull GeometryFactory factory) {
        Coordinate[] coordinates = (Coordinate[])IntStream.range(0, count).mapToObj(i -> DuckDBGeometryConverter.readCoordinate(buffer, hasZ, hasM)).toArray(Coordinate[]::new);
        return factory.getCoordinateSequenceFactory().create(coordinates);
    }

    @NotNull
    private static Coordinate readCoordinate(@NotNull ByteBuffer buffer, boolean hasZ, boolean hasM) {
        double m;
        double x = buffer.getDouble();
        double y = buffer.getDouble();
        double z = hasZ ? buffer.getDouble() : 0.0;
        double d = m = hasM ? buffer.getDouble() : 0.0;
        if (hasZ && hasM) {
            return new CoordinateXYZM(x, y, z, m);
        }
        if (hasM) {
            return new CoordinateXYM(x, y, m);
        }
        if (hasZ) {
            return new Coordinate(x, y, z);
        }
        return new Coordinate(x, y);
    }

    private static enum GeometryType {
        POINT,
        LINESTRING,
        POLYGON,
        MULTI_POINT,
        MULTI_LINESTRING,
        MULTI_POLYGON,
        MULTI_GEOMETRY;


        static GeometryType valueOf(int value) {
            if (value < 0 || value > GeometryType.values().length) {
                throw new IllegalArgumentException("Invalid geometry type: " + value);
            }
            return GeometryType.values()[value];
        }
    }
}

