/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.controls.StringEditorTableUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class StringEditorTableFactory<T> {
    public static final String CUSTOM_EDITABLE_LIST_VALUE_KEY = "CUSTOM_EDITABLE_LIST_VALUE";
    protected final Table valueTable;
    @Nullable
    protected final List<T> values;
    protected final StringEditorTableUtils.TableValuesManager<T> valuesManager;
    @Nullable
    protected final IContentProposalProvider proposalProvider;
    protected final boolean withReordering;
    protected final Runnable buttonsRefresher;
    protected CustomTableEditor tableEditor;
    protected Control addButton;
    protected Control removeButton;
    protected Control clearButton;
    protected Control upButton;
    protected Control downButton;

    public StringEditorTableFactory(@NotNull Composite parent, @Nullable List<T> values, @NotNull StringEditorTableUtils.TableValuesManager<T> valuesManager, @Nullable IContentProposalProvider proposalProvider, boolean withReordering) {
        this.valueTable = new Table(parent, 68356);
        this.values = values;
        this.valuesManager = valuesManager;
        this.proposalProvider = proposalProvider;
        this.withReordering = withReordering;
        this.buttonsRefresher = this.buttonsRefresher();
    }

    @NotNull
    public Table createTable() {
        this.setLayout();
        this.createValueColumn();
        this.fillItems();
        this.tableEditor = this.createTableEditor();
        this.createRightArea();
        this.valueTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringEditorTableFactory.this.buttonsRefresher.run();
            }
        });
        return this.valueTable;
    }

    @NotNull
    protected Runnable buttonsRefresher() {
        return () -> {
            int selectionIndex = this.valueTable.getSelectionIndex();
            if (selectionIndex < 0) {
                this.removeButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
                this.upButton.setEnabled(selectionIndex > 0);
                this.downButton.setEnabled(selectionIndex < this.valueTable.getItemCount() - 1);
            }
        };
    }

    protected void setLayout() {
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        this.valueTable.setLayoutData((Object)gd);
        this.valueTable.setLinesVisible(true);
    }

    @NotNull
    protected TableColumn createValueColumn() {
        final TableColumn valueColumn = UIUtils.createTableColumn(this.valueTable, 16384, UIMessages.properties_value);
        this.valueTable.addControlListener((ControlListener)new ControlAdapter(this){
            final /* synthetic */ StringEditorTableFactory this$0;
            {
                this.this$0 = this$0;
            }

            public void controlResized(ControlEvent e) {
                valueColumn.setWidth(this.this$0.valueTable.getClientArea().width);
            }
        });
        return valueColumn;
    }

    protected void fillItems() {
        this.valueTable.removeAll();
        if (!CommonUtils.isEmpty(this.values)) {
            for (T value : this.values) {
                TableItem tableItem = new TableItem(this.valueTable, 16384);
                tableItem.setText(this.valuesManager.getString(value));
                tableItem.setData(CUSTOM_EDITABLE_LIST_VALUE_KEY, value);
                DBPImage icon = this.valuesManager.getIcon(value);
                tableItem.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
            }
        }
    }

    @NotNull
    protected CustomTableEditor createTableEditor() {
        return new CustomTableEditor(this.valueTable){
            {
                this.firstTraverseIndex = 0;
                this.lastTraverseIndex = 0;
            }

            @Override
            @Nullable
            protected Control createEditor(Table table, int index, TableItem item) {
                Text editor;
                if (StringEditorTableFactory.this.valuesManager.isEditable(StringEditorTableFactory.this.getCustomValue(item)).booleanValue()) {
                    editor = new Text((Composite)table, 2048);
                    editor.setText(item.getText());
                    editor.addModifyListener(e -> this.saveEditorValue((Control)editor, index, item));
                    if (StringEditorTableFactory.this.proposalProvider != null) {
                        this.setProposalAdapter(ContentAssistUtils.installContentProposal((Control)editor, (IControlContentAdapter)new SmartTextContentAdapter(), StringEditorTableFactory.this.proposalProvider));
                    }
                } else {
                    editor = null;
                }
                return editor;
            }

            @Override
            protected void saveEditorValue(Control control, int index, TableItem item) {
                String text = ((Text)control).getText().trim();
                Object value = StringEditorTableFactory.this.valuesManager.prepareNewValue(StringEditorTableFactory.this.getCustomValue(item), text);
                if (value != null) {
                    StringEditorTableFactory.this.setCustomValue(item, value);
                    item.setText(StringEditorTableFactory.this.valuesManager.getString(value));
                    DBPImage icon = StringEditorTableFactory.this.valuesManager.getIcon(value);
                    item.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
                }
            }
        };
    }

    @NotNull
    protected Composite createRightArea() {
        Composite rightArea = UIUtils.createPlaceholder(this.valueTable.getParent(), 1, 5);
        rightArea.setLayoutData((Object)new GridData(1040));
        Composite buttonsGroup = UIUtils.createPlaceholder(rightArea, 1, 5);
        buttonsGroup.setLayoutData((Object)new GridData(2));
        this.addButton = this.addButton(buttonsGroup);
        this.removeButton = this.removeButton(buttonsGroup);
        this.clearButton = this.clearButton(buttonsGroup);
        Composite bottomButtonsGroup = UIUtils.createPlaceholder(rightArea, 1, 5);
        bottomButtonsGroup.setLayoutData((Object)new GridData(2, 2, true, true));
        this.upButton = this.upButton(bottomButtonsGroup);
        this.downButton = this.downButton(bottomButtonsGroup);
        return rightArea;
    }

    @NotNull
    protected Control addButton(@NotNull Composite buttonsGroup) {
        Button addButton = new Button(buttonsGroup, 8);
        addButton.setText(UIMessages.button_add);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem newItem = new TableItem(StringEditorTableFactory.this.valueTable, 16384);
                StringEditorTableFactory.this.addTableItem(newItem);
            }
        });
        return addButton;
    }

    protected void addTableItem(@NotNull TableItem newItem) {
        DBPImage icon = this.valuesManager.getIcon(null);
        newItem.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
        this.valueTable.setSelection(newItem);
        this.tableEditor.closeEditor();
        this.tableEditor.showEditor(newItem);
        this.buttonsRefresher.run();
    }

    @NotNull
    protected Control removeButton(@NotNull Composite buttonsGroup) {
        Button removeButton = new Button(buttonsGroup, 8);
        removeButton.setText(UIMessages.button_remove);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = StringEditorTableFactory.this.valueTable.getSelectionIndex();
                if (selectionIndex >= 0) {
                    StringEditorTableFactory.this.tableEditor.closeEditor();
                    StringEditorTableFactory.this.valueTable.remove(selectionIndex);
                    StringEditorTableFactory.this.buttonsRefresher.run();
                }
            }
        });
        removeButton.setEnabled(false);
        return removeButton;
    }

    @NotNull
    protected Control clearButton(@NotNull Composite buttonsGroup) {
        Button clearButton = new Button(buttonsGroup, 8);
        clearButton.setText(UIMessages.button_clear);
        clearButton.setLayoutData((Object)new GridData(768));
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringEditorTableFactory.this.tableEditor.closeEditor();
                StringEditorTableFactory.this.valueTable.removeAll();
                StringEditorTableFactory.this.buttonsRefresher.run();
            }
        });
        return clearButton;
    }

    @NotNull
    protected Control upButton(@NotNull Composite buttonsGroup) {
        Button upButton = new Button(buttonsGroup, 8);
        upButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_UP));
        upButton.setLayoutData((Object)new GridData(768));
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = StringEditorTableFactory.this.valueTable.getSelectionIndex();
                if (selectionIndex >= 1 && selectionIndex < StringEditorTableFactory.this.valueTable.getItemCount()) {
                    Object value = StringEditorTableFactory.this.getCustomValue(StringEditorTableFactory.this.valueTable.getItem(selectionIndex));
                    StringEditorTableFactory.this.valueTable.remove(selectionIndex);
                    TableItem tableItem = new TableItem(StringEditorTableFactory.this.valueTable, 16384, selectionIndex - 1);
                    tableItem.setText(StringEditorTableFactory.this.valuesManager.getString(value));
                    StringEditorTableFactory.this.setCustomValue(tableItem, value);
                    DBPImage icon = StringEditorTableFactory.this.valuesManager.getIcon(value);
                    tableItem.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
                    StringEditorTableFactory.this.valueTable.setSelection(selectionIndex - 1);
                    StringEditorTableFactory.this.buttonsRefresher.run();
                }
            }
        });
        upButton.setVisible(this.withReordering);
        return upButton;
    }

    @NotNull
    protected Control downButton(@NotNull Composite buttonsGroup) {
        Button downButton = new Button(buttonsGroup, 8);
        downButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_DOWN));
        downButton.setLayoutData((Object)new GridData(768));
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = StringEditorTableFactory.this.valueTable.getSelectionIndex();
                if (selectionIndex >= 0 && selectionIndex < StringEditorTableFactory.this.valueTable.getItemCount() - 1) {
                    Object value = StringEditorTableFactory.this.getCustomValue(StringEditorTableFactory.this.valueTable.getItem(selectionIndex));
                    StringEditorTableFactory.this.valueTable.remove(selectionIndex);
                    TableItem tableItem = new TableItem(StringEditorTableFactory.this.valueTable, 16384, selectionIndex + 1);
                    tableItem.setText(StringEditorTableFactory.this.valuesManager.getString(value));
                    StringEditorTableFactory.this.setCustomValue(tableItem, value);
                    DBPImage icon = StringEditorTableFactory.this.valuesManager.getIcon(value);
                    tableItem.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
                    StringEditorTableFactory.this.valueTable.setSelection(selectionIndex + 1);
                    StringEditorTableFactory.this.buttonsRefresher.run();
                }
            }
        });
        downButton.setVisible(this.withReordering);
        return downButton;
    }

    @Nullable
    private <T> T getCustomValue(TableItem tableItem) {
        return (T)tableItem.getData(CUSTOM_EDITABLE_LIST_VALUE_KEY);
    }

    private <T> void setCustomValue(TableItem tableItem, T value) {
        tableItem.setData(CUSTOM_EDITABLE_LIST_VALUE_KEY, value);
    }

    public record StringValuesManager(@Nullable DBPImage icon) implements StringEditorTableUtils.TableValuesManager<String>
    {
        @Override
        @Nullable
        public DBPImage getIcon(@Nullable String value) {
            return this.icon;
        }

        @Override
        @NotNull
        public String getString(@Nullable String value) {
            return value == null ? "" : value;
        }

        @Override
        @NotNull
        public Boolean isEditable(@Nullable String value) {
            return true;
        }

        @Override
        @Nullable
        public String prepareNewValue(@Nullable String originalValue, @Nullable String string) {
            return string;
        }
    }
}

