/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.script.CompiledScriptCleaner;
import org.freeplane.plugin.script.GroovyScript;
import org.freeplane.plugin.script.PrecompiledClasses;
import org.freeplane.plugin.script.ScriptClassLoader;
import org.freeplane.plugin.script.ScriptResources;

class ClasspathScriptCompiler {
    private static final String GROOVY = "groovy";
    private static final String JAVA = "java";
    private static final String COMPILED_SCRIPTS_FILE = ".compiledscripts";
    private static final String LAST_JAVA_COMPILER_VERSION = "last_java_compiler_version";
    private static final String COMPILE_ONLY_CHANGED_SCRIPT_FILES = "compile_only_changed_script_files";
    private final CompilerConfiguration compilerConfiguration;
    private final GroovyClassLoader compilerClassLoader;
    private PrecompiledClasses oldCompiledFiles;
    private final boolean compileOnlyChangedScriptFiles;

    private static boolean isCurrentJavaVersionCompatibleWithCachedClassFiles() {
        String lastJavaVersion = ResourceController.getResourceController().getProperty(LAST_JAVA_COMPILER_VERSION, null);
        return lastJavaVersion != null && Compat.JAVA_VERSION.compareTo(lastJavaVersion) >= 0;
    }

    private static CompilerConfiguration createCompilerConfiguration() {
        CompilerConfiguration configuration = GroovyScript.createCompilerConfiguration();
        File compiledScriptsDir = ScriptResources.getPrecompiledScriptsDir();
        compiledScriptsDir.mkdirs();
        configuration.setTargetDirectory(compiledScriptsDir);
        HashMap jointOptions = new HashMap();
        configuration.setJointCompilationOptions(jointOptions);
        return configuration;
    }

    ClasspathScriptCompiler() {
        ScriptClassLoader scriptClassLoader = ScriptClassLoader.createClassLoader();
        this.compilerClassLoader = new GroovyClassLoader((GroovyClassLoader)scriptClassLoader);
        this.compilerConfiguration = ClasspathScriptCompiler.createCompilerConfiguration();
        this.compileOnlyChangedScriptFiles = ClasspathScriptCompiler.isCurrentJavaVersionCompatibleWithCachedClassFiles() && ClasspathScriptCompiler.compilesOnlyChangedScriptFiles();
    }

    void compileScriptsOnPath(List<String> pathElements) {
        this.compileLibraryScripts(pathElements);
        new CompiledScriptCleaner().removeOutdatedCompiledScripts(this.compileOnlyChangedScriptFiles);
        ResourceController.getResourceController().setProperty(LAST_JAVA_COMPILER_VERSION, Compat.JAVA_VERSION);
    }

    private void compileLibraryScripts(List<String> pathElements) {
        PrecompiledClasses newCompiledFiles = new PrecompiledClasses(System.currentTimeMillis());
        File precompiledScriptsDir = ScriptResources.getPrecompiledScriptsDir();
        File compiledScriptListFile = this.compiledScriptListFile(precompiledScriptsDir);
        this.oldCompiledFiles = PrecompiledClasses.read(compiledScriptListFile);
        for (String pathElement : pathElements) {
            File dir = new File(pathElement);
            if (!dir.isDirectory() || precompiledScriptsDir.equals(dir)) continue;
            Collection<File> compiledScripts = this.compileScriptsInDirectory(dir);
            newCompiledFiles.addAll(compiledScripts);
        }
        this.oldCompiledFiles = null;
        newCompiledFiles.write(compiledScriptListFile);
    }

    static boolean compilesOnlyChangedScriptFiles() {
        return ResourceController.getResourceController().getBooleanProperty(COMPILE_ONLY_CHANGED_SCRIPT_FILES);
    }

    private Collection<File> compileScriptsInDirectory(File dir) {
        Collection<File> compiledScriptFiles;
        Collection<File> allScriptFiles = FileUtils.listFiles((File)dir, (String[])new String[]{GROOVY, JAVA}, (boolean)true);
        Collection<File> collection = compiledScriptFiles = this.compileOnlyChangedScriptFiles ? this.filterNewFiles(allScriptFiles) : allScriptFiles;
        if (!compiledScriptFiles.isEmpty()) {
            try {
                GroovyScript.checkAccessPermissionCheckerExists();
                this.compile(dir, compiledScriptFiles);
                LogUtils.info((String)("compiled in " + dir + ": " + this.createNameList(allScriptFiles)));
            }
            catch (Exception e) {
                LogUtils.severe((String)("error compiling in " + dir + this.createNameList(compiledScriptFiles)), (Throwable)e);
                return Collections.emptyList();
            }
        }
        return allScriptFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(File dir, Collection<File> files) throws Exception {
        File tmpDir = null;
        try {
            tmpDir = DefaultGroovyStaticMethods.createTempDir(null, (String)"groovy-generated-", (String)"-java-source");
            this.compilerConfiguration.getJointCompilationOptions().put("stubDir", tmpDir);
            this.compile(dir, this.toArray(files));
        }
        finally {
            try {
                if (tmpDir != null) {
                    FileSystemCompiler.deleteRecursive((File)tmpDir);
                }
            }
            catch (Throwable t) {
                LogUtils.severe((String)("error: could not delete temp files - " + tmpDir.getPath()));
            }
        }
    }

    private Collection<File> filterNewFiles(Collection<File> files) {
        return this.oldCompiledFiles.filterNewAndNewer(files);
    }

    private File compiledScriptListFile(File dir) {
        return new File(dir, COMPILED_SCRIPTS_FILE);
    }

    private void compile(File dir, File[] files) throws Exception {
        JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(this.compilerConfiguration, this.compilerClassLoader, null);
        new FileSystemCompiler(this.compilerConfiguration, (CompilationUnit)unit).compile(files);
    }

    private File[] toArray(Collection<File> groovyFiles) {
        return groovyFiles.toArray(new File[groovyFiles.size()]);
    }

    private ArrayList<String> createNameList(Collection<File> files) {
        ArrayList<String> names = new ArrayList<String>(files.size());
        for (File file : files) {
            names.add(file.getName());
        }
        return names;
    }
}

