/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeArrayIterator
extends ES6Iterator {
    private static final long serialVersionUID = 1L;
    private static final String ITERATOR_TAG = "ArrayIterator";
    private ARRAY_ITERATOR_TYPE type;
    private Scriptable arrayLike;
    private int index;

    static void init(ScriptableObject scriptableObject, boolean bl) {
        ES6Iterator.init(scriptableObject, bl, new NativeArrayIterator(), ITERATOR_TAG);
    }

    private NativeArrayIterator() {
    }

    public NativeArrayIterator(Scriptable scriptable, Scriptable scriptable2, ARRAY_ITERATOR_TYPE aRRAY_ITERATOR_TYPE) {
        super(scriptable, ITERATOR_TAG);
        this.index = 0;
        this.arrayLike = scriptable2;
        this.type = aRRAY_ITERATOR_TYPE;
    }

    @Override
    public String getClassName() {
        return "Array Iterator";
    }

    @Override
    protected boolean isDone(Context context, Scriptable scriptable) {
        return (long)this.index >= NativeArray.getLengthProperty(context, this.arrayLike);
    }

    @Override
    protected Object nextValue(Context context, Scriptable scriptable) {
        if (this.type == ARRAY_ITERATOR_TYPE.KEYS) {
            return this.index++;
        }
        Object object = this.arrayLike.get(this.index, this.arrayLike);
        if (object == Scriptable.NOT_FOUND) {
            object = Undefined.instance;
        }
        if (this.type == ARRAY_ITERATOR_TYPE.ENTRIES) {
            object = context.newArray(scriptable, new Object[]{this.index, object});
        }
        ++this.index;
        return object;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }

    public static enum ARRAY_ITERATOR_TYPE {
        ENTRIES,
        KEYS,
        VALUES;

    }
}

