---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: パスキー
description: パスキーを使用したパスワードレス認証と2要素認証
ignore_in_report: true
noindex: true
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 18.6で`passkeys`[フラグ](../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206407)されました。GitLab Self-Managedでは、デフォルトで無効になっています。

{{< /history >}}

パスキーを使用すると、パスワードを使用せずに、安全かつ簡単にGitLabアカウントにサインインできます。パスキーは、フィッシングに強いサインインを提供し、脆弱なパスワードの脆弱性や認証情報の侵害からユーザーを保護します。

## パスキーの仕組み {#how-passkeys-work}

パスキーは、公開キーペア暗号を使用して、安全にGitLabに認証します。パスキーを作成すると、次のようになります:

- デバイスは、一意の暗号学的なキーペアを生成します。
- 秘密キーはデバイス上に安全に保持され、共有されることはありません。
- GitLabは公開キーのみを保存し、これはユーザーになりすますために使用することはできません。
- サインイン時に、デバイスは生体認証またはPINを使用して秘密キーのロックを解除し、IDを証明します。

このアプローチにより、GitLabサーバーが侵害された場合でも、攻撃者がパスキーを使用してアカウントにアクセスできなくなります。

### セキュリティに関する考慮事項 {#security-considerations}

- バックアップの認証方法を維持する: リカバリーコードやその他の2要素認証方法など、アカウントにアクセスするための代替手段を常に維持してください。
- デバイスのセキュリティを維持する: デバイスが強力なPIN、パスワード、または生体認証ロックで保護されていることを確認してください。
- 定期的なレビュー: 登録済みのパスキーを定期的にレビューし、使用しなくなったデバイスのパスキーを削除します。
- 共有デバイスを使用しない: 共有デバイスまたは公共デバイスにパスキーを設定しないでください。

## パスキーの表示 {#view-your-passkeys}

パスキー名、デバイスの種類、使用状況の詳細など、登録済みのパスキーに関する情報を表示するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. **認証を管理**を選択します。
1. **パスキーサインイン**セクションで、パスキーを表示します。

## パスキーの追加 {#add-a-passkey}

前提要件: 

- WebAuthn規格をサポートするデバイスが必要です。
  - デスクトップブラウザ: Chrome、Firefox、Safari、Edge。
  - モバイルデバイス: 生体認証またはデバイスPINがオンになっているiOS 16以降およびAndroid 9以降。
  - セキュリティキー: FIDO2またはWebAuthnをサポートするハードウェアセキュリティキー。

パスキーを追加するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. **認証を管理**を選択します。
1. **パスキーサインイン**セクションで、**パスキーを追加**を選択します。
1. デバイスまたはブラウザの指示に従ってください。
1. 現在のパスワードを入力して、IDを確認します。
1. パスキーの名前を入力します。
1. **パスキーを追加**を選択します。

## パスキーでサインイン {#sign-in-with-a-passkey}

パスワードの代わりに、パスキーを使用してGitLabにサインインするには:

1. GitLabサインインページに移動します。

   - GitLab.comの場合は、`https://gitlab.com/users/sign_in`にアクセスしてください。
   - GitLab Self-Managedでは、インスタンスドメインを使用します。たとえば`https://gitlab.example.com/users/sign_in`などです。

1. 追加のサインインオプションで、**パスキー**を選択します。
1. デバイスの指示に従って、フィンガープリント、顔認識、またはデバイスPINを使用して認証します。

## 2要素認証にパスキーを使用する {#use-a-passkey-for-two-factor-authentication}

アカウントで[2要素認証](../user/profile/account/two_factor_authentication.md) (2FA) を有効にしている場合、パスキーは追加のデフォルトの2FAオプションとして利用できます。

パスキーを2FA方式として使用するには:

1. GitLabサインインページに移動します。

   - GitLab.comの場合は、`https://gitlab.com/users/sign_in`にアクセスしてください。
   - GitLab Self-Managedでは、インスタンスドメインを使用します。たとえば`https://gitlab.example.com/users/sign_in`などです。

1. ユーザー名とパスワードを入力します。
1. プロンプトが表示されたら、パスキーで認証します。
1. デバイスの指示に従って、フィンガープリント、顔認識、またはデバイスPINを使用して認証します。

{{< alert type="note" >}}

現在のデバイスでパスキーが利用できない場合は、代わりにバックアップの2FA方式を使用してください。

{{< /alert >}}

## パスキーの削除 {#delete-a-passkey}

デバイスを使用しなくなった場合、または新しいパスキーに置き換えたい場合は、パスキーを削除します。唯一のパスキーを削除すると、GitLabはアカウントのパスキーサインインも無効にします。

パスキーを削除するには:

1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**アカウント**を選択します。
1. **認証を管理**を選択します。
1. **パスキーサインイン**セクションで、削除するパスキーを見つけます。
1. パスキーの横にある**削除**（{{< icon name="remove" >}}）を選択します。
1. 確認ダイアログで、削除を確認します。

   - 複数のパスキーがある場合は、**パスキーを削除**を選択します。
   - 単一のパスキーがある場合は、**パスキーサインインを無効にする**を選択します。

{{< alert type="warning" >}}

削除されたパスキーはリカバリーできません。デバイスで再度認証する場合は、新しいパスキーを追加する必要があります。

{{< /alert >}}

## トラブルシューティング {#troubleshooting}

### パスキーの追加に関する問題 {#problems-adding-a-passkey}

パスキーを追加できない場合:

- デバイスとブラウザがWebAuthnと生体認証をサポートしていることを確認します。
- ブラウザが最新であることを確認してください。
- デバイスにデバイスPIN、フィンガープリント、または顔認識を設定していることを確認してください。
- 別のブラウザまたはデバイスを使用してみてください。
- デバイスがWebAuthn2要素認証方式としてすでに登録されているかどうかを確認します。
  - デバイスがWebAuthn2要素認証方式としてすでに登録されている場合:

    1. 2要素認証方式からWebAuthnデバイスを削除します。
    1. パスキーとして登録します。
    1. 2FAを再度有効にする場合は、バックアップの2FA方式（認証アプリなど）を設定します。GitLabは、デフォルトの2要素認証として自動的にパスキーを追加します。

### パスキーでサインインできません {#cannot-sign-in-with-passkey}

パスキーを使用してサインインできない場合:

- パスキーの作成に使用したのと同じデバイスを使用していることを確認してください。
- 生体認証またはデバイスPINが機能していることを確認します。
- ブラウザのキャッシュとCookieをクリアしてみてください。
- バックアップの2FA方式またはパスワードを使用してサインインし、パスキー設定を確認します。

### 紛失または交換されたデバイス {#lost-or-replaced-device}

デバイスを紛失した場合、または新しいデバイスを入手した場合は、パスワードでサインインして、新しいパスキーを設定します。

新しいデバイスにパスキーを設定するには:

1. パスワードを使用してGitLabにサインインします。
1. パスキーを2FA方式として使用する場合は、バックアップ方式でサインインします。
1. アカウント設定から古いパスキーを削除します。
1. 新しいデバイスに新しいパスキーを設定します。

## 関連トピック {#related-topics}

- [2要素認証](../user/profile/account/two_factor_authentication.md)
- [ユーザーパスワード](../user/profile/user_passwords.md)
