---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: セキュリティインシデントへの対応。
---

セキュリティインシデントが発生した場合は、まず組織で定義されたプロセスに従ってください。GitLabセキュリティオペレーションチームがこのガイドを作成しました:

- GitLab Self-ManagedインスタンスとGitLab.com上のグループの管理者およびメンテナー向け。
- GitLabサービスに関連するさまざまなセキュリティインシデントへの対応方法に関する追加情報とベストプラクティスを提供するため。
- セキュリティインシデントを処理するために、組織で定義されたプロセスを補完するものとして。これは**代替ではありません**。

このガイドを使用することで、GitLabに関連するセキュリティインシデントの処理に自信を持てるはずです。必要に応じて、このガイドからGitLabドキュメントの他の部分にリンクしています。

{{< alert type="warning" >}}

ご自身の責任において、このガイドに記載されている提案や推奨事項をご利用ください。

{{< /alert >}}

## 一般的なセキュリティインシデントのシナリオ {#common-security-incident-scenarios}

### パブリックインターネットへの認証情報の公開 {#credential-exposure-to-public-internet}

このシナリオは、設定ミスまたは人為的なエラーにより、機密情報である認証または認可情報がインターネットに公開されたセキュリティイベントを指します。このような情報には、以下が含まれる場合があります:

- パスワード。
- パーソナルアクセストークン。
- グループ/プロジェクトアクセストークン。
- Runnerトークン。
- パイプライントリガートークン。
- SSHキー。

このシナリオには、GitLabサービスを介したサードパーティの認証情報に関する機密情報の公開も含まれる場合があります。このような情報漏洩は、GitLabの公開プロジェクトへの誤ったコミットや、CI/CD設定の誤設定などが原因で発生する可能性があります。詳細については、以下を参照してください:

- [GitLabトークンの概要](tokens/_index.md)
- [GitLab CI/CD](../ci/variables/_index.md#cicd-variable-security) CI/CD変数のセキュリティ

#### レスポンス {#response}

認証情報の公開に関連するセキュリティインシデントは、トークンの種類とそれに関連するユーザー権限に応じて、軽度から重大まで重大度が異なります。このようなインシデントに対応する場合は、以下を行う必要があります:

- トークンの種類とスコープを特定します。
- トークンの所有者と、トークン情報に基づいて関連するチームを特定します。
  - パーソナルアクセストークンの場合は、[パーソナルアクセストークンAPI](../api/personal_access_tokens.md#get-details-on-a-personal-access-token)を使用すると、トークンの詳細をすばやく取得できます。
- スコープと潜在的な影響を評価したら、トークンを[失効](../api/personal_access_tokens.md#revoke-a-personal-access-token)または[ローテーション](../api/group_access_tokens.md#rotate-a-group-access-token)します。本番環境のトークンを失効することは、公開されたトークンによってもたらされるセキュリティリスクと、トークンを失効することによって引き起こされる可能性のある可用性のリスクとのバランスを取ることです。トークンを失効するのは、以下の場合のみにしてください:
  - トークンの失効が及ぼす可能性のある影響について、十分理解している場合。
  - 会社のセキュリティインシデント対応ガイドラインに従っている場合。
- 認証情報の公開時間と、認証情報を失効した時間を記録します。
- GitLabの監査ログをレビューして、公開されたトークンに関連する不正なアクティビティーを特定します。トークンのスコープと種類に応じて、以下に関連する監査イベントを検索します:
  - 新しく作成されたユーザー。
  - トークン。
  - 悪意のあるパイプライン。
  - コードの変更。
  - GitLabプロジェクト設定の変更。

#### イベントタイプ {#event-types}

- グループまたはネームスペースで利用可能な[監査イベント](../administration/compliance/audit_event_reports.md)をレビューします。
- 攻撃者は、永続性を維持するために、トークン、SSHキー、またはユーザーアカウントを作成しようとする可能性があります。これらのアクティビティーに関連する[監査イベント](../user/compliance/audit_event_types.md)を探します。
- CIに関連する[監査イベント](../user/compliance/audit_event_types.md#continuous-integration)に焦点を当てて、CI/CD変数への変更を特定します。
- 攻撃者が実行したパイプラインの[ジョブログ](../administration/cicd/job_logs.md)をレビューします

### 侵害された疑いのあるユーザーアカウント {#suspected-compromised-user-account}

#### レスポンス {#response-1}

ユーザーアカウントまたはボットアカウントが侵害された疑いがある場合は、次のようにする必要があります:

- 現在のリスクを軽減するために[ユーザーをブロックします](../administration/moderate_users.md#block-a-user)。
- ユーザーがアクセスできる可能性のあるすべての認証情報をリセットします。たとえば、少なくともメンテナーロールを持つユーザーは、保護された[CI/CD変数](../ci/variables/_index.md)と[Runner登録トークン](tokens/_index.md#runner-registration-tokens-deprecated)を表示できます。
- [ユーザーパスワードをリセットする](reset_user_password.md)。
- ユーザーに[2要素認証](../user/profile/account/two_factor_authentication.md) （2FA）を有効にしてもらい、[インスタンスまたはグループの2FAの強制](two_factor_authentication.md)を検討してください。
- 調査を完了して影響を軽減した後、ユーザーのブロックを解除します。

#### イベントタイプ {#event-types-1}

利用可能な[監査イベント](../administration/compliance/audit_event_reports.md)をレビューして、不審なアカウントの挙動を特定します。例: 

- 不審なサインインイベント。
- パーソナルアクセストークン、GitLabプロジェクト、グループアクセストークンの作成または削除。
- SSHまたはGPGキーの作成または削除。
- 2FAの作成、変更、または削除。
- リポジトリへの変更。
- グループまたはGitLabプロジェクトの設定への変更。
- Runnerの追加または変更。
- WebhookまたはGitフックの追加または変更。
- 認可されたOAuthアプリケーションの追加または変更。
- 接続されたSAML IDプロバイダーへの変更。
- メールアドレスまたは通知への変更。

### CI/CD関連のセキュリティインシデント {#cicd-related-security-incidents}

CI/CDワークフローは、最新のソフトウェア開発に不可欠なものであり、主にデベロッパーやSREが本番環境へのコードのビルド、テスト、デプロイに使用します。これらのワークフローは本番環境に接続されているため、CI/CDパイプライン内の機密シークレットへのアクセスが必要になることがよくあります。CI/CDに関連するセキュリティインシデントは、セットアップによって異なる場合がありますが、大まかには次のように分類できます:

- 公開されたGitLab CI/CDジョブトークンに関連するセキュリティインシデント。
- 設定ミスされたGitLab CI/CDを通じて公開されたシークレット。

#### レスポンス {#response-2}

##### 公開されたGitLab CI/CDジョブトークン {#exposed-gitlab-cicd-job-token}

パイプラインジョブが実行されようとすると、GitLabは一意のトークンを生成し、それを`CI_JOB_TOKEN` [定義済み変数](../ci/variables/predefined_variables.md)としてインジェストします。GitLab CI/CDジョブトークンを使用すると、特定のAPIエンドポイントで認証できます。このトークンは、ジョブの実行を引き起こしたユーザーと同じAPIへのアクセス許可を持っています。このトークンは、パイプラインジョブの実行中のみ有効です。ジョブが終了すると、トークンは有効期限切れになり、使用できなくなります。

通常の状況では、`CI_JOB_TOKEN`はジョブログに表示されません。ただし、意図せずにこのデータを公開する可能性があります:

- パイプラインで詳細ログ記録を有効にする。
- Shell環境変数をコンソールにエコーするコマンドを実行する。
- Runnerインフラストラクチャを適切に保護できないと、このデータが意図せずに公開される可能性があります。

このような場合は、次のようにする必要があります:

- リポジトリ内のソースコードに最近変更が加えられていないか確認してください。変更されたファイルのコミット履歴を調べて、変更を加えたアクターを特定できます。疑わしい編集が疑われる場合は、[侵害された疑いのあるユーザーアカウントガイドライン](responding_to_security_incidents.md#suspected-compromised-user-account)を使用して、ユーザーアクティビティーを調査します。
- そのファイルによって呼び出されるコードへの疑わしい変更は、問題を引き起こす可能性があり、調査して、公開されたシークレットにつながる可能性があります。
- 失効の本番環境への影響を判断した後、公開されたシークレットのローテーションを検討してください。
- 利用可能な[監査ログ](../administration/compliance/audit_event_reports.md)をレビューして、ユーザーとGitLabプロジェクト設定への疑わしい変更がないか確認します。

##### 設定ミスされたGitLab CI/CDを通じて公開されたシークレット {#secrets-exposed-through-misconfigured-gitlab-cicd}

CI変数として保存されているシークレットが[マスク](../ci/variables/_index.md#mask-a-cicd-variable)されていない場合、ジョブログに公開される可能性があります。たとえば、環境変数をエコーしたり、詳細なエラーメッセージが発生したりするなどです。GitLabプロジェクトの表示レベルに応じて、ジョブログには社内からアクセスできる場合や、GitLabプロジェクトが公開されている場合はインターネット経由でアクセスできる場合があります。この種のセキュリティインシデントを軽減するには、次のようにする必要があります:

- [公開されたシークレットガイドライン](#credential-exposure-to-public-internet)に従って、公開されたシークレットを失効させます。
- 変数をマスクすることを検討してください。これにより、ジョブログ内に直接反映されなくなります。ただし、マスクは完全ではありません。たとえば、マスクされた変数は、アーティファクトファイルに書き込まれたり、リモートシステムに送信されたりする可能性があります。
- 変数の保護を検討してください。これにより、保護されたブランチでのみ利用できるようになります。
- 公開パイプラインを無効にして、ジョブログとアーティファクトへのパブリックアクセスを防ぐことを検討してください。
- アーティファクトの保持とポリシーの有効期限をレビューします。
- ベストプラクティスに関する詳細については、CI/CD [ジョブトークンセキュリティガイドライン](../ci/jobs/ci_job_token.md#gitlab-cicd-job-token-security)に従ってください。
- 公開時に疑わしい変更が加えられたかどうかを判断するために、AWSのCloudTrailログやGCPのCloudAudit Logsなど、公開されたシークレットシステムの監査ログをレビューします。
- ユーザーとGitLabプロジェクト設定への疑わしい変更がないか、利用可能な監査ログをレビューします。

### 侵害された疑いのあるインスタンス {#suspected-compromised-instance}

GitLab Self-Managedインスタンスのお客様と管理者は、以下に責任を負います:

- 基盤となるインフラストラクチャのセキュリティ。
- GitLabインストールを最新の状態に保つこと。

[GitLabを定期的にアップデート](../policy/maintenance.md)し、オペレーティングシステムとそのソフトウェアをアップデートし、ベンダーのガイダンスに従ってホストを強化することが重要です。

#### レスポンス {#response-3}

GitLabインスタンスが侵害された疑いがある場合は、次のようにする必要があります:

- 利用可能な[監査イベント](../administration/compliance/audit_event_reports.md)をレビューして、不審なアカウントの挙動がないか確認します。
- [すべてのユーザー](../administration/moderate_users.md) （管理者ルートユーザーを含む）をレビューし、必要に応じて、[侵害された疑いのあるユーザーアカウントガイドライン](responding_to_security_incidents.md#suspected-compromised-user-account)の手順に従います。
- 利用可能な場合は、認証情報インベントリをレビューしてください。
- すべての機密情報である認証情報、変数、トークン、シークレットを変更します。たとえば、インスタンスの設定、データベース、CI/CDパイプライン、またはその他の場所に存在するものです。
- 最新バージョンのGitLabにアップデートし、セキュリティパッチがリリースされるたびにアップデートする計画を採用します。
- さらに、サーバーが悪意のあるアクターによって侵害された場合、インシデント対応計画で実行される一般的な手順を以下に示します:
  1. 後で調査するために、すべてのサーバーの状態とログを書き込み専用の場所に保存します。
  1. 認識されないバックグラウンドプロセスを探します。
  1. システム上の開いているポートを確認します。当社の[デフォルトポートガイドライン](../administration/package_information/defaults.md)を、開始点として使用できます。
  1. 既知の正常なバックアップから、または最初からホストを再ビルドし、すべての最新のセキュリティパッチを適用します。
  1. 異常なトラフィックがないか、ネットワークログをレビューします。
  1. ネットワークモニタリングとネットワークレベルの制御を確立します。
  1. 認可されたユーザーとサーバーのみに、受信および送信ネットワークアクセスを制限します。
  1. すべてのログが、独立した書き込み専用データストアにルーティングされるようにします。

#### イベントタイプ {#event-types-2}

[システムアクセス監査イベント](../user/compliance/audit_event_types.md#system-access)をレビューして、システム設定、ユーザーのアクセス許可、ユーザーログインイベントに関連する変更を判断します。

### 設定ミスされたGitLabプロジェクトまたはグループ設定 {#misconfigured-project-or-group-settings}

セキュリティインシデントは、不適切に設定されたGitLabプロジェクトまたはグループ設定の結果として発生する可能性があり、機密情報または独自のデータへの不正アクセスにつながる可能性があります。これらのインシデントには、以下が含まれますが、これらに限定されません:

- GitLabプロジェクトの表示レベルの変更。
- MR承認設定の変更。
- GitLabプロジェクトの削除。
- 疑わしいWebhookのGitLabプロジェクトへの追加。
- 保護ブランチ設定の変更。

#### レスポンス {#response-4}

GitLabプロジェクト設定への不正な変更が疑われる場合は、次の手順を実行することを検討してください:

- まず、利用可能な[監査イベント](../administration/compliance/audit_event_reports.md)をレビューして、アクションの責任者を特定します。
- ユーザーアカウントが疑わしい場合は、[侵害された疑いのあるユーザーアカウントガイドライン](responding_to_security_incidents.md#suspected-compromised-user-account)に概説されている手順に従ってください。
- 監査イベントを参照し、GitLabプロジェクトのオーナーとメンテナーにガイドラインを問い合わせて、設定を元の状態に戻すことを検討してください。

#### イベントタイプ {#event-types-3}

- 監査ログは、`target_type`フィールドに基づいてフィルタリングできます。セキュリティインシデントのコンテキストに基づいて、このフィールドにフィルターを適用して、スコープを絞り込みます。
- [コンプライアンス管理](../user/compliance/audit_event_types.md#compliance-management)と[グループとGitLabプロジェクトの監査イベント](../user/compliance/audit_event_types.md#groups-and-projects)の特定の監査イベントを探します。

### セキュリティインシデントに関する支援についてGitLabに問い合わせる {#engaging-gitlab-for-assistance-with-a-security-incident}

GitLabに支援を求める前に、[GitLabドキュメント](https://docs.gitlab.com)を検索してください。お客様側で予備調査を実施し、追加の質問がある場合や支援が必要な場合は、サポートにご連絡ください。GitLabサポートからの支援を受ける資格は、[ライセンスによって決定されます](https://about.gitlab.com/support/#gitlab-support-service-levels)。

### セキュリティのベストプラクティス {#security-best-practices}

環境を管理するための提案については、[GitLabセキュリティドキュメント](_index.md)を確認してください。

#### 強化に関する推奨事項 {#hardening-recommendations}

GitLab環境におけるセキュリティ対策状況を改善する方法については、[強化に関する推奨事項](hardening.md)をご覧ください。

[Git乱用レートの制限](../user/group/reporting/git_abuse_rate_limit.md)の詳細にあるように、実装を検討することもできます。乱用レートの制限を設定すると、特定の種類のインシデントを自動的に軽減するのに役立つ場合があります。

### 検出 {#detections}

GitLab SIRTは、[GitLab SIRTパブリックプロジェクト](https://gitlab.com/gitlab-security-oss/guard/-/tree/main/detections)で検出のアクティブリポジトリを維持しています。

このリポジトリの検出は、監査イベントに基づいており、一般的なSigmaルール形式になっています。シグマルールコンバーターを使用して、目的の形式でルールを取得できます。シグマ形式とそれに関連するツールについては、リポジトリにアクセスしてください。GitLabの監査ログがSIEMにインジェストされていることを確認してください。目的の場所に監査イベントをストリーミングするには、[Self-Managedインスタンス](../administration/compliance/audit_event_streaming.md)または[GitLab.comトップレベルグループ](../user/compliance/audit_event_streaming.md)の監査イベントストリーミングガイドに従ってください。
