/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tim.prune.cmd.Command;
import tim.prune.cmd.PointFlag;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;

public class SetSegmentsCmd
extends Command {
    private final HashMap<DataPoint, Boolean> _segmentFlags = new HashMap();

    public SetSegmentsCmd() {
        super(null);
    }

    public SetSegmentsCmd(List<PointFlag> list) {
        super(null);
        for (PointFlag pointFlag : list) {
            this.addSegmentFlag(pointFlag.getPoint(), pointFlag.getFlag());
        }
    }

    private SetSegmentsCmd(SetSegmentsCmd setSegmentsCmd) {
        super(setSegmentsCmd);
    }

    public void addSegmentFlag(DataPoint dataPoint) {
        this.addSegmentFlag(dataPoint, true);
    }

    public void addSegmentFlag(DataPoint dataPoint, boolean bl) {
        if (dataPoint != null) {
            this._segmentFlags.put(dataPoint, bl);
        }
    }

    @Override
    public int getUpdateFlags() {
        return 2;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        for (Map.Entry<DataPoint, Boolean> entry : this._segmentFlags.entrySet()) {
            DataPoint dataPoint = entry.getKey();
            boolean bl = entry.getValue();
            dataPoint.setSegmentStart(bl);
        }
        return !this._segmentFlags.isEmpty();
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        SetSegmentsCmd setSegmentsCmd = new SetSegmentsCmd(this);
        for (DataPoint dataPoint : this._segmentFlags.keySet()) {
            setSegmentsCmd.addSegmentFlag(dataPoint, dataPoint.getSegmentStart());
        }
        return setSegmentsCmd;
    }
}

