/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

binary morphological opening of an image.


This filter removes small (i.e., smaller than the structuring element)
structures in the interior or at the boundaries of the image. The
morphological opening of an image "f" is defined as: Opening(f) =
Dilatation(Erosion(f)).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel.

This code was contributed in the Insight Journal paper: "Binary
morphological closing and opening image filters" by Lehmann G. https://doi.org/10.54294/bcwtvq


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleErodeImageFilter

 itk::simple::BinaryMorphologicalOpening for the procedural interface

 itk::BinaryMorphologicalOpeningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMorphologicalOpeningImageFilter.h
*/
public class BinaryMorphologicalOpeningImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryMorphologicalOpeningImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryMorphologicalOpeningImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryMorphologicalOpeningImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryMorphologicalOpeningImageFilter::~BinaryMorphologicalOpeningImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryMorphologicalOpeningImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryMorphologicalOpeningImageFilter::BinaryMorphologicalOpeningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryMorphologicalOpeningImageFilter() {
    this(SimpleITKJNI.new_BinaryMorphologicalOpeningImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BinaryMorphologicalOpeningImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalOpeningImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::BinaryMorphologicalOpeningImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalOpeningImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value in eroded part of the image. Defaults to zero

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryMorphologicalOpeningImageFilter::GetBackgroundValue() const

Set the value in eroded part of the image. Defaults to zero

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalOpeningImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as "foreground". Defaults to
maximum value of PixelType.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryMorphologicalOpeningImageFilter::GetForegroundValue() const

Get the value in the image considered as "foreground". Defaults to
maximum value of PixelType.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMorphologicalOpeningImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMorphologicalOpeningImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryMorphologicalOpeningImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryMorphologicalOpeningImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
