/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.SWIGTYPE_p_itk__TransformBaseTemplateT_double_t;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.TransformEnum;
import org.itk.simple.VectorDouble;

public class Transform {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Transform(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Transform transform) {
        return transform == null ? 0L : transform.swigCPtr;
    }

    protected static long swigRelease(Transform transform) {
        long l = 0L;
        if (transform != null) {
            if (!transform.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = transform.swigCPtr;
            transform.swigCMemOwn = false;
            transform.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_Transform(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Transform() {
        this(SimpleITKJNI.new_Transform__SWIG_0(), true);
    }

    public Transform(SWIGTYPE_p_itk__TransformBaseTemplateT_double_t sWIGTYPE_p_itk__TransformBaseTemplateT_double_t) {
        this(SimpleITKJNI.new_Transform__SWIG_1(SWIGTYPE_p_itk__TransformBaseTemplateT_double_t.getCPtr(sWIGTYPE_p_itk__TransformBaseTemplateT_double_t)), true);
    }

    public Transform(long l, TransformEnum transformEnum) {
        this(SimpleITKJNI.new_Transform__SWIG_2(l, transformEnum.swigValue()), true);
    }

    public Transform(Image image, TransformEnum transformEnum) {
        this(SimpleITKJNI.new_Transform__SWIG_3(Image.getCPtr(image), image, transformEnum.swigValue()), true);
    }

    public Transform(Image image) {
        this(SimpleITKJNI.new_Transform__SWIG_4(Image.getCPtr(image), image), true);
    }

    public Transform(Transform transform) {
        this(SimpleITKJNI.new_Transform__SWIG_5(Transform.getCPtr(transform), transform), true);
    }

    public SWIGTYPE_p_itk__TransformBaseTemplateT_double_t getITKBase() {
        long l = SimpleITKJNI.Transform_getITKBase__SWIG_0(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_itk__TransformBaseTemplateT_double_t(l, false);
    }

    public long getDimension() {
        return SimpleITKJNI.Transform_getDimension(this.swigCPtr, this);
    }

    public void setParameters(VectorDouble vectorDouble) {
        SimpleITKJNI.Transform_setParameters(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getParameters() {
        return new VectorDouble(SimpleITKJNI.Transform_getParameters(this.swigCPtr, this), true);
    }

    public long getNumberOfParameters() {
        return SimpleITKJNI.Transform_getNumberOfParameters(this.swigCPtr, this);
    }

    public void setFixedParameters(VectorDouble vectorDouble) {
        SimpleITKJNI.Transform_setFixedParameters(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getFixedParameters() {
        return new VectorDouble(SimpleITKJNI.Transform_getFixedParameters(this.swigCPtr, this), true);
    }

    public long getNumberOfFixedParameters() {
        return SimpleITKJNI.Transform_getNumberOfFixedParameters(this.swigCPtr, this);
    }

    public VectorDouble transformPoint(VectorDouble vectorDouble) {
        return new VectorDouble(SimpleITKJNI.Transform_transformPoint(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble), true);
    }

    public VectorDouble transformVector(VectorDouble vectorDouble, VectorDouble vectorDouble2) {
        return new VectorDouble(SimpleITKJNI.Transform_transformVector(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble, VectorDouble.getCPtr(vectorDouble2), vectorDouble2), true);
    }

    public void writeTransform(String string) {
        SimpleITKJNI.Transform_writeTransform(this.swigCPtr, this, string);
    }

    public boolean isLinear() {
        return SimpleITKJNI.Transform_isLinear(this.swigCPtr, this);
    }

    public void setIdentity() {
        SimpleITKJNI.Transform_setIdentity(this.swigCPtr, this);
    }

    public boolean setInverse() {
        return SimpleITKJNI.Transform_setInverse(this.swigCPtr, this);
    }

    public Transform getInverse() {
        return new Transform(SimpleITKJNI.Transform_getInverse(this.swigCPtr, this), true);
    }

    public String toString() {
        return SimpleITKJNI.Transform_toString(this.swigCPtr, this);
    }

    public String getName() {
        return SimpleITKJNI.Transform_getName(this.swigCPtr, this);
    }

    public void makeUnique() {
        SimpleITKJNI.Transform_makeUnique(this.swigCPtr, this);
    }

    public TransformEnum getTransformEnum() {
        return TransformEnum.swigToEnum(SimpleITKJNI.Transform_getTransformEnum(this.swigCPtr, this));
    }
}

