/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.date;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Objects;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class Interval {
    private final Instant start;
    private final Instant end;

    public Interval(Instant start, Instant end) {
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return String.valueOf(this.start) + "/" + String.valueOf(this.end);
    }

    public String format() {
        String latestDate;
        Object ts = "";
        DateTimeFormatter df = DateUtils.getDateFormatter(FormatStyle.SHORT);
        String earliestDate = df.format(this.getStart());
        if (earliestDate.equals(latestDate = df.format(this.getEnd()))) {
            DateTimeFormatter tf = DateUtils.getTimeFormatter(FormatStyle.SHORT);
            ts = (String)ts + earliestDate + " ";
            ts = (String)ts + tf.format(this.getStart()) + " \u2013 " + tf.format(this.getEnd());
        } else {
            DateTimeFormatter dtf = DateUtils.getDateTimeFormatter(FormatStyle.SHORT, FormatStyle.MEDIUM);
            ts = (String)ts + dtf.format(this.getStart()) + " \u2013 " + dtf.format(this.getEnd());
        }
        ts = (String)ts + String.format(" (%s)", Utils.getDurationString(this.getEnd().toEpochMilli() - this.getStart().toEpochMilli()));
        return ts;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)o;
        return Objects.equals(this.start, interval.start) && Objects.equals(this.end, interval.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

