/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.AutoOffsetReset;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.NamedOperation;
import org.apache.kafka.streams.processor.TimestampExtractor;

public class Consumed<K, V>
implements NamedOperation<Consumed<K, V>> {
    protected Serde<K> keySerde;
    protected Serde<V> valueSerde;
    protected TimestampExtractor timestampExtractor;
    @Deprecated
    protected Topology.AutoOffsetReset legacyResetPolicy;
    protected AutoOffsetReset resetPolicy;
    protected String processorName;

    private Consumed(Serde<K> keySerde, Serde<V> valueSerde, TimestampExtractor timestampExtractor, Topology.AutoOffsetReset legacyResetPolicy, AutoOffsetReset resetPolicy, String processorName) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.timestampExtractor = timestampExtractor;
        this.legacyResetPolicy = legacyResetPolicy;
        this.resetPolicy = resetPolicy;
        this.processorName = processorName;
    }

    protected Consumed(Consumed<K, V> consumed) {
        this(consumed.keySerde, consumed.valueSerde, consumed.timestampExtractor, consumed.legacyResetPolicy, consumed.resetPolicy, consumed.processorName);
    }

    @Deprecated
    private static AutoOffsetReset convertOldToNew(Topology.AutoOffsetReset resetPolicy) {
        if (resetPolicy == null) {
            return null;
        }
        return resetPolicy == Topology.AutoOffsetReset.EARLIEST ? AutoOffsetReset.earliest() : AutoOffsetReset.latest();
    }

    @Deprecated
    public static <K, V> Consumed<K, V> with(Serde<K> keySerde, Serde<V> valueSerde, TimestampExtractor timestampExtractor, Topology.AutoOffsetReset resetPolicy) {
        return new Consumed<K, V>(keySerde, valueSerde, timestampExtractor, resetPolicy, Consumed.convertOldToNew(resetPolicy), null);
    }

    public static <K, V> Consumed<K, V> with(Serde<K> keySerde, Serde<V> valueSerde, TimestampExtractor timestampExtractor, AutoOffsetReset resetPolicy) {
        return new Consumed<K, V>(keySerde, valueSerde, timestampExtractor, null, resetPolicy, null);
    }

    public static <K, V> Consumed<K, V> with(Serde<K> keySerde, Serde<V> valueSerde) {
        return new Consumed<K, V>(keySerde, valueSerde, null, null, null, null);
    }

    public static <K, V> Consumed<K, V> with(TimestampExtractor timestampExtractor) {
        return new Consumed<K, V>(null, null, timestampExtractor, null, null, null);
    }

    @Deprecated
    public static <K, V> Consumed<K, V> with(Topology.AutoOffsetReset resetPolicy) {
        return new Consumed<K, V>(null, null, null, resetPolicy, Consumed.convertOldToNew(resetPolicy), null);
    }

    public static <K, V> Consumed<K, V> with(AutoOffsetReset resetPolicy) {
        return new Consumed<K, V>(null, null, null, null, resetPolicy, null);
    }

    public static <K, V> Consumed<K, V> as(String processorName) {
        return new Consumed<K, V>(null, null, null, null, null, processorName);
    }

    public Consumed<K, V> withKeySerde(Serde<K> keySerde) {
        return new Consumed<K, V>(keySerde, this.valueSerde, this.timestampExtractor, this.legacyResetPolicy, this.resetPolicy, this.processorName);
    }

    public Consumed<K, V> withValueSerde(Serde<V> valueSerde) {
        return new Consumed<K, V>(this.keySerde, valueSerde, this.timestampExtractor, this.legacyResetPolicy, this.resetPolicy, this.processorName);
    }

    public Consumed<K, V> withTimestampExtractor(TimestampExtractor timestampExtractor) {
        return new Consumed<K, V>(this.keySerde, this.valueSerde, timestampExtractor, this.legacyResetPolicy, this.resetPolicy, this.processorName);
    }

    @Deprecated
    public Consumed<K, V> withOffsetResetPolicy(Topology.AutoOffsetReset resetPolicy) {
        return new Consumed<K, V>(this.keySerde, this.valueSerde, this.timestampExtractor, resetPolicy, Consumed.convertOldToNew(resetPolicy), this.processorName);
    }

    public Consumed<K, V> withOffsetResetPolicy(AutoOffsetReset resetPolicy) {
        return new Consumed<K, V>(this.keySerde, this.valueSerde, this.timestampExtractor, null, resetPolicy, this.processorName);
    }

    @Override
    public Consumed<K, V> withName(String processorName) {
        return new Consumed<K, V>(this.keySerde, this.valueSerde, this.timestampExtractor, this.legacyResetPolicy, this.resetPolicy, processorName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Consumed consumed = (Consumed)o;
        return Objects.equals(this.keySerde, consumed.keySerde) && Objects.equals(this.valueSerde, consumed.valueSerde) && Objects.equals(this.timestampExtractor, consumed.timestampExtractor) && this.legacyResetPolicy == consumed.legacyResetPolicy && this.resetPolicy == consumed.resetPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keySerde, this.valueSerde, this.timestampExtractor, this.legacyResetPolicy, this.resetPolicy});
    }
}

