/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.HibernateException;
import org.hibernate.boot.internal.LimitedCollectionClassification;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAssociationAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddable;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManagedType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTenantIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.models.internal.ModelsHelper;
import org.hibernate.boot.models.xml.UnknownAttributeTypeException;
import org.hibernate.boot.models.xml.internal.SimpleTypeInterpretation;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.internal.ParameterizedTypeDetailsImpl;
import org.hibernate.models.internal.WildcardTypeDetailsImpl;
import org.hibernate.models.internal.dynamic.DynamicClassDetails;
import org.hibernate.models.internal.dynamic.DynamicFieldDetails;
import org.hibernate.models.internal.jdk.JdkClassDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.usertype.UserType;

public class DynamicModelHelper {
    private static ClassDetails COLLECTION_CLASS_DETAILS;
    private static ClassDetails SET_CLASS_DETAILS;
    private static ClassDetails LIST_CLASS_DETAILS;
    private static ClassDetails SORTED_SET_CLASS_DETAILS;
    private static ClassDetails MAP_CLASS_DETAILS;
    private static ClassDetails SORTED_MAP_CLASS_DETAILS;

    static void prepareDynamicClass(MutableClassDetails classDetails, JaxbManagedType jaxbManagedType, XmlDocumentContext xmlDocumentContext) {
        JaxbMappedSuperclassImpl jaxbMappedSuperclass;
        JaxbAttributesContainerImpl attributes;
        if (jaxbManagedType instanceof JaxbEntityImpl) {
            JaxbTenantIdImpl tenantId;
            DynamicFieldDetails member;
            TypeDetails attributeJavaType;
            JaxbEntityImpl jaxbDynamicEntity = (JaxbEntityImpl)jaxbManagedType;
            JaxbAttributesContainerImpl attributes2 = jaxbDynamicEntity.getAttributes();
            if (attributes2 != null) {
                if (CollectionHelper.isNotEmpty(attributes2.getIdAttributes())) {
                    attributes2.getIdAttributes().forEach(jaxbId -> {
                        TypeDetails attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, jaxbId, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbId.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                } else if (attributes2.getEmbeddedIdAttribute() != null) {
                    JaxbEmbeddedIdImpl embeddedId = attributes2.getEmbeddedIdAttribute();
                    attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, embeddedId, xmlDocumentContext);
                    member = new DynamicFieldDetails(embeddedId.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                    classDetails.addField((FieldDetails)member);
                }
                if (attributes2.getNaturalId() != null) {
                    attributes2.getNaturalId().getBasicAttributes().forEach(jaxbBasic -> {
                        TypeDetails attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, jaxbBasic, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbBasic.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                    attributes2.getNaturalId().getEmbeddedAttributes().forEach(jaxbEmbedded -> {
                        TypeDetails attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, jaxbEmbedded, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbEmbedded.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                    attributes2.getNaturalId().getManyToOneAttributes().forEach(jaxbManyToOne -> {
                        TypeDetails attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManyToOne, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbManyToOne.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                    attributes2.getNaturalId().getAnyMappingAttributes().forEach(jaxbAnyMapping -> {
                        TypeDetails attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbAnyMapping, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbAnyMapping.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                }
            }
            if ((tenantId = jaxbDynamicEntity.getTenantId()) != null) {
                attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, tenantId, xmlDocumentContext);
                member = new DynamicFieldDetails(tenantId.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            }
        } else if (jaxbManagedType instanceof JaxbMappedSuperclassImpl && (attributes = (jaxbMappedSuperclass = (JaxbMappedSuperclassImpl)jaxbManagedType).getAttributes()) != null) {
            if (CollectionHelper.isNotEmpty(attributes.getIdAttributes())) {
                attributes.getIdAttributes().forEach(jaxbId -> {
                    TypeDetails attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, jaxbId, xmlDocumentContext);
                    DynamicFieldDetails member = new DynamicFieldDetails(jaxbId.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                    classDetails.addField((FieldDetails)member);
                });
            } else {
                JaxbEmbeddedIdImpl embeddedId = attributes.getEmbeddedIdAttribute();
                TypeDetails attributeJavaType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, embeddedId, xmlDocumentContext);
                DynamicFieldDetails member = new DynamicFieldDetails(embeddedId.getName(), attributeJavaType, (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            }
        }
        JaxbAttributesContainer attributes3 = jaxbManagedType.getAttributes();
        if (attributes3 != null) {
            attributes3.getBasicAttributes().forEach(jaxbBasic -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbBasic.getName(), DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, jaxbBasic, xmlDocumentContext), (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getEmbeddedAttributes().forEach(jaxbEmbedded -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbEmbedded.getName(), DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManagedType, jaxbEmbedded, xmlDocumentContext), (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getOneToOneAttributes().forEach(jaxbOneToOne -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbOneToOne.getName(), DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbOneToOne, xmlDocumentContext), (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getManyToOneAttributes().forEach(jaxbManyToOne -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbManyToOne.getName(), DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManyToOne, xmlDocumentContext), (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getAnyMappingAttributes().forEach(jaxbAnyMapping -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbAnyMapping.getName(), DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbAnyMapping, xmlDocumentContext), (ClassDetails)classDetails, -5337, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getElementCollectionAttributes().forEach(jaxbElementCollection -> {
                TypeDetails elementType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbElementCollection, xmlDocumentContext);
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbElementCollection.getName(), DynamicModelHelper.makeCollectionType((ClassDetails)classDetails, jaxbElementCollection, elementType, xmlDocumentContext), (ClassDetails)classDetails, -5337, false, true, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getOneToManyAttributes().forEach(jaxbOneToMany -> {
                TypeDetails elementType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbOneToMany, xmlDocumentContext);
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbOneToMany.getName(), DynamicModelHelper.makeCollectionType((ClassDetails)classDetails, jaxbOneToMany, elementType, xmlDocumentContext), (ClassDetails)classDetails, -5337, false, true, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getManyToManyAttributes().forEach(jaxbManyToMany -> {
                TypeDetails elementType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbManyToMany, xmlDocumentContext);
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbManyToMany.getName(), DynamicModelHelper.makeCollectionType((ClassDetails)classDetails, jaxbManyToMany, elementType, xmlDocumentContext), (ClassDetails)classDetails, -5337, false, true, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getPluralAnyMappingAttributes().forEach(jaxbPluralAnyMapping -> {
                TypeDetails attributeType = DynamicModelHelper.determineAttributeJavaTypeDetails(jaxbPluralAnyMapping, xmlDocumentContext);
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbPluralAnyMapping.getName(), attributeType, (ClassDetails)classDetails, -5337, false, true, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
        }
    }

    private static TypeDetails makeCollectionType(ClassDetails declaringType, JaxbPluralAttribute jaxbPluralAttribute, TypeDetails elementType, XmlDocumentContext xmlDocumentContext) {
        ClassDetails collectionClassDetails;
        MutableClassDetailsRegistry classDetailsRegistry = (MutableClassDetailsRegistry)xmlDocumentContext.getBootstrapContext().getModelsContext().getClassDetailsRegistry().as(MutableClassDetailsRegistry.class);
        return new ParameterizedTypeDetailsImpl(collectionClassDetails, switch (jaxbPluralAttribute.getClassification()) {
            case LimitedCollectionClassification.BAG -> {
                collectionClassDetails = DynamicModelHelper.collectionType(classDetailsRegistry);
                yield List.of(elementType);
            }
            case LimitedCollectionClassification.LIST -> {
                collectionClassDetails = DynamicModelHelper.listType(classDetailsRegistry);
                yield List.of(elementType);
            }
            case LimitedCollectionClassification.SET -> {
                collectionClassDetails = DynamicModelHelper.setType(jaxbPluralAttribute, classDetailsRegistry);
                yield List.of(elementType);
            }
            case LimitedCollectionClassification.MAP -> {
                collectionClassDetails = DynamicModelHelper.mapType(jaxbPluralAttribute, classDetailsRegistry);
                ClassDetails objectClassDetails = classDetailsRegistry.resolveClassDetails(Object.class.getName());
                yield List.of(new WildcardTypeDetailsImpl((TypeDetails)new ClassTypeDetailsImpl(objectClassDetails, TypeDetails.Kind.CLASS), true), elementType);
            }
            default -> throw new UnknownAttributeTypeException(String.format(Locale.ROOT, "Could not determine target type for dynamic attribute [%s, %s]", declaringType, jaxbPluralAttribute.getName()));
        }, (TypeVariableScope)declaringType);
    }

    private static ClassDetails collectionType(MutableClassDetailsRegistry classDetailsRegistry) {
        if (COLLECTION_CLASS_DETAILS == null) {
            COLLECTION_CLASS_DETAILS = classDetailsRegistry.getClassDetails(Collection.class.getName());
        }
        return COLLECTION_CLASS_DETAILS;
    }

    private static ClassDetails listType(MutableClassDetailsRegistry classDetailsRegistry) {
        if (LIST_CLASS_DETAILS == null) {
            LIST_CLASS_DETAILS = classDetailsRegistry.getClassDetails(List.class.getName());
        }
        return LIST_CLASS_DETAILS;
    }

    private static ClassDetails setType(JaxbPluralAttribute jaxbPluralAttribute, MutableClassDetailsRegistry classDetailsRegistry) {
        if (DynamicModelHelper.isSorted(jaxbPluralAttribute)) {
            if (SORTED_SET_CLASS_DETAILS == null) {
                SORTED_SET_CLASS_DETAILS = classDetailsRegistry.getClassDetails(SortedSet.class.getName());
            }
            return SORTED_SET_CLASS_DETAILS;
        }
        if (SET_CLASS_DETAILS == null) {
            SET_CLASS_DETAILS = classDetailsRegistry.getClassDetails(Set.class.getName());
        }
        return SET_CLASS_DETAILS;
    }

    private static boolean isSorted(JaxbPluralAttribute jaxbPluralAttribute) {
        return StringHelper.isNotEmpty(jaxbPluralAttribute.getSort()) || jaxbPluralAttribute.getSortNatural() != null || StringHelper.isNotEmpty(jaxbPluralAttribute.getOrderBy());
    }

    private static ClassDetails mapType(JaxbPluralAttribute jaxbPluralAttribute, MutableClassDetailsRegistry classDetailsRegistry) {
        if (DynamicModelHelper.isSorted(jaxbPluralAttribute)) {
            if (SORTED_MAP_CLASS_DETAILS == null) {
                SORTED_MAP_CLASS_DETAILS = classDetailsRegistry.getClassDetails(SortedMap.class.getName());
            }
            return SORTED_MAP_CLASS_DETAILS;
        }
        if (MAP_CLASS_DETAILS == null) {
            MAP_CLASS_DETAILS = classDetailsRegistry.getClassDetails(Map.class.getName());
        }
        return MAP_CLASS_DETAILS;
    }

    private static TypeDetails determineAttributeJavaTypeDetails(JaxbManagedType declaringType, JaxbBasicMapping jaxbBasicMapping, XmlDocumentContext xmlDocumentContext) {
        return new ClassTypeDetailsImpl(DynamicModelHelper.determineAttributeJavaType(declaringType, jaxbBasicMapping, xmlDocumentContext), TypeDetails.Kind.CLASS);
    }

    private static ClassDetails determineAttributeJavaType(JaxbManagedType declaringType, JaxbBasicMapping jaxbBasicMapping, XmlDocumentContext xmlDocumentContext) {
        String declaringTypeName;
        JaxbBasicImpl jaxbBasicAttribute;
        TemporalType temporalType;
        JdbcType jdbcType;
        String userTypeImplName;
        String target = jaxbBasicMapping.getTarget();
        if (StringHelper.isNotEmpty(target)) {
            SimpleTypeInterpretation simpleTypeInterpretation = SimpleTypeInterpretation.interpret(target);
            if (simpleTypeInterpretation == null) {
                throw new UnknownAttributeTypeException(String.format(Locale.ROOT, "Could not determine target type for dynamic attribute [%s, %s]", declaringType, jaxbBasicMapping.getName()));
            }
            return DynamicModelHelper.resolveBasicMappingTarget(simpleTypeInterpretation, xmlDocumentContext);
        }
        BootstrapContext bootstrapContext = xmlDocumentContext.getBootstrapContext();
        ModelsContext modelsContext = bootstrapContext.getModelsContext();
        JaxbUserTypeImpl userTypeNode = jaxbBasicMapping.getType();
        if (userTypeNode != null && StringHelper.isNotEmpty(userTypeImplName = userTypeNode.getValue())) {
            MutableClassDetails userTypeImplDetails = xmlDocumentContext.resolveJavaType(userTypeImplName);
            UserType userType = (UserType)DynamicModelHelper.createInstance((ClassDetails)userTypeImplDetails);
            Class modelClass = userType.returnedClass();
            return modelsContext.getClassDetailsRegistry().getClassDetails(modelClass.getName());
        }
        String javaTypeImplName = jaxbBasicMapping.getJavaType();
        if (StringHelper.isNotEmpty(javaTypeImplName)) {
            MutableClassDetails javaTypeImplDetails = xmlDocumentContext.resolveJavaType(javaTypeImplName);
            JavaType javaType = (JavaType)DynamicModelHelper.createInstance((ClassDetails)javaTypeImplDetails);
            Class modelClass = javaType.getJavaTypeClass();
            return modelsContext.getClassDetailsRegistry().getClassDetails(modelClass.getName());
        }
        String jdbcTypeImplName = jaxbBasicMapping.getJdbcType();
        Integer jdbcTypeCode = jaxbBasicMapping.getJdbcTypeCode();
        if (StringHelper.isNotEmpty(jdbcTypeImplName)) {
            MutableClassDetails jdbcTypeImplDetails = xmlDocumentContext.resolveJavaType(javaTypeImplName);
            jdbcType = (JdbcType)DynamicModelHelper.createInstance((ClassDetails)jdbcTypeImplDetails);
        } else {
            jdbcType = jdbcTypeCode != null ? bootstrapContext.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(jdbcTypeCode) : null;
        }
        if (jdbcType != null) {
            JavaType javaType = jdbcType.getJdbcRecommendedJavaTypeMapping(0, 0, bootstrapContext.getTypeConfiguration());
            Class modelClass = javaType.getJavaTypeClass();
            return modelsContext.getClassDetailsRegistry().getClassDetails(modelClass.getName());
        }
        if (jaxbBasicMapping instanceof JaxbBasicImpl && (temporalType = (jaxbBasicAttribute = (JaxbBasicImpl)jaxbBasicMapping).getTemporal()) != null) {
            return DynamicModelHelper.resolveTemporalJavaType(temporalType, xmlDocumentContext);
        }
        if (declaringType instanceof JaxbEntity) {
            JaxbEntity jaxbEntity = (JaxbEntity)declaringType;
            declaringTypeName = StringHelper.nullIfEmpty(jaxbEntity.getName());
        } else if (declaringType instanceof JaxbEmbeddable) {
            JaxbEmbeddable jaxbEmbeddable = (JaxbEmbeddable)declaringType;
            declaringTypeName = StringHelper.nullIfEmpty(jaxbEmbeddable.getName());
        } else {
            declaringTypeName = null;
        }
        throw new UnknownAttributeTypeException(String.format(Locale.ROOT, "Could not determine target type for dynamic attribute [%s#%s]", declaringTypeName != null ? declaringTypeName : declaringType.getClazz(), jaxbBasicMapping.getName()));
    }

    private static ClassDetails resolveBasicMappingTarget(SimpleTypeInterpretation targetInterpretation, XmlDocumentContext xmlDocumentContext) {
        ModelsContext modelsContext = xmlDocumentContext.getBootstrapContext().getModelsContext();
        ClassDetailsRegistry classDetailsRegistry = modelsContext.getClassDetailsRegistry();
        return classDetailsRegistry.resolveClassDetails(targetInterpretation.getJavaType().getName());
    }

    private static MutableClassDetails resolveTemporalJavaType(TemporalType temporalType, XmlDocumentContext xmlDocumentContext) {
        ModelsContext modelsContext = xmlDocumentContext.getBootstrapContext().getModelsContext();
        MutableClassDetailsRegistry classDetailsRegistry = (MutableClassDetailsRegistry)modelsContext.getClassDetailsRegistry().as(MutableClassDetailsRegistry.class);
        switch (temporalType) {
            case DATE: {
                return (MutableClassDetails)classDetailsRegistry.resolveClassDetails(Date.class.getName(), name -> new JdkClassDetails(Date.class, modelsContext));
            }
            case TIME: {
                return (MutableClassDetails)classDetailsRegistry.resolveClassDetails(Time.class.getName(), name -> new JdkClassDetails(Time.class, modelsContext));
            }
        }
        return (MutableClassDetails)classDetailsRegistry.resolveClassDetails(Timestamp.class.getName(), name -> new JdkClassDetails(Timestamp.class, modelsContext));
    }

    private static TypeDetails determineAttributeJavaTypeDetails(JaxbManagedType declaringType, JaxbEmbeddedMapping jaxbEmbeddedMapping, XmlDocumentContext xmlDocumentContext) {
        String target = jaxbEmbeddedMapping.getTarget();
        if (StringHelper.isNotEmpty(target)) {
            ModelsContext modelsContext = xmlDocumentContext.getBootstrapContext().getModelsContext();
            ClassDetails memberTypeClassDetails = ModelsHelper.resolveClassDetails(target, modelsContext.getClassDetailsRegistry(), () -> new DynamicClassDetails(target, modelsContext));
            return new ClassTypeDetailsImpl(memberTypeClassDetails, TypeDetails.Kind.CLASS);
        }
        throw new HibernateException("Could not determine target type for dynamic attribute");
    }

    private static TypeDetails determineAttributeJavaTypeDetails(JaxbAssociationAttribute jaxbAssociationAttribute, XmlDocumentContext xmlDocumentContext) {
        String target = jaxbAssociationAttribute.getTargetEntity();
        if (StringHelper.isNotEmpty(target)) {
            ModelsContext modelsContext = xmlDocumentContext.getBootstrapContext().getModelsContext();
            ClassDetails classDetails = ModelsHelper.resolveClassDetails(target, modelsContext.getClassDetailsRegistry(), () -> new DynamicClassDetails(target, null, false, null, null, modelsContext));
            return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
        }
        throw new HibernateException("Could not determine target type for dynamic attribute");
    }

    private static TypeDetails determineAttributeJavaTypeDetails(JaxbAnyMapping jaxbAnyMapping, XmlDocumentContext xmlDocumentContext) {
        ModelsContext modelsContext = xmlDocumentContext.getBootstrapContext().getModelsContext();
        ClassDetails objectClassDetails = modelsContext.getClassDetailsRegistry().resolveClassDetails(Object.class.getName());
        return new ClassTypeDetailsImpl(objectClassDetails, TypeDetails.Kind.CLASS);
    }

    private static TypeDetails determineAttributeJavaTypeDetails(JaxbElementCollectionImpl jaxbElementCollection, XmlDocumentContext xmlDocumentContext) {
        LimitedCollectionClassification classification = NullnessHelper.nullif(jaxbElementCollection.getClassification(), LimitedCollectionClassification.BAG);
        return switch (classification) {
            default -> throw new IncompatibleClassChangeError();
            case LimitedCollectionClassification.BAG -> DynamicModelHelper.resolveCollectionType(Collection.class, xmlDocumentContext);
            case LimitedCollectionClassification.LIST -> DynamicModelHelper.resolveCollectionType(List.class, xmlDocumentContext);
            case LimitedCollectionClassification.SET -> DynamicModelHelper.resolveCollectionType(Set.class, xmlDocumentContext);
            case LimitedCollectionClassification.MAP -> DynamicModelHelper.resolveCollectionType(Map.class, xmlDocumentContext);
        };
    }

    private static TypeDetails resolveCollectionType(Class<?> collectionType, XmlDocumentContext xmlDocumentContext) {
        ClassDetails classDetails = xmlDocumentContext.getBootstrapContext().getModelsContext().getClassDetailsRegistry().resolveClassDetails(collectionType.getName());
        return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
    }

    private static <T> @NonNull T createInstance(ClassDetails classDetails) {
        try {
            return classDetails.toJavaClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new HibernateException("Unable to create instance from incoming ClassDetails - " + String.valueOf(classDetails));
        }
    }
}

