/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.headers.Header;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedHeader;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedHeaders
implements ComposedChanged {
    private final Map<String, Header> oldHeaders;
    private final Map<String, Header> newHeaders;
    private final DiffContext context;
    private Map<String, Header> increased;
    private Map<String, Header> missing;
    private Map<String, ChangedHeader> changed;

    public ChangedHeaders(Map<String, Header> oldHeaders, Map<String, Header> newHeaders, DiffContext context) {
        this.oldHeaders = oldHeaders;
        this.newHeaders = newHeaders;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed.values());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (!this.missing.isEmpty() && BackwardIncompatibleProp.RESPONSE_HEADERS_DECREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public Map<String, Header> getOldHeaders() {
        return this.oldHeaders;
    }

    public Map<String, Header> getNewHeaders() {
        return this.newHeaders;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Map<String, Header> getIncreased() {
        return this.increased;
    }

    public Map<String, Header> getMissing() {
        return this.missing;
    }

    public Map<String, ChangedHeader> getChanged() {
        return this.changed;
    }

    public ChangedHeaders setIncreased(Map<String, Header> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedHeaders setMissing(Map<String, Header> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedHeaders setChanged(Map<String, ChangedHeader> changed) {
        this.changed = changed;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedHeaders that = (ChangedHeaders)o;
        return Objects.equals(this.oldHeaders, that.oldHeaders) && Objects.equals(this.newHeaders, that.newHeaders) && Objects.equals(this.context, that.context) && Objects.equals(this.increased, that.increased) && Objects.equals(this.missing, that.missing) && Objects.equals(this.changed, that.changed);
    }

    public int hashCode() {
        return Objects.hash(this.oldHeaders, this.newHeaders, this.context, this.increased, this.missing, this.changed);
    }

    public String toString() {
        return "ChangedHeaders(oldHeaders=" + this.getOldHeaders() + ", newHeaders=" + this.getNewHeaders() + ", context=" + this.getContext() + ", increased=" + this.getIncreased() + ", missing=" + this.getMissing() + ", changed=" + this.getChanged() + ")";
    }
}

