/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;

final class OracleConversionReader
extends Reader {
    static final int CHUNK_SIZE = 32768;
    Monitor monitor;
    DBConversion dbConversion;
    int conversion;
    InputStream istream;
    private char[] buf;
    private byte[] byteBuf;
    int pos;
    int count;
    int numUnconvertedBytes;
    boolean isClosed;
    boolean endOfStream;
    private short csform;
    int[] nbytes;

    public OracleConversionReader(DBConversion conv_object, InputStream istream, int conversion, Monitor monitor) throws SQLException {
        if (conv_object == null || istream == null || conversion != 8 && conversion != 9) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.monitor = monitor;
        this.dbConversion = conv_object;
        this.conversion = conversion;
        this.istream = istream;
        this.count = 0;
        this.pos = 0;
        this.numUnconvertedBytes = 0;
        this.isClosed = false;
        this.nbytes = new int[1];
        if (conversion == 8) {
            this.byteBuf = this.dbConversion.byteArrayAllocator.apply(16384);
            this.buf = this.dbConversion.charArrayAllocator.apply(32768);
        } else if (conversion == 9) {
            this.byteBuf = this.dbConversion.byteArrayAllocator.apply(32768);
            this.buf = this.dbConversion.charArrayAllocator.apply(32768);
        }
    }

    public void setFormOfUse(short csform) {
        this.csform = csform;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (!this.needChars()) {
            this.deallocateBuffers();
            return -1;
        }
        int start = off;
        int end = start + Math.min(len, cbuf.length - off);
        start += this.writeChars(cbuf, start, end - start);
        while (start < end && this.needChars()) {
            start += this.writeChars(cbuf, start, end - start);
        }
        return start - off;
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    int bytes_read = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
                    if (bytes_read == -1) {
                        this.endOfStream = true;
                        if (this.numUnconvertedBytes != 0) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55).fillInStackTrace();
                        }
                    }
                    if ((bytes_read += this.numUnconvertedBytes) > 0) {
                        switch (this.conversion) {
                            case 8: {
                                this.count = DBConversion.RAWBytesToHexChars(this.byteBuf, bytes_read, this.buf);
                                break;
                            }
                            case 9: {
                                this.nbytes[0] = bytes_read;
                                this.count = this.csform == 2 ? this.dbConversion.NCHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length) : this.dbConversion.CHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length);
                                this.numUnconvertedBytes = this.nbytes[0];
                                for (int i = 0; i < this.numUnconvertedBytes; ++i) {
                                    this.byteBuf[i] = this.byteBuf[bytes_read - this.numUnconvertedBytes + i];
                                }
                                break;
                            }
                            default: {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                            }
                        }
                        if (this.count > 0) {
                            this.pos = 0;
                            return true;
                        }
                    }
                }
                catch (SQLException e) {
                    throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] destbuf, int offset, int length) {
        int availableLength = Math.min(length, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, destbuf, offset, availableLength);
        this.pos += availableLength;
        return availableLength;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.istream.close();
        }
        this.deallocateBuffers();
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException e) {
            throw (IOException)DatabaseError.createIOException(e).fillInStackTrace();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private void deallocateBuffers() {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            if (this.byteBuf != null) {
                this.dbConversion.byteArrayCache.accept(this.byteBuf);
                this.byteBuf = null;
            }
            if (this.buf != null) {
                this.dbConversion.charArrayCache.accept(this.buf);
                this.buf = null;
            }
        }
    }
}

