/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.merge;

import java.io.IOException;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class MergedSegmentWarmerStats
implements Writeable,
ToXContentFragment {
    private long totalInvocationsCount;
    private long totalTimeMillis;
    private long totalFailureCount;
    private long totalBytesSent;
    private long totalBytesReceived;
    private long totalSendTimeMillis;
    private long totalReceiveTimeMillis;
    private long ongoingCount;

    public MergedSegmentWarmerStats() {
    }

    public MergedSegmentWarmerStats(StreamInput in) throws IOException {
        this.totalInvocationsCount = in.readVLong();
        this.totalTimeMillis = in.readVLong();
        this.totalFailureCount = in.readVLong();
        this.totalBytesSent = in.readVLong();
        this.totalBytesReceived = in.readVLong();
        this.totalSendTimeMillis = in.readVLong();
        this.totalReceiveTimeMillis = in.readVLong();
        this.ongoingCount = in.readVLong();
    }

    public synchronized void add(long totalInvocationsCount, long totalTimeMillis, long totalFailureCount, long totalBytesSent, long totalBytesReceived, long totalSendTimeMillis, long totalReceiveTimeMillis, long ongoingCount) {
        this.totalInvocationsCount += totalInvocationsCount;
        this.totalTimeMillis += totalTimeMillis;
        this.totalFailureCount += totalFailureCount;
        this.totalBytesSent += totalBytesSent;
        this.totalBytesReceived += totalBytesReceived;
        this.totalSendTimeMillis += totalSendTimeMillis;
        this.totalReceiveTimeMillis += totalReceiveTimeMillis;
        this.ongoingCount += ongoingCount;
    }

    public void add(MergedSegmentWarmerStats mergedSegmentWarmerStats) {
        this.ongoingCount += mergedSegmentWarmerStats.ongoingCount;
    }

    public synchronized void addTotals(MergedSegmentWarmerStats mergedSegmentWarmerStats) {
        if (mergedSegmentWarmerStats == null) {
            return;
        }
        this.totalInvocationsCount += mergedSegmentWarmerStats.totalInvocationsCount;
        this.totalTimeMillis += mergedSegmentWarmerStats.totalTimeMillis;
        this.totalFailureCount += mergedSegmentWarmerStats.totalFailureCount;
        this.totalBytesSent += mergedSegmentWarmerStats.totalBytesSent;
        this.totalBytesReceived += mergedSegmentWarmerStats.totalBytesReceived;
        this.totalSendTimeMillis += mergedSegmentWarmerStats.totalSendTimeMillis;
        this.totalReceiveTimeMillis += mergedSegmentWarmerStats.totalReceiveTimeMillis;
    }

    public long getTotalInvocationsCount() {
        return this.totalInvocationsCount;
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeMillis);
    }

    public long getOngoingCount() {
        return this.ongoingCount;
    }

    public ByteSizeValue getTotalReceivedSize() {
        return new ByteSizeValue(this.totalBytesReceived);
    }

    public ByteSizeValue getTotalSentSize() {
        return new ByteSizeValue(this.totalBytesSent);
    }

    public TimeValue getTotalReceiveTime() {
        return new TimeValue(this.totalReceiveTimeMillis);
    }

    public long getTotalFailureCount() {
        return this.totalFailureCount;
    }

    public TimeValue getTotalSendTime() {
        return new TimeValue(this.totalSendTimeMillis);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("warmer");
        builder.field("total_invocations_count", this.totalInvocationsCount);
        builder.humanReadableField("total_time_millis", "total_time", (Object)this.getTotalTime());
        builder.field("total_failure_count", this.totalFailureCount);
        builder.humanReadableField("total_bytes_sent", "total_sent_size", (Object)this.getTotalSentSize());
        builder.humanReadableField("total_bytes_received", "total_received_size", (Object)this.getTotalReceivedSize());
        builder.humanReadableField("total_send_time_millis", "total_send_time", (Object)this.getTotalSendTime());
        builder.humanReadableField("total_receive_time_millis", "total_receive_time", (Object)this.getTotalReceiveTime());
        builder.field("ongoing_count", this.ongoingCount);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalInvocationsCount);
        out.writeVLong(this.totalTimeMillis);
        out.writeVLong(this.totalFailureCount);
        out.writeVLong(this.totalBytesSent);
        out.writeVLong(this.totalBytesReceived);
        out.writeVLong(this.totalSendTimeMillis);
        out.writeVLong(this.totalReceiveTimeMillis);
        out.writeVLong(this.ongoingCount);
    }

    static final class Fields {
        static final String WARMER = "warmer";
        static final String WARM_INVOCATIONS_COUNT = "total_invocations_count";
        static final String TOTAL_TIME_MILLIS = "total_time_millis";
        static final String TOTAL_FAILURE_COUNT = "total_failure_count";
        static final String TOTAL_BYTES_SENT = "total_bytes_sent";
        static final String TOTAL_BYTES_RECEIVED = "total_bytes_received";
        static final String TOTAL_SEND_TIME_MILLIS = "total_send_time_millis";
        static final String TOTAL_RECEIVE_TIME_MILLIS = "total_receive_time_millis";
        static final String ONGOING_COUNT = "ongoing_count";
        public static final String TOTAL_TIME = "total_time";
        public static final String TOTAL_SEND_TIME = "total_send_time";
        public static final String TOTAL_RECEIVE_TIME = "total_receive_time";
        public static final String TOTAL_SENT_SIZE = "total_sent_size";
        public static final String TOTAL_RECEIVED_SIZE = "total_received_size";

        Fields() {
        }
    }
}

