/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.repositories.cleanup;

import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import org.opensearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.RepositoryCleanupInProgress;
import org.opensearch.cluster.SnapshotDeletionsInProgress;
import org.opensearch.cluster.SnapshotsInProgress;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.store.RemoteSegmentStoreDirectoryFactory;
import org.opensearch.index.store.lockmanager.RemoteStoreLockManagerFactory;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryCleanupResult;
import org.opensearch.repositories.RepositoryData;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.snapshots.SnapshotsService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public final class TransportCleanupRepositoryAction
extends TransportClusterManagerNodeAction<CleanupRepositoryRequest, CleanupRepositoryResponse> {
    private static final Logger logger = LogManager.getLogger(TransportCleanupRepositoryAction.class);
    private final RepositoriesService repositoriesService;
    private final SnapshotsService snapshotsService;
    private final RemoteStoreLockManagerFactory remoteStoreLockManagerFactory;
    private final RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory;

    @Override
    protected String executor() {
        return "same";
    }

    @Inject
    public TransportCleanupRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, SnapshotsService snapshotsService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RemoteStoreSettings remoteStoreSettings) {
        super("cluster:admin/repository/_cleanup", transportService, clusterService, threadPool, actionFilters, CleanupRepositoryRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
        this.snapshotsService = snapshotsService;
        this.remoteSegmentStoreDirectoryFactory = new RemoteSegmentStoreDirectoryFactory(() -> repositoriesService, threadPool, remoteStoreSettings.getSegmentsPathFixedPrefix());
        this.remoteStoreLockManagerFactory = new RemoteStoreLockManagerFactory(() -> repositoriesService, remoteStoreSettings.getSegmentsPathFixedPrefix());
        if (DiscoveryNode.isClusterManagerNode(clusterService.getSettings())) {
            TransportCleanupRepositoryAction.addClusterStateApplier(clusterService);
        }
    }

    private static void addClusterStateApplier(ClusterService clusterService) {
        clusterService.addStateApplier(event -> {
            if (event.localNodeClusterManager() && !event.previousState().nodes().isLocalNodeElectedClusterManager()) {
                final RepositoryCleanupInProgress repositoryCleanupInProgress = event.state().custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY);
                if (!repositoryCleanupInProgress.hasCleanupInProgress()) {
                    return;
                }
                clusterService.submitStateUpdateTask("clean up repository cleanup task after cluster-manager failover", new ClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        return TransportCleanupRepositoryAction.removeInProgressCleanup(currentState);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        logger.debug("Removed repository cleanup task [{}] from cluster state", (Object)repositoryCleanupInProgress);
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        logger.warn("Failed to remove repository cleanup task [{}] from cluster state", (Object)repositoryCleanupInProgress);
                    }
                });
            }
        });
    }

    private static ClusterState removeInProgressCleanup(ClusterState currentState) {
        return currentState.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY).hasCleanupInProgress() ? ClusterState.builder(currentState).putCustom("repository_cleanup", RepositoryCleanupInProgress.EMPTY).build() : currentState;
    }

    @Override
    protected CleanupRepositoryResponse read(StreamInput in) throws IOException {
        return new CleanupRepositoryResponse(in);
    }

    @Override
    protected void clusterManagerOperation(CleanupRepositoryRequest request, ClusterState state, ActionListener<CleanupRepositoryResponse> listener) {
        this.cleanupRepo(request.name(), (ActionListener<RepositoryCleanupResult>)ActionListener.map(listener, CleanupRepositoryResponse::new));
    }

    @Override
    protected ClusterBlockException checkBlock(CleanupRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private void cleanupRepo(final String repositoryName, ActionListener<RepositoryCleanupResult> listener) {
        Repository repository = this.repositoriesService.repository(repositoryName);
        if (!(repository instanceof BlobStoreRepository)) {
            listener.onFailure((Exception)new IllegalArgumentException("Repository [" + repositoryName + "] does not support repository cleanup"));
            return;
        }
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        StepListener repositoryDataListener = new StepListener();
        repository.getRepositoryData((ActionListener<RepositoryData>)repositoryDataListener);
        repositoryDataListener.whenComplete(repositoryData -> {
            final long repositoryStateId = repositoryData.getGenId();
            logger.info("Running cleanup operations on repository [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
            this.clusterService.submitStateUpdateTask("cleanup repository [" + repositoryName + "][" + repositoryStateId + "]", new ClusterStateUpdateTask((ActionListener)listener, blobStoreRepository, (RepositoryData)repositoryData){
                private boolean startedCleanup = false;
                final /* synthetic */ ActionListener val$listener;
                final /* synthetic */ BlobStoreRepository val$blobStoreRepository;
                final /* synthetic */ RepositoryData val$repositoryData;
                {
                    this.val$listener = actionListener;
                    this.val$blobStoreRepository = blobStoreRepository;
                    this.val$repositoryData = repositoryData;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RepositoryCleanupInProgress repositoryCleanupInProgress = currentState.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY);
                    if (repositoryCleanupInProgress.hasCleanupInProgress()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a repository cleanup is already in-progress in [" + String.valueOf(repositoryCleanupInProgress) + "]");
                    }
                    SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                    if (deletionsInProgress.hasDeletionsInProgress()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a snapshot is currently being deleted in [" + String.valueOf(deletionsInProgress) + "]");
                    }
                    SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                    if (!snapshots.entries().isEmpty()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a snapshot is currently running in [" + String.valueOf(snapshots) + "]");
                    }
                    return ClusterState.builder(currentState).putCustom("repository_cleanup", new RepositoryCleanupInProgress(Collections.singletonList(RepositoryCleanupInProgress.startedEntry(repositoryName, repositoryStateId)))).build();
                }

                @Override
                public void onFailure(String source, Exception e) {
                    this.after(e, null);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    this.startedCleanup = true;
                    logger.debug("Initialized repository cleanup in cluster state for [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
                    TransportCleanupRepositoryAction.this.threadPool.executor("snapshot").execute(ActionRunnable.wrap(this.val$listener, l -> this.val$blobStoreRepository.cleanup(repositoryStateId, TransportCleanupRepositoryAction.this.snapshotsService.minCompatibleVersion(newState.nodes().getMinNodeVersion(), this.val$repositoryData, null), TransportCleanupRepositoryAction.this.remoteStoreLockManagerFactory, TransportCleanupRepositoryAction.this.remoteSegmentStoreDirectoryFactory, (ActionListener<RepositoryCleanupResult>)ActionListener.wrap(result -> this.after(null, (RepositoryCleanupResult)result), e -> this.after((Exception)e, null)))));
                }

                private void after(final @Nullable Exception failure, final @Nullable RepositoryCleanupResult result) {
                    if (failure == null) {
                        logger.debug("Finished repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
                    } else {
                        logger.debug(() -> new ParameterizedMessage("Failed to finish repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId), (Throwable)failure);
                    }
                    assert (failure != null || result != null);
                    if (!this.startedCleanup) {
                        logger.debug("No cleanup task to remove from cluster state because we failed to start one", (Throwable)failure);
                        this.val$listener.onFailure(failure);
                        return;
                    }
                    TransportCleanupRepositoryAction.this.clusterService.submitStateUpdateTask("remove repository cleanup task [" + repositoryName + "][" + repositoryStateId + "]", new ClusterStateUpdateTask(){

                        @Override
                        public ClusterState execute(ClusterState currentState) {
                            return TransportCleanupRepositoryAction.removeInProgressCleanup(currentState);
                        }

                        @Override
                        public void onFailure(String source, Exception e) {
                            if (failure != null) {
                                e.addSuppressed(failure);
                            }
                            logger.warn(() -> new ParameterizedMessage("[{}] failed to remove repository cleanup task", (Object)repositoryName), (Throwable)e);
                            val$listener.onFailure(e);
                        }

                        @Override
                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            if (failure == null) {
                                logger.info("Done with repository cleanup on [{}][{}] with result [{}]", (Object)repositoryName, (Object)repositoryStateId, (Object)result);
                                val$listener.onResponse((Object)result);
                            } else {
                                logger.warn(() -> new ParameterizedMessage("Failed to run repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId), (Throwable)failure);
                                val$listener.onFailure(failure);
                            }
                        }
                    });
                }
            });
        }, arg_0 -> listener.onFailure(arg_0));
    }
}

