/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.NlsString;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.BinTimeSpanUtils;
import org.opensearch.sql.calcite.utils.binning.SpanParser;

public class TimeSpanHelper {
    public RexNode createTimeSpanExpression(String spanStr, RexNode fieldExpr, RexNode alignTimeValue, CalcitePlanContext context) {
        if (alignTimeValue != null && this.shouldApplyAligntime(spanStr)) {
            return this.createAlignedTimeSpan(spanStr, fieldExpr, alignTimeValue, context);
        }
        return this.createStandardTimeSpan(spanStr, fieldExpr, context);
    }

    private boolean shouldApplyAligntime(String spanStr) {
        if (spanStr == null) {
            return false;
        }
        String timeUnit = SpanParser.extractTimeUnit(spanStr = spanStr.replace("'", "").replace("\"", "").trim().toLowerCase());
        if (timeUnit == null) {
            return true;
        }
        String normalizedUnit = this.normalizeTimeUnit(timeUnit);
        return !normalizedUnit.equals("d") && !normalizedUnit.equals("M");
    }

    private RexNode createAlignedTimeSpan(String spanStr, RexNode fieldExpr, RexNode alignTimeValue, CalcitePlanContext context) {
        String normalizedUnit;
        int intervalValue;
        if (!(alignTimeValue instanceof RexLiteral)) {
            return this.createStandardTimeSpan(spanStr, fieldExpr, context);
        }
        Comparable value = ((RexLiteral)alignTimeValue).getValue();
        String aligntimeStr = this.extractAlignTimeString(value);
        if (aligntimeStr == null) {
            return this.createStandardTimeSpan(spanStr, fieldExpr, context);
        }
        String timeUnit = SpanParser.extractTimeUnit(spanStr = spanStr.replace("'", "").replace("\"", "").trim());
        if (timeUnit != null) {
            String valueStr = spanStr.substring(0, spanStr.length() - timeUnit.length());
            intervalValue = Integer.parseInt(valueStr);
            normalizedUnit = this.normalizeTimeUnit(timeUnit);
        } else {
            intervalValue = Integer.parseInt(spanStr);
            normalizedUnit = "h";
        }
        String modifier = this.extractModifier(aligntimeStr);
        return BinTimeSpanUtils.createBinTimeSpanExpressionWithTimeModifier(fieldExpr, intervalValue, normalizedUnit, modifier, context);
    }

    private RexNode createStandardTimeSpan(String spanStr, RexNode fieldExpr, CalcitePlanContext context) {
        String timeUnit = SpanParser.extractTimeUnit(spanStr = spanStr.replace("'", "").replace("\"", "").trim());
        if (timeUnit != null) {
            String valueStr = spanStr.substring(0, spanStr.length() - timeUnit.length());
            int value = Integer.parseInt(valueStr);
            String normalizedUnit = this.normalizeTimeUnit(timeUnit);
            return BinTimeSpanUtils.createBinTimeSpanExpression(fieldExpr, value, normalizedUnit, 0L, context);
        }
        int value = Integer.parseInt(spanStr);
        return BinTimeSpanUtils.createBinTimeSpanExpression(fieldExpr, value, "h", 0L, context);
    }

    private String extractAlignTimeString(Object value) {
        if (value instanceof NlsString) {
            return ((NlsString)value).getValue();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private String extractModifier(String aligntimeStr) {
        if ((aligntimeStr = aligntimeStr.replace("\"", "").replace("'", "").trim()).startsWith("ALIGNTIME_EPOCH:")) {
            return aligntimeStr.substring("ALIGNTIME_EPOCH:".length());
        }
        if (aligntimeStr.startsWith("ALIGNTIME_TIME_MODIFIER:")) {
            return aligntimeStr.substring("ALIGNTIME_TIME_MODIFIER:".length());
        }
        if (aligntimeStr.startsWith("@d")) {
            return aligntimeStr;
        }
        if (aligntimeStr.matches("\\d+")) {
            return aligntimeStr;
        }
        return null;
    }

    private String normalizeTimeUnit(String unit) {
        switch (unit.toLowerCase()) {
            case "s": 
            case "sec": 
            case "secs": 
            case "second": 
            case "seconds": {
                return "s";
            }
            case "m": 
            case "min": 
            case "mins": 
            case "minute": 
            case "minutes": {
                return "m";
            }
            case "h": 
            case "hr": 
            case "hrs": 
            case "hour": 
            case "hours": {
                return "h";
            }
            case "d": 
            case "day": 
            case "days": {
                return "d";
            }
            case "mon": 
            case "month": 
            case "months": {
                return "months";
            }
            case "us": {
                return "us";
            }
            case "ms": {
                return "ms";
            }
            case "cs": {
                return "cs";
            }
            case "ds": {
                return "ds";
            }
        }
        return unit;
    }
}

