/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.transport.ResultResponse;

public class ForecastResultResponse
extends ResultResponse<ForecastResult> {
    public static final String DATA_QUALITY_JSON_KEY = "dataQuality";
    public static final String ERROR_JSON_KEY = "error";
    public static final String FEATURES_JSON_KEY = "features";
    public static final String FEATURE_VALUE_JSON_KEY = "value";
    public static final String RCF_TOTAL_UPDATES_JSON_KEY = "rcfTotalUpdates";
    public static final String FORECASTER_INTERVAL_IN_MINUTES_JSON_KEY = "forecasterIntervalInMinutes";
    public static final String FORECAST_VALUES_JSON_KEY = "forecastValues";
    public static final String FORECAST_UPPERS_JSON_KEY = "forecastUppers";
    public static final String FORECAST_LOWERS_JSON_KEY = "forecastLowers";
    private Double dataQuality;
    private float[] forecastsValues;
    private float[] forecastsUppers;
    private float[] forecastsLowers;

    public ForecastResultResponse(List<FeatureData> features, String error, Long rcfTotalUpdates, Long forecasterIntervalInMinutes, Boolean isHCForecaster, String taskId) {
        this(Double.NaN, features, error, rcfTotalUpdates, forecasterIntervalInMinutes, isHCForecaster, null, null, null, taskId);
    }

    public ForecastResultResponse(Double confidence, List<FeatureData> features, String error, Long rcfTotalUpdates, Long forecasterIntervalInMinutes, Boolean isHCForecaster, float[] forecastsValues, float[] forecastsUppers, float[] forecastsLowers, String taskId) {
        super(features, error, rcfTotalUpdates, forecasterIntervalInMinutes, isHCForecaster, taskId);
        this.dataQuality = confidence;
        this.forecastsValues = forecastsValues;
        this.forecastsUppers = forecastsUppers;
        this.forecastsLowers = forecastsLowers;
        this.taskId = taskId;
    }

    public ForecastResultResponse(StreamInput in) throws IOException {
        super(in);
        this.dataQuality = in.readDouble();
        int size = in.readVInt();
        this.features = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.features.add(new FeatureData(in));
        }
        this.error = in.readOptionalString();
        this.rcfTotalUpdates = in.readOptionalLong();
        this.configIntervalInMinutes = in.readOptionalLong();
        this.isHC = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.forecastsValues = in.readFloatArray();
            this.forecastsUppers = in.readFloatArray();
            this.forecastsLowers = in.readFloatArray();
        } else {
            this.forecastsValues = null;
            this.forecastsUppers = null;
            this.forecastsLowers = null;
        }
        this.taskId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.dataQuality.doubleValue());
        out.writeVInt(this.features.size());
        for (FeatureData feature : this.features) {
            feature.writeTo(out);
        }
        out.writeOptionalString(this.error);
        out.writeOptionalLong(this.rcfTotalUpdates);
        out.writeOptionalLong(this.configIntervalInMinutes);
        out.writeOptionalBoolean(this.isHC);
        if (this.forecastsValues != null) {
            if (this.forecastsUppers == null || this.forecastsLowers == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "null value: forecastsUppers: %s, forecastsLowers: %s", this.forecastsUppers, this.forecastsLowers));
            }
            out.writeBoolean(true);
            out.writeFloatArray(this.forecastsValues);
            out.writeFloatArray(this.forecastsUppers);
            out.writeFloatArray(this.forecastsLowers);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.taskId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.dataQuality != null && !this.dataQuality.equals(Double.NaN)) {
            builder.field(DATA_QUALITY_JSON_KEY, this.dataQuality);
        }
        if (this.error != null) {
            builder.field(ERROR_JSON_KEY, this.error);
        }
        if (this.features != null && this.features.size() > 0) {
            builder.startArray(FEATURES_JSON_KEY);
            for (FeatureData feature : this.features) {
                feature.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.rcfTotalUpdates != null) {
            builder.field(RCF_TOTAL_UPDATES_JSON_KEY, this.rcfTotalUpdates);
        }
        if (this.forecastsValues != null) {
            builder.field(FORECAST_VALUES_JSON_KEY, (Object)this.forecastsValues);
        }
        if (this.forecastsUppers != null) {
            builder.field(FORECAST_UPPERS_JSON_KEY, (Object)this.forecastsUppers);
        }
        if (this.forecastsLowers != null) {
            builder.field(FORECAST_LOWERS_JSON_KEY, (Object)this.forecastsLowers);
        }
        if (this.taskId != null) {
            builder.field("task_id", this.taskId);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public List<ForecastResult> toIndexableResults(Config config, Instant dataStartInstant, Instant dataEndInstant, Instant executionStartInstant, Instant executionEndInstant, Integer schemaVersion, User user, String error) {
        long forecasterIntervalMilli = Duration.between(dataStartInstant, dataEndInstant).toMillis();
        return ForecastResult.fromRawRCFCasterResult(config.getId(), forecasterIntervalMilli, this.dataQuality, this.features, dataStartInstant, dataEndInstant, executionStartInstant, executionEndInstant, error, Optional.empty(), user, schemaVersion, null, this.forecastsValues, this.forecastsUppers, this.forecastsLowers, this.taskId);
    }

    @Override
    public boolean shouldSave() {
        return super.shouldSave() || this.forecastsValues != null && this.forecastsValues.length > 0;
    }
}

