/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.util.Map;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.remote.metadata.client.WriteDataObjectRequest;

public class PutDataObjectRequest
extends WriteDataObjectRequest<PutDataObjectRequest> {
    private final boolean overwriteIfExists;
    private final ToXContentObject dataObject;

    public PutDataObjectRequest(String index, String id, String tenantId, Long ifSeqNo, Long ifPrimaryTerm, WriteRequest.RefreshPolicy refreshPolicy, TimeValue timeout, boolean overwriteIfExists, ToXContentObject dataObject, String cmkRoleArn, String assumeRoleArn) {
        super(index, id, tenantId, ifSeqNo, ifPrimaryTerm, refreshPolicy, timeout, !overwriteIfExists, cmkRoleArn, assumeRoleArn);
        this.overwriteIfExists = overwriteIfExists;
        this.dataObject = dataObject;
    }

    public boolean overwriteIfExists() {
        return this.overwriteIfExists;
    }

    public ToXContentObject dataObject() {
        return this.dataObject;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WriteDataObjectRequest.Builder<Builder> {
        private boolean overwriteIfExists = true;
        private ToXContentObject dataObject = null;

        public Builder overwriteIfExists(boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        public Builder dataObject(ToXContentObject dataObject) {
            this.dataObject = dataObject;
            return this;
        }

        public Builder dataObject(Map<String, Object> dataObjectMap) {
            this.dataObject = (builder, params) -> builder.map(dataObjectMap);
            return this;
        }

        public PutDataObjectRequest build() {
            WriteDataObjectRequest.validateSeqNoAndPrimaryTerm(this.ifSeqNo, this.ifPrimaryTerm, !this.overwriteIfExists);
            return new PutDataObjectRequest(this.index, this.id, this.tenantId, this.ifSeqNo, this.ifPrimaryTerm, this.refreshPolicy, this.timeout, this.overwriteIfExists, this.dataObject, this.cmkRoleArn, this.assumeRoleArn);
        }
    }
}

