/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.DnsResolver;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.HttpRoute;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.config.Configurable;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.config.ConnectionConfig;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.config.RequestConfig;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.ExecSupport;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.async.AbstractMinimalHttpAsyncClientBase;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.async.LoggingExceptionCallback;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.async.LoggingIOSessionDecorator;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.impl.nio.MultihomeConnectionInitiator;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.protocol.HttpClientContext;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.Contract;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.concurrent.Cancellable;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.concurrent.ComplexCancellable;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.concurrent.FutureCallback;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.function.Resolver;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.EntityDetails;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.Header;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpException;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpHost;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpResponse;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.CapacityChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.DataStreamChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.HandlerFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.RequestChannel;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.HttpContext;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.io.CloseMode;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.Command;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.ConnectionInitiator;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOReactorConfig;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.reactor.IOSession;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Args;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public final class MinimalH2AsyncClient
extends AbstractMinimalHttpAsyncClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(MinimalH2AsyncClient.class);
    private final InternalH2ConnPool connPool;
    private final ConnectionInitiator connectionInitiator;

    MinimalH2AsyncClient(IOEventHandlerFactory eventHandlerFactory, AsyncPushConsumerRegistry pushConsumerRegistry, IOReactorConfig reactorConfig, ThreadFactory threadFactory, ThreadFactory workerThreadFactory, DnsResolver dnsResolver, TlsStrategy tlsStrategy) {
        super(new DefaultConnectingIOReactor(eventHandlerFactory, reactorConfig, workerThreadFactory, LoggingIOSessionDecorator.INSTANCE, LoggingExceptionCallback.INSTANCE, null, ioSession -> ioSession.enqueue(new ShutdownCommand(CloseMode.GRACEFUL), Command.Priority.IMMEDIATE)), pushConsumerRegistry, threadFactory);
        this.connectionInitiator = new MultihomeConnectionInitiator(this.getConnectionInitiator(), dnsResolver);
        this.connPool = new InternalH2ConnPool(this.connectionInitiator, object -> null, tlsStrategy);
    }

    @Override
    public Cancellable execute(final AsyncClientExchangeHandler exchangeHandler, final HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context) {
        Args.notNull(exchangeHandler, "Message exchange handler");
        final ComplexCancellable cancellable = new ComplexCancellable();
        try {
            if (!this.isRunning()) {
                throw new CancellationException("Request execution cancelled");
            }
            final HttpClientContext clientContext = HttpClientContext.castOrCreate(context);
            exchangeHandler.produceRequest((request, entityDetails, context1) -> {
                RequestConfig requestConfig = null;
                if (request instanceof Configurable) {
                    requestConfig = ((Configurable)((Object)request)).getConfig();
                }
                if (requestConfig != null) {
                    clientContext.setRequestConfig(requestConfig);
                } else {
                    requestConfig = clientContext.getRequestConfigOrDefault();
                }
                Timeout connectTimeout = requestConfig.getConnectTimeout();
                HttpHost target = new HttpHost(request.getScheme(), request.getAuthority());
                Future<IOSession> sessionFuture = this.connPool.getSession(new HttpRoute(target), connectTimeout, new FutureCallback<IOSession>(){

                    @Override
                    public void completed(IOSession session) {
                        AsyncClientExchangeHandler internalExchangeHandler = new AsyncClientExchangeHandler(){

                            @Override
                            public void releaseResources() {
                                exchangeHandler.releaseResources();
                            }

                            @Override
                            public void failed(Exception cause) {
                                exchangeHandler.failed(cause);
                            }

                            @Override
                            public void cancel() {
                                this.failed(new RequestFailedException("Request aborted"));
                            }

                            @Override
                            public void produceRequest(RequestChannel channel, HttpContext context1) throws HttpException, IOException {
                                channel.sendRequest(request, entityDetails, context1);
                            }

                            @Override
                            public int available() {
                                return exchangeHandler.available();
                            }

                            @Override
                            public void produce(DataStreamChannel channel) throws IOException {
                                exchangeHandler.produce(channel);
                            }

                            @Override
                            public void consumeInformation(HttpResponse response, HttpContext context1) throws HttpException, IOException {
                                exchangeHandler.consumeInformation(response, context1);
                            }

                            @Override
                            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context1) throws HttpException, IOException {
                                exchangeHandler.consumeResponse(response, entityDetails, context1);
                            }

                            @Override
                            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                                exchangeHandler.updateCapacity(capacityChannel);
                            }

                            @Override
                            public void consume(ByteBuffer src) throws IOException {
                                exchangeHandler.consume(src);
                            }

                            @Override
                            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                                exchangeHandler.streamEnd(trailers);
                            }
                        };
                        if (LOG.isDebugEnabled()) {
                            String exchangeId = ExecSupport.getNextExchangeId();
                            clientContext.setExchangeId(exchangeId);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{} executing message exchange {}", (Object)exchangeId, (Object)ConnPoolSupport.getId(session));
                            }
                            session.enqueue(new RequestExecutionCommand(new LoggingAsyncClientExchangeHandler(LOG, exchangeId, internalExchangeHandler), pushHandlerFactory, cancellable, clientContext), Command.Priority.NORMAL);
                        } else {
                            session.enqueue(new RequestExecutionCommand(internalExchangeHandler, pushHandlerFactory, cancellable, clientContext), Command.Priority.NORMAL);
                        }
                    }

                    @Override
                    public void failed(Exception ex) {
                        exchangeHandler.failed(ex);
                    }

                    @Override
                    public void cancelled() {
                        exchangeHandler.cancel();
                    }
                });
                cancellable.setDependency(() -> sessionFuture.cancel(true));
            }, context);
        }
        catch (IOException | IllegalStateException | HttpException ex) {
            exchangeHandler.failed(ex);
        }
        return cancellable;
    }

    public void setConnectionConfigResolver(Resolver<HttpHost, ConnectionConfig> connectionConfigResolver) {
        this.connPool.setConnectionConfigResolver(connectionConfigResolver);
    }
}

