/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AbortTransactionOptions;
import org.apache.kafka.clients.admin.AbortTransactionResult;
import org.apache.kafka.clients.admin.AbortTransactionSpec;
import org.apache.kafka.clients.admin.AddRaftVoterOptions;
import org.apache.kafka.clients.admin.AddRaftVoterResult;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterStreamsGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterStreamsGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteShareGroupsOptions;
import org.apache.kafka.clients.admin.DeleteShareGroupsResult;
import org.apache.kafka.clients.admin.DeleteStreamsGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteStreamsGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteStreamsGroupsOptions;
import org.apache.kafka.clients.admin.DeleteStreamsGroupsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClassicGroupsOptions;
import org.apache.kafka.clients.admin.DescribeClassicGroupsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeFeaturesResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumResult;
import org.apache.kafka.clients.admin.DescribeProducersOptions;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeShareGroupsOptions;
import org.apache.kafka.clients.admin.DescribeShareGroupsResult;
import org.apache.kafka.clients.admin.DescribeStreamsGroupsOptions;
import org.apache.kafka.clients.admin.DescribeStreamsGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeTransactionsOptions;
import org.apache.kafka.clients.admin.DescribeTransactionsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FenceProducersOptions;
import org.apache.kafka.clients.admin.FenceProducersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesOptions;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesResult;
import org.apache.kafka.clients.admin.ListConfigResourcesOptions;
import org.apache.kafka.clients.admin.ListConfigResourcesResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListShareGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.ListTransactionsOptions;
import org.apache.kafka.clients.admin.ListTransactionsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.RaftVoterEndpoint;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RemoveRaftVoterOptions;
import org.apache.kafka.clients.admin.RemoveRaftVoterResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.clients.admin.TerminateTransactionOptions;
import org.apache.kafka.clients.admin.TerminateTransactionResult;
import org.apache.kafka.clients.admin.UnregisterBrokerOptions;
import org.apache.kafka.clients.admin.UnregisterBrokerResult;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.clients.admin.UserScramCredentialAlteration;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaFilter;

public interface Admin
extends AutoCloseable {
    public static Admin create(Properties props) {
        return KafkaAdminClient.createInternal(new AdminClientConfig(props, true), null);
    }

    public static Admin create(Map<String, Object> conf) {
        return KafkaAdminClient.createInternal(new AdminClientConfig(conf, true), null, null);
    }

    @Override
    default public void close() {
        this.close(Duration.ofMillis(Long.MAX_VALUE));
    }

    public void close(Duration var1);

    default public CreateTopicsResult createTopics(Collection<NewTopic> newTopics) {
        return this.createTopics(newTopics, new CreateTopicsOptions());
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> var1, CreateTopicsOptions var2);

    default public DeleteTopicsResult deleteTopics(Collection<String> topics) {
        return this.deleteTopics(TopicCollection.ofTopicNames(topics), new DeleteTopicsOptions());
    }

    default public DeleteTopicsResult deleteTopics(Collection<String> topics, DeleteTopicsOptions options) {
        return this.deleteTopics(TopicCollection.ofTopicNames(topics), options);
    }

    default public DeleteTopicsResult deleteTopics(TopicCollection topics) {
        return this.deleteTopics(topics, new DeleteTopicsOptions());
    }

    public DeleteTopicsResult deleteTopics(TopicCollection var1, DeleteTopicsOptions var2);

    default public ListTopicsResult listTopics() {
        return this.listTopics(new ListTopicsOptions());
    }

    public ListTopicsResult listTopics(ListTopicsOptions var1);

    default public DescribeTopicsResult describeTopics(Collection<String> topicNames) {
        return this.describeTopics(topicNames, new DescribeTopicsOptions());
    }

    default public DescribeTopicsResult describeTopics(Collection<String> topicNames, DescribeTopicsOptions options) {
        return this.describeTopics(TopicCollection.ofTopicNames(topicNames), options);
    }

    default public DescribeTopicsResult describeTopics(TopicCollection topics) {
        return this.describeTopics(topics, new DescribeTopicsOptions());
    }

    public DescribeTopicsResult describeTopics(TopicCollection var1, DescribeTopicsOptions var2);

    default public DescribeClusterResult describeCluster() {
        return this.describeCluster(new DescribeClusterOptions());
    }

    public DescribeClusterResult describeCluster(DescribeClusterOptions var1);

    default public DescribeAclsResult describeAcls(AclBindingFilter filter) {
        return this.describeAcls(filter, new DescribeAclsOptions());
    }

    public DescribeAclsResult describeAcls(AclBindingFilter var1, DescribeAclsOptions var2);

    default public CreateAclsResult createAcls(Collection<AclBinding> acls) {
        return this.createAcls(acls, new CreateAclsOptions());
    }

    public CreateAclsResult createAcls(Collection<AclBinding> var1, CreateAclsOptions var2);

    default public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters) {
        return this.deleteAcls(filters, new DeleteAclsOptions());
    }

    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> var1, DeleteAclsOptions var2);

    default public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources) {
        return this.describeConfigs(resources, new DescribeConfigsOptions());
    }

    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> var1, DescribeConfigsOptions var2);

    default public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs) {
        return this.incrementalAlterConfigs(configs, new AlterConfigsOptions());
    }

    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> var1, AlterConfigsOptions var2);

    default public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment) {
        return this.alterReplicaLogDirs(replicaAssignment, new AlterReplicaLogDirsOptions());
    }

    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> var1, AlterReplicaLogDirsOptions var2);

    default public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers) {
        return this.describeLogDirs(brokers, new DescribeLogDirsOptions());
    }

    public DescribeLogDirsResult describeLogDirs(Collection<Integer> var1, DescribeLogDirsOptions var2);

    default public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas) {
        return this.describeReplicaLogDirs(replicas, new DescribeReplicaLogDirsOptions());
    }

    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> var1, DescribeReplicaLogDirsOptions var2);

    default public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions) {
        return this.createPartitions(newPartitions, new CreatePartitionsOptions());
    }

    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> var1, CreatePartitionsOptions var2);

    default public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete) {
        return this.deleteRecords(recordsToDelete, new DeleteRecordsOptions());
    }

    public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> var1, DeleteRecordsOptions var2);

    default public CreateDelegationTokenResult createDelegationToken() {
        return this.createDelegationToken(new CreateDelegationTokenOptions());
    }

    public CreateDelegationTokenResult createDelegationToken(CreateDelegationTokenOptions var1);

    default public RenewDelegationTokenResult renewDelegationToken(byte[] hmac) {
        return this.renewDelegationToken(hmac, new RenewDelegationTokenOptions());
    }

    public RenewDelegationTokenResult renewDelegationToken(byte[] var1, RenewDelegationTokenOptions var2);

    default public ExpireDelegationTokenResult expireDelegationToken(byte[] hmac) {
        return this.expireDelegationToken(hmac, new ExpireDelegationTokenOptions());
    }

    public ExpireDelegationTokenResult expireDelegationToken(byte[] var1, ExpireDelegationTokenOptions var2);

    default public DescribeDelegationTokenResult describeDelegationToken() {
        return this.describeDelegationToken(new DescribeDelegationTokenOptions());
    }

    public DescribeDelegationTokenResult describeDelegationToken(DescribeDelegationTokenOptions var1);

    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> var1, DescribeConsumerGroupsOptions var2);

    default public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds) {
        return this.describeConsumerGroups(groupIds, new DescribeConsumerGroupsOptions());
    }

    @Deprecated(since="4.1", forRemoval=true)
    public ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions var1);

    @Deprecated(since="4.1", forRemoval=true)
    default public ListConsumerGroupsResult listConsumerGroups() {
        return this.listConsumerGroups(new ListConsumerGroupsOptions());
    }

    default public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId, ListConsumerGroupOffsetsOptions options) {
        ListConsumerGroupOffsetsSpec groupSpec = new ListConsumerGroupOffsetsSpec();
        return this.listConsumerGroupOffsets(Collections.singletonMap(groupId, groupSpec), options);
    }

    default public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId) {
        return this.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions());
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(Map<String, ListConsumerGroupOffsetsSpec> var1, ListConsumerGroupOffsetsOptions var2);

    default public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(Map<String, ListConsumerGroupOffsetsSpec> groupSpecs) {
        return this.listConsumerGroupOffsets(groupSpecs, new ListConsumerGroupOffsetsOptions());
    }

    public ListStreamsGroupOffsetsResult listStreamsGroupOffsets(Map<String, ListStreamsGroupOffsetsSpec> var1, ListStreamsGroupOffsetsOptions var2);

    default public ListStreamsGroupOffsetsResult listStreamsGroupOffsets(Map<String, ListStreamsGroupOffsetsSpec> groupSpecs) {
        return this.listStreamsGroupOffsets(groupSpecs, new ListStreamsGroupOffsetsOptions());
    }

    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> var1, DeleteConsumerGroupsOptions var2);

    default public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds) {
        return this.deleteConsumerGroups(groupIds, new DeleteConsumerGroupsOptions());
    }

    public DeleteStreamsGroupsResult deleteStreamsGroups(Collection<String> var1, DeleteStreamsGroupsOptions var2);

    default public DeleteStreamsGroupsResult deleteStreamsGroups(Collection<String> groupIds) {
        return this.deleteStreamsGroups(groupIds, new DeleteStreamsGroupsOptions());
    }

    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String var1, Set<TopicPartition> var2, DeleteConsumerGroupOffsetsOptions var3);

    default public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        return this.deleteConsumerGroupOffsets(groupId, partitions, new DeleteConsumerGroupOffsetsOptions());
    }

    public DeleteStreamsGroupOffsetsResult deleteStreamsGroupOffsets(String var1, Set<TopicPartition> var2, DeleteStreamsGroupOffsetsOptions var3);

    default public DeleteStreamsGroupOffsetsResult deleteStreamsGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        return this.deleteStreamsGroupOffsets(groupId, partitions, new DeleteStreamsGroupOffsetsOptions());
    }

    default public ListGroupsResult listGroups() {
        return this.listGroups(new ListGroupsOptions());
    }

    public ListGroupsResult listGroups(ListGroupsOptions var1);

    default public ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> partitions) {
        return this.electLeaders(electionType, partitions, new ElectLeadersOptions());
    }

    public ElectLeadersResult electLeaders(ElectionType var1, Set<TopicPartition> var2, ElectLeadersOptions var3);

    default public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> reassignments) {
        return this.alterPartitionReassignments(reassignments, new AlterPartitionReassignmentsOptions());
    }

    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> var1, AlterPartitionReassignmentsOptions var2);

    default public ListPartitionReassignmentsResult listPartitionReassignments() {
        return this.listPartitionReassignments(new ListPartitionReassignmentsOptions());
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(Set<TopicPartition> partitions) {
        return this.listPartitionReassignments(partitions, new ListPartitionReassignmentsOptions());
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(Set<TopicPartition> partitions, ListPartitionReassignmentsOptions options) {
        return this.listPartitionReassignments(Optional.of(partitions), options);
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(ListPartitionReassignmentsOptions options) {
        return this.listPartitionReassignments(Optional.empty(), options);
    }

    public ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> var1, ListPartitionReassignmentsOptions var2);

    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String var1, RemoveMembersFromConsumerGroupOptions var2);

    default public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets) {
        return this.alterConsumerGroupOffsets(groupId, offsets, new AlterConsumerGroupOffsetsOptions());
    }

    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String var1, Map<TopicPartition, OffsetAndMetadata> var2, AlterConsumerGroupOffsetsOptions var3);

    default public AlterStreamsGroupOffsetsResult alterStreamsGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets) {
        return this.alterStreamsGroupOffsets(groupId, offsets, new AlterStreamsGroupOffsetsOptions());
    }

    public AlterStreamsGroupOffsetsResult alterStreamsGroupOffsets(String var1, Map<TopicPartition, OffsetAndMetadata> var2, AlterStreamsGroupOffsetsOptions var3);

    default public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets) {
        return this.listOffsets(topicPartitionOffsets, new ListOffsetsOptions());
    }

    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> var1, ListOffsetsOptions var2);

    default public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter) {
        return this.describeClientQuotas(filter, new DescribeClientQuotasOptions());
    }

    public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter var1, DescribeClientQuotasOptions var2);

    default public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries) {
        return this.alterClientQuotas(entries, new AlterClientQuotasOptions());
    }

    public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> var1, AlterClientQuotasOptions var2);

    default public DescribeUserScramCredentialsResult describeUserScramCredentials() {
        return this.describeUserScramCredentials(null, new DescribeUserScramCredentialsOptions());
    }

    default public DescribeUserScramCredentialsResult describeUserScramCredentials(List<String> users) {
        return this.describeUserScramCredentials(users, new DescribeUserScramCredentialsOptions());
    }

    public DescribeUserScramCredentialsResult describeUserScramCredentials(List<String> var1, DescribeUserScramCredentialsOptions var2);

    default public AlterUserScramCredentialsResult alterUserScramCredentials(List<UserScramCredentialAlteration> alterations) {
        return this.alterUserScramCredentials(alterations, new AlterUserScramCredentialsOptions());
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(List<UserScramCredentialAlteration> var1, AlterUserScramCredentialsOptions var2);

    default public DescribeFeaturesResult describeFeatures() {
        return this.describeFeatures(new DescribeFeaturesOptions());
    }

    public DescribeFeaturesResult describeFeatures(DescribeFeaturesOptions var1);

    public UpdateFeaturesResult updateFeatures(Map<String, FeatureUpdate> var1, UpdateFeaturesOptions var2);

    default public DescribeMetadataQuorumResult describeMetadataQuorum() {
        return this.describeMetadataQuorum(new DescribeMetadataQuorumOptions());
    }

    public DescribeMetadataQuorumResult describeMetadataQuorum(DescribeMetadataQuorumOptions var1);

    @InterfaceStability.Unstable
    default public UnregisterBrokerResult unregisterBroker(int brokerId) {
        return this.unregisterBroker(brokerId, new UnregisterBrokerOptions());
    }

    @InterfaceStability.Unstable
    public UnregisterBrokerResult unregisterBroker(int var1, UnregisterBrokerOptions var2);

    default public DescribeProducersResult describeProducers(Collection<TopicPartition> partitions) {
        return this.describeProducers(partitions, new DescribeProducersOptions());
    }

    public DescribeProducersResult describeProducers(Collection<TopicPartition> var1, DescribeProducersOptions var2);

    default public DescribeTransactionsResult describeTransactions(Collection<String> transactionalIds) {
        return this.describeTransactions(transactionalIds, new DescribeTransactionsOptions());
    }

    public DescribeTransactionsResult describeTransactions(Collection<String> var1, DescribeTransactionsOptions var2);

    default public AbortTransactionResult abortTransaction(AbortTransactionSpec spec) {
        return this.abortTransaction(spec, new AbortTransactionOptions());
    }

    public AbortTransactionResult abortTransaction(AbortTransactionSpec var1, AbortTransactionOptions var2);

    default public ListTransactionsResult listTransactions() {
        return this.listTransactions(new ListTransactionsOptions());
    }

    public ListTransactionsResult listTransactions(ListTransactionsOptions var1);

    default public FenceProducersResult fenceProducers(Collection<String> transactionalIds) {
        return this.fenceProducers(transactionalIds, new FenceProducersOptions());
    }

    public FenceProducersResult fenceProducers(Collection<String> var1, FenceProducersOptions var2);

    public ListConfigResourcesResult listConfigResources(Set<ConfigResource.Type> var1, ListConfigResourcesOptions var2);

    default public ListConfigResourcesResult listConfigResources() {
        return this.listConfigResources(Set.of(), new ListConfigResourcesOptions());
    }

    @Deprecated(since="4.1", forRemoval=true)
    public ListClientMetricsResourcesResult listClientMetricsResources(ListClientMetricsResourcesOptions var1);

    @Deprecated(since="4.1", forRemoval=true)
    default public ListClientMetricsResourcesResult listClientMetricsResources() {
        return this.listClientMetricsResources(new ListClientMetricsResourcesOptions());
    }

    public Uuid clientInstanceId(Duration var1);

    default public AddRaftVoterResult addRaftVoter(int voterId, Uuid voterDirectoryId, Set<RaftVoterEndpoint> endpoints) {
        return this.addRaftVoter(voterId, voterDirectoryId, endpoints, new AddRaftVoterOptions());
    }

    public AddRaftVoterResult addRaftVoter(int var1, Uuid var2, Set<RaftVoterEndpoint> var3, AddRaftVoterOptions var4);

    default public RemoveRaftVoterResult removeRaftVoter(int voterId, Uuid voterDirectoryId) {
        return this.removeRaftVoter(voterId, voterDirectoryId, new RemoveRaftVoterOptions());
    }

    public RemoveRaftVoterResult removeRaftVoter(int var1, Uuid var2, RemoveRaftVoterOptions var3);

    public DescribeShareGroupsResult describeShareGroups(Collection<String> var1, DescribeShareGroupsOptions var2);

    default public DescribeShareGroupsResult describeShareGroups(Collection<String> groupIds) {
        return this.describeShareGroups(groupIds, new DescribeShareGroupsOptions());
    }

    public AlterShareGroupOffsetsResult alterShareGroupOffsets(String var1, Map<TopicPartition, Long> var2, AlterShareGroupOffsetsOptions var3);

    default public AlterShareGroupOffsetsResult alterShareGroupOffsets(String groupId, Map<TopicPartition, Long> offsets) {
        return this.alterShareGroupOffsets(groupId, offsets, new AlterShareGroupOffsetsOptions());
    }

    public ListShareGroupOffsetsResult listShareGroupOffsets(Map<String, ListShareGroupOffsetsSpec> var1, ListShareGroupOffsetsOptions var2);

    default public ListShareGroupOffsetsResult listShareGroupOffsets(Map<String, ListShareGroupOffsetsSpec> groupSpecs) {
        return this.listShareGroupOffsets(groupSpecs, new ListShareGroupOffsetsOptions());
    }

    public DeleteShareGroupOffsetsResult deleteShareGroupOffsets(String var1, Set<String> var2, DeleteShareGroupOffsetsOptions var3);

    default public DeleteShareGroupOffsetsResult deleteShareGroupOffsets(String groupId, Set<String> topics) {
        return this.deleteShareGroupOffsets(groupId, topics, new DeleteShareGroupOffsetsOptions());
    }

    public DeleteShareGroupsResult deleteShareGroups(Collection<String> var1, DeleteShareGroupsOptions var2);

    default public DeleteShareGroupsResult deleteShareGroups(Collection<String> groupIds) {
        return this.deleteShareGroups(groupIds, new DeleteShareGroupsOptions());
    }

    public DescribeStreamsGroupsResult describeStreamsGroups(Collection<String> var1, DescribeStreamsGroupsOptions var2);

    default public DescribeStreamsGroupsResult describeStreamsGroups(Collection<String> groupIds) {
        return this.describeStreamsGroups(groupIds, new DescribeStreamsGroupsOptions());
    }

    public DescribeClassicGroupsResult describeClassicGroups(Collection<String> var1, DescribeClassicGroupsOptions var2);

    default public DescribeClassicGroupsResult describeClassicGroups(Collection<String> groupIds) {
        return this.describeClassicGroups(groupIds, new DescribeClassicGroupsOptions());
    }

    public void registerMetricForSubscription(KafkaMetric var1);

    public void unregisterMetricFromSubscription(KafkaMetric var1);

    public Map<MetricName, ? extends Metric> metrics();

    default public TerminateTransactionResult forceTerminateTransaction(String transactionalId) {
        return this.forceTerminateTransaction(transactionalId, new TerminateTransactionOptions());
    }

    public TerminateTransactionResult forceTerminateTransaction(String var1, TerminateTransactionOptions var2);
}

