/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input.execute.agent;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.input.execute.agent.AgentInput;
import org.opensearch.ml.common.input.execute.agent.ContentBlock;
import org.opensearch.ml.common.input.execute.agent.ContentType;
import org.opensearch.ml.common.input.execute.agent.InputType;
import org.opensearch.ml.common.input.execute.agent.Message;
import org.opensearch.ml.common.input.execute.agent.ToolCall;

public class AgentInputProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(AgentInputProcessor.class);

    private AgentInputProcessor() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void validateInput(AgentInput agentInput) {
        if (agentInput == null || agentInput.getInput() == null) {
            throw new IllegalArgumentException("AgentInput and its input field cannot be null");
        }
        InputType type = agentInput.getInputType();
        switch (type) {
            case TEXT: {
                AgentInputProcessor.validateTextInput((String)agentInput.getInput());
                break;
            }
            case CONTENT_BLOCKS: {
                List blocks = (List)agentInput.getInput();
                AgentInputProcessor.validateContentBlocks(blocks);
                break;
            }
            case MESSAGES: {
                List messages = (List)agentInput.getInput();
                AgentInputProcessor.validateMessages(messages);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported input type: " + String.valueOf((Object)type));
            }
        }
    }

    private static void validateTextInput(String text) {
        if (text == null || text.trim().isEmpty()) {
            throw new IllegalArgumentException("Text input cannot be null or empty");
        }
    }

    private static void validateContentBlocks(List<ContentBlock> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            throw new IllegalArgumentException("Content blocks cannot be null or empty");
        }
        block6: for (ContentBlock block : blocks) {
            if (block.getType() == null) {
                throw new IllegalArgumentException("Content block type cannot be null");
            }
            switch (block.getType()) {
                case TEXT: {
                    if (block.getText() != null && !block.getText().trim().isEmpty()) continue block6;
                    throw new IllegalArgumentException("Text content block cannot have null or empty text");
                }
                case IMAGE: {
                    if (block.getImage() != null) continue block6;
                    throw new IllegalArgumentException("Image content block must have image data");
                }
                case DOCUMENT: {
                    if (block.getDocument() != null) continue block6;
                    throw new IllegalArgumentException("Document content block must have document data");
                }
                case VIDEO: {
                    if (block.getVideo() != null) continue block6;
                    throw new IllegalArgumentException("Video content block must have video data");
                }
            }
            throw new IllegalArgumentException("Unsupported content block type: " + String.valueOf((Object)block.getType()));
        }
    }

    private static void validateMessages(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            throw new IllegalArgumentException("Messages cannot be null or empty");
        }
        block11: for (Message message : messages) {
            String role;
            if (message.getRole() == null || message.getRole().trim().isEmpty()) {
                throw new IllegalArgumentException("Message role cannot be null or empty");
            }
            switch (role = message.getRole().toLowerCase()) {
                case "user": 
                case "system": {
                    if (message.getContent() == null || message.getContent().isEmpty()) {
                        throw new IllegalArgumentException(role + " message must have content");
                    }
                    AgentInputProcessor.validateContentBlocks(message.getContent());
                    continue block11;
                }
                case "assistant": {
                    AgentInputProcessor.validateAssistantMessage(message);
                    continue block11;
                }
                case "tool": {
                    AgentInputProcessor.validateToolMessage(message);
                    continue block11;
                }
            }
            if (message.getContent() == null || message.getContent().isEmpty()) {
                throw new IllegalArgumentException("Message with role '" + role + "' must have content");
            }
            AgentInputProcessor.validateContentBlocks(message.getContent());
        }
        Message lastMessage = messages.getLast();
        if (!"user".equalsIgnoreCase(lastMessage.getRole()) && !"tool".equalsIgnoreCase(lastMessage.getRole())) {
            throw new IllegalArgumentException("Last message must be from role 'user' or 'tool'");
        }
    }

    private static void validateAssistantMessage(Message message) {
        boolean hasToolCalls;
        boolean hasContent = message.getContent() != null && !message.getContent().isEmpty();
        boolean bl = hasToolCalls = message.getToolCalls() != null && !message.getToolCalls().isEmpty();
        if (!hasContent && !hasToolCalls) {
            throw new IllegalArgumentException("Assistant message must have either content or tool calls");
        }
        if (hasContent) {
            AgentInputProcessor.validateContentBlocks(message.getContent());
        }
        if (hasToolCalls) {
            AgentInputProcessor.validateToolCalls(message.getToolCalls());
        }
    }

    private static void validateToolMessage(Message message) {
        if (message.getToolCallId() == null || message.getToolCallId().trim().isEmpty()) {
            throw new IllegalArgumentException("Tool message must have toolCallId");
        }
        if (message.getContent() == null || message.getContent().isEmpty()) {
            throw new IllegalArgumentException("Tool message must have content");
        }
        AgentInputProcessor.validateContentBlocks(message.getContent());
    }

    private static void validateToolCalls(List<ToolCall> toolCalls) {
        if (toolCalls == null || toolCalls.isEmpty()) {
            return;
        }
        for (ToolCall toolCall : toolCalls) {
            if (toolCall.getId() == null || toolCall.getId().trim().isEmpty()) {
                throw new IllegalArgumentException("Tool call must have an id");
            }
            if (toolCall.getType() == null || toolCall.getType().trim().isEmpty()) {
                throw new IllegalArgumentException("Tool call must have a type");
            }
            if (toolCall.getFunction() == null) {
                throw new IllegalArgumentException("Tool call must have a function");
            }
            ToolCall.ToolFunction function = toolCall.getFunction();
            if (function.getName() == null || function.getName().trim().isEmpty()) {
                throw new IllegalArgumentException("Tool call function must have a name");
            }
            if (function.getArguments() != null) continue;
            throw new IllegalArgumentException("Tool call function must have arguments");
        }
    }

    public static String extractQuestionText(AgentInput agentInput) {
        AgentInputProcessor.validateInput(agentInput);
        return switch (agentInput.getInputType()) {
            case InputType.TEXT -> (String)agentInput.getInput();
            case InputType.CONTENT_BLOCKS -> {
                List blocks = (List)agentInput.getInput();
                yield AgentInputProcessor.extractTextFromContentBlocks(blocks);
            }
            case InputType.MESSAGES -> {
                List messages = (List)agentInput.getInput();
                yield AgentInputProcessor.extractTextFromMessages(messages);
            }
            default -> throw new IllegalArgumentException("Unsupported input type: " + String.valueOf((Object)agentInput.getInputType()));
        };
    }

    private static String extractTextFromContentBlocks(List<ContentBlock> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            throw new IllegalArgumentException("Content blocks cannot be null or empty");
        }
        StringBuilder textBuilder = new StringBuilder();
        for (ContentBlock block : blocks) {
            String text;
            if (block.getType() != ContentType.TEXT || (text = block.getText()) == null || text.trim().isEmpty()) continue;
            textBuilder.append(text.trim());
            textBuilder.append("\n");
        }
        return textBuilder.toString();
    }

    private static String extractTextFromMessages(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            throw new IllegalArgumentException("Messages cannot be null or empty");
        }
        List<Message> trailingUserMessages = AgentInputProcessor.filterTrailingUserMessages(messages);
        StringBuilder combinedText = new StringBuilder();
        for (Message message : trailingUserMessages) {
            String text = AgentInputProcessor.extractTextFromContentBlocks(message.getContent());
            if (text.isEmpty()) continue;
            if (combinedText.length() > 0) {
                combinedText.append("\n");
            }
            combinedText.append(text);
        }
        return combinedText.toString();
    }

    public static List<Message> filterTrailingUserMessages(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return new ArrayList<Message>();
        }
        int startIndex = 0;
        for (int i = messages.size() - 1; i >= 0; --i) {
            String role;
            Message message = messages.get(i);
            if (message == null || message.getRole() == null || !(role = message.getRole().toLowerCase()).equals("assistant")) continue;
            startIndex = i + 1;
            break;
        }
        return new ArrayList<Message>(messages.subList(startIndex, messages.size()));
    }
}

