-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

local utils = require 'utils'

-- The words are taken from
-- https://github.com/thomasleveil/name-generator
-- and modified a bit
local fr = {
	left = {
		"Achille",
		"Aiolia",
		"Akela",
		"Akhenaton",
		"Albator",
		"Aldebaran",
		"Aldo",
		"Alexandre",
		"Alfred",
		"Ali",
		"Allen",
		"Amonbofis",
		"Angelina",
		"Angelot",
		"Angharad",
		"Antoine",
		"Antoinette",
		"Aphodite",
		"Apu",
		"Arabelle",
		"Archimede",
		"Ariel",
		"Aristote",
		"Armstrong",
		"Arthur",
		"Arwen",
		"Arya",
		"Astro",
		"Astrobald",
		"Attila",
		"Auguste",
		"Aélis",
		"Babar",
		"Babur",
		"Bach",
		"Baelish",
		"Bagheera",
		"Baloo",
		"Ban",
		"Barney",
		"Bart",
		"Basil",
		"Bayard",
		"Beavis",
		"Becassine",
		"Beethoven",
		"Bell",
		"Bellatrix",
		"Berlewen",
		"Berlingot",
		"Bernadette",
		"Besson",
		"Betameche",
		"Betty",
		"Bibofoc",
		"Bidochon",
		"Bilbon",
		"Bill",
		"Bip",
		"Bismarck",
		"Blacksad",
		"Blair",
		"Blake",
		"Blueberry",
		"Blum",
		"Bob",
		"Bohort",
		"Bonaparte",
		"Bonemine",
		"Boo",
		"Boon",
		"Boris",
		"Boulier",
		"Bourriquet",
		"Brad",
		"Brienne",
		"Brisefer",
		"Broflovski",
		"Broly",
		"Bronn",
		"Bruce",
		"Budd",
		"Burns",
		"Butch",
		"Caesar",
		"Cage",
		"Caius",
		"Calimero",
		"Calogrenant",
		"Calvin",
		"Cameron",
		"Canardo",
		"Candy",
		"Capitaine",
		"Capone",
		"Carrey",
		"Cartier",
		"Cartman",
		"Castafiore",
		"Castro",
		"Cell",
		"Cendrillon",
		"Cersei",
		"Champignac",
		"Champollion",
		"Chan",
		"Chanel",
		"Chaozu",
		"Chaplin",
		"Charlemagne",
		"Charlie",
		"Chichi",
		"Chihiro",
		"Chinaman",
		"Chris",
		"Churchill",
		"Claude",
		"Claudia",
		"Clemenceau",
		"Clint",
		"Clinton",
		"Clochette",
		"Clooney",
		"Clovis",
		"Cléopatre",
		"Cobra",
		"Coco",
		"Colomb",
		"Colonel",
		"Conan",
		"Confucius",
		"Connery",
		"Constantin",
		"Cook",
		"Cortex",
		"Corto",
		"Cousin",
		"Cromwell",
		"Cruise",
		"Cubitus",
		"Curella",
		"Curie",
		"Cutler",
		"Cuvillier",
		"Cylia",
		"Daario",
		"Daffy",
		"Dagonet",
		"Daisy",
		"Dali",
		"Dalton",
		"Damon",
		"Daniel",
		"Darkos",
		"Darwin",
		"David",
		"Davos",
		"Davy",
		"Dean",
		"DeGroot",
		"Deiter",
		"Delon",
		"DeMesmaeker",
		"Demetra",
		"Dendé",
		"Denis",
		"Denver",
		"Depardieu",
		"Depereinconu",
		"Depp",
		"Descartes",
		"Diana",
		"Diaz",
		"Dickens",
		"Diderot",
		"Diego",
		"Diesel",
		"Dinesh",
		"Dingo",
		"Django",
		"Docteur",
		"Dohko",
		"Doisneau",
		"Donatello",
		"Donnie",
		"Doug",
		"Downey",
		"Drago",
		"Dugenou",
		"Duke",
		"Duplumier",
		"Eastwood",
		"Eddard",
		"Eddie",
		"EdFenech",
		"Edison",
		"Einstein",
		"Elias",
		"Elizabeth",
		"Elle",
		"Ellington",
		"Elsa",
		"Elvis",
		"Entrechats",
		"Epoxy",
		"Erlich",
		"Esteban",
		"Euclide",
		"Euler",
		"Euripide",
		"Fantasio",
		"Felix",
		"Fenton",
		"Fidel",
		"Fievel",
		"Finch",
		"Finot",
		"Fiona",
		"Fisher",
		"Flagada",
		"Flanders",
		"Fleming",
		"Flint",
		"Flupke",
		"Ford",
		"Frank",
		"Franklin",
		"Franky",
		"Franquin",
		"Fred",
		"Fredrick",
		"Freeman",
		"Freezer",
		"Freud",
		"Fripounet",
		"Frodon",
		"Funkey",
		"Félibelle",
		"Gabin",
		"Gadget",
		"Galantine",
		"Galaxien",
		"Galien",
		"Galile",
		"Gandhi",
		"Garulfo",
		"Gaston",
		"Gates",
		"Gaulle",
		"Gauss",
		"Gautama",
		"Gauvain",
		"Geluck",
		"Genie",
		"George",
		"Georgie",
		"Geronimo",
		"Gilfoyle",
		"Gingerbread",
		"Ginny",
		"Ginsberg",
		"Giovani",
		"Gir",
		"Gloria",
		"Gogo",
		"Goldorak",
		"Goliath",
		"Gomez",
		"Gorbachev",
		"Gordon",
		"Goscinny",
		"Gotenks",
		"Gotlib",
		"Gourmandine",
		"Greg",
		"Gregor",
		"Grosminet",
		"Gros",
		"Guenièvre",
		"Guevara",
		"Gustave",
		"Gutenberg",
		"Géo",
		"Haddock",
		"Hadrien",
		"Hamilton",
		"Hanks",
		"Hannibal",
		"Hans",
		"Hardy",
		"Harrald",
		"Harrison",
		"Hatchet",
		"Hawkins",
		"Hector",
		"Hemingway",
		"Hercule",
		"Herge",
		"Hesiode",
		"Hilda",
		"Homer",
		"Horace",
		"Howard",
		"Huang",
		"Hugo",
		"Hyppolyte",
		"Hyôga",
		"Idefix",
		"Iron",
		"Ivan",
		"Iznogoud",
		"Jabu",
		"Jackie",
		"Jack",
		"Jackson",
		"Jacques",
		"Jafar",
		"James",
		"Jared",
		"Jarvis",
		"Jasmine",
		"Jaures",
		"Jayce",
		"Jobs",
		"Joe",
		"Joffrey",
		"Johansson",
		"John",
		"Johnny",
		"Jorah",
		"Jules",
		"Julien",
		"Justinien",
		"Kaa",
		"Kadoc",
		"Kaio",
		"Kamé",
		"Karadoc",
		"Kennedy",
		"Kenny",
		"Kenshiro",
		"Khan",
		"Kheops",
		"Khroutchev",
		"King",
		"Korben",
		"Kowalski",
		"Kyle",
		"Kylo",
		"Labevue",
		"LaChose",
		"LaCrampe",
		"Lagaffe",
		"Lancelot",
		"Lanfeust",
		"Lankou",
		"LaoTseu",
		"Lapinot",
		"Lapoigne",
		"Largo",
		"Laurel",
		"Leclerc",
		"Leeloo",
		"Lefuneste",
		"LeGrinch",
		"Leila",
		"LeLorax",
		"Lennon",
		"Lenny",
		"Leonard",
		"Leonardo",
		"Lewis",
		"Lilo",
		"Lincoln",
		"Little",
		"Livingstone",
		"Longtarin",
		"Lord",
		"Louis",
		"Loupio",
		"Lucky",
		"Luke",
		"Lumiere",
		"Léodagan",
		"Machete",
		"Madchat",
		"Maester",
		"Mafalda",
		"Major",
		"Maltazard",
		"Mandela",
		"Mandryka",
		"Manny",
		"Mao",
		"Marcel",
		"Margaery",
		"Marge",
		"Marius",
		"Marley",
		"Marsupilami",
		"Marty",
		"Marvel",
		"Marvin",
		"Marx",
		"Masellus",
		"Matisse",
		"Maître",
		"McQueen",
		"Megot",
		"Melchior",
		"Melman",
		"Melusine",
		"Mendoza",
		"Merad",
		"Mercredi",
		"Merlin",
		"Mia",
		"Michelangelo",
		"Mickey",
		"Milhouse",
		"Milo",
		"Milou",
		"Mimi",
		"Minikeums",
		"Minipouss",
		"Minus",
		"Missandei",
		"Miss",
		"Mister",
		"Mitterand",
		"Moliere",
		"Monroe",
		"Morgane",
		"Morris",
		"Morticia",
		"Mortimer",
		"Morvax",
		"Mouche",
		"Moulin",
		"Mowgli",
		"Mozart",
		"Murtogg",
		"Musclor",
		"Muzo",
		"Mélisandre",
		"Méléagant",
		"Mû",
		"Nana",
		"Nanar",
		"Nappa",
		"Natacha",
		"Nelson",
		"Neron",
		"Newton",
		"Nick",
		"Nietzsche",
		"Nixon",
		"Numéro",
		"Numérobis",
		"Némo",
		"Oberyn",
		"Oddjob",
		"Okko",
		"Olaf",
		"Olive",
		"Oolong",
		"Oompa",
		"Orko",
		"Oswaldo",
		"Ottokar",
		"PaiMei",
		"Pan",
		"Pancho",
		"Panpan",
		"Panthro",
		"Pascal",
		"Pasteur",
		"Pedro",
		"Pelisse",
		"Pendragon",
		"Penny",
		"Pepito",
		"Perce",
		"Perceval",
		"Pericles",
		"Perlin",
		"Perrier",
		"Peter",
		"Peyo",
		"Piaf",
		"Picasso",
		"Piccolo",
		"Picsou",
		"Pifou",
		"Pintel",
		"Pitt",
		"Placid",
		"Platon",
		"Plume",
		"Pluto",
		"Podrick",
		"Poincare",
		"Poison",
		"Pompon",
		"Ponchelot",
		"Pongo",
		"Popeye",
		"Porcinet",
		"Portman",
		"Presley",
		"Prunelle",
		"Puduk",
		"Pugsley",
		"Pumbaa",
		"Pumyra",
		"Pythagore",
		"Père",
		"Quick",
		"Quino",
		"Rabelais",
		"Rackham",
		"Raditz",
		"Ragetti",
		"Ragnar",
		"Rahan",
		"Rajesh",
		"Ramsay",
		"Ramses",
		"Randall",
		"Randor",
		"Rantanplan",
		"Raoh",
		"Raoul",
		"Raoulette",
		"Raphael",
		"Rasputin",
		"Razmokets",
		"Reiser",
		"Rembrandt",
		"Remus",
		"Renart",
		"Ric",
		"Richard",
		"Robert",
		"Roberts",
		"Robin",
		"Rocket",
		"Rodin",
		"Roger",
		"Roi",
		"Ron",
		"Roosevelt",
		"Roparzh",
		"Rory",
		"Roshan",
		"Ruby",
		"Ryûken",
		"Sailor",
		"Saladin",
		"Sally",
		"Sammy",
		"Samwell",
		"Sancho",
		"Sandor",
		"SanKuKai",
		"Sansa",
		"Saori",
		"Scar",
		"Scarecrow",
		"Scarlett",
		"Schtroumpf",
		"Schwarzenegger",
		"Scooby",
		"Scott",
		"Scrameustache",
		"Scrat",
		"Sean",
		"Seiya",
		"Severus",
		"Shae",
		"Shaina",
		"Shaka",
		"Shakespeare",
		"Sheldon",
		"Shenron",
		"Shere",
		"Shion",
		"Shiryu",
		"Shosanna",
		"Shredder",
		"Shunikki",
		"Sid",
		"Simba",
		"Simpson",
		"Sinatra",
		"Sirius",
		"Skeletor",
		"Skipper",
		"Slugworth",
		"Smith",
		"Smithers",
		"Snarf",
		"Snoke",
		"Snoopy",
		"Snorky",
		"Snotrod",
		"Socrate",
		"Soeur",
		"Sofie",
		"Son",
		"Sparrow",
		"Spartacus",
		"Speedy",
		"Spirou",
		"Splinter",
		"Stan",
		"Stitch",
		"Stuart",
		"Supermatou",
		"Sylvestre",
		"Sylvette",
		"Syrena",
		"Tahiti",
		"Talon",
		"Tamara",
		"Tao",
		"TaoPaiPai",
		"Tardi",
		"Tartine",
		"Tarzan",
		"Tata",
		"Taupeman",
		"Ten",
		"Terrance",
		"Tesla",
		"Thales",
		"Thatcher",
		"Theon",
		"Thorgal",
		"Tif",
		"Tigrou",
		"Tim",
		"Timon",
		"Timothy",
		"Tintin",
		"Titeuf",
		"Titi",
		"Titus",
		"Toki",
		"Tolkien",
		"Tom",
		"Tommen",
		"Tomtom",
		"Tondu",
		"Tony",
		"Tortues",
		"Totoche",
		"Toufu",
		"Trajan",
		"Travolta",
		"Trigro",
		"Trondheim",
		"Trotski",
		"Trunks",
		"Turkish",
		"Tyene",
		"Tyrion",
		"Tête",
		"Uderzo",
		"Ulysse",
		"Ursula",
		"Vaillant",
		"Valentin",
		"Valerian",
		"Van",
		"Vegeta",
		"Verinus",
		"Vertignasse",
		"Veruca",
		"Vespucci",
		"Veyron",
		"Vicky",
		"Victor",
		"Victoria",
		"Videl",
		"Vincent",
		"Vinci",
		"Viviane",
		"Walt",
		"Walter",
		"Wapi",
		"Warhol",
		"Waternoose",
		"Wendi",
		"Wendy",
		"Wiggum",
		"Wilde",
		"Will",
		"William",
		"Williams",
		"Willie",
		"Willis",
		"Willy",
		"Wilson",
		"Winnie",
		"Winston",
		"Woody",
		"Yakari",
		"Ygrid",
		"Yvain",
		"Zed",
		"Zedong",
		"Zembla",
		"Zia",
		"Zorg",
		"Zoro",
	},

	right = {
		"Aberrant",
		"Abrasif",
		"Abruti",
		"Absent",
		"Absurde",
		"Abusif",
		"Accro",
		"Actif",
		"Admirable",
		"Adoptable",
		"Adorable",
		"Adroit",
		"Affectif",
		"Affolé",
		"Affreux",
		"Agile",
		"Agréable",
		"Aguerri",
		"Aguichant",
		"Ahuri",
		"Aigri",
		"Aimable",
		"Albinos",
		"Alerte",
		"Aliénable",
		"Alléchant",
		"Ambigu",
		"Ambitieux",
		"Ambulant",
		"Amer",
		"Amical",
		"Amnésique",
		"Amorphe",
		"Amoureux",
		"Ample",
		"Angora",
		"Anguleux",
		"Angélique",
		"Anonyme",
		"Anormal",
		"Antimite",
		"Antique",
		"Anxieux",
		"Apaisant",
		"Apathique",
		"Aphasique",
		"Aphone",
		"Appliqué",
		"Apprêté",
		"Apte",
		"Archaïque",
		"Ardent",
		"Ardu",
		"Argenté",
		"Arrogant",
		"Asocial",
		"Assidu",
		"Astucieux",
		"Atomique",
		"Attachant",
		"Attardé",
		"Attentif",
		"Atterrant",
		"Attractif",
		"Atypique",
		"Audacieux",
		"Austère",
		"Autiste",
		"Avarié",
		"Averti",
		"Aveuglant",
		"Aveugle",
		"Bagarreur",
		"Balourd",
		"Banal",
		"Bancal",
		"Baraqué",
		"Barbare",
		"Barbu",
		"Bariolé",
		"Barjot",
		"Barré",
		"Bavard",
		"Berceur",
		"Bestial",
		"Bienvenu",
		"Bigame",
		"Bigarré",
		"Bigleux",
		"Bipolaire",
		"Biscornu",
		"Blafard",
		"Blagueur",
		"Blême",
		"Borgne",
		"Borné",
		"Bosseur",
		"Bossu",
		"Bouché",
		"Boudiné",
		"Bouffant",
		"Bouillant",
		"Bourru",
		"Bourré",
		"Branché",
		"Brave",
		"Bref",
		"Bricoleur",
		"Brillant",
		"Bucolique",
		"Burlesque",
		"Buté",
		"Buveur",
		"Bâtard",
		"Bénévole",
		"Caduc",
		"Calin",
		"Calme",
		"Calé",
		"Canaille",
		"Candide",
		"Cannibal",
		"Captif",
		"Captivant",
		"Carabiné",
		"Carboné",
		"Cardiaque",
		"Carentiel",
		"Caresseur",
		"Carioca",
		"Caritatif",
		"Carnivore",
		"Cartésien",
		"Caréné",
		"Casanier",
		"Casqué",
		"Cassant",
		"Casseur",
		"Causant",
		"Causeur",
		"Caustique",
		"Cavalier",
		"Caverneux",
		"Cendré",
		"Censé",
		"Centriste",
		"Certifié",
		"Chahuteur",
		"Champion",
		"Champêtre",
		"Chanceux",
		"Chantant",
		"Chaotique",
		"Chapelier",
		"Charmant",
		"Charmeur",
		"Charnu",
		"Charrieur",
		"Chasseur",
		"Chaste",
		"Chaud",
		"Chauve",
		"Chauvin",
		"Chevelu",
		"Chevronné",
		"Chiant",
		"Chic",
		"Chicanier",
		"Chiné",
		"Chloré",
		"Chocolaté",
		"Chou",
		"Chouette",
		"Chéri",
		"Chétif",
		"Chômé",
		"Cinglé",
		"Citronné",
		"Civique",
		"Clair",
		"Clairsemé",
		"Clapoteux",
		"Classique",
		"Clinquant",
		"Clément",
		"Clérical",
		"Cocasse",
		"Cochon",
		"Cocu",
		"Cohérent",
		"Collant",
		"Coloré",
		"Coléreux",
		"Colérique",
		"Comateux",
		"Combatif",
		"Comique",
		"Commode",
		"Commun",
		"Complexe",
		"Complice",
		"Compliqué",
		"Comprimé",
		"Compulsif",
		"Compétent",
		"Comédien",
		"Concentré",
		"Concis",
		"Condamné",
		"Confiant",
		"Confus",
		"Content",
		"Cool",
		"Coquet",
		"Coquin",
		"Cordial",
		"Coriace",
		"Cornu",
		"Corpulent",
		"Correct",
		"Cosmique",
		"Couillon",
		"Coupable",
		"Courageux",
		"Courtois",
		"Craintif",
		"Cramoisi",
		"Crapuleux",
		"Craquant",
		"Crasseux",
		"Critique",
		"Croulant",
		"Croyant",
		"Cruel",
		"Cryogène",
		"Crâneur",
		"Créatif",
		"Crédible",
		"Crédule",
		"Crémeux",
		"Crépelé",
		"Crépu",
		"Crétin",
		"Cuisant",
		"Culminant",
		"Culotté",
		"Cultivé",
		"Cupide",
		"Curieux",
		"Cynique",
		"Câlin",
		"Célèbre",
		"Cérébral",
		"Daltonien",
		"Dangereux",
		"Darwinien",
		"Demeuré",
		"Difficile",
		"Difforme",
		"Diffus",
		"Différent",
		"Digne",
		"Digressif",
		"Diligent",
		"Diminué",
		"Dingo",
		"Dingue",
		"Diplomate",
		"Direct",
		"Directif",
		"Dirigiste",
		"Discret",
		"Disjoncté",
		"Dissident",
		"Dissipé",
		"Dissuasif",
		"Distant",
		"Distingué",
		"Distrait",
		"Divin",
		"Divorcé",
		"Docile",
		"Doctrinal",
		"Dodu",
		"Dominant",
		"Dormant",
		"Doré",
		"Douteux",
		"Doux",
		"Doué",
		"Draconien",
		"Drastique",
		"Drogué",
		"Droit",
		"Droitier",
		"Dru",
		"Drôle",
		"Dubitatif",
		"Dupe",
		"Dur",
		"Dynamique",
		"Débile",
		"Débraillé",
		"Débridé",
		"Débutant",
		"Décadent",
		"Décaféiné",
		"Décent",
		"Déchirant",
		"Déchu",
		"Décisif",
		"Défait",
		"Défensif",
		"Déficient",
		"Défroqué",
		"Dégonflé",
		"Dégourdi",
		"Dégoûtant",
		"Dégoûté",
		"Dégradant",
		"Déguisé",
		"Délabré",
		"Délicat",
		"Délicieux",
		"Délirant",
		"Déloyal",
		"Déluré",
		"Démagogue",
		"Dément",
		"Démentiel",
		"Démerdard",
		"Démesuré",
		"Démodé",
		"Démonté",
		"Dénué",
		"Dépanneur",
		"Dépassé",
		"Dépendant",
		"Dépensier",
		"Déphasé",
		"Dépouillé",
		"Dépravé",
		"Dépressif",
		"Déprimant",
		"Déprimé",
		"Déraciné",
		"Dérangé",
		"Déroutant",
		"Déréglé",
		"Désabusé",
		"Désarmant",
		"Désemparé",
		"Désirable",
		"Désireux",
		"Désoeuvré",
		"Désolant",
		"Désolé",
		"Détendu",
		"Déterminé",
		"Détonant",
		"Déviant",
		"Dévolu",
		"Dévoreur",
		"Dévoué",
		"Déçu",
		"Effacé",
		"Effarant",
		"Efficace",
		"Efficient",
		"Effrayant",
		"Effronté",
		"Effréné",
		"Efféminé",
		"Embêtant",
		"Emmerdant",
		"Empaillé",
		"Emplumé",
		"Empoté",
		"Empressé",
		"Enchanté",
		"Encorné",
		"Endiablé",
		"Endocrine",
		"Endolori",
		"Endormi",
		"Endurant",
		"Endurci",
		"Enfantin",
		"Enfariné",
		"Enflammé",
		"Enflé",
		"Engagé",
		"Enivrant",
		"Enjoué",
		"Ennuyant",
		"Enrageant",
		"Enragé",
		"Enrichi",
		"Entêté",
		"Enveloppé",
		"Enviable",
		"Envoûtant",
		"Errant",
		"Exaltant",
		"Exalté",
		"Excessif",
		"Excité",
		"Exclusif",
		"Excusable",
		"Exigeant",
		"Exotique",
		"Explicite",
		"Explosif",
		"Exquis",
		"Fabuleux",
		"Fameux",
		"Fanatique",
		"Fanfaron",
		"Fantasque",
		"Farfelu",
		"Farineux",
		"Farouche",
		"Fascinant",
		"Fatal",
		"Fatidique",
		"Fatigant",
		"Fatigué",
		"Festif",
		"Feutré",
		"Fiable",
		"Fidèle",
		"Fier",
		"Finaud",
		"Flagada",
		"Flatteur",
		"Flemmard",
		"Flâneur",
		"Foireux",
		"Folichon",
		"Fonceur",
		"Fortiche",
		"Fortuné",
		"Fou",
		"Foufou",
		"Fougueux",
		"Fouineur",
		"Fourbe",
		"Fragile",
		"Framboisé",
		"Frileux",
		"Fringant",
		"Frisé",
		"Fructueux",
		"Frustré",
		"Fugace",
		"Fugitif",
		"Fugueur",
		"Fulgurant",
		"Fulminant",
		"Fumant",
		"Furax",
		"Fureteur",
		"Furibond",
		"Furieux",
		"Furtif",
		"Fusant",
		"Futé",
		"Féroce",
		"Féru",
		"Fétide",
		"Fêlé",
		"Gaga",
		"Gai",
		"Gaillard",
		"Galant",
		"Givré",
		"Glacial",
		"Glaireux",
		"Glacé",
		"Glamour",
		"Glauque",
		"Glaçant",
		"Glouton",
		"Gluant",
		"Gnangnan",
		"Goguenard",
		"Goinfre",
		"Gominé",
		"Gommeux",
		"Gonflant",
		"Gonflé",
		"Gothique",
		"Gourmand",
		"Gracieux",
		"Gradé",
		"Gratiné",
		"Graveleux",
		"Grincheux",
		"Grisé",
		"Grognon",
		"Grondeur",
		"Grotesque",
		"Gueulard",
		"Guindé",
		"Génial",
		"Généreux",
		"Habillé",
		"Hagard",
		"Haineux",
		"Haletant",
		"Halluciné",
		"Handicapé",
		"Hardi",
		"Hargneux",
		"Hasardeux",
		"Hautain",
		"Heureux",
		"Hideux",
		"Hilarant",
		"Hilare",
		"Hippie",
		"Honnête",
		"Honorable",
		"Honteux",
		"Horrible",
		"Horticole",
		"Hostile",
		"Huileux",
		"Humaniste",
		"Humanoïde",
		"Humble",
		"Huppé",
		"Hurleur",
		"Hybride",
		"Hydratant",
		"Hâtif",
		"Héliporté",
		"Héroïque",
		"Hérétique",
		"Hésitant",
		"Iconique",
		"Idiot",
		"Idyllique",
		"Idéal",
		"Idéaliste",
		"Ignare",
		"Ignescent",
		"Ignifuge",
		"Ignoble",
		"Ignorant",
		"Illettré",
		"Illogique",
		"Illuminé",
		"Illustre",
		"Illégal",
		"Imaginal",
		"Imberbe",
		"Imbu",
		"Imbécile",
		"Immaculé",
		"Immature",
		"Immergé",
		"Immobile",
		"Imparable",
		"Imparfait",
		"Impartial",
		"Impatient",
		"Impie",
		"Implosif",
		"Imposant",
		"Imprudent",
		"Impulsif",
		"Impérial",
		"Inachevé",
		"Inadapté",
		"Inaltéré",
		"Inapte",
		"Inattendu",
		"Incarné",
		"Incertain",
		"Incisif",
		"Incitatif",
		"Incommode",
		"Incompris",
		"Incongru",
		"Inconnu",
		"Incorrect",
		"Incrédule",
		"Inculte",
		"Indemne",
		"Indigeste",
		"Indulgent",
		"Indécent",
		"Indécis",
		"Indélicat",
		"Inepte",
		"Infantile",
		"Infernal",
		"Infidèle",
		"Influent",
		"Ingénieux",
		"Ingérable",
		"Innocent",
		"Innomable",
		"Insistant",
		"Insoumis",
		"Inspiré",
		"Instable",
		"Instruit",
		"Intrigant",
		"Intrusif",
		"Intuitif",
		"Intègre",
		"Invaincu",
		"Inventif",
		"Invisible",
		"Inédit",
		"Inégalé",
		"Ironique",
		"Irritable",
		"Irritant",
		"Irréel",
		"Jaloux",
		"Jaseur",
		"Jazzy",
		"Joueur",
		"Joufflu",
		"Jovial",
		"Joyeux",
		"Judicieux",
		"Junior",
		"Juste",
		"Justicier",
		"Juvénile",
		"Laxiste",
		"Libertin",
		"Libre",
		"Limpide",
		"Logique",
		"Loquace",
		"Lucide",
		"Lugubre",
		"Luisant",
		"Lumineux",
		"Lunatique",
		"Luxuriant",
		"Léger",
		"Légitime",
		"Maboul",
		"Mafieux",
		"Magique",
		"Magistral",
		"Magnanime",
		"Majeur",
		"Maladroit",
		"Malaisé",
		"Malappris",
		"Malfamé",
		"Malicieux",
		"Malin",
		"Malpoli",
		"Malvoyant",
		"Maléfique",
		"Manchot",
		"Maniaque",
		"Maniéré",
		"Marginal",
		"Masqué",
		"Massif",
		"Matinal",
		"Mature",
		"Maudit",
		"Mental",
		"Menteur",
		"Militant",
		"Miniature",
		"Minuscule",
		"Minutieux",
		"Miraculé",
		"Mitigé",
		"Moderne",
		"Modeste",
		"Modéré",
		"Moelleux",
		"Monacal",
		"Mondain",
		"Monotone",
		"Moqueur",
		"Moraliste",
		"Mordant",
		"Mordu",
		"Motivé",
		"Mou",
		"Moucheté",
		"Moustachu",
		"Muet",
		"Musclé",
		"Myope",
		"Mythomane",
		"Méconnu",
		"Mécontent",
		"Médiateur",
		"Méfiant",
		"Mélodieux",
		"Mélomane",
		"Mémorable",
		"Nacré",
		"Nain",
		"Navigant",
		"Naïf",
		"Nerveux",
		"Neutre",
		"Nigaud",
		"Nocturne",
		"Nomade",
		"Normal",
		"Notoire",
		"Novateur",
		"Novice",
		"Nucléaire",
		"Nyctalope",
		"Négligent",
		"Néophyte",
		"Névrosé",
		"Objectif",
		"Obscur",
		"Obscène",
		"Obsessif",
		"Obsolète",
		"Obstiné",
		"Obsédé",
		"Obtus",
		"Obèse",
		"Obéissant",
		"Occupé",
		"Officieux",
		"Oisif",
		"Omnivore",
		"Optimal",
		"Optionnel",
		"Ordinaire",
		"Ordonné",
		"Organisé",
		"Original",
		"Osé",
		"Oublieux",
		"Outrageux",
		"Outré",
		"Oxydable",
		"Pacifique",
		"Pacifiste",
		"Pailleté",
		"Palmipède",
		"Panaché",
		"Pantois",
		"Paralysé",
		"Parasite",
		"Paresseux",
		"Parfait",
		"Partageur",
		"Partageux",
		"Partial",
		"Partisan",
		"Passionné",
		"Pastoral",
		"Pataud",
		"Patient",
		"Patraque",
		"Paumé",
		"Peinard",
		"Penaud",
		"Pensif",
		"Perceptif",
		"Percutant",
		"Permissif",
		"Perméable",
		"Perplexe",
		"Perpétuel",
		"Persuasif",
		"Pertinent",
		"Perçant",
		"Peureux",
		"Phobique",
		"Pimpant",
		"Piquant",
		"Placide",
		"Plaisant",
		"Planqué",
		"Pliant",
		"Plumeté",
		"Poilu",
		"Poissard",
		"Poli",
		"Polisson",
		"Poltron",
		"Pommé",
		"Pompette",
		"Ponctuel",
		"Pondeur",
		"Populaire",
		"Populiste",
		"Positif",
		"Possessif",
		"Possédé",
		"Posé",
		"Potable",
		"Potelé",
		"Pourri",
		"Poussif",
		"Poétique",
		"Pratique",
		"Presbyte",
		"Pressant",
		"Pressé",
		"Primitif",
		"Princier",
		"Principal",
		"Proactif",
		"Probable",
		"Probant",
		"Prodigue",
		"Productif",
		"Profane",
		"Profond",
		"Prominent",
		"Promis",
		"Prompt",
		"Propice",
		"Propre",
		"Prospère",
		"Prostré",
		"Provençal",
		"Provocant",
		"Prudent",
		"Précieux",
		"Précipité",
		"Précis",
		"Précoce",
		"Prédateur",
		"Prédictif",
		"Présent",
		"Présumé",
		"Prévenant",
		"Préventif",
		"Prévoyant",
		"Prêcheur",
		"Psychique",
		"Pudibond",
		"Pudique",
		"Pugnace",
		"Puissant",
		"Punk",
		"Pur",
		"Puriste",
		"Puéril",
		"Pâle",
		"Pâlichon",
		"Pâlot",
		"Pédagogue",
		"Pédestre",
		"Pénible",
		"Pépère",
		"Péteux",
		"Quantique",
		"Rabougri",
		"Racoleur",
		"Radical",
		"Radieux",
		"Radin",
		"Radoteur",
		"Raffiné",
		"Rageur",
		"Railleur",
		"Raisonné",
		"Ramolli",
		"Ramollo",
		"Rampant",
		"Rancunier",
		"Rapiat",
		"Rapide",
		"Raplapla",
		"Rasoir",
		"Rassurant",
		"Rastafari",
		"Rationnel",
		"Ravageur",
		"Ravi",
		"Ravissant",
		"Rayonnant",
		"Rebelle",
		"Rebondi",
		"Recherché",
		"Reconnu",
		"Regardant",
		"Relax",
		"Relaxant",
		"Reluisant",
		"Renommé",
		"Repentant",
		"Repu",
		"Retardé",
		"Retraité",
		"Riant",
		"Ridicule",
		"Rieur",
		"Rigide",
		"Rigolard",
		"Rigolo",
		"Rigoureux",
		"Ringard",
		"Ripou",
		"Riquiqui",
		"Riverain",
		"Robuste",
		"Ronchon",
		"Rondelet",
		"Ronflant",
		"Roublard",
		"Rouillé",
		"Roulant",
		"Rouquin",
		"Royal",
		"Rubicond",
		"Rude",
		"Rudenté",
		"Ruminant",
		"Rupin",
		"Rural",
		"Rustique",
		"Rusé",
		"Rutilant",
		"Râleur",
		"Réactif",
		"Réceptif",
		"Réfléchi",
		"Réfrigéré",
		"Réglo",
		"Régulier",
		"Réputé",
		"Répétitif",
		"Réservé",
		"Réticent",
		"Révoltant",
		"Révolté",
		"Rêvasseur",
		"Rêveur",
		"Sage",
		"Sain",
		"Salutaire",
		"Salvateur",
		"Sanguin",
		"Satirique",
		"Satisfait",
		"Sauvage",
		"Savant",
		"Sec",
		"Secret",
		"Sectaire",
		"Sensible",
		"Sensuel",
		"Sensé",
		"Septique",
		"Serein",
		"Serviable",
		"Sexy",
		"Seyant",
		"Siffleur",
		"Simple",
		"Simplet",
		"Simpliste",
		"Sincère",
		"Singulier",
		"Sinistre",
		"Siphonné",
		"Snob",
		"Sobre",
		"Sociable",
		"Social",
		"Soigneux",
		"Solennel",
		"Solidaire",
		"Solvable",
		"Sombre",
		"Sommaire",
		"Somnolent",
		"Somptueux",
		"Songeur",
		"Sonné",
		"Sot",
		"Soucieux",
		"Souple",
		"Sourd",
		"Souriant",
		"Sourieur",
		"Sournois",
		"Souverain",
		"Soyeux",
		"Soûl",
		"Spartiate",
		"Spirituel",
		"Splendide",
		"Spongieux",
		"Spontané",
		"Sportif",
		"Spécial",
		"Stable",
		"Stagiaire",
		"Stimulant",
		"Strict",
		"Studieux",
		"Stupide",
		"Stupéfait",
		"Stylé",
		"Subjectif",
		"Sublime",
		"Subtil",
		"Succinct",
		"Suffisant",
		"Suggestif",
		"Sulfureux",
		"Superbe",
		"Superflu",
		"Suprême",
		"Surbooké",
		"Surdoué",
		"Surfait",
		"Surhumain",
		"Suspect",
		"Svelte",
		"Séducteur",
		"Séduisant",
		"Sélectif",
		"Sénile",
		"Sérieux",
		"Sévère",
		"Tabou",
		"Taciturne",
		"Tactile",
		"Tangible",
		"Tapageur",
		"Taquin",
		"Taré",
		"Tatillon",
		"Teigneux",
		"Tempéré",
		"Tenace",
		"Tendre",
		"Tendu",
		"Tentateur",
		"Terne",
		"Terrible",
		"Théâtral",
		"Tigré",
		"Timbré",
		"Timide",
		"Timoré",
		"Titré",
		"Titulaire",
		"Tolérable",
		"Tolérant",
		"Toqué",
		"Tordant",
		"Tordu",
		"Tortueux",
		"Touffu",
		"Tourmenté",
		"Toxique",
		"Transi",
		"Trapu",
		"Traqueur",
		"Travesti",
		"Traître",
		"Trompeur",
		"Troublant",
		"Trépidant",
		"Turbulent",
		"Tâteur",
		"Téméraire",
		"Ténu",
		"Ténébreux",
		"Tétanique",
		"Têtu",
		"Ultime",
		"Ultra",
		"Unicolore",
		"Unicorne",
		"Urbain",
		"Utile",
		"Utopique",
		"Utopiste",
		"Vagabond",
		"Vague",
		"Vaillant",
		"Vainqueur",
		"Valeureux",
		"Vantard",
		"Vaporeux",
		"Veinard",
		"Venimeux",
		"Ventru",
		"Vertueux",
		"Vibrant",
		"Vicelard",
		"Vif",
		"Vigilant",
		"Vigoureux",
		"Vilain",
		"Viril",
		"Virtuel",
		"Virtuose",
		"Vorace",
		"Véloce",
		"Véridique",
		"Véritable",
		"Zen",
		"Zinzin",
		"Zélé",
		"Ébahi",
		"Éberlué",
		"Éclairé",
		"Éclatant",
		"Économe",
		"Édifiant",
		"Égoïste",
		"Éhonté",
		"Élogieux",
		"Éloquent",
		"Élégant",
		"Émotif",
		"Émouvant",
		"Ému",
		"Éméché",
		"Énergique",
		"Énervant",
		"Énervé",
		"Épatant",
		"Épaté",
		"Éperdu",
		"Éphémère",
		"Épicurien",
		"Épique",
		"Épris",
		"Épuisant",
		"Épuisé",
		"Équilibré",
		"Équitable",
		"Éternel",
		"Étonnant",
		"Étouffant",
		"Étourdi",
		"Étrange",
		"Évasif",
		"Éveillé",
		"Évident",
		"Évocateur"
	}
}

local docker = {
	left = {
		"Admiring",
		"Adoring",
		"Affectionate",
		"Agitated",
		"Amazing",
		"Angry",
		"Awesome",
		"Blissful",
		"Boring",
		"Brave",
		"Clever",
		"Cocky",
		"Compassionate",
		"Competent",
		"Condescending",
		"Confident",
		"Cranky",
		"Dazzling",
		"Determined",
		"Distracted",
		"Dreamy",
		"Eager",
		"Ecstatic",
		"Elastic",
		"Elated",
		"Elegant",
		"Eloquent",
		"Epic",
		"Fervent",
		"Festive",
		"Flamboyant",
		"Focused",
		"Friendly",
		"Frosty",
		"Gallant",
		"Gifted",
		"Goofy",
		"Gracious",
		"Happy",
		"Hardcore",
		"Heuristic",
		"Hopeful",
		"Hungry",
		"Infallible",
		"Inspiring",
		"Jolly",
		"Jovial",
		"Keen",
		"Kind",
		"Laughing",
		"Loving",
		"Lucid",
		"Mystifying",
		"Modest",
		"Musing",
		"Naughty",
		"Nervous",
		"Nifty",
		"Nostalgic",
		"Objective",
		"Optimistic",
		"Peaceful",
		"Pedantic",
		"Pensive",
		"Practical",
		"Priceless",
		"Quirky",
		"Quizzical",
		"Relaxed",
		"Reverent",
		"Romantic",
		"Sad",
		"Serene",
		"Sharp",
		"Silly",
		"Sleepy",
		"Stoic",
		"Stupefied",
		"Suspicious",
		"Tender",
		"Thirsty",
		"Trusting",
		"Unruffled",
		"Upbeat",
		"Vibrant",
		"Vigilant",
		"Vigorous",
		"Wizardly",
		"Wonderful",
		"Xenodochial",
		"Youthful",
		"Zealous",
		"Zen",
	},
	right = {
		"Albattani",
		"Allen",
		"Almeida",
		"Agnesi",
		"Archimedes",
		"Ardinghelli",
		"Aryabhata",
		"Austin",
		"Babbage",
		"Banach",
		"Bardeen",
		"Bartik",
		"Bassi",
		"Beaver",
		"Bell",
		"Benz",
		"Bhabha",
		"Bhaskara",
		"Blackwell",
		"Bohr",
		"Booth",
		"Borg",
		"Bose",
		"Boyd",
		"Brahmagupta",
		"Brattain",
		"Brown",
		"Carson",
		"Chandrasekhar",
		"Shannon",
		"Clarke",
		"Colden",
		"Cori",
		"Cray",
		"Curran",
		"Curie",
		"Darwin",
		"Davinci",
		"Dijkstra",
		"Dubinsky",
		"Easley",
		"Edison",
		"Einstein",
		"Elion",
		"Engelbart",
		"Euclid",
		"Euler",
		"Fermat",
		"Fermi",
		"Feynman",
		"Franklin",
		"Galileo",
		"Gates",
		"Goldberg",
		"Goldstine",
		"Goldwasser",
		"Golick",
		"Goodall",
		"Haibt",
		"Hamilton",
		"Hawking",
		"Heisenberg",
		"Hermann",
		"Heyrovsky",
		"Hodgkin",
		"Hoover",
		"Hopper",
		"Hugle",
		"Hypatia",
		"Jackson",
		"Jang",
		"Jennings",
		"Jepsen",
		"Johnson",
		"Joliot",
		"Jones",
		"Kalam",
		"Kare",
		"Keller",
		"Kepler",
		"Khorana",
		"Kilby",
		"Kirch",
		"Knuth",
		"Kowalevski",
		"Lalande",
		"Lamarr",
		"Lamport",
		"Leakey",
		"Leavitt",
		"Lewin",
		"Lichterman",
		"Liskov",
		"Lovelace",
		"Lumiere",
		"Mahavira",
		"Mayer",
		"Mccarthy",
		"Mcclintock",
		"Mclean",
		"Mcnulty",
		"Meitner",
		"Meninsky",
		"Mestorf",
		"Minsky",
		"Mirzakhani",
		"Morse",
		"Murdock",
		"Neumann",
		"Newton",
		"Nightingale",
		"Nobel",
		"Noether",
		"Northcutt",
		"Noyce",
		"Panini",
		"Pare",
		"Pasteur",
		"Payne",
		"Perlman",
		"Pike",
		"Poincare",
		"Poitras",
		"Ptolemy",
		"Raman",
		"Ramanujan",
		"Ride",
		"Montalcini",
		"Ritchie",
		"Roentgen",
		"Rosalind",
		"Saha",
		"Sammet",
		"Shaw",
		"Shirley",
		"Shockley",
		"Sinoussi",
		"Snyder",
		"Spence",
		"Stallman",
		"Stonebraker",
		"Swanson",
		"Swartz",
		"Swirles",
		"Tesla",
		"Thompson",
		"Torvalds",
		"Turing",
		"Varahamihira",
		"Visvesvaraya",
		"Volhard",
		"Wescoff",
		"Wiles",
		"Williams",
		"Wilson",
		"Wing",
		"Wozniak",
		"Wright",
		"Yalow",
		"Yonath",
	}
}

return {
	generateRandom = function()
		local dict = utils.chooseEqual({fr, docker})
		return utils.chooseEqual(dict.left) .. " " .. utils.chooseEqual(dict.right)
	end
}
