/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.builtin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.builtin.SimpleReturnFunction;
import net.sourceforge.plantuml.tim.expression.TValue;

public class JsonAdd
extends SimpleReturnFunction {
    private static final TFunctionSignature SIGNATURE = new TFunctionSignature("%json_add", 3);

    @Override
    public TFunctionSignature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 2 || nbArg == 3;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        TValue data = values.get(0);
        if (!data.isJson()) {
            throw new EaterException("Not JSON data", location);
        }
        JsonValue json = data.toJson().cloneMe();
        if (!json.isArray() && !json.isObject()) {
            return data;
        }
        if (json.isArray()) {
            JsonValue value = values.get(1).toJsonValue();
            json.asArray().add(value);
            return TValue.fromJson(json);
        }
        if (json.isObject()) {
            String name = values.get(1).toString();
            JsonValue value = values.get(2).toJsonValue();
            json.asObject().add(name, value);
            return TValue.fromJson(json);
        }
        throw new EaterException("Bad JSON type", location);
    }
}

