/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class ObjectCreationExpression
extends Expression {
    public static final TokenRole NEW_KEYWORD_ROLE = new TokenRole("new", 1);

    public ObjectCreationExpression(AstType type) {
        this(-34, type);
    }

    public ObjectCreationExpression(AstType type, Iterable<Expression> arguments) {
        this(-34, type, arguments);
    }

    public ObjectCreationExpression(AstType type, Expression ... arguments) {
        this(-34, type, arguments);
    }

    public ObjectCreationExpression(int offset, AstType type) {
        super(offset);
        this.setType(type);
    }

    public ObjectCreationExpression(int offset, AstType type, Iterable<Expression> arguments) {
        super(offset);
        this.setType(type);
        if (arguments != null) {
            for (Expression argument : arguments) {
                this.addChild(argument, Roles.ARGUMENT);
            }
        }
    }

    public ObjectCreationExpression(int offset, AstType type, Expression ... arguments) {
        super(offset);
        this.setType(type);
        if (arguments != null) {
            for (Expression argument : arguments) {
                this.addChild(argument, Roles.ARGUMENT);
            }
        }
    }

    public final Expression getTarget() {
        return this.getChildByRole(Roles.TARGET_EXPRESSION);
    }

    public final void setTarget(Expression value) {
        this.setChildByRole(Roles.TARGET_EXPRESSION, value);
    }

    public final AstNodeCollection<Expression> getArguments() {
        return this.getChildrenByRole(Roles.ARGUMENT);
    }

    public final JavaTokenNode getNewToken() {
        return this.getChildByRole(NEW_KEYWORD_ROLE);
    }

    public final AstType getType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setType(AstType type) {
        this.setChildByRole(Roles.TYPE, type);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitObjectCreationExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof ObjectCreationExpression) {
            ObjectCreationExpression otherExpression = (ObjectCreationExpression)other;
            return !otherExpression.isNull() && this.getTarget().matches(otherExpression.getTarget(), match) && this.getType().matches(otherExpression.getType(), match) && this.getArguments().matches(otherExpression.getArguments(), match);
        }
        return false;
    }
}

