/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core.matcher;

import java.awt.Component;
import java.util.regex.Pattern;
import org.assertj.core.util.Objects;
import org.assertj.swing.core.GenericTypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.util.Strings;

public abstract class NamedComponentMatcherTemplate<T extends Component>
extends GenericTypeMatcher<T> {
    private static final Object ANY = new Object(){

        public String toString() {
            return "<Any>";
        }
    };
    private final Object name;

    protected NamedComponentMatcherTemplate(@Nonnull Class<T> supportedType) {
        super(supportedType);
        this.name = ANY;
    }

    protected NamedComponentMatcherTemplate(@Nonnull Class<T> supportedType, @Nullable Object name) {
        super(supportedType);
        this.name = name;
    }

    @Nullable
    protected final Object quotedName() {
        return this.quoted(this.name);
    }

    @Nullable
    protected final Object quoted(@Nullable Object propertyValue) {
        if (ANY.equals(propertyValue)) {
            return ANY;
        }
        if (propertyValue instanceof Pattern) {
            String pattern = ((Pattern)propertyValue).pattern();
            return org.assertj.core.util.Strings.quote((String)pattern);
        }
        return org.assertj.core.util.Strings.quote((Object)propertyValue);
    }

    protected final boolean isNameMatching(@Nullable String actual) {
        if (ANY.equals(this.name)) {
            return true;
        }
        return Objects.areEqual((Object)this.name, (Object)actual);
    }

    protected final boolean arePropertyValuesMatching(@Nullable Object expected, @Nullable Object actual) {
        if (ANY.equals(expected)) {
            return true;
        }
        if (expected instanceof String && actual instanceof String) {
            return Strings.areEqualOrMatch((String)expected, (String)actual);
        }
        if (expected instanceof Pattern && actual instanceof CharSequence) {
            return Strings.match((Pattern)expected, (CharSequence)actual);
        }
        return Objects.areEqual((Object)expected, (Object)actual);
    }

    @Nullable
    protected final Object name() {
        return this.name;
    }

    @Nonnull
    protected static final Object anyValue() {
        return ANY;
    }
}

