/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.latex.EndFrameBox;
import com.dickimawbooks.texparserlib.latex.FrameBox;
import com.dickimawbooks.texparserlib.latex.StartFrameBox;
import java.io.IOException;

public class FrameBoxEnv
extends Declaration {
    protected FrameBox fbox;
    protected boolean popLeadingSpace;

    public FrameBoxEnv(FrameBox frameBox) {
        this(frameBox.getId(), frameBox);
    }

    public FrameBoxEnv(String string, FrameBox frameBox) {
        this(string, frameBox, true);
    }

    public FrameBoxEnv(String string, FrameBox frameBox, boolean bl) {
        super(string);
        this.fbox = frameBox;
        this.popLeadingSpace = bl;
        this.setEndDeclaration(new EndDeclaration(string));
    }

    @Override
    public Object clone() {
        return new FrameBoxEnv(this.getName(), this.fbox, this.popLeadingSpace);
    }

    protected void preprocess(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.popLeadingSpace) {
            TeXObject teXObject = teXObjectList.peekStack();
            while (teXObject instanceof WhiteSpace) {
                teXObjectList.popStack(teXParser);
                teXObject = teXObjectList.peekStack();
            }
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.preprocess(teXParser, teXObjectList);
        StartFrameBox startFrameBox = new StartFrameBox(this.fbox);
        startFrameBox.process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.preprocess(teXParser, teXParser);
        StartFrameBox startFrameBox = new StartFrameBox(this.fbox);
        startFrameBox.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        EndFrameBox endFrameBox = new EndFrameBox(this.fbox);
        endFrameBox.process(teXParser, teXObjectList);
    }

    public FrameBox getFrameBox() {
        return this.fbox;
    }

    public boolean isInLine() {
        return this.fbox.isInLine();
    }

    public boolean isMultiLine() {
        return this.fbox.isMultiLine();
    }

    @Override
    public boolean isModeSwitcher() {
        return false;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }
}

