;;; python-mode-write-tests.el --- -*- lexical-binding: t; -*- 

 ;; Copyright (C) 2015-2016  Andreas Röhler

;; Author: Andreas Röhler <andreas.roehler@online.de>

;; Keywords:

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;;

;;; Code:


(defun py-write-variables-test ()
  (interactive)
  (set-buffer (get-buffer-create "Py-Variables-Test"))
  (erase-buffer)
  (dolist (elt py-variables)
    (setq elt (prin1-to-string elt))
    (insert (concat "-eval \"(assert (boundp '" elt ") nil \\\"" elt " not a variable\\\")\" \\\n")))
  (switch-to-buffer (current-buffer))
  (emacs-lisp-mode))

(defun py-write-docstring-style-test ()
  (interactive)
  (set-buffer (get-buffer-create "Py-Docstring-Style-Test"))
  (erase-buffer)
  (dolist (elt docstring-styles)
    ;; (setq elt (prin1-to-string elt))
    ;; py-nil-docstring-style-on
    (insert (concat "
  \(py-" elt "-docstring-style-on)
  \(assert (eq '" elt " py-docstring-style) nil \"" elt " not py-docstring-style\")\n")))
  (switch-to-buffer (current-buffer))
  (emacs-lisp-mode))

(defun py-write-ert-forward-tests ()
  (interactive)
  (set-buffer (get-buffer-create "py-ert-forward-tests.el"))
  (erase-buffer)
  (switch-to-buffer (current-buffer))
  (insert ";;; py-ert-forward-tests.el --- Just some more tests \n")
  (insert arkopf)
  (insert "\n;;This file is generated by function from python-mode-utils.el - see in
;; directory devel. Edits here might not be persistent.\n")
  (dolist (ele py-navigate-test-forms)
    (insert (concat "
\(ert-deftest py-ert-forward-" ele "-test ()
  (py-test-with-temp-buffer-point-min
      \"
# {{
class bar:
    def foo ():
        try:
            if foo:
                for a in b:
                    print('%(language)s has %(number)03d quote types.' %
       {'language': \\\"Python\\\", \\\"number\\\": 2})

            elif bar:
                for a in b:
                    pass
            else:
                for a in b:
                    pass
# }}
        except:
            block2
\"\n"))
    (insert (make-string 4 ?\ ))
    (cond ((string-match "elif" ele)
	   (insert "(search-forward \"elif\")"))
	  ((string-match "else" ele)
	   (insert "(search-forward \"else\")"))
	  ((string-match "for-block" ele)
	   (insert "(search-forward \"for\")"))
	  ((string-match "try-block" ele)
	   (insert "(search-forward \"try\")"))
	  ((string-match "except" ele)
	   (insert "(search-forward \"except\")"))
	  ((string-match "clause" ele)
	   (insert "(search-forward \"elif\")"))
	  ((string-match "partial-expression" ele)
	   (insert "(search-forward \"Python\")"))
	  (t (insert "(search-forward \"if\")")))
    (insert (concat "
    (py-forward-" ele ")
    (should (eq (char-before) "))
    (cond ((string= "block" ele)
           (insert "?s"))
          ((string= "clause" ele)
           (insert "?s"))
          ((string= "section" ele)
           (insert "?}"))
	  ((string= "for-block" ele)
           (insert "?)"))
	  ((string= "block-or-clause" ele)
           (insert "?s"))
          ((string= "def" ele)
           (insert "?2"))
          ((string= "class" ele)
           (insert "?2"))
          ((string= "def-or-class" ele)
           (insert "?2"))
          ((string= "if-block" ele)
           (insert "?s"))
          ((string= "elif-block" ele)
           (insert "?s"))
          ((string= "else-block" ele)
           (insert "?s"))
          ((string= "try-block" ele)
           (insert "?s"))
          ((string= "except-block" ele)
           (insert "?2"))
          ((string= "minor-block" ele)
           (insert "?s"))
          ((string= "top-level" ele)
           (insert "?2"))
          ((string= "expression" ele)
           (insert "?:"))
          ((string= "partial-expression" ele)
           (insert "?n"))
	  ((string= "statement" ele)
           (insert "?:")))
    (insert "))))\n"))

  (dolist (ele py-bol-forms)
    (insert (concat "
\(ert-deftest py-ert-forward-" ele "-bol-test ()
  (py-test-with-temp-buffer
      \"
\# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
\"
    (goto-char 103)
    (py-forward-" ele "-bol)
    (should (eq (point) "))
    (cond ((string= "block" ele)
           (insert "140"))
          ((string= "clause" ele)
           (insert "140"))
	  ((string= "for-block" ele)
           (insert "140"))
          ((string= "block-or-clause" ele)
           (insert "140"))
          ((string= "def" ele)
           (insert "175"))
          ((string= "class" ele)
           (insert "175"))
          ((string= "def-or-class" ele)
           (insert "175"))
          ((string= "if-block" ele)
           (insert "140"))
	  ((string= "elif-block" ele)
           (insert "140"))
	  ((string= "else-block" ele)
           (insert "140"))
          ((string= "top-level" ele)
           (insert "175"))
          ((string= "try-block" ele)
           (insert "140"))
          ((string= "statement" ele)
           (insert "115"))
          ((string= "minor-block" ele)
           (insert "140")))

    (insert "))))\n"))

  (insert "\n(provide 'py-ert-forward-tests)
;;; py-ert-forward-tests.el ends here")

  (switch-to-buffer (current-buffer))
  (emacs-lisp-mode)
  (write-file (concat py-install-directory "/test/py-ert-forward-tests.el")))

(defun write-ert-execute-statement-test ()
  "Write `py-execute-statement...' etc. "
  (interactive)
  ;; (load-shells)
  (let ((py-bounds-command-names py-bounds-command-names)
        (py-test-shells py-shells)
        (py-options py-options))
    (set-buffer (get-buffer-create "py-ert-execute-statement-test.el"))
    (erase-buffer)
    (when (interactive-p) (switch-to-buffer (current-buffer)))
    (insert ";;; ")
    (insert " --- py-execute-statement tests")
    (insert arkopf)
    (dolist (elt py-shells)
      (setq elt (prin1-to-string elt))
      (dolist (pyo py-options)
	(if (string= "" elt)
	    (insert (concat "\n\n(defun py-execute-" ele))
	  (insert (concat "\n\n(defun py-execute-" ele "-" elt)))
	(unless (string= pyo "")(insert (concat "-" pyo)))
	(insert "-test")
	(insert " (&optional arg load-branch-function)")
	(insert (concat "
  (interactive \"p\")
  (let ((py-store-result-p t)
        py-result
        (teststring \""))
	(cond ((or (string-match "block" ele)(string-match "clause" ele))
	       (insert (concat "if True: print(\\\"I'm the py-execute-" ele)))
	      ((string-match "def" ele)
	       (insert (concat "def foo (): print(\\\"I'm the py-execute-" ele)))
	      ((string= "class" ele)
	       (insert (concat "class foo (): print(\\\"I'm the py-execute-" ele)))
	      (t (insert (concat "print(\\\"I'm the py-execute-" ele))))
	(unless (string= "" elt) (insert (concat "-" elt)))
	(unless (string= pyo "")(insert (concat "-" pyo)))
	(if (string-match "def" ele)
	    (progn
	      ;; (switch-to-buffer (current-buffer))
	      (insert "-test\\\")\nfoo()\"))"))
	  (insert "-test\\\")\"))"))
	(if (string= "" elt)
	    (insert (concat "
  (py-bug-tests-intern 'py-execute-" ele))
	  (insert (concat "
  (py-bug-tests-intern 'py-execute-" ele "-" elt)))
	(unless (string= pyo "")(insert (concat "-" pyo)))
	(insert (concat "-base arg teststring)))\n"))
	(if (string= "" elt)
	    (insert (concat "\n(defun py-execute-" ele))
	  (insert (concat "\n\(defun py-execute-" ele "-" elt)))
	(unless (string= pyo "")(insert (concat "-" pyo)))
	(insert "-base (arg)\n")
	(if (string= "" elt)
	    (insert (concat "  (py-execute-" ele))
	  (insert (concat "  (py-execute-" ele "-" elt)))
	(unless (string= pyo "")(insert (concat "-" pyo)))

	(cond ((string= "region" ele)
	       (insert " (line-beginning-position) (line-end-position)")))
	(insert ")")

	(if (string= "" elt)
	    (progn
	      (insert (concat "(set-buffer (py--fetch-first-python-buffer))(goto-char (point-min))(search-forward \"the py-execute-"))
	      (unless (string= pyo "")(insert (concat "-" pyo)))
	      (insert "-test\" nil nil 1))"))
	  (insert (concat "
  (if (string-match \"\*I\" py-buffer-name) (sit-for 1 t) (sit-for 0.1 t))
  (set-buffer py-buffer-name)
  (sit-for 0.1 t)
  (when py-verbose-p (message \"py-result %s\" (or py-error py-result)))
  (when
      (assert (search-backward \"the py-execute-" ele "-" elt))
	  (unless (string= pyo "")(insert (concat "-" pyo)))

	  (insert "-test\" nil nil 1)"))

	(if (string= "" elt)
	    (insert (concat "
           nil \"py-execute-" ele))
	  (insert (concat " nil \"py-execute-" ele "-" elt)))
	(unless (string= pyo "")(insert (concat "-" pyo)))
	(insert "-test failed\")
    (kill-buffer-unconditional py-buffer-name)))")))
    (insert "\n\n(provide 'py-ert-execute-statement-test)
;;; py-ert-execute-statement-test.el here\n "))
  (emacs-lisp-mode)
  (write-file (concat py-install-directory "/py-ert-execute-statement-test.el")))

(defun write-ert-execute-block-test ()
  "Write `py-execute-block...' etc. "
  (interactive)
  ;; (load-shells)
  (set-buffer (get-buffer-create "py-ert-execute-block-test.el"))
  (erase-buffer)
  (when (interactive-p) (switch-to-buffer (current-buffer)))
  (insert ";;; py-ert-execute-block-test.el")
  (insert " --- py-execute-block tests\n")
  (insert arkopf)
  (dolist (elt py-shells)
    (setq elt (format "%s" elt))
    (if (string= "" elt)
	(insert "(ert-deftest py-ert-execute-block")
      (insert (concat "(ert-deftest py-ert-execute-block-" elt)))
    (insert "-test ()\n")
    (insert (make-string 2 ?\ ))
    (if (string= "" elt)
	(insert "(let ((buffer \\\"*Python*\\\"))\n")
      (insert (concat "(let ((buffer (py--choose-buffer-name \"" elt "\")))\n")))
    (insert (make-string 4 ?\ ))
    (insert "(py-test-with-temp-buffer
        \"if True:
    print(\\\"one\\\")
    print(\\\"two\\\")\"\n")
    (insert (make-string 6 ?\ ))
    (if (string= "" elt)
	(insert "(py-execute-block)\n")
      (insert (concat "(py-execute-block-" elt)))
    (insert ")\n")
    (insert (make-string 6 ?\ ))
    (insert "(set-buffer buffer)\n")
    (insert (make-string 6 ?\ ))
    (insert "(should (search-backward \"two\")))))\n\n"
	    ))
  (insert "\n\n(provide 'py-ert-execute-block-test)
;;; py-ert-execute-block-test.el here\n ")
  (emacs-lisp-mode)
  (write-file (concat py-install-directory "/test/py-ert-execute-block-test.el")))

(defun write-ert-execute-region-test ()
  "Write `py-execute-region...' etc. "
  (interactive)
  ;; (load-shells)
  (set-buffer (get-buffer-create "py-ert-execute-region-test.el"))
  (erase-buffer)
  (switch-to-buffer (current-buffer))
  (insert ";;; py-ert-execute-region-test.el")
  (insert " --- py-execute-region tests\n")
  (insert arkopf)
  (dolist (elt py-shells)
    (setq elt (format "%s" elt))
    (if (string= "" elt)
	(insert "(ert-deftest py-ert-execute-region")
      (insert (concat "(ert-deftest py-ert-execute-region-" elt)))
    (insert "-test ()\n")
    (insert (make-string 2 ?\ ))
    (insert "(let ((py-shell-name ")
    (if (string= "" elt)
	(insert "\"python\"")
      (insert (concat "\"" elt "\"")))
    (insert ")\n")
    (insert (make-string 8 ?\ ))
    (if (string= "" elt)
	(insert "(buffer \\\"*Python*\\\"")
      (insert (concat "(buffer (py--choose-buffer-name \"" elt "\")")))
    (insert "))\n")
    (insert (make-string 4 ?\ ))
    (insert "(py-test-with-temp-buffer
        \"print(\\\"one\\\")
print(\\\"two\\\")\"\n")
    (insert (make-string 6 ?\ ))
    (if (string= "" elt)
	(insert "(py-execute-region)")
      (insert (concat "(py-execute-region-" elt " (point-min) (point-max)")))
    (insert "\n")
    (insert (make-string 6 ?\ ))
    (insert "(set-buffer buffer)\n")
    (insert (make-string 6 ?\ ))
    (insert "(should (search-backward \"two\")))))\n\n"
	    ))
  (insert "\n\n(provide 'py-ert-execute-region-test)
;;; py-ert-execute-region-test.el here\n ")
  (emacs-lisp-mode)
  (write-file (concat py-install-directory "/test/py-ert-execute-region-test.el")))


(defun write-unified-extended-execute-ert-tests (&optional path-to-shell command option)
  "Write `py-ert-execute-region-python2-test'"
  (interactive)
  (let ((py-bounds-command-names (if command (list command) py-bounds-command-names))
        ;; (py-shells py-commands)
        (py-options (if option (list option) py-options)))
    (if path-to-shell
        (set-buffer (get-buffer-create (concat path-to-shell ".el")))
      (set-buffer (get-buffer-create "extended-execute-ert-tests.el")))
    (erase-buffer)
    (switch-to-buffer (current-buffer))
    (insert ";;; Extended executes ert tests")
    (insert " --- more execute tests\n")
    (insert arkopf)

    (insert "
;; created by `write-unified-extended-execute-ert-tests'\n")
    (switch-to-buffer (current-buffer))
    ;; see also `py-checker-command-names'
    (dolist (ele py-bounds-command-names)
      (dolist (elt py-shells)
        (setq elt (prin1-to-string elt))
        (setq kurz elt)
        (dolist (pyo py-options)
          (insert (concat "(ert-deftest py-execute-"))
          (if (string= "default" elt)
              (insert ele)
            (insert (concat ele  "-" kurz)))
          (unless (string= pyo "")(insert (concat "-" pyo)))
          (if (string-match "region" elt)
              (insert "(beg end)")
            (insert " ()"))
          (insert (concat "
  \"Run " ele " at point to "))
          (cond ((string-match "ipython" kurz)
                 (insert "IPython"))
                ((string= "python" kurz)
                 (insert "default"))
                (t (insert (capitalize kurz))))
          (cond ((string= pyo "dedicated")
                 (insert " unique interpreter. "))
                ((string= pyo "dedicated-switch")
                 (insert " unique interpreter test. "))
                (t (insert " interpreter test. ")))
          (insert "\"\n")
            (if (string= "default" elt)
                (insert (concat "  (py-test-with-temp-buffer\n
\"print(\\\"I'm the py-ert-execute-" ele "-test\\\")\"
" ele "\""))
              (insert (concat "  (py-test-with-temp-buffer\n
\"print(\\\"I'm the py-ert-execute-" ele "-" elt "-test\\\")\"
")))
                      (cond ((string= pyo "dedicated")
                 (insert " dedicated. "))
                ((string= pyo "dedicated-switch")
                 (insert " unique interpreter test. "))
                (t (insert " interpreter test. ")))

            (insert "
    (let (py-result)
    (push-mark)
    (goto-char (point-min)))")
            (if (string-match "region" ele)
                (insert (concat "
    (py-execute-" ele "-" "elt "-" "pyo" (region-beginning) (region-end))
\(py-execute-" ele "-" "elt "-" "pyo)))
            (insert (concat "
    (should (string-match \"py-ert-execute-" ele "-" " elt "-" pyo "-test\" py-result))))))

    (insert "(provide 'extended-execute-ert-tests)
;;; extended-execute-ert-tests.el ends here\n ")
  (emacs-lisp-mode))

(provide 'python-mode-write-tests)
;;; python-mode-write-tests.el ends here
